/** @module @sage/xtrem-x3-postgres */
import { AnyValue, AsyncGenericReader } from '@sage/xtrem-async-helper';
import { Connection } from '@sage/xtrem-postgres';
import { LoggerInterface } from '@sage/xtrem-shared';
import { IndexColumn, PoolConfig, PoolReaderOptions, SqlExecuteOptions, SqlReadTableSchemaOptions, TableDefinition, Pool as XtremX3Pool } from '@sage/xtrem-x3-sql';
export declare class PostgresPool extends XtremX3Pool<Connection> {
    #private;
    readonly dialect = "postgres";
    constructor(config: PoolConfig, logger?: LoggerInterface);
    param(i: number): string;
    protected checkConnection(cnx: Connection): Connection | undefined;
    protected createConnection(): Promise<Connection>;
    protected closeConnection(cnx: Connection): void;
    execute<T extends AnyValue>(sql: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    execute<T extends AnyValue>(cnx: Connection, sql: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    createReader<T extends AnyValue>(cnx: Connection, sql: string, args: any[], opts: PoolReaderOptions): AsyncGenericReader<T>;
    tableExists(tableName: string, schemaName: string): Promise<boolean>;
    viewExists(tableName: string, schemaName: string): Promise<boolean>;
    private describeNumberColumn;
    /**
     * Parses a SQL row to a columnDefinition (refer to fillColumnInfos to get the format of the SQL row)
     * @param rrow
     * @returns
     */
    private _sqlRowToColumnDefinition;
    private static _transformSqlArgs;
    private fillColumnInfos;
    static parseIndexDefinition(indexName: string, indexDefinition: string): IndexColumn[];
    private fillIndexInfos;
    readTableSchema(schemaName: string, tableName: string, options?: SqlReadTableSchemaOptions): Promise<TableDefinition>;
    getFullTableDefName(tableDef: TableDefinition): string;
    getFullTableName(schemaName: string, tableName: string, alias?: string): string;
}
export declare function create(config: PoolConfig, logger?: LoggerInterface): XtremX3Pool<Connection>;
//# sourceMappingURL=pool.d.ts.map