import type { GraphApi } from '@sage/wh-master-data-api';
import type { Destination } from '@sage/wh-system-api';
import { getDestinations } from '@sage/wh-system/lib/client-functions/user-print-destinations-values';
import * as ui from '@sage/xtrem-ui';
import {
    LabelDocumentDestination,
    getLabelDocumentDestination,
    setDocumentDestination,
    setLabelDestination,
    setLabelDocumentDestination,
} from '../client-functions/storage-properties';
import { readUser } from '../client-functions/user-extension';

@ui.decorators.sticker<MobilePrintDestinations>({
    title: 'Print destinations',
    icon: 'print',
    category: 'mobile',
    isActive() {
        return true;
    },
    async onLoad() {
        const sessionLabelDocumentDestination = getLabelDocumentDestination(this);
        let sessionLabelDestination = sessionLabelDocumentDestination?.labelDestination;
        let sessionDocumentDestination = sessionLabelDocumentDestination?.documentDestination;

        if (!sessionLabelDestination && !sessionDocumentDestination) {
            const user = await readUser(this, this.$.userCode);
            if (!user) {
                return;
            }
            const defaultDestinations = await getDestinations(user);
            if (
                !defaultDestinations ||
                defaultDestinations.length === 0 ||
                (!defaultDestinations[0].destination &&
                    defaultDestinations.length > 1 &&
                    !defaultDestinations[1].destination)
            ) {
                return;
            }
            const userDefaultLabelDestination = defaultDestinations[0];
            const userDefaultDocumentDestination = userDefaultLabelDestination;
            // defaultDestinations.length > 1 ? defaultDestinations[1] : userDefaultLabelDestination;

            if (['printer', 'zplPrinter'].includes(userDefaultLabelDestination.destination)) {
                setLabelDestination(this, userDefaultLabelDestination?.code);
                sessionLabelDestination = userDefaultLabelDestination.code;
            }

            if (['printer', 'zplPrinter'].includes(userDefaultDocumentDestination.destination)) {
                setDocumentDestination(this, userDefaultDocumentDestination?.code);
                sessionDocumentDestination = userDefaultDocumentDestination.code;
            }
        }
        this.labelDestination.value = { code: sessionLabelDestination };
        this.documentDestination.value = { code: sessionDocumentDestination };
    },
    businessActions() {
        return [this.saveButton];
    },
})
export class MobilePrintDestinations extends ui.Sticker<GraphApi> {
    @ui.decorators.section<MobilePrintDestinations>({
        title: 'Print destinations',
    })
    section!: ui.containers.Section;

    @ui.decorators.block<MobilePrintDestinations>({
        parent() {
            return this.section;
        },
    })
    block!: ui.containers.Block;

    @ui.decorators.referenceField<MobilePrintDestinations, Destination>({
        node: '@sage/wh-system/Destination',
        filter() {
            return {
                isActive: true,
                destination: { _in: ['printer', 'zplPrinter'] },
            };
        },
        valueField: 'code',
        columns: [
            ui.nestedFields.text({ bind: 'code', title: 'Code', canFilter: true }),
            ui.nestedFields.text({ bind: 'description', title: 'Description', canFilter: true }),
            ui.nestedFields.text({ bind: 'destination', title: 'Type', canFilter: true }),
            ui.nestedFields.text({ bind: 'printerName', title: 'Name', canFilter: true }),
            ui.nestedFields.checkbox({ bind: 'isActive', isHidden: true }),
            ui.nestedFields.text({ bind: 'destination', isHidden: true }),
        ],
        isFullWidth: true,
        isAutoSelectEnabled: true,
        title: 'Label destination',
        helperTextField: 'description',
        canFilter: false,
        parent() {
            return this.block;
        },
        onChange() {
            this.saveButton.isDisabled = !this.labelDestination.value && !this.documentDestination.value;
        },
    })
    labelDestination!: ui.fields.Reference;

    @ui.decorators.referenceField<MobilePrintDestinations, Destination>({
        node: '@sage/wh-system/Destination',
        filter() {
            return {
                isActive: true,
                destination: { _in: ['printer', 'zplPrinter'] },
            };
        },
        valueField: 'code',
        columns: [
            ui.nestedFields.text({ bind: 'code', title: 'Code', canFilter: true }),
            ui.nestedFields.text({ bind: 'description', title: 'Description', canFilter: true }),
            ui.nestedFields.text({ bind: 'destination', title: 'Type', canFilter: true }),
            ui.nestedFields.text({ bind: 'printerName', title: 'Name', canFilter: true }),
            ui.nestedFields.checkbox({ bind: 'isActive', isHidden: true }),
            ui.nestedFields.text({ bind: 'destination', isHidden: true }),
        ],
        isFullWidth: true,
        isAutoSelectEnabled: true,
        title: 'Document destination',
        helperTextField: 'description',
        canFilter: false,
        parent() {
            return this.block;
        },
        onChange() {
            this.saveButton.isDisabled = !this.labelDestination.value && !this.documentDestination.value;
        },
    })
    documentDestination!: ui.fields.Reference;

    @ui.decorators.pageAction<MobilePrintDestinations>({
        title: 'Set destinations',
        buttonType: 'primary',
        isTransient: true,
        isDisabled: true,
        onClick() {
            if (this.labelDestination.value?.code || this.documentDestination.value?.code) {
                setLabelDocumentDestination(this, <LabelDocumentDestination>{
                    ...(this.labelDestination.value && { label: this.labelDestination.value.code }),
                    ...(this.documentDestination.value && { document: this.documentDestination.value.code }),
                });
            }
            this.$.finish(); // This is used to automatically close this sticker
        },
    })
    saveButton!: ui.PageAction;
}
