import {
    AggregateEdgesSelector,
    AggregateGroupSelector,
    AggregateQueryOptions,
    AggregateQuerySelector,
    AggregateValuesSelector,
    ClientNode,
    aggregateEdgesSelector,
} from '@sage/xtrem-client';

/**
 * Prepare the aggregate request before execution
 * @param selector
 * @param filter
 * @param numberOfRecords (optional, default 1000)
 * @returns request prepared
 */
export function prepareAggregateGenericRequest<T extends ClientNode>(
    selector: AggregateQuerySelector<T, AggregateGroupSelector<T>, AggregateValuesSelector<T>>,
    filter: AggregateQueryOptions<T>,
    numberOfRecords = 1000,
) {
    const _aggregateRequest: AggregateEdgesSelector<
        T,
        AggregateGroupSelector<T>,
        AggregateValuesSelector<T>
    > = aggregateEdgesSelector<T, AggregateGroupSelector<T>, AggregateValuesSelector<T>>(selector, filter);
    if (_aggregateRequest?.__args) {
        _aggregateRequest.__args.first = numberOfRecords;
    }
    return _aggregateRequest;
}
