// From file: @sage/wh-master-data/build/index.d.ts
declare module '@sage/wh-master-data/index' {
	export * from '@sage/wh-master-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/index.d.ts
declare module '@sage/wh-master-data/lib/index' {
	export * as enums from '@sage/wh-master-data/lib/enums/index';
	export * as functions from '@sage/wh-master-data/lib/functions/index';
	export * as interfaces from '@sage/wh-master-data/lib/interfaces/index';
	export * as menuItems from '@sage/wh-master-data/lib/menu-items/index';
	export * as nodeExtensions from '@sage/wh-master-data/lib/node-extensions/index';
	export * as nodes from '@sage/wh-master-data/lib/nodes/index';
	export * as serviceOptions from '@sage/wh-master-data/lib/service-options/index';
	export * as sharedFunctions from '@sage/wh-master-data/lib/shared-functions/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/shared-functions/math.d.ts
declare module '@sage/wh-master-data/lib/shared-functions/math' {
	/**
	 * Truncate quantity to a number of decimals
	 * @param quantity  quantity to truncate
	 * @param precision number of decimals or undefined (truncate to integer)
	 * @returns truncated quantity
	 */
	export function truncate(quantity: number, precision?: number): number;
	//# sourceMappingURL=math.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/shared-functions/index.d.ts
declare module '@sage/wh-master-data/lib/shared-functions/index' {
	export * from '@sage/wh-master-data/lib/shared-functions/constants';
	export * from '@sage/wh-master-data/lib/shared-functions/math';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/shared-functions/constants.d.ts
declare module '@sage/wh-master-data/lib/shared-functions/constants' {
	/**
	 * Maximum length for store code
	 */
	export const MAX_STORE_CODE_LENGTH = 3;
	//# sourceMappingURL=constants.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/service-options/index.d.ts
declare module '@sage/wh-master-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/work-center.d.ts
declare module '@sage/wh-master-data/lib/nodes/work-center' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class WorkCenter extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly sequence: Promise<integer>;
	    readonly lastSlave: Promise<integer>;
	    readonly level: Promise<integer>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly masterStation: Reference<sageWhMasterData.nodes.WorkCenter | null>;
	    readonly unit1: Reference<sageWhMasterData.nodes.UnitOfMeasure>;
	    readonly unit2: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly unit3: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	}
	//# sourceMappingURL=work-center.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/wh-site.d.ts
declare module '@sage/wh-master-data/lib/nodes/wh-site' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class WhSite extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly transferValidationType: Promise<sageWhMasterData.enums.ValidationType | null>;
	    readonly isTransferOperationCodeAllowed: Promise<boolean>;
	    readonly isPickControlCodeAllowed: Promise<boolean>;
	    readonly isRepositoningControlCodeAllowed: Promise<boolean>;
	    readonly isReceiptOperationCodeAllowed: Promise<boolean>;
	    readonly isAdjustementOperationCodeAllowed: Promise<boolean>;
	    readonly isAdjustementControlCodeAllowed: Promise<boolean>;
	    readonly isConsumableInputControlCodeAllowed: Promise<boolean>;
	    readonly isConsumableOutputControlCodeAllowed: Promise<boolean>;
	    readonly isSimplifiedStockCountCodeAllowed: Promise<boolean>;
	    readonly isPrintTransferListAllowed: Promise<boolean>;
	    readonly isPrintTransferLabelAllowed: Promise<boolean>;
	    readonly isMonoZoneOriginAllowed: Promise<boolean>;
	    readonly isMonoZoneDestinationAllowed: Promise<boolean>;
	    readonly isDockAssignmentAllowed: Promise<boolean>;
	    readonly isItemBarCodeAllowed: Promise<boolean>;
	    readonly isEanBarCodeAllowed: Promise<boolean>;
	    readonly isTransferProductBarCodeAllowed: Promise<boolean>;
	    readonly isTransferEanBarCodeAllowed: Promise<boolean>;
	    readonly isDripAndDropAllowed: Promise<boolean>;
	    readonly isPreventiveStockCount: Promise<boolean>;
	    readonly timeBetweenInterval: Promise<integer | null>;
	    readonly inventoryMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly isPickingOperationCodeAllowed: Promise<boolean>;
	    readonly isDockControlParcels: Promise<boolean>;
	    readonly isSingleDepositor: Promise<boolean>;
	    readonly isSingleStorageType: Promise<boolean>;
	    readonly isStoreChaining: Promise<boolean>;
	    readonly isRotationClassesChaining: Promise<boolean>;
	    readonly isChainingAssignmentClasses: Promise<boolean>;
	    readonly isChainingVolumeClasses: Promise<boolean>;
	    readonly isPickProdWithoutPrompt: Promise<boolean>;
	    readonly rotationPickingWithoutPrompt: Reference<sageWhMasterData.nodes.RotationClass | null>;
	    readonly pickingVolumeWithoutPrompt: Reference<sageWhMasterData.nodes.VolumeClass | null>;
	    readonly idealRotationClass: Promise<sageWhMasterData.enums.IdealRotationClass | null>;
	    readonly idealVolumeClass: Promise<sageWhMasterData.enums.IdealVolumeType | null>;
	    readonly targetCover: Promise<decimal | null>;
	    readonly minimumDelayBeforeReallocation: Promise<integer | null>;
	    readonly minimumActivityBeforeAllocation: Promise<integer | null>;
	    readonly calculationPeriod: Promise<integer | null>;
	    readonly transferPicking: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly transferReserve: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly isRoundCreation: Promise<boolean>;
	    readonly isInitializeCarrierAndTransportMode: Promise<boolean>;
	    readonly isResearchGenericRound: Promise<boolean>;
	    readonly deliveryInAdvance: Promise<integer | null>;
	    readonly roundHour: Promise<string>;
	    readonly isEdiOperationCode: Promise<boolean>;
	    readonly dcmdLimitQuantity: Promise<integer | null>;
	    readonly carriageNoteDstdReport: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly carriageReceiptDstdReport: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly internationalLanguage: Reference<sageWhSystem.nodes.Language | null>;
	    readonly crossDockingStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isWaveInitialization: Promise<boolean>;
	    readonly isInterSiteRoundManagement: Promise<boolean>;
	    readonly eanDefaultMethod: Promise<sageWhMasterData.enums.DefaultMode | null>;
	    readonly isUnicityCheck: Promise<boolean>;
	    readonly isRepackingOperationCodeAllowed: Promise<boolean>;
	    readonly isPickingValidated: Promise<boolean>;
	    readonly transferMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly isOutputMouvementGrouping: Promise<boolean>;
	    readonly isTransfertMouvementGrouping: Promise<boolean>;
	    readonly loadingUnit: Promise<sageWhMasterData.enums.LoadUnitType | null>;
	    readonly isReceiptDockCapacity: Promise<boolean>;
	    readonly isAutoQuayOccupation: Promise<boolean>;
	    readonly receiptAppointmentOccupationStartTime: Promise<string>;
	    readonly receiptAppointmentOccupationEndTime: Promise<string>;
	    readonly receiptAppointmentProvisionalDuration: Promise<string>;
	    readonly receiptAppointmentTruckTrackingStatus: Promise<string>;
	    readonly isReceiptAppointmentAssignement: Promise<boolean>;
	    readonly isReceiptAppointementDockFreeing: Promise<boolean>;
	    readonly isShipmentDockCapacity: Promise<boolean>;
	    readonly shipmentAppointmentOccupationStartTime: Promise<string>;
	    readonly shipmentAppointmentOccupationEndTime: Promise<string>;
	    readonly shipmentAppointmentProvisionalDuration: Promise<string>;
	    readonly shipmentAppointmentTruckTrackingStatus: Promise<string>;
	    readonly isRoundReference: Promise<boolean>;
	    readonly isShipmentAppointementAssignment: Promise<boolean>;
	    readonly isAutoShipmentAppointementAssignment: Promise<boolean>;
	    readonly isUpdateOnLoading: Promise<boolean>;
	    readonly isShipmentAppointementDockFreing: Promise<boolean>;
	    readonly otherAppointmentOccupationStartTime: Promise<string>;
	    readonly otherAppointmentOccupationEndTime: Promise<string>;
	    readonly otherAppointmentProvisionalDuration: Promise<string>;
	    readonly otherAppointmentTruckTrackingStatus: Promise<string>;
	    readonly workCenter1: Reference<sageWhMasterData.nodes.WorkCenter | null>;
	    readonly unitOfMeasure1: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly workCenter2: Reference<sageWhMasterData.nodes.WorkCenter | null>;
	    readonly unitOfMeasure2: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly isSimplifiedStockCount: Promise<boolean>;
	    readonly isLastStockCountDateUpdate: Promise<boolean>;
	    readonly siteSei: Promise<string>;
	    readonly addressingPriorities: Collection<sageWhMasterData.nodes.WhSiteAddressingPriorities>;
	    readonly isNoWorkDays: Collection<sageWhMasterData.nodes.WhSiteIsNoWorkDays>;
	    readonly supplierBarCodes: Collection<sageWhMasterData.nodes.WhSiteSupplierBarCodes>;
	}
	//# sourceMappingURL=wh-site.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/wh-site-supplier-bar-codes.d.ts
declare module '@sage/wh-master-data/lib/nodes/wh-site-supplier-bar-codes' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class WhSiteSupplierBarCodes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.WhSite>;
	    readonly supplierBarCodeStart: Promise<integer | null>;
	    readonly supplierBarCodeEnd: Promise<integer | null>;
	}
	//# sourceMappingURL=wh-site-supplier-bar-codes.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/wh-site-is-no-work-days.d.ts
declare module '@sage/wh-master-data/lib/nodes/wh-site-is-no-work-days' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class WhSiteIsNoWorkDays extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.WhSite>;
	    readonly isNoWorkDay: Promise<boolean>;
	}
	//# sourceMappingURL=wh-site-is-no-work-days.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/wh-site-addressing-priorities.d.ts
declare module '@sage/wh-master-data/lib/nodes/wh-site-addressing-priorities' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class WhSiteAddressingPriorities extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.WhSite>;
	    readonly addressingPriority: Promise<sageWhMasterData.enums.MappingAddressingCriteria | null>;
	}
	//# sourceMappingURL=wh-site-addressing-priorities.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/volume-class.d.ts
declare module '@sage/wh-master-data/lib/nodes/volume-class' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class VolumeClass extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortdescription: Promise<string>;
	    readonly maximumVolume: Promise<decimal | null>;
	    readonly numberOfChaining: Promise<integer | null>;
	    readonly volumeClassesChaining: Collection<sageWhMasterData.nodes.VolumeClassVolumeClassesChaining>;
	}
	//# sourceMappingURL=volume-class.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/volume-class-volume-classes-chaining.d.ts
declare module '@sage/wh-master-data/lib/nodes/volume-class-volume-classes-chaining' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class VolumeClassVolumeClassesChaining extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.VolumeClass>;
	    readonly volumeClassChaining: Reference<sageWhMasterData.nodes.VolumeClass | null>;
	}
	//# sourceMappingURL=volume-class-volume-classes-chaining.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/unit-of-measure.d.ts
declare module '@sage/wh-master-data/lib/nodes/unit-of-measure' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	export class UnitOfMeasure extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly numberOfDecimals: Promise<integer | null>;
	    readonly symbol: Promise<string>;
	    readonly unitType: Promise<sageWhSystem.enums.UnitType | null>;
	    readonly codeCeeOnu: Reference<sageWhSystem.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=unit-of-measure.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/truck-tracking-status.d.ts
declare module '@sage/wh-master-data/lib/nodes/truck-tracking-status' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class TruckTrackingStatus extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=truck-tracking-status.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/transport-type.d.ts
declare module '@sage/wh-master-data/lib/nodes/transport-type' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class TransportType extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isFreeFreight: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=transport-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/transport-mode.d.ts
declare module '@sage/wh-master-data/lib/nodes/transport-mode' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class TransportMode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=transport-mode.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/tariff-code.d.ts
declare module '@sage/wh-master-data/lib/nodes/tariff-code' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class TariffCode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=tariff-code.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/supplier.d.ts
declare module '@sage/wh-master-data/lib/nodes/supplier' {
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class Supplier extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly postalCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly region: Promise<string>;
	    readonly country: Reference<sageWhStructure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly telephone: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly isQualityControlManagement: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly adresses: Collection<sageWhMasterData.nodes.SupplierAdresses>;
	    readonly companyNames: Collection<sageWhMasterData.nodes.SupplierCompanyNames>;
	}
	//# sourceMappingURL=supplier.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/supplier-company-names.d.ts
declare module '@sage/wh-master-data/lib/nodes/supplier-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class SupplierCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Supplier>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=supplier-company-names.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/supplier-adresses.d.ts
declare module '@sage/wh-master-data/lib/nodes/supplier-adresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class SupplierAdresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Supplier>;
	    readonly adress: Promise<string>;
	}
	//# sourceMappingURL=supplier-adresses.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store.d.ts
declare module '@sage/wh-master-data/lib/nodes/store' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class Store extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isProximityPickingStore: Promise<boolean>;
	    readonly isKeyInControlCode: Promise<boolean>;
	    readonly priorityInOutput: Promise<string>;
	    readonly isAuthorizedInOutput: Promise<boolean>;
	    readonly storeType: Promise<sageWhMasterData.enums.StoreType>;
	    readonly groupMergingOfFlows: Promise<string>;
	    readonly isBigVolumesAllowed: Promise<boolean>;
	    readonly isSmallVolumesAllowed: Promise<boolean>;
	    readonly chainingMode: Reference<sageWhMasterData.nodes.StoreChaining | null>;
	    readonly addressStructure: Promise<string>;
	    readonly storingStructure: Promise<string>;
	    readonly aisleType: Promise<sageWhMasterData.enums.AislesType | null>;
	    readonly rowFacing: Promise<sageWhMasterData.enums.AislesInFront | null>;
	    readonly presentAisleRank: Promise<integer | null>;
	    readonly presentAisleLevel: Promise<string>;
	    readonly rankOfFrontAisle: Promise<integer | null>;
	    readonly levelOfInfrontAisle: Promise<string>;
	    readonly isAisleChaining: Promise<boolean>;
	    readonly extendProximityLevel: Promise<string>;
	    readonly keyOfCalculation: Promise<integer | null>;
	    readonly isTransferCompleteObject: Promise<boolean>;
	    readonly reintegrationStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly isPreventiveStockCount: Promise<boolean>;
	    readonly isBalanceReaddressing: Promise<boolean>;
	    readonly supportingBeamMaxWeight: Promise<decimal | null>;
	    readonly alertThreshold: Promise<decimal | null>;
	    readonly locations: Collection<sageWhMasterData.nodes.Location>;
	    readonly addressesCode: Collection<sageWhMasterData.nodes.StoreAddressesCode>;
	    readonly addressesDescription: Collection<sageWhMasterData.nodes.StoreAddressesDescription>;
	    readonly addressesFormat: Collection<sageWhMasterData.nodes.StoreAddressesFormat>;
	    readonly addressesLength: Collection<sageWhMasterData.nodes.StoreAddressesLength>;
	    readonly addressesType: Collection<sageWhMasterData.nodes.StoreAddressesType>;
	    readonly putawayOrders: Collection<sageWhMasterData.nodes.StorePutawayOrders>;
	    readonly startLevels: Collection<sageWhMasterData.nodes.StoreStartLevels>;
	}
	//# sourceMappingURL=store.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-start-levels.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-start-levels' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreStartLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Store>;
	    readonly startLevel: Promise<integer | null>;
	}
	//# sourceMappingURL=store-start-levels.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-putaway-orders.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-putaway-orders' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StorePutawayOrders extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Store>;
	    readonly putawayOrder: Promise<integer | null>;
	}
	//# sourceMappingURL=store-putaway-orders.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-chaining.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-chaining' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreChaining extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly priorityStore: Reference<sageWhMasterData.nodes.Store>;
	    readonly numberOfChaining: Promise<integer | null>;
	    readonly isChainingForSplittingStores: Promise<boolean>;
	    readonly storesChaining: Collection<sageWhMasterData.nodes.StoreChainingStoresChaining>;
	}
	//# sourceMappingURL=store-chaining.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-chaining-stores-chaining.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-chaining-stores-chaining' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreChainingStoresChaining extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.StoreChaining>;
	    readonly storeChaining: Reference<sageWhMasterData.nodes.Store | null>;
	}
	//# sourceMappingURL=store-chaining-stores-chaining.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-addresses-type.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-addresses-type' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreAddressesType extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Store>;
	    readonly addressType: Promise<sageWhMasterData.enums.Format | null>;
	}
	//# sourceMappingURL=store-addresses-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-addresses-length.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-addresses-length' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreAddressesLength extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Store>;
	    readonly addressLength: Promise<integer | null>;
	}
	//# sourceMappingURL=store-addresses-length.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-addresses-format.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-addresses-format' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreAddressesFormat extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Store>;
	    readonly addressFormat: Promise<string>;
	}
	//# sourceMappingURL=store-addresses-format.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-addresses-description.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-addresses-description' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreAddressesDescription extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Store>;
	    readonly addressDescription: Promise<string>;
	}
	//# sourceMappingURL=store-addresses-description.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/store-addresses-code.d.ts
declare module '@sage/wh-master-data/lib/nodes/store-addresses-code' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StoreAddressesCode extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Store>;
	    readonly addressCode: Promise<string>;
	}
	//# sourceMappingURL=store-addresses-code.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/storage-type.d.ts
declare module '@sage/wh-master-data/lib/nodes/storage-type' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StorageType extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly isPickingPivot: Promise<boolean>;
	    readonly depositorManagement: Promise<sageWhMasterData.enums.Assignment | null>;
	    readonly productManagement: Promise<sageWhMasterData.enums.Assignment | null>;
	    readonly isSingleContainer: Promise<boolean>;
	    readonly isSingleSource: Promise<boolean>;
	    readonly isSingleLot: Promise<boolean>;
	    readonly isSingleReservation: Promise<boolean>;
	    readonly singleDate: Promise<sageWhMasterData.enums.MonoFifoDate | null>;
	    readonly isSingleStockStatus: Promise<boolean>;
	    readonly isContainerCorrespendence: Promise<boolean>;
	    readonly isInputFifoDateResetToZero: Promise<boolean>;
	    readonly isStrictUnStocking: Promise<boolean>;
	    readonly unStocking: Promise<sageWhMasterData.enums.UnstoringType | null>;
	    readonly isFifoByLocation: Promise<boolean>;
	    readonly isInputOfOldFifoDateAllowed: Promise<boolean>;
	    readonly isFifoGapControl: Promise<boolean>;
	    readonly fillControl: Promise<sageWhMasterData.enums.FillingUpControl | null>;
	    readonly isAutomaticAddressingAuthorized: Promise<boolean>;
	    readonly isLabelPrinting: Promise<boolean>;
	    readonly storeType: Promise<sageWhMasterData.enums.StoreType | null>;
	    readonly isAdressPositionManagement: Promise<boolean>;
	    readonly homogeneousObject: Promise<sageWhMasterData.enums.HomogeneousPallet | null>;
	    readonly isExceedMaximumCapacityOfPickingLocation: Promise<boolean>;
	    readonly isUndifferentiatedStockObject: Promise<boolean>;
	    readonly isAssemblyAuthorized: Promise<boolean>;
	    readonly isLotSwapping: Promise<boolean>;
	    readonly isAutomaticMovementSplit: Promise<boolean>;
	    readonly isStockObjectAdcGrouping: Promise<boolean>;
	    readonly isFifoDateAdcGrouping: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=storage-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/stock-nature.d.ts
declare module '@sage/wh-master-data/lib/nodes/stock-nature' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class StockNature extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly type: Promise<sageWhMasterData.enums.StockNatureType | null>;
	    readonly isExclusiveStore: Promise<boolean>;
	}
	//# sourceMappingURL=stock-nature.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/stock-count-class.d.ts
declare module '@sage/wh-master-data/lib/nodes/stock-count-class' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	export class StockCountClass extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly numberOfStockCounts: Promise<integer>;
	    readonly minimumDaysBetweenStockCounts: Promise<integer | null>;
	}
	//# sourceMappingURL=stock-count-class.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/shipping-unit-type.d.ts
declare module '@sage/wh-master-data/lib/nodes/shipping-unit-type' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
	export class ShippingUnitType extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	    readonly height: Promise<decimal | null>;
	    readonly width: Promise<decimal | null>;
	    readonly depth: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly usefulVolume: Promise<decimal | null>;
	    readonly surfaceEquivalent: Promise<integer | null>;
	    readonly isLengthChangeable: Promise<boolean>;
	    readonly isWidthChangeable: Promise<boolean>;
	    readonly isDepthChangeable: Promise<boolean>;
	    readonly weight: Promise<decimal | null>;
	    readonly maximumWeight: Promise<decimal | null>;
	    readonly isWeightChangeable: Promise<boolean>;
	}
	//# sourceMappingURL=shipping-unit-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/serial-group.d.ts
declare module '@sage/wh-master-data/lib/nodes/serial-group' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class SerialGroup extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly parentGroup: Reference<sageWhMasterData.nodes.SerialGroup | null>;
	}
	//# sourceMappingURL=serial-group.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/rotation-class.d.ts
declare module '@sage/wh-master-data/lib/nodes/rotation-class' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class RotationClass extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly maximumRequestPerDay: Promise<integer | null>;
	    readonly promptRate: Promise<integer | null>;
	    readonly numberOfChaining: Promise<integer | null>;
	    readonly isActive: Promise<boolean>;
	    readonly rotationClassesChaining: Collection<sageWhMasterData.nodes.RotationClassRotationClassesChaining>;
	}
	//# sourceMappingURL=rotation-class.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/rotation-class-rotation-classes-chaining.d.ts
declare module '@sage/wh-master-data/lib/nodes/rotation-class-rotation-classes-chaining' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class RotationClassRotationClassesChaining extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.RotationClass>;
	    readonly rotationClassChaining: Reference<sageWhMasterData.nodes.RotationClass | null>;
	}
	//# sourceMappingURL=rotation-class-rotation-classes-chaining.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/range-of-parcel.d.ts
declare module '@sage/wh-master-data/lib/nodes/range-of-parcel' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class RangeOfParcel extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=range-of-parcel.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/preparation-area.d.ts
declare module '@sage/wh-master-data/lib/nodes/preparation-area' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class PreparationArea extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly preparationOrderPrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly generalPrinter: Reference<sageWhSystem.nodes.Destination | null>;
	    readonly labelPrinter1: Reference<sageWhSystem.nodes.Destination | null>;
	    readonly labelPrinter2: Reference<sageWhSystem.nodes.Destination | null>;
	    readonly isBigParcelAuthorized: Promise<boolean>;
	    readonly maximumNumberOfParcels: Promise<integer | null>;
	    readonly maximumWeight: Promise<decimal | null>;
	    readonly maximumVolume: Promise<decimal | null>;
	    readonly maximumSurfaceEquivalent: Promise<integer | null>;
	    readonly isTransmittedToL1: Promise<boolean>;
	    readonly maximumShippingUnit: Promise<integer | null>;
	    readonly maximumWeightForPrepalletizationOrder: Promise<decimal | null>;
	    readonly maximumVolumeForPrepalletizationOrder: Promise<decimal | null>;
	    readonly maximumSurfaceEquivalentForPrepalletizationOrder: Promise<integer | null>;
	    readonly parametersForPreparationOrder: Collection<sageWhMasterData.nodes.PreparationAreaParametersForPreparationOrder>;
	}
	//# sourceMappingURL=preparation-area.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/preparation-area-parameters-for-preparation-order.d.ts
declare module '@sage/wh-master-data/lib/nodes/preparation-area-parameters-for-preparation-order' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class PreparationAreaParametersForPreparationOrder extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.PreparationArea>;
	    readonly parameterForPickingPreparationOrder: Promise<decimal | null>;
	    readonly parameterForReservePreparationOrder: Promise<decimal | null>;
	    readonly parameterForMixedPreparationOrder: Promise<decimal | null>;
	}
	//# sourceMappingURL=preparation-area-parameters-for-preparation-order.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/parcel-type.d.ts
declare module '@sage/wh-master-data/lib/nodes/parcel-type' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class ParcelType extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel>;
	    readonly code: Promise<string>;
	    readonly siteDepositorIdentifier: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly height: Promise<decimal | null>;
	    readonly width: Promise<decimal | null>;
	    readonly depth: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly usefulVolume: Promise<decimal>;
	    readonly isBigParcel: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly surfaceEquivalent: Promise<integer | null>;
	    readonly maximumWeight: Promise<decimal | null>;
	    readonly minimumLimitPercentagePerBigParcel: Promise<integer | null>;
	    readonly parcelTare: Promise<decimal | null>;
	    readonly tareTolerancePercentage: Promise<integer | null>;
	    readonly shippingUnitGroup: Promise<string>;
	    readonly shippinUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
	    readonly isPalettizableAsIs: Promise<boolean>;
	    readonly shippingUnitTypeShippedAsIs: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
	}
	//# sourceMappingURL=parcel-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/operand.d.ts
declare module '@sage/wh-master-data/lib/nodes/operand' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Operand extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly operatorName: Promise<string>;
	    readonly isReceiptAuthorized: Promise<boolean>;
	    readonly isPreventiveStockCountAuthorized: Promise<boolean>;
	    readonly isPutawayAuthorized: Promise<boolean>;
	    readonly isReorderAuthorized: Promise<boolean>;
	    readonly isTransferAuthorized: Promise<boolean>;
	    readonly isPickingAuthorized: Promise<boolean>;
	    readonly isPrepackingAuthorized: Promise<boolean>;
	    readonly isDeclaredPackingAuthorized: Promise<boolean>;
	    readonly isManualAdjustmentAuthorized: Promise<boolean>;
	    readonly isCarrierEdiAuthorized: Promise<boolean>;
	    readonly isAssemblyAuthorized: Promise<boolean>;
	    readonly isDisassemblyAuthorized: Promise<boolean>;
	    readonly isQualityControlAuthorized: Promise<boolean>;
	    readonly isAnalysisRequestAuthorized: Promise<boolean>;
	    readonly isConsumableInputAuthorized: Promise<boolean>;
	    readonly isConsumableOuputAuthorized: Promise<boolean>;
	    readonly isStockOnDockAuthorized: Promise<boolean>;
	    readonly isForcedDeliveryOrderShippingAuthorized: Promise<boolean>;
	    readonly isPrepalletizationAuthorized: Promise<boolean>;
	    readonly isAutoPalletisationAuthorized: Promise<boolean>;
	    readonly isRepackingAuthorized: Promise<boolean>;
	    readonly isSimplifiedStockCountAuthorized: Promise<boolean>;
	}
	//# sourceMappingURL=operand.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/movement-code.d.ts
declare module '@sage/wh-master-data/lib/nodes/movement-code' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class MovementCode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly adjustmentMovementType: Promise<sageWhMasterData.enums.AdjustmentType | null>;
	    readonly processingFamily: Promise<sageWhMasterData.enums.ProcessingFamily>;
	    readonly consumableMovementType: Promise<sageWhMasterData.enums.ConsumableMvtType | null>;
	    readonly isTransmittedFromL3: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=movement-code.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/location.d.ts
declare module '@sage/wh-master-data/lib/nodes/location' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, integer, date, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class Location extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly store: Reference<sageWhMasterData.nodes.Store>;
	    readonly code: Promise<string>;
	    readonly storageType: Promise<string>;
	    readonly storage: Reference<sageWhMasterData.nodes.StorageType>;
	    readonly storeType: Promise<sageWhMasterData.enums.StoreType>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType>;
	    readonly dockType: Promise<sageWhMasterData.enums.DockType | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
	    readonly lotNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly numberOfConsumptionUnitPerContainer: Promise<decimal | null>;
	    readonly rotationClass: Reference<sageWhMasterData.nodes.RotationClass | null>;
	    readonly assignmentClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
	    readonly prohibitedClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
	    readonly height: Promise<decimal>;
	    readonly width: Promise<decimal>;
	    readonly depth: Promise<decimal>;
	    readonly volume: Promise<decimal>;
	    readonly maxVolume: Promise<decimal | null>;
	    readonly maxWeightAuthorized: Promise<decimal | null>;
	    readonly maxMeters: Promise<decimal | null>;
	    readonly maximumLoad: Promise<decimal | null>;
	    readonly dockHeight: Promise<decimal | null>;
	    readonly storingTime: Promise<decimal | null>;
	    readonly unStockingTime: Promise<decimal | null>;
	    readonly presentContainerMaximumQuantity: Promise<decimal | null>;
	    readonly referenceContainerLevel: Promise<integer | null>;
	    readonly maximumQuantityInReferenceContainer: Promise<decimal | null>;
	    readonly quantityInStock: Promise<decimal | null>;
	    readonly lastStockCount: Promise<date | null>;
	    readonly lastReceipt: Promise<date | null>;
	    readonly firstArrival: Promise<date | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly quantityInPendingInput: Promise<decimal | null>;
	    readonly quantityInPendingOutput: Promise<decimal | null>;
	    readonly quantityInPendingReplenish: Promise<decimal | null>;
	    readonly isBlockedInInput: Promise<boolean>;
	    readonly isBlockedInOutput: Promise<boolean>;
	    readonly isBlockedInInput2: Promise<boolean>;
	    readonly isBlockedInOutput2: Promise<boolean>;
	    readonly isAutoAddressing: Promise<boolean>;
	    readonly isKeyInControlCode: Promise<boolean>;
	    readonly controlCode: Promise<string>;
	    readonly reorderPoint: Promise<decimal | null>;
	    readonly replenishmentType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly replenishmentLevel: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	    readonly percentageOccupied: Promise<integer | null>;
	    readonly parity: Promise<sageWhMasterData.enums.Parity | null>;
	    readonly isTemporaryPicking: Promise<boolean>;
	    readonly isPickingPivot: Promise<boolean>;
	    readonly wavePivot: Promise<string>;
	    readonly pickingPriority: Promise<integer | null>;
	    readonly isUsed: Promise<boolean>;
	    readonly controlDimension: Promise<sageWhMasterData.enums.ControlOfDimensions | null>;
	    readonly isActive: Promise<boolean>;
	    readonly isDockLeveler: Promise<boolean>;
	    readonly completeObjectsAddressingThreshold: Promise<decimal | null>;
	    readonly displayCode: Promise<string>;
	    readonly storeLocationCode: Promise<string>;
	    readonly storeLocationKey: Promise<string>;
	    readonly splitAddresses: Collection<sageWhMasterData.nodes.LocationSplitAddresses>;
	}
	//# sourceMappingURL=location.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/location-split-addresses.d.ts
declare module '@sage/wh-master-data/lib/nodes/location-split-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class LocationSplitAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly store: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Location>;
	    readonly splitAddress: Promise<string>;
	}
	//# sourceMappingURL=location-split-addresses.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/index.d.ts
declare module '@sage/wh-master-data/lib/nodes/index' {
	export * from '@sage/wh-master-data/lib/nodes/appointment-management';
	export * from '@sage/wh-master-data/lib/nodes/assignment-class-chaining-assignments';
	export * from '@sage/wh-master-data/lib/nodes/assignment-class';
	export * from '@sage/wh-master-data/lib/nodes/carrier-addresses';
	export * from '@sage/wh-master-data/lib/nodes/carrier-company-names';
	export * from '@sage/wh-master-data/lib/nodes/carrier-tariffication-types';
	export * from '@sage/wh-master-data/lib/nodes/carrier-transportation-methods';
	export * from '@sage/wh-master-data/lib/nodes/carrier';
	export * from '@sage/wh-master-data/lib/nodes/common-image';
	export * from '@sage/wh-master-data/lib/nodes/currency-rate';
	export * from '@sage/wh-master-data/lib/nodes/currency';
	export * from '@sage/wh-master-data/lib/nodes/customer-adresses';
	export * from '@sage/wh-master-data/lib/nodes/customer-company-names';
	export * from '@sage/wh-master-data/lib/nodes/customer';
	export * from '@sage/wh-master-data/lib/nodes/depositor-addresses';
	export * from '@sage/wh-master-data/lib/nodes/depositor-cross-docking-priorities';
	export * from '@sage/wh-master-data/lib/nodes/depositor-names';
	export * from '@sage/wh-master-data/lib/nodes/depositor-picking-pivot-priorities';
	export * from '@sage/wh-master-data/lib/nodes/depositor';
	export * from '@sage/wh-master-data/lib/nodes/generic-round-time-limit-per-days';
	export * from '@sage/wh-master-data/lib/nodes/generic-round';
	export * from '@sage/wh-master-data/lib/nodes/generic-wave';
	export * from '@sage/wh-master-data/lib/nodes/location-split-addresses';
	export * from '@sage/wh-master-data/lib/nodes/location';
	export * from '@sage/wh-master-data/lib/nodes/movement-code';
	export * from '@sage/wh-master-data/lib/nodes/operand';
	export * from '@sage/wh-master-data/lib/nodes/parcel-type';
	export * from '@sage/wh-master-data/lib/nodes/preparation-area-parameters-for-preparation-order';
	export * from '@sage/wh-master-data/lib/nodes/preparation-area';
	export * from '@sage/wh-master-data/lib/nodes/range-of-parcel';
	export * from '@sage/wh-master-data/lib/nodes/rotation-class-rotation-classes-chaining';
	export * from '@sage/wh-master-data/lib/nodes/rotation-class';
	export * from '@sage/wh-master-data/lib/nodes/serial-group';
	export * from '@sage/wh-master-data/lib/nodes/shipping-unit-type';
	export * from '@sage/wh-master-data/lib/nodes/stock-count-class';
	export * from '@sage/wh-master-data/lib/nodes/stock-nature';
	export * from '@sage/wh-master-data/lib/nodes/storage-type';
	export * from '@sage/wh-master-data/lib/nodes/store-addresses-code';
	export * from '@sage/wh-master-data/lib/nodes/store-addresses-description';
	export * from '@sage/wh-master-data/lib/nodes/store-addresses-format';
	export * from '@sage/wh-master-data/lib/nodes/store-addresses-length';
	export * from '@sage/wh-master-data/lib/nodes/store-addresses-type';
	export * from '@sage/wh-master-data/lib/nodes/store-chaining-stores-chaining';
	export * from '@sage/wh-master-data/lib/nodes/store-chaining';
	export * from '@sage/wh-master-data/lib/nodes/store-putaway-orders';
	export * from '@sage/wh-master-data/lib/nodes/store-start-levels';
	export * from '@sage/wh-master-data/lib/nodes/store';
	export * from '@sage/wh-master-data/lib/nodes/supplier-adresses';
	export * from '@sage/wh-master-data/lib/nodes/supplier-company-names';
	export * from '@sage/wh-master-data/lib/nodes/supplier';
	export * from '@sage/wh-master-data/lib/nodes/tariff-code';
	export * from '@sage/wh-master-data/lib/nodes/transport-mode';
	export * from '@sage/wh-master-data/lib/nodes/transport-type';
	export * from '@sage/wh-master-data/lib/nodes/truck-tracking-status';
	export * from '@sage/wh-master-data/lib/nodes/unit-of-measure';
	export * from '@sage/wh-master-data/lib/nodes/volume-class-volume-classes-chaining';
	export * from '@sage/wh-master-data/lib/nodes/volume-class';
	export * from '@sage/wh-master-data/lib/nodes/wh-site-addressing-priorities';
	export * from '@sage/wh-master-data/lib/nodes/wh-site-is-no-work-days';
	export * from '@sage/wh-master-data/lib/nodes/wh-site-supplier-bar-codes';
	export * from '@sage/wh-master-data/lib/nodes/wh-site';
	export * from '@sage/wh-master-data/lib/nodes/work-center';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/generic-wave.d.ts
declare module '@sage/wh-master-data/lib/nodes/generic-wave' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class GenericWave extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	    readonly priority: Promise<integer | null>;
	    readonly criteria: Promise<string>;
	    readonly workCenter: Reference<sageWhMasterData.nodes.WorkCenter | null>;
	    readonly unitOfMeasure: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly maximumLoadLimit: Promise<decimal | null>;
	    readonly isAdditionAuthorized: Promise<boolean>;
	    readonly isSingleDeliveryOrderWave: Promise<boolean>;
	    readonly isMergingOfFlows: Promise<boolean>;
	    readonly isAutomaticRelease: Promise<boolean>;
	    readonly isMissionToBlock: Promise<boolean>;
	    readonly missionPriority: Promise<integer | null>;
	    readonly siteDepositorIdentifier: Promise<string>;
	}
	//# sourceMappingURL=generic-wave.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/generic-round.d.ts
declare module '@sage/wh-master-data/lib/nodes/generic-round' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class GenericRound extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly dock: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly duration: Promise<string>;
	    readonly maximumWeight: Promise<decimal | null>;
	    readonly maximumVolume: Promise<decimal | null>;
	    readonly maximumLinearMeters: Promise<decimal | null>;
	    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
	    readonly shipToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly pickingLeadTime: Promise<string>;
	    readonly isInterSiteRoundManagement: Promise<boolean>;
	    readonly destinationSite: Reference<sageWhSystem.nodes.Site | null>;
	    readonly isActive: Promise<boolean>;
	    readonly timeLimitPerDays: Collection<sageWhMasterData.nodes.GenericRoundTimeLimitPerDays>;
	}
	//# sourceMappingURL=generic-round.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/generic-round-time-limit-per-days.d.ts
declare module '@sage/wh-master-data/lib/nodes/generic-round-time-limit-per-days' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class GenericRoundTimeLimitPerDays extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.GenericRound>;
	    readonly timeLimitPerDay: Promise<string>;
	}
	//# sourceMappingURL=generic-round-time-limit-per-days.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/depositor.d.ts
declare module '@sage/wh-master-data/lib/nodes/depositor' {
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class Depositor extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly postalCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly region: Promise<string>;
	    readonly country: Reference<sageWhStructure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly phone: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly siteTaxIdNumber: Promise<string>;
	    readonly email: Promise<string>;
	    readonly registeredCapital: Promise<string>;
	    readonly rcs: Promise<string>;
	    readonly isSupportNumber: Promise<boolean>;
	    readonly isLotNumber: Promise<boolean>;
	    readonly storingListValidation: Promise<sageWhMasterData.enums.ValidationType>;
	    readonly isControlInputFlow: Promise<boolean>;
	    readonly isPutAlwayLabel: Promise<boolean>;
	    readonly isStoringList: Promise<boolean>;
	    readonly isSingleInputStoringList: Promise<boolean>;
	    readonly isSingleStoreStoringList: Promise<boolean>;
	    readonly printSequenceOfStoringList: Promise<sageWhMasterData.enums.PrintingSequence>;
	    readonly isStoringListControlCode: Promise<boolean>;
	    readonly isStoringListOperatorCode: Promise<boolean>;
	    readonly uniqueInputReference: Promise<sageWhMasterData.enums.UniqueReference>;
	    readonly quantityControlInInput: Promise<sageWhMasterData.enums.QuantityControlInputLine>;
	    readonly isOutputOnPendingInput: Promise<boolean>;
	    readonly isSplitReplenishmentObjects: Promise<boolean>;
	    readonly isReplenishmentBalanceReaddressing: Promise<boolean>;
	    readonly isControlOutputFlow: Promise<boolean>;
	    readonly isOutputShortageManagement: Promise<boolean>;
	    readonly isPartialsByProduct: Promise<boolean>;
	    readonly isShortageByDeliveryOrder: Promise<boolean>;
	    readonly isPreparationLoad: Promise<boolean>;
	    readonly replenishmentValidation: Promise<sageWhMasterData.enums.ValidationType>;
	    readonly isReplenishList: Promise<boolean>;
	    readonly isReplenishLabel: Promise<boolean>;
	    readonly isPreparationOrderOperatorCode: Promise<boolean>;
	    readonly isDeclarativePackingOperatorCode: Promise<boolean>;
	    readonly isPrepackingOperatorCode: Promise<boolean>;
	    readonly isPickOperatorCode: Promise<boolean>;
	    readonly isSuOperatorCode: Promise<boolean>;
	    readonly isRoOperatorCode: Promise<boolean>;
	    readonly uniqueOutputReference: Promise<sageWhMasterData.enums.UniqueReference>;
	    readonly isOrderManagement: Promise<boolean>;
	    readonly isGenericRoundManagement: Promise<boolean>;
	    readonly isSingleParcelItem: Promise<boolean>;
	    readonly isStrictSequentiality: Promise<boolean>;
	    readonly shippingUnitTypeShippingAsIs: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
	    readonly isShippingUnitClosingAuthorization: Promise<boolean>;
	    readonly isShipmentManagement: Promise<boolean>;
	    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly keyInRealParcelWeight: Promise<sageWhMasterData.enums.KyInInformation>;
	    readonly enterShippingUnitInfo: Promise<sageWhMasterData.enums.SuInformationEntry>;
	    readonly isParcelPalletisation: Promise<boolean>;
	    readonly isControlLoadingParcel: Promise<boolean>;
	    readonly parcelTypeDispatchableInState: Reference<sageWhMasterData.nodes.ParcelType | null>;
	    readonly parcelRangeDispatchableInState: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly printDeliveryNotes: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly isPrintMergingOfFlowsTransferReport: Promise<boolean>;
	    readonly isPrintMergingOfFlowsTransferLabel: Promise<boolean>;
	    readonly isPrintParcelLabels: Promise<boolean>;
	    readonly isShippingUnitLabels: Promise<boolean>;
	    readonly isPalletizationOrderLabels: Promise<boolean>;
	    readonly isGroupedsLabels: Promise<boolean>;
	    readonly isControlCodeOfPick: Promise<boolean>;
	    readonly isControlCodeOfDeposit: Promise<boolean>;
	    readonly isControlCodeOfOutput: Promise<boolean>;
	    readonly addressingPriority: Promise<sageWhMasterData.enums.MergingOfFlowsPriority>;
	    readonly transferMergingOfFlowsValidation: Promise<sageWhMasterData.enums.ValidationType>;
	    readonly isGroupMergingOfFlows: Promise<boolean>;
	    readonly isParcelVolumeManagement: Promise<boolean>;
	    readonly launchingMergingOfFlowsStep2: Promise<sageWhMasterData.enums.ValidationType | null>;
	    readonly isPrintTemporaryDeliveryNotes: Promise<boolean>;
	    readonly deliveryOrderStatusForDeliveryNotes: Promise<sageWhMasterData.enums.DoHeaderStatus | null>;
	    readonly isPrintFinalDeliveryNotes: Promise<boolean>;
	    readonly isPrintDifferentialDeliveryNotes: Promise<boolean>;
	    readonly isMovementInSuperiorContainer: Promise<boolean>;
	    readonly isSingleDeliveryOrderShippingUnit: Promise<boolean>;
	    readonly isSingleConsigneeShippingUnit: Promise<boolean>;
	    readonly isAutoPalettizeBigParcels: Promise<boolean>;
	    readonly shippingUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
	    readonly autoTransferMovementAdjustementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly auto2PhaseTransferMovementAdjustementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly waveReplenishment: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly balanceMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly mergingOfFlowsTransfer: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly transferOfComponent: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly kitTransfer: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly isInitializeCarrierAndTransportMode: Promise<boolean>;
	    readonly adjustmentAfterStockCount: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly isStockAvailable: Promise<boolean>;
	    readonly isPickingStock: Promise<boolean>;
	    readonly isTransferOfIncomplete: Promise<boolean>;
	    readonly uniqueReference: Promise<sageWhMasterData.enums.UniqueReference | null>;
	    readonly componentTransferValidation: Promise<sageWhMasterData.enums.ValidationType | null>;
	    readonly kitTransferValidation: Promise<sageWhMasterData.enums.ValidationType | null>;
	    readonly isShortagePerItem: Promise<boolean>;
	    readonly isShortagePerPreparationOrder: Promise<boolean>;
	    readonly isKitOperatorCode: Promise<boolean>;
	    readonly isComponentOperatorCode: Promise<boolean>;
	    readonly analysisKitMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly analysisComponentMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly isComponentTransferList: Promise<boolean>;
	    readonly isComponentTransferLabel: Promise<boolean>;
	    readonly isSinglePreparationAreaKitRemoval: Promise<boolean>;
	    readonly isSinglePreparationAreaKitRelocation: Promise<boolean>;
	    readonly isSplittingKit: Promise<boolean>;
	    readonly maximumPrepaprationAreaKit: Reference<sageWhMasterData.nodes.PreparationArea | null>;
	    readonly customerControl: Promise<sageWhMasterData.enums.CustomerEnum | null>;
	    readonly isInputsConfigurationFlag: Promise<boolean>;
	    readonly isOutputsConfigurationFlag: Promise<boolean>;
	    readonly isStocksConfigurationFlag: Promise<boolean>;
	    readonly isPickReplenishOrderMonoPreparationArea: Promise<boolean>;
	    readonly isDepositorReplenishOrderMonoPreparationArea: Promise<boolean>;
	    readonly isPickMergingOfFlowsMonoPreparationArea: Promise<boolean>;
	    readonly isDepositorMergingOfFlowsMonoPreparationArea: Promise<boolean>;
	    readonly isMergingOfflowsDivision: Promise<boolean>;
	    readonly mergingOfFlowsPreparationAreaMax: Reference<sageWhMasterData.nodes.PreparationArea | null>;
	    readonly refuseStockNature: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly consumedStockNature: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly isAutomaticAddressing: Promise<boolean>;
	    readonly isQualityOperatorCode: Promise<boolean>;
	    readonly isValidationAnalysisRequestOperatorCode: Promise<boolean>;
	    readonly autoAnalysisRequestAdjustementMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly autoAnalysisRequestTransfertMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly isAutoPrintQualityRecord: Promise<boolean>;
	    readonly sequenceCode: Reference<sageWhMasterData.nodes.StoreChaining | null>;
	    readonly isChainingStore: Promise<boolean>;
	    readonly isChainingRotationClasse: Promise<boolean>;
	    readonly isChainingAssignmentClasses: Promise<boolean>;
	    readonly isCrossDockingManagement: Promise<boolean>;
	    readonly crossDockingLevel: Promise<sageWhMasterData.enums.CrossDockingBlockingLevel | null>;
	    readonly isCrossDockingStoreStock: Promise<boolean>;
	    readonly isCrossDockingStoreStockNotAvailable: Promise<boolean>;
	    readonly isReserveStockNotAvailable: Promise<boolean>;
	    readonly isDirectInputMovementNotAddressed: Promise<boolean>;
	    readonly isExpectedInputUnderReceipt: Promise<boolean>;
	    readonly isAlwaysExpressRequirement: Promise<boolean>;
	    readonly isWaveInitialization: Promise<boolean>;
	    readonly ssccExtensionCharacter: Promise<string>;
	    readonly eanUccCode: Promise<string>;
	    readonly isSsccParcelOnOutput: Promise<boolean>;
	    readonly isSsccShippingUnitOnOutput: Promise<boolean>;
	    readonly isStockOnDockParcels: Promise<boolean>;
	    readonly isStockOnDockShippingUnit: Promise<boolean>;
	    readonly isStockOnDockOperation: Promise<boolean>;
	    readonly isStockOnDockValidation: Promise<boolean>;
	    readonly interSiteDeliveryNotePrinting: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly log: Promise<string>;
	    readonly isDefaultReceiptMode: Promise<boolean>;
	    readonly isDefaultPickingMode: Promise<boolean>;
	    readonly isUnavailablePendingInput: Promise<boolean>;
	    readonly isUnavailableReorderInProcess: Promise<boolean>;
	    readonly seiDepositor: Promise<string>;
	    readonly addresses: Collection<sageWhMasterData.nodes.DepositorAddresses>;
	    readonly crossDockingPriorities: Collection<sageWhMasterData.nodes.DepositorCrossDockingPriorities>;
	    readonly names: Collection<sageWhMasterData.nodes.DepositorNames>;
	    readonly pickingPivotPriorities: Collection<sageWhMasterData.nodes.DepositorPickingPivotPriorities>;
	}
	//# sourceMappingURL=depositor.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/depositor-picking-pivot-priorities.d.ts
declare module '@sage/wh-master-data/lib/nodes/depositor-picking-pivot-priorities' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class DepositorPickingPivotPriorities extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly pickingPivotPriority: Promise<sageWhMasterData.enums.PivotPickingPriority | null>;
	}
	//# sourceMappingURL=depositor-picking-pivot-priorities.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/depositor-names.d.ts
declare module '@sage/wh-master-data/lib/nodes/depositor-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class DepositorNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly name: Promise<string>;
	}
	//# sourceMappingURL=depositor-names.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/depositor-cross-docking-priorities.d.ts
declare module '@sage/wh-master-data/lib/nodes/depositor-cross-docking-priorities' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class DepositorCrossDockingPriorities extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly crossDockingPriority: Promise<sageWhMasterData.enums.CrossDockingOutputPriority | null>;
	}
	//# sourceMappingURL=depositor-cross-docking-priorities.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/depositor-addresses.d.ts
declare module '@sage/wh-master-data/lib/nodes/depositor-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class DepositorAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly address: Promise<string>;
	}
	//# sourceMappingURL=depositor-addresses.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/customer.d.ts
declare module '@sage/wh-master-data/lib/nodes/customer' {
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class Customer extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly postalCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly region: Promise<string>;
	    readonly country: Reference<sageWhStructure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly telephone: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly billToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly notes: Promise<string>;
	    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly roundPosition: Promise<integer | null>;
	    readonly deliveryArea: Promise<string>;
	    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
	    readonly currency: Reference<sageWhMasterData.nodes.Currency>;
	    readonly partialDeliveryManagement: Promise<sageWhMasterData.enums.PartialDeliveryAuthorized | null>;
	    readonly servicePriority: Promise<sageWhMasterData.enums.ServicePriority | null>;
	    readonly isCarriageAmountCalculation: Promise<boolean>;
	    readonly tariffCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
	    readonly printLanguage: Reference<sageWhSystem.nodes.Language>;
	    readonly deliveryNotePrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly isSsccManagementOnOutput: Promise<boolean>;
	    readonly isLotManagement: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly adresses: Collection<sageWhMasterData.nodes.CustomerAdresses>;
	    readonly companyNames: Collection<sageWhMasterData.nodes.CustomerCompanyNames>;
	}
	//# sourceMappingURL=customer.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/customer-company-names.d.ts
declare module '@sage/wh-master-data/lib/nodes/customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Customer>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=customer-company-names.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/customer-adresses.d.ts
declare module '@sage/wh-master-data/lib/nodes/customer-adresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CustomerAdresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Customer>;
	    readonly adress: Promise<string>;
	}
	//# sourceMappingURL=customer-adresses.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/currency.d.ts
declare module '@sage/wh-master-data/lib/nodes/currency' {
	import { Node, decimal, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class Currency extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly rounding: Promise<decimal | null>;
	    readonly format1: Promise<string>;
	    readonly format2: Promise<string>;
	    readonly format3: Promise<string>;
	    readonly isEuro: Promise<boolean>;
	    readonly euroRate: Promise<decimal | null>;
	    readonly euroConversionDate: Promise<date | null>;
	    readonly currencyEndDate: Promise<date | null>;
	    readonly symbol: Promise<string>;
	    readonly numberOfDecimals: Promise<integer | null>;
	    readonly isoCode: Promise<string>;
	    readonly isoNumericCode: Promise<string>;
	    readonly currencyRates: Collection<sageWhMasterData.nodes.CurrencyRate>;
	}
	//# sourceMappingURL=currency.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/currency-rate.d.ts
declare module '@sage/wh-master-data/lib/nodes/currency-rate' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, decimal } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CurrencyRate extends Node {
	    readonly rateType: Promise<sageWhSystem.enums.ExchangeRateType | null>;
	    readonly sourceCurrency: Reference<sageWhMasterData.nodes.Currency>;
	    readonly destinationCurrency: Reference<sageWhMasterData.nodes.Currency>;
	    readonly rateDate: Promise<date>;
	    readonly inverseRate: Promise<decimal | null>;
	    readonly rate: Promise<decimal | null>;
	    readonly divisor: Promise<decimal | null>;
	}
	//# sourceMappingURL=currency-rate.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/common-image.d.ts
declare module '@sage/wh-master-data/lib/nodes/common-image' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, BinaryStream } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CommonImage extends Node {
	    readonly code: Promise<string>;
	    readonly site: Reference<sageWhSystem.nodes.Site | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly identifier3: Promise<string>;
	    readonly filename: Promise<string>;
	    readonly image: Promise<BinaryStream>;
	}
	//# sourceMappingURL=common-image.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/carrier.d.ts
declare module '@sage/wh-master-data/lib/nodes/carrier' {
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class Carrier extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly postalCode: Promise<string>;
	    readonly city: Promise<string>;
	    readonly region: Promise<string>;
	    readonly country: Reference<sageWhStructure.nodes.Country | null>;
	    readonly countryName: Promise<string>;
	    readonly telephone: Promise<string>;
	    readonly fax: Promise<string>;
	    readonly email: Promise<string>;
	    readonly carriageNotePrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly carriageReceiptPrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly carriageNoteTariffCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
	    readonly carriageReceiptTariffCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
	    readonly isCarriageNoteAmountCalculation: Promise<boolean>;
	    readonly isCarriageReceiptAmountCalculation: Promise<boolean>;
	    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
	    readonly isEdiManagement: Promise<boolean>;
	    readonly interSiteCarriageNotePrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly interSiteCarriageReceiptPrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
	    readonly isActive: Promise<boolean>;
	    readonly addresses: Collection<sageWhMasterData.nodes.CarrierAddresses>;
	    readonly companyNames: Collection<sageWhMasterData.nodes.CarrierCompanyNames>;
	    readonly tarifficationTypes: Collection<sageWhMasterData.nodes.CarrierTarifficationTypes>;
	    readonly transportationMethods: Collection<sageWhMasterData.nodes.CarrierTransportationMethods>;
	}
	//# sourceMappingURL=carrier.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/carrier-transportation-methods.d.ts
declare module '@sage/wh-master-data/lib/nodes/carrier-transportation-methods' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CarrierTransportationMethods extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Carrier>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	}
	//# sourceMappingURL=carrier-transportation-methods.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/carrier-tariffication-types.d.ts
declare module '@sage/wh-master-data/lib/nodes/carrier-tariffication-types' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CarrierTarifficationTypes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Carrier>;
	    readonly tarifficationType: Promise<sageWhMasterData.enums.TarificationType | null>;
	}
	//# sourceMappingURL=carrier-tariffication-types.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/carrier-company-names.d.ts
declare module '@sage/wh-master-data/lib/nodes/carrier-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CarrierCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Carrier>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=carrier-company-names.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/carrier-addresses.d.ts
declare module '@sage/wh-master-data/lib/nodes/carrier-addresses' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CarrierAddresses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.Carrier>;
	    readonly address: Promise<string>;
	}
	//# sourceMappingURL=carrier-addresses.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/assignment-class.d.ts
declare module '@sage/wh-master-data/lib/nodes/assignment-class' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class AssignmentClass extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly numberOfChainings: Promise<integer | null>;
	    readonly outsizeManagement: Promise<sageWhMasterData.enums.Outsize | null>;
	    readonly isActive: Promise<boolean>;
	    readonly chainingAssignments: Collection<sageWhMasterData.nodes.AssignmentClassChainingAssignments>;
	}
	//# sourceMappingURL=assignment-class.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/assignment-class-chaining-assignments.d.ts
declare module '@sage/wh-master-data/lib/nodes/assignment-class-chaining-assignments' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class AssignmentClassChainingAssignments extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhMasterData.nodes.AssignmentClass>;
	    readonly chainingAssignmentClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
	}
	//# sourceMappingURL=assignment-class-chaining-assignments.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/nodes/appointment-management.d.ts
declare module '@sage/wh-master-data/lib/nodes/appointment-management' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, decimal, TextStream } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class AppointmentManagement extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly appointmentType: Promise<sageWhMasterData.enums.AppointmentType | null>;
	    readonly appointmentStatus: Promise<sageWhMasterData.enums.AppointmentStatus | null>;
	    readonly appointmentCreationType: Promise<sageWhMasterData.enums.AppointmentCreationType | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
	    readonly creationDate: Promise<date>;
	    readonly expectedDockAssignmentStartDate: Promise<date | null>;
	    readonly expectedDockAssignmentEndDate: Promise<date | null>;
	    readonly actualDockAssignmentStartDate: Promise<date | null>;
	    readonly actualDockAssignmentEndDate: Promise<date | null>;
	    readonly effectiveStartDate: Promise<date | null>;
	    readonly effectiveEndDate: Promise<date | null>;
	    readonly expectedTruckArrivalDate: Promise<date | null>;
	    readonly expectedTruckDepartureDate: Promise<date | null>;
	    readonly actualTruckArrivalDate: Promise<date | null>;
	    readonly actualTruckDepartureDate: Promise<date | null>;
	    readonly creationTime: Promise<string>;
	    readonly expectedDockAssignmentDuration: Promise<string>;
	    readonly expectedStartTime: Promise<string>;
	    readonly expectedEndTime: Promise<string>;
	    readonly actualStartTime: Promise<string>;
	    readonly actualEndTime: Promise<string>;
	    readonly effectiveStartTime: Promise<string>;
	    readonly effectiveEndTime: Promise<string>;
	    readonly expectedTruckArrivalTime: Promise<string>;
	    readonly expectedTruckDepartureTime: Promise<string>;
	    readonly actualTruckArrivalTime: Promise<string>;
	    readonly actualTruckDepartureTime: Promise<string>;
	    readonly status: Promise<sageWhMasterData.enums.RoundStatus | null>;
	    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
	    readonly carrierName: Promise<string>;
	    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
	    readonly carriageReference: Promise<string>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly dock: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly linearMeters: Promise<decimal | null>;
	    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
	    readonly customer: Reference<sageWhMasterData.nodes.Customer | null>;
	    readonly supplier: Reference<sageWhMasterData.nodes.Supplier | null>;
	    readonly truckTrackingStatus: Reference<sageWhMasterData.nodes.TruckTrackingStatus | null>;
	    readonly comment: Promise<TextStream>;
	    readonly workCenter: Reference<sageWhMasterData.nodes.WorkCenter | null>;
	    readonly unit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly estimatedLoad: Promise<decimal | null>;
	    readonly loadWeight: Promise<decimal | null>;
	}
	//# sourceMappingURL=appointment-management.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/node-extensions/user-extension.d.ts
declare module '@sage/wh-master-data/lib/node-extensions/user-extension' {
	import * as sageWhSystem from '@sage/wh-system';
	import { NodeExtension } from '@sage/xtrem-core';
	export class UserExtension extends NodeExtension<sageWhSystem.nodes.User> {
	    readonly currentDepositorCode: Promise<string>;
	    readonly currentSiteCode: Promise<string>;
	    readonly defaultSiteCode: Promise<string>;
	    readonly isAllowedDepositorChange: Promise<boolean | null>;
	    readonly isAllowedSiteChange: Promise<boolean | null>;
	}
	declare module '@sage/wh-system/lib/nodes/user' {
	    interface User extends UserExtension {
	    }
	}
	//# sourceMappingURL=user-extension.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/node-extensions/site-extension.d.ts
declare module '@sage/wh-master-data/lib/node-extensions/site-extension' {
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	export class SiteExtension extends NodeExtension<sageWhSystem.nodes.Site> {
	    readonly country: Reference<sageWhStructure.nodes.Country>;
	}
	declare module '@sage/wh-system/lib/nodes/site' {
	    interface Site extends SiteExtension {
	    }
	}
	//# sourceMappingURL=site-extension.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/node-extensions/index.d.ts
declare module '@sage/wh-master-data/lib/node-extensions/index' {
	export * from '@sage/wh-master-data/lib/node-extensions/company-extension';
	export * from '@sage/wh-master-data/lib/node-extensions/site-extension';
	export * from '@sage/wh-master-data/lib/node-extensions/user-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/node-extensions/company-extension.d.ts
declare module '@sage/wh-master-data/lib/node-extensions/company-extension' {
	import * as sageWhStructure from '@sage/wh-structure';
	import * as sageWhSystem from '@sage/wh-system';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	export class CompanyExtension extends NodeExtension<sageWhSystem.nodes.Company> {
	    readonly country: Reference<sageWhStructure.nodes.Country | null>;
	    readonly registredCapitalCurrency: Reference<sageWhMasterData.nodes.Currency | null>;
	    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
	}
	declare module '@sage/wh-system/lib/nodes/company' {
	    interface Company extends CompanyExtension {
	    }
	}
	//# sourceMappingURL=company-extension.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/menu-items/utilities.d.ts
declare module '@sage/wh-master-data/lib/menu-items/utilities' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const utilities: RootMenuItem;
	//# sourceMappingURL=utilities.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/menu-items/stock.d.ts
declare module '@sage/wh-master-data/lib/menu-items/stock' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const stock: RootMenuItem;
	//# sourceMappingURL=stock.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/menu-items/stock-control.d.ts
declare module '@sage/wh-master-data/lib/menu-items/stock-control' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const stockControl: RootMenuItem;
	//# sourceMappingURL=stock-control.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/menu-items/receipt.d.ts
declare module '@sage/wh-master-data/lib/menu-items/receipt' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const receipt: RootMenuItem;
	//# sourceMappingURL=receipt.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/menu-items/issue.d.ts
declare module '@sage/wh-master-data/lib/menu-items/issue' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const issue: RootMenuItem;
	//# sourceMappingURL=issue.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/menu-items/index.d.ts
declare module '@sage/wh-master-data/lib/menu-items/index' {
	export * from '@sage/wh-master-data/lib/menu-items/issue';
	export * from '@sage/wh-master-data/lib/menu-items/receipt';
	export * from '@sage/wh-master-data/lib/menu-items/stock';
	export * from '@sage/wh-master-data/lib/menu-items/stock-control';
	export * from '@sage/wh-master-data/lib/menu-items/utilities';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/interfaces/index.d.ts
declare module '@sage/wh-master-data/lib/interfaces/index' {
	export * from '@sage/wh-master-data/lib/interfaces/constants';
	export * from '@sage/wh-master-data/lib/interfaces/environnement';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/interfaces/environnement.d.ts
declare module '@sage/wh-master-data/lib/interfaces/environnement' {
	export interface DepositorConfiguration {
	    isLotNumber: boolean;
	    isSupportNumber: boolean;
	}
	export interface SiteConfiguration {
	    eanDefaultMethod: string;
	    isDripAndDropAllowed: boolean;
	    supplierBarCodeRange1: [number, number];
	    supplierBarCodeRange2: [number, number];
	}
	export interface StockUnit {
	    code: string;
	    numberOfDecimals?: number;
	}
	export interface SiteDepositorSelected {
	    siteCode: string;
	    depositorCode: string;
	}
	export interface StoreLocationSelected {
	    storeCode?: string;
	    locationCode?: string;
	    locationType?: string;
	    referenceContainerCode?: string;
	}
	//# sourceMappingURL=environnement.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/interfaces/constants.d.ts
declare module '@sage/wh-master-data/lib/interfaces/constants' {
	import { ContainerLevel } from '@sage/wh-master-data/lib/enums/index';
	export const hightestContainerLevel: ContainerLevel;
	//# sourceMappingURL=constants.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/functions/user-extension.d.ts
declare module '@sage/wh-master-data/lib/functions/user-extension' {
	import * as whSystem from '@sage/wh-system';
	import { ExtensionMembers } from '@sage/xtrem-core';
	import * as whMasterData from '@sage/wh-master-data/lib/index';
	/**
	 * get default site code
	 * @param _this
	 * @returns default site for current user
	 */
	export function getDefaultSiteCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
	/**
	 *  get site code for current user
	 * @param _this
	 * @param user
	 * @returns
	 */
	export function getCurrentSiteCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
	/**
	 * get depositor code for current user
	 * @param _this
	 * @param user
	 * @returns
	 */
	export function getCurrentDepositorCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
	/**
	 * Check if you can enter the site
	 * @param _this
	 * @returns
	 */
	export function getByUserIsAllowedSiteChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
	/**
	 * Check if you can enter the depositor
	 *  @param _this
	 * @returns
	 */
	export function getByUserIsAllowedDepositorChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
	/**
	 * get site code for given user
	 * @param this
	 * @param userCode
	 * @returns default site for the user
	 */
	export function getByUserCurrentSiteCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
	/**
	 * get depositor code for given user
	 *  @param this
	 * @param user
	 * @returns default depositor for the user
	 */
	export function getByUserCurrentDepositorCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
	/**
	 * Check if the given user can enter the site
	 * @param _this
	 * @param userCode
	 * @returns
	 */
	export function getIsUserAllowedSiteChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
	/**
	 * Check if the given user can enter the depositor
	 * @param _this
	 * @param userCode
	 * @returns
	 */
	export function getIsUserAllowedDepositorChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
	/**
	 * Read site from given site
	 * Only instance with property code
	 * @param _this
	 * @param siteCode
	 * @returns site when exist
	 */
	export function readSite(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>, siteCode: string): Promise<whSystem.nodes.Site | null>;
	/**
	 *  Read user from given user code for print destinations and site depositor
	 * @param pageInstance
	 * @param userCode
	 * @returns
	 */
	export function readUser(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>, userCode?: string | null): Promise<whSystem.nodes.User | null>;
	/**
	 * Read record section
	 */
	/**
	 * Read depositor from given site and depositor codes
	 * Only instance with property site and code
	 * @param _this
	 * @param siteCode
	 * @param depositorCode
	 * @returns depositor when exist
	 */
	export function readDepositor(_this: whMasterData.nodes.Depositor, siteCode: string, depositorCode: string): Promise<whMasterData.nodes.Depositor | null>;
	//# sourceMappingURL=user-extension.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/functions/location.d.ts
declare module '@sage/wh-master-data/lib/functions/location' {
	import * as sageWhMasterData from '@sage/wh-master-data/lib/index';
	/**
	 * Get the location key for a store location (SQL mutation).
	 * @param _this The location object.
	 * @returns The location key as a string.
	 */
	export function getDisplayCode(_this: sageWhMasterData.nodes.Location): Promise<string>;
	/**
	 * Get the location code for a store location (SQL mutation).
	 * @param _this The location object.
	 * @returns The location code as a string.
	 */
	export function getStoreLocationCode(_this: sageWhMasterData.nodes.Location): Promise<string>;
	//# sourceMappingURL=location.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/functions/index.d.ts
declare module '@sage/wh-master-data/lib/functions/index' {
	export * from '@sage/wh-master-data/lib/functions/location';
	export * from '@sage/wh-master-data/lib/functions/user-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/validation-type.d.ts
declare module '@sage/wh-master-data/lib/enums/validation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValidationTypeEnum {
	    manual = 1,
	    automatic = 2
	}
	export interface ValidationType$EnumInterface {
	    manual: 1;
	    automatic: 2;
	}
	export type ValidationType = keyof ValidationType$EnumInterface;
	export const validationTypeDatatype: X3EnumDataType<keyof ValidationType$EnumInterface, unknown>;
	//# sourceMappingURL=validation-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/unstoring-type.d.ts
declare module '@sage/wh-master-data/lib/enums/unstoring-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UnstoringTypeEnum {
	    fifo = 1,
	    lifo = 2
	}
	export interface UnstoringType$EnumInterface {
	    fifo: 1;
	    lifo: 2;
	}
	export type UnstoringType = keyof UnstoringType$EnumInterface;
	export const unstoringTypeDatatype: X3EnumDataType<keyof UnstoringType$EnumInterface, unknown>;
	//# sourceMappingURL=unstoring-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/unique-reference.d.ts
declare module '@sage/wh-master-data/lib/enums/unique-reference' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UniqueReferenceEnum {
	    no = 1,
	    yes = 2,
	    yesIfNotClosed = 3
	}
	export interface UniqueReference$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesIfNotClosed: 3;
	}
	export type UniqueReference = keyof UniqueReference$EnumInterface;
	export const uniqueReferenceDatatype: X3EnumDataType<keyof UniqueReference$EnumInterface, unknown>;
	//# sourceMappingURL=unique-reference.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/tarification-type.d.ts
declare module '@sage/wh-master-data/lib/enums/tarification-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TarificationTypeEnum {
	    weight = 1,
	    volume = 2,
	    linearMeter = 3,
	    noOfParcel = 4
	}
	export interface TarificationType$EnumInterface {
	    weight: 1;
	    volume: 2;
	    linearMeter: 3;
	    noOfParcel: 4;
	}
	export type TarificationType = keyof TarificationType$EnumInterface;
	export const tarificationTypeDatatype: X3EnumDataType<keyof TarificationType$EnumInterface, unknown>;
	//# sourceMappingURL=tarification-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/su-information-entry.d.ts
declare module '@sage/wh-master-data/lib/enums/su-information-entry' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuInformationEntryEnum {
	    byDefaultAndNonModifiable = 1,
	    byDefaultAndModifiable = 2,
	    modifiable = 3
	}
	export interface SuInformationEntry$EnumInterface {
	    byDefaultAndNonModifiable: 1;
	    byDefaultAndModifiable: 2;
	    modifiable: 3;
	}
	export type SuInformationEntry = keyof SuInformationEntry$EnumInterface;
	export const suInformationEntryDatatype: X3EnumDataType<keyof SuInformationEntry$EnumInterface, unknown>;
	//# sourceMappingURL=su-information-entry.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/store-type.d.ts
declare module '@sage/wh-master-data/lib/enums/store-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StoreTypeEnum {
	    main = 1,
	    singleAddress = 2,
	    splitting = 3,
	    dock = 4,
	    crossDocking = 5,
	    buffer = 6,
	    twoPhaseTransfer = 7
	}
	export interface StoreType$EnumInterface {
	    main: 1;
	    singleAddress: 2;
	    splitting: 3;
	    dock: 4;
	    crossDocking: 5;
	    buffer: 6;
	    twoPhaseTransfer: 7;
	}
	export type StoreType = keyof StoreType$EnumInterface;
	export const storeTypeDatatype: X3EnumDataType<keyof StoreType$EnumInterface, unknown>;
	//# sourceMappingURL=store-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/stock-nature-type.d.ts
declare module '@sage/wh-master-data/lib/enums/stock-nature-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockNatureTypeEnum {
	    general = 1,
	    assembling = 2,
	    qualityControl = 3
	}
	export interface StockNatureType$EnumInterface {
	    general: 1;
	    assembling: 2;
	    qualityControl: 3;
	}
	export type StockNatureType = keyof StockNatureType$EnumInterface;
	export const stockNatureTypeDatatype: X3EnumDataType<keyof StockNatureType$EnumInterface, unknown>;
	//# sourceMappingURL=stock-nature-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/service-priority.d.ts
declare module '@sage/wh-master-data/lib/enums/service-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServicePriorityEnum {
	    lowest = 1,
	    low = 2,
	    medium = 3,
	    mediumHigh = 4,
	    high = 5,
	    highest = 6
	}
	export interface ServicePriority$EnumInterface {
	    lowest: 1;
	    low: 2;
	    medium: 3;
	    mediumHigh: 4;
	    high: 5;
	    highest: 6;
	}
	export type ServicePriority = keyof ServicePriority$EnumInterface;
	export const servicePriorityDatatype: X3EnumDataType<keyof ServicePriority$EnumInterface, unknown>;
	//# sourceMappingURL=service-priority.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/round-status.d.ts
declare module '@sage/wh-master-data/lib/enums/round-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoundStatusEnum {
	    notCompliant = 1,
	    notUsed2 = 2,
	    awaitingTruck = 3,
	    awaitingShipment = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    notUsed8 = 8,
	    validated = 9
	}
	export interface RoundStatus$EnumInterface {
	    notCompliant: 1;
	    notUsed2: 2;
	    awaitingTruck: 3;
	    awaitingShipment: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    notUsed8: 8;
	    validated: 9;
	}
	export type RoundStatus = keyof RoundStatus$EnumInterface;
	export const roundStatusDatatype: X3EnumDataType<keyof RoundStatus$EnumInterface, unknown>;
	//# sourceMappingURL=round-status.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/quantity-control-input-line.d.ts
declare module '@sage/wh-master-data/lib/enums/quantity-control-input-line' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuantityControlInputLineEnum {
	    no = 1,
	    yes = 2,
	    warning = 3
	}
	export interface QuantityControlInputLine$EnumInterface {
	    no: 1;
	    yes: 2;
	    warning: 3;
	}
	export type QuantityControlInputLine = keyof QuantityControlInputLine$EnumInterface;
	export const quantityControlInputLineDatatype: X3EnumDataType<keyof QuantityControlInputLine$EnumInterface, unknown>;
	//# sourceMappingURL=quantity-control-input-line.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/processing-family.d.ts
declare module '@sage/wh-master-data/lib/enums/processing-family' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessingFamilyEnum {
	    inputs = 1,
	    transfers = 2,
	    manualAdjustments = 3,
	    automaticAdjustments = 4,
	    outputs = 5,
	    consumable = 6,
	    assembling = 7,
	    disassembling = 8
	}
	export interface ProcessingFamily$EnumInterface {
	    inputs: 1;
	    transfers: 2;
	    manualAdjustments: 3;
	    automaticAdjustments: 4;
	    outputs: 5;
	    consumable: 6;
	    assembling: 7;
	    disassembling: 8;
	}
	export type ProcessingFamily = keyof ProcessingFamily$EnumInterface;
	export const processingFamilyDatatype: X3EnumDataType<keyof ProcessingFamily$EnumInterface, unknown>;
	//# sourceMappingURL=processing-family.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/printing-sequence.d.ts
declare module '@sage/wh-master-data/lib/enums/printing-sequence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintingSequenceEnum {
	    storeInput = 1,
	    inputStore = 2
	}
	export interface PrintingSequence$EnumInterface {
	    storeInput: 1;
	    inputStore: 2;
	}
	export type PrintingSequence = keyof PrintingSequence$EnumInterface;
	export const printingSequenceDatatype: X3EnumDataType<keyof PrintingSequence$EnumInterface, unknown>;
	//# sourceMappingURL=printing-sequence.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/pivot-picking-priority.d.ts
declare module '@sage/wh-master-data/lib/enums/pivot-picking-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PivotPickingPriorityEnum {
	    depositor = 1,
	    store = 2,
	    rotation = 3,
	    assignment = 4
	}
	export interface PivotPickingPriority$EnumInterface {
	    depositor: 1;
	    store: 2;
	    rotation: 3;
	    assignment: 4;
	}
	export type PivotPickingPriority = keyof PivotPickingPriority$EnumInterface;
	export const pivotPickingPriorityDatatype: X3EnumDataType<keyof PivotPickingPriority$EnumInterface, unknown>;
	//# sourceMappingURL=pivot-picking-priority.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/partial-delivery-authorized.d.ts
declare module '@sage/wh-master-data/lib/enums/partial-delivery-authorized' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PartialDeliveryAuthorizedEnum {
	    yes = 1,
	    byLine = 2,
	    no = 3
	}
	export interface PartialDeliveryAuthorized$EnumInterface {
	    yes: 1;
	    byLine: 2;
	    no: 3;
	}
	export type PartialDeliveryAuthorized = keyof PartialDeliveryAuthorized$EnumInterface;
	export const partialDeliveryAuthorizedDatatype: X3EnumDataType<keyof PartialDeliveryAuthorized$EnumInterface, unknown>;
	//# sourceMappingURL=partial-delivery-authorized.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/parity.d.ts
declare module '@sage/wh-master-data/lib/enums/parity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParityEnum {
	    old = 1,
	    even = 2,
	    evenAndOdd = 3
	}
	export interface Parity$EnumInterface {
	    old: 1;
	    even: 2;
	    evenAndOdd: 3;
	}
	export type Parity = keyof Parity$EnumInterface;
	export const parityDatatype: X3EnumDataType<keyof Parity$EnumInterface, unknown>;
	//# sourceMappingURL=parity.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/outsize.d.ts
declare module '@sage/wh-master-data/lib/enums/outsize' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OutsizeEnum {
	    no = 1,
	    yes = 2,
	    adjoiningOutsize = 3
	}
	export interface Outsize$EnumInterface {
	    no: 1;
	    yes: 2;
	    adjoiningOutsize: 3;
	}
	export type Outsize = keyof Outsize$EnumInterface;
	export const outsizeDatatype: X3EnumDataType<keyof Outsize$EnumInterface, unknown>;
	//# sourceMappingURL=outsize.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/mono-fifo-date.d.ts
declare module '@sage/wh-master-data/lib/enums/mono-fifo-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MonoFifoDateEnum {
	    no = 1,
	    byDay = 2,
	    byMonth = 3,
	    byYear = 4
	}
	export interface MonoFifoDate$EnumInterface {
	    no: 1;
	    byDay: 2;
	    byMonth: 3;
	    byYear: 4;
	}
	export type MonoFifoDate = keyof MonoFifoDate$EnumInterface;
	export const monoFifoDateDatatype: X3EnumDataType<keyof MonoFifoDate$EnumInterface, unknown>;
	//# sourceMappingURL=mono-fifo-date.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/merging-of-flows-priority.d.ts
declare module '@sage/wh-master-data/lib/enums/merging-of-flows-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MergingOfFlowsPriorityEnum {
	    priorityService = 1,
	    priorityShipComplete = 2
	}
	export interface MergingOfFlowsPriority$EnumInterface {
	    priorityService: 1;
	    priorityShipComplete: 2;
	}
	export type MergingOfFlowsPriority = keyof MergingOfFlowsPriority$EnumInterface;
	export const mergingOfFlowsPriorityDatatype: X3EnumDataType<keyof MergingOfFlowsPriority$EnumInterface, unknown>;
	//# sourceMappingURL=merging-of-flows-priority.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/mapping-addressing-criteria.d.ts
declare module '@sage/wh-master-data/lib/enums/mapping-addressing-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MappingAddressingCriteriaEnum {
	    store = 1,
	    rotationClass = 2,
	    assignmentClass = 3,
	    volumeClass = 4,
	    depositor = 5,
	    storageType = 6
	}
	export interface MappingAddressingCriteria$EnumInterface {
	    store: 1;
	    rotationClass: 2;
	    assignmentClass: 3;
	    volumeClass: 4;
	    depositor: 5;
	    storageType: 6;
	}
	export type MappingAddressingCriteria = keyof MappingAddressingCriteria$EnumInterface;
	export const mappingAddressingCriteriaDatatype: X3EnumDataType<keyof MappingAddressingCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=mapping-addressing-criteria.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/location-type.d.ts
declare module '@sage/wh-master-data/lib/enums/location-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocationTypeEnum {
	    picking = 1,
	    reserve = 2
	}
	export interface LocationType$EnumInterface {
	    picking: 1;
	    reserve: 2;
	}
	export type LocationType = keyof LocationType$EnumInterface;
	export const locationTypeDatatype: X3EnumDataType<keyof LocationType$EnumInterface, unknown>;
	//# sourceMappingURL=location-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/load-unit-type.d.ts
declare module '@sage/wh-master-data/lib/enums/load-unit-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LoadUnitTypeEnum {
	    notManaged = 1,
	    weight = 2,
	    linearMeters = 3
	}
	export interface LoadUnitType$EnumInterface {
	    notManaged: 1;
	    weight: 2;
	    linearMeters: 3;
	}
	export type LoadUnitType = keyof LoadUnitType$EnumInterface;
	export const loadUnitTypeDatatype: X3EnumDataType<keyof LoadUnitType$EnumInterface, unknown>;
	//# sourceMappingURL=load-unit-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/ky-in-information.d.ts
declare module '@sage/wh-master-data/lib/enums/ky-in-information' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum KyInInformationEnum {
	    notModifiable = 1,
	    byDefaultAndNotModifiable = 2,
	    byDefaultAndModifiable = 3,
	    modifiable = 4
	}
	export interface KyInInformation$EnumInterface {
	    notModifiable: 1;
	    byDefaultAndNotModifiable: 2;
	    byDefaultAndModifiable: 3;
	    modifiable: 4;
	}
	export type KyInInformation = keyof KyInInformation$EnumInterface;
	export const kyInInformationDatatype: X3EnumDataType<keyof KyInInformation$EnumInterface, unknown>;
	//# sourceMappingURL=ky-in-information.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/index.d.ts
declare module '@sage/wh-master-data/lib/enums/index' {
	export * from '@sage/wh-master-data/lib/enums/adjustment-type';
	export * from '@sage/wh-master-data/lib/enums/aisles-in-front';
	export * from '@sage/wh-master-data/lib/enums/aisles-type';
	export * from '@sage/wh-master-data/lib/enums/appointment-creation-type';
	export * from '@sage/wh-master-data/lib/enums/appointment-status';
	export * from '@sage/wh-master-data/lib/enums/appointment-type';
	export * from '@sage/wh-master-data/lib/enums/assignment';
	export * from '@sage/wh-master-data/lib/enums/consumable-mvt-type';
	export * from '@sage/wh-master-data/lib/enums/container-level';
	export * from '@sage/wh-master-data/lib/enums/container-management-type';
	export * from '@sage/wh-master-data/lib/enums/control-of-dimensions';
	export * from '@sage/wh-master-data/lib/enums/cross-docking-blocking-level';
	export * from '@sage/wh-master-data/lib/enums/cross-docking-output-priority';
	export * from '@sage/wh-master-data/lib/enums/customer-enum';
	export * from '@sage/wh-master-data/lib/enums/default-mode';
	export * from '@sage/wh-master-data/lib/enums/do-header-status';
	export * from '@sage/wh-master-data/lib/enums/dock-management';
	export * from '@sage/wh-master-data/lib/enums/dock-type';
	export * from '@sage/wh-master-data/lib/enums/filling-up-control';
	export * from '@sage/wh-master-data/lib/enums/format';
	export * from '@sage/wh-master-data/lib/enums/homogeneous-pallet';
	export * from '@sage/wh-master-data/lib/enums/ideal-rotation-class';
	export * from '@sage/wh-master-data/lib/enums/ideal-volume-type';
	export * from '@sage/wh-master-data/lib/enums/ky-in-information';
	export * from '@sage/wh-master-data/lib/enums/load-unit-type';
	export * from '@sage/wh-master-data/lib/enums/location-type';
	export * from '@sage/wh-master-data/lib/enums/mapping-addressing-criteria';
	export * from '@sage/wh-master-data/lib/enums/merging-of-flows-priority';
	export * from '@sage/wh-master-data/lib/enums/mono-fifo-date';
	export * from '@sage/wh-master-data/lib/enums/outsize';
	export * from '@sage/wh-master-data/lib/enums/parity';
	export * from '@sage/wh-master-data/lib/enums/partial-delivery-authorized';
	export * from '@sage/wh-master-data/lib/enums/pivot-picking-priority';
	export * from '@sage/wh-master-data/lib/enums/printing-sequence';
	export * from '@sage/wh-master-data/lib/enums/processing-family';
	export * from '@sage/wh-master-data/lib/enums/quantity-control-input-line';
	export * from '@sage/wh-master-data/lib/enums/round-status';
	export * from '@sage/wh-master-data/lib/enums/service-priority';
	export * from '@sage/wh-master-data/lib/enums/stock-nature-type';
	export * from '@sage/wh-master-data/lib/enums/store-type';
	export * from '@sage/wh-master-data/lib/enums/su-information-entry';
	export * from '@sage/wh-master-data/lib/enums/tarification-type';
	export * from '@sage/wh-master-data/lib/enums/unique-reference';
	export * from '@sage/wh-master-data/lib/enums/unstoring-type';
	export * from '@sage/wh-master-data/lib/enums/validation-type';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/ideal-volume-type.d.ts
declare module '@sage/wh-master-data/lib/enums/ideal-volume-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IdealVolumeTypeEnum {
	    location = 1,
	    targetCover = 2
	}
	export interface IdealVolumeType$EnumInterface {
	    location: 1;
	    targetCover: 2;
	}
	export type IdealVolumeType = keyof IdealVolumeType$EnumInterface;
	export const idealVolumeTypeDatatype: X3EnumDataType<keyof IdealVolumeType$EnumInterface, unknown>;
	//# sourceMappingURL=ideal-volume-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/ideal-rotation-class.d.ts
declare module '@sage/wh-master-data/lib/enums/ideal-rotation-class' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IdealRotationClassEnum {
	    location = 1,
	    countOfRotation = 2
	}
	export interface IdealRotationClass$EnumInterface {
	    location: 1;
	    countOfRotation: 2;
	}
	export type IdealRotationClass = keyof IdealRotationClass$EnumInterface;
	export const idealRotationClassDatatype: X3EnumDataType<keyof IdealRotationClass$EnumInterface, unknown>;
	//# sourceMappingURL=ideal-rotation-class.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/homogeneous-pallet.d.ts
declare module '@sage/wh-master-data/lib/enums/homogeneous-pallet' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HomogeneousPalletEnum {
	    no = 1,
	    standardHomogeneous = 2,
	    homogeneous = 3
	}
	export interface HomogeneousPallet$EnumInterface {
	    no: 1;
	    standardHomogeneous: 2;
	    homogeneous: 3;
	}
	export type HomogeneousPallet = keyof HomogeneousPallet$EnumInterface;
	export const homogeneousPalletDatatype: X3EnumDataType<keyof HomogeneousPallet$EnumInterface, unknown>;
	//# sourceMappingURL=homogeneous-pallet.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/format.d.ts
declare module '@sage/wh-master-data/lib/enums/format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormatEnum {
	    alphabetic = 1,
	    numeric = 2,
	    alphanumeric = 3
	}
	export interface Format$EnumInterface {
	    alphabetic: 1;
	    numeric: 2;
	    alphanumeric: 3;
	}
	export type Format = keyof Format$EnumInterface;
	export const formatDatatype: X3EnumDataType<keyof Format$EnumInterface, unknown>;
	//# sourceMappingURL=format.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/filling-up-control.d.ts
declare module '@sage/wh-master-data/lib/enums/filling-up-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FillingUpControlEnum {
	    no = 1,
	    inReferenceContainer = 2,
	    inNumberOfContainer = 3,
	    inReferenceContainerOnTheGround = 4
	}
	export interface FillingUpControl$EnumInterface {
	    no: 1;
	    inReferenceContainer: 2;
	    inNumberOfContainer: 3;
	    inReferenceContainerOnTheGround: 4;
	}
	export type FillingUpControl = keyof FillingUpControl$EnumInterface;
	export const fillingUpControlDatatype: X3EnumDataType<keyof FillingUpControl$EnumInterface, unknown>;
	//# sourceMappingURL=filling-up-control.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/dock-type.d.ts
declare module '@sage/wh-master-data/lib/enums/dock-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DockTypeEnum {
	    receivingDock = 1,
	    shippingDock = 2,
	    generalDock = 3
	}
	export interface DockType$EnumInterface {
	    receivingDock: 1;
	    shippingDock: 2;
	    generalDock: 3;
	}
	export type DockType = keyof DockType$EnumInterface;
	export const dockTypeDatatype: X3EnumDataType<keyof DockType$EnumInterface, unknown>;
	//# sourceMappingURL=dock-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/dock-management.d.ts
declare module '@sage/wh-master-data/lib/enums/dock-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DockManagementEnum {
	    rdv = 1,
	    round = 2
	}
	export interface DockManagement$EnumInterface {
	    rdv: 1;
	    round: 2;
	}
	export type DockManagement = keyof DockManagement$EnumInterface;
	export const dockManagementDatatype: X3EnumDataType<keyof DockManagement$EnumInterface, unknown>;
	//# sourceMappingURL=dock-management.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/do-header-status.d.ts
declare module '@sage/wh-master-data/lib/enums/do-header-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DoHeaderStatusEnum {
	    waitFirstPick = 1,
	    waitNthPick = 2,
	    selectedForPreparation = 3,
	    preparationInProcess = 4,
	    waitToBePacked = 5,
	    waitToPalletized = 6,
	    waitToLoad = 7,
	    waitToShip = 8,
	    shippedClosed = 9
	}
	export interface DoHeaderStatus$EnumInterface {
	    waitFirstPick: 1;
	    waitNthPick: 2;
	    selectedForPreparation: 3;
	    preparationInProcess: 4;
	    waitToBePacked: 5;
	    waitToPalletized: 6;
	    waitToLoad: 7;
	    waitToShip: 8;
	    shippedClosed: 9;
	}
	export type DoHeaderStatus = keyof DoHeaderStatus$EnumInterface;
	export const doHeaderStatusDatatype: X3EnumDataType<keyof DoHeaderStatus$EnumInterface, unknown>;
	//# sourceMappingURL=do-header-status.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/default-mode.d.ts
declare module '@sage/wh-master-data/lib/enums/default-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultModeEnum {
	    supplierBc = 1,
	    eanCode = 2,
	    support = 3
	}
	export interface DefaultMode$EnumInterface {
	    supplierBc: 1;
	    eanCode: 2;
	    support: 3;
	}
	export type DefaultMode = keyof DefaultMode$EnumInterface;
	export const defaultModeDatatype: X3EnumDataType<keyof DefaultMode$EnumInterface, unknown>;
	//# sourceMappingURL=default-mode.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/customer-enum.d.ts
declare module '@sage/wh-master-data/lib/enums/customer-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerEnumEnum {
	    no = 1,
	    yes = 2,
	    additional = 3
	}
	export interface CustomerEnum$EnumInterface {
	    no: 1;
	    yes: 2;
	    additional: 3;
	}
	export type CustomerEnum = keyof CustomerEnum$EnumInterface;
	export const customerEnumDatatype: X3EnumDataType<keyof CustomerEnum$EnumInterface, unknown>;
	//# sourceMappingURL=customer-enum.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/cross-docking-output-priority.d.ts
declare module '@sage/wh-master-data/lib/enums/cross-docking-output-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrossDockingOutputPriorityEnum {
	    cdkStoreStock = 1,
	    nonAvailableReserveStock = 2,
	    nonAddressedDirectInputMvt = 3,
	    expectedInputReceptionInProcess = 4
	}
	export interface CrossDockingOutputPriority$EnumInterface {
	    cdkStoreStock: 1;
	    nonAvailableReserveStock: 2;
	    nonAddressedDirectInputMvt: 3;
	    expectedInputReceptionInProcess: 4;
	}
	export type CrossDockingOutputPriority = keyof CrossDockingOutputPriority$EnumInterface;
	export const crossDockingOutputPriorityDatatype: X3EnumDataType<keyof CrossDockingOutputPriority$EnumInterface, unknown>;
	//# sourceMappingURL=cross-docking-output-priority.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/cross-docking-blocking-level.d.ts
declare module '@sage/wh-master-data/lib/enums/cross-docking-blocking-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrossDockingBlockingLevelEnum {
	    pickingsParcelsValidation = 1,
	    packing = 2,
	    palettization = 3,
	    shippingUnitClosing = 4,
	    loading = 5,
	    shipment = 6,
	    none = 7
	}
	export interface CrossDockingBlockingLevel$EnumInterface {
	    pickingsParcelsValidation: 1;
	    packing: 2;
	    palettization: 3;
	    shippingUnitClosing: 4;
	    loading: 5;
	    shipment: 6;
	    none: 7;
	}
	export type CrossDockingBlockingLevel = keyof CrossDockingBlockingLevel$EnumInterface;
	export const crossDockingBlockingLevelDatatype: X3EnumDataType<keyof CrossDockingBlockingLevel$EnumInterface, unknown>;
	//# sourceMappingURL=cross-docking-blocking-level.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/control-of-dimensions.d.ts
declare module '@sage/wh-master-data/lib/enums/control-of-dimensions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlOfDimensionsEnum {
	    none = 1,
	    height = 2,
	    heightAndWidthDepth = 3,
	    heightAndWidthAndDepth = 4,
	    widthDepth = 5,
	    widthAndDepth = 6
	}
	export interface ControlOfDimensions$EnumInterface {
	    none: 1;
	    height: 2;
	    heightAndWidthDepth: 3;
	    heightAndWidthAndDepth: 4;
	    widthDepth: 5;
	    widthAndDepth: 6;
	}
	export type ControlOfDimensions = keyof ControlOfDimensions$EnumInterface;
	export const controlOfDimensionsDatatype: X3EnumDataType<keyof ControlOfDimensions$EnumInterface, unknown>;
	//# sourceMappingURL=control-of-dimensions.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/container-management-type.d.ts
declare module '@sage/wh-master-data/lib/enums/container-management-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContainerManagementTypeEnum {
	    normal = 1,
	    unit = 2
	}
	export interface ContainerManagementType$EnumInterface {
	    normal: 1;
	    unit: 2;
	}
	export type ContainerManagementType = keyof ContainerManagementType$EnumInterface;
	export const containerManagementTypeDatatype: X3EnumDataType<keyof ContainerManagementType$EnumInterface, unknown>;
	//# sourceMappingURL=container-management-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/container-level.d.ts
declare module '@sage/wh-master-data/lib/enums/container-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContainerLevelEnum {
	    level1 = 1,
	    level2 = 2,
	    level3 = 3,
	    level4 = 4,
	    level5 = 5
	}
	export interface ContainerLevel$EnumInterface {
	    level1: 1;
	    level2: 2;
	    level3: 3;
	    level4: 4;
	    level5: 5;
	}
	export type ContainerLevel = keyof ContainerLevel$EnumInterface;
	export const containerLevelDatatype: X3EnumDataType<keyof ContainerLevel$EnumInterface, unknown>;
	//# sourceMappingURL=container-level.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/consumable-mvt-type.d.ts
declare module '@sage/wh-master-data/lib/enums/consumable-mvt-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsumableMvtTypeEnum {
	    input = 1,
	    output = 2
	}
	export interface ConsumableMvtType$EnumInterface {
	    input: 1;
	    output: 2;
	}
	export type ConsumableMvtType = keyof ConsumableMvtType$EnumInterface;
	export const consumableMvtTypeDatatype: X3EnumDataType<keyof ConsumableMvtType$EnumInterface, unknown>;
	//# sourceMappingURL=consumable-mvt-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/assignment.d.ts
declare module '@sage/wh-master-data/lib/enums/assignment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssignmentEnum {
	    assigned = 1,
	    single = 2,
	    multi = 3
	}
	export interface Assignment$EnumInterface {
	    assigned: 1;
	    single: 2;
	    multi: 3;
	}
	export type Assignment = keyof Assignment$EnumInterface;
	export const assignmentDatatype: X3EnumDataType<keyof Assignment$EnumInterface, unknown>;
	//# sourceMappingURL=assignment.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/appointment-type.d.ts
declare module '@sage/wh-master-data/lib/enums/appointment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AppointmentTypeEnum {
	    receiptAppointment = 1,
	    shippingAppointment = 2,
	    otherAppointment = 3
	}
	export interface AppointmentType$EnumInterface {
	    receiptAppointment: 1;
	    shippingAppointment: 2;
	    otherAppointment: 3;
	}
	export type AppointmentType = keyof AppointmentType$EnumInterface;
	export const appointmentTypeDatatype: X3EnumDataType<keyof AppointmentType$EnumInterface, unknown>;
	//# sourceMappingURL=appointment-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/appointment-status.d.ts
declare module '@sage/wh-master-data/lib/enums/appointment-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AppointmentStatusEnum {
	    planned = 1,
	    inProgress = 2,
	    completed = 3
	}
	export interface AppointmentStatus$EnumInterface {
	    planned: 1;
	    inProgress: 2;
	    completed: 3;
	}
	export type AppointmentStatus = keyof AppointmentStatus$EnumInterface;
	export const appointmentStatusDatatype: X3EnumDataType<keyof AppointmentStatus$EnumInterface, unknown>;
	//# sourceMappingURL=appointment-status.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/appointment-creation-type.d.ts
declare module '@sage/wh-master-data/lib/enums/appointment-creation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AppointmentCreationTypeEnum {
	    appointmentEntry = 1,
	    appointmentImport = 2,
	    expectedInput = 3,
	    receipt = 4,
	    round = 5
	}
	export interface AppointmentCreationType$EnumInterface {
	    appointmentEntry: 1;
	    appointmentImport: 2;
	    expectedInput: 3;
	    receipt: 4;
	    round: 5;
	}
	export type AppointmentCreationType = keyof AppointmentCreationType$EnumInterface;
	export const appointmentCreationTypeDatatype: X3EnumDataType<keyof AppointmentCreationType$EnumInterface, unknown>;
	//# sourceMappingURL=appointment-creation-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/aisles-type.d.ts
declare module '@sage/wh-master-data/lib/enums/aisles-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AislesTypeEnum {
	    line = 1,
	    comb = 2
	}
	export interface AislesType$EnumInterface {
	    line: 1;
	    comb: 2;
	}
	export type AislesType = keyof AislesType$EnumInterface;
	export const aislesTypeDatatype: X3EnumDataType<keyof AislesType$EnumInterface, unknown>;
	//# sourceMappingURL=aisles-type.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/aisles-in-front.d.ts
declare module '@sage/wh-master-data/lib/enums/aisles-in-front' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AislesInFrontEnum {
	    negative = 1,
	    positive = 2
	}
	export interface AislesInFront$EnumInterface {
	    negative: 1;
	    positive: 2;
	}
	export type AislesInFront = keyof AislesInFront$EnumInterface;
	export const aislesInFrontDatatype: X3EnumDataType<keyof AislesInFront$EnumInterface, unknown>;
	//# sourceMappingURL=aisles-in-front.d.ts.map
}
// From file: @sage/wh-master-data/build/lib/enums/adjustment-type.d.ts
declare module '@sage/wh-master-data/lib/enums/adjustment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AdjustmentTypeEnum {
	    addToTheContainer = 1,
	    creation = 2,
	    qualitative = 3,
	    deletion = 4,
	    increaseQuantity = 5,
	    decreaseQuantity = 6
	}
	export interface AdjustmentType$EnumInterface {
	    addToTheContainer: 1;
	    creation: 2;
	    qualitative: 3;
	    deletion: 4;
	    increaseQuantity: 5;
	    decreaseQuantity: 6;
	}
	export type AdjustmentType = keyof AdjustmentType$EnumInterface;
	export const adjustmentTypeDatatype: X3EnumDataType<keyof AdjustmentType$EnumInterface, unknown>;
	//# sourceMappingURL=adjustment-type.d.ts.map
}
declare module '@sage/wh-master-data' {
	export * from '@sage/wh-master-data/index';
}
