import type { Depositor, GraphApi, WhSite } from '@sage/wh-master-data-api';
import type { User } from '@sage/wh-system-api';
import * as ui from '@sage/xtrem-ui';
export declare class MobileSiteDepositor extends ui.Sticker<GraphApi> {
    section: ui.containers.Section;
    block: ui.containers.Block;
    /**
     * User selection field empty is current user
     */
    selectionUser: ui.fields.Reference<User>;
    selectionSite: ui.fields.Reference<WhSite>;
    selectionDepositor: ui.fields.Reference<Depositor>;
    saveButton: ui.PageAction;
    /**
     * Set the selected site and depositor, and update the sticker
     * @param _selectedSiteDepositor
     * @param isUpdateMenu
     */
    private _setMobileSettings;
    /**
     *
     * @returns true if the selected depositor is valid, false otherwise
     */
    private _checkDepositor;
    /**
     * Check if the user is an admin
     * @param userCode
     * @returns true if the user is an admin, false otherwise
     */
    private readonly _isUserAdmin;
    /**
     * Check if the current user is an admin
     * @returns true if the current user is an admin, false otherwise
     */
    private readonly _isCurrentUserAdmin;
    /**
     * Update the selectionDepositor and saveButton
     * @param clearDepositor
     * @returns true if the selectionDepositor is enabled, false otherwise
     */
    private _updateSelectionDepositorAndSaveButton;
    /**
     * Update the selectionDepositor
     * @returns true if the selectionDepositor is enabled, false otherwise
     */
    private _updateSelectionDepositor;
    /**
     * Check if the site and depositor have values
     * @returns true if the site and depositor have values, false otherwise
     */
    private _checkSiteDepositorHasValues;
    /**
     * Update the saveButton
     * @param disableButton
     * @returns true if the saveButton is enabled, false otherwise
     */
    private _updateSaveButton;
    /**
     * Update the site, depositor selection fields, storage, and, optionally, the menu.
     * @param selectedSiteDepositor
     * @param isUpdateMenu
     */
    private _updateSelectionFieldsSiteDepositorAndStorage;
    /**
     * Technical attributes
     */
    private _isAllowedSiteChange;
    private _isAllowedDepositorChange;
}
//# sourceMappingURL=mobile-site-depositor.d.ts.map