"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.truncate = truncate;
const typesLib = require("@sage/xtrem-decimal");
/**
 * Truncate quantity to a number of decimals
 * @param quantity  quantity to truncate
 * @param precision number of decimals or undefined (truncate to integer)
 * @returns truncated quantity
 */
function truncate(quantity, precision) {
    if (!precision) {
        return Math.trunc(quantity);
    }
    const _precision = 10 ** (precision ?? 0);
    return typesLib.div(Math.trunc(typesLib.mul(quantity, _precision)), _precision);
}
//# sourceMappingURL=math.js.map