"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhSite = void 0;
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhMasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        inventoryMovementCode: {
            site: 'site',
            code: 'inventoryMovementCode',
        },
        rotationPickingWithoutPrompt: {
            site: 'site',
            code: 'rotationPickingWithoutPrompt',
        },
        pickingVolumeWithoutPrompt: {
            site: 'site',
            code: 'pickingVolumeWithoutPrompt',
        },
        transferPicking: {
            site: 'site',
            code: 'transferPicking',
        },
        transferReserve: {
            site: 'site',
            code: 'transferReserve',
        },
        carriageNoteDstdReport: {
            reportName: 'carriageNoteDstdReport',
        },
        carriageReceiptDstdReport: {
            reportName: 'carriageReceiptDstdReport',
        },
        internationalLanguage: {
            code: 'internationalLanguage',
        },
        crossDockingStore: {
            site: 'site',
            code: 'crossDockingStore',
        },
        transferMovementCode: {
            site: 'site',
            code: 'transferMovementCode',
        },
        workCenter1: {
            site: 'site',
            code: 'workCenter1',
        },
        unitOfMeasure1: {
            code: 'unitOfMeasure1',
        },
        workCenter2: {
            site: 'site',
            code: 'workCenter2',
        },
        unitOfMeasure2: {
            code: 'unitOfMeasure2',
        },
    },
};
let WhSite = class WhSite extends xtrem_core_1.Node {
};
exports.WhSite = WhSite;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], WhSite.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRFVLD',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "transferValidationType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isTransferOperationCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFPIKCTL',
        lookupAccess: true,
    })
], WhSite.prototype, "isPickControlCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFDPSCTL',
        lookupAccess: true,
    })
], WhSite.prototype, "isRepositoningControlCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isReceiptOperationCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADJOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isAdjustementOperationCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADJCTL',
        lookupAccess: true,
    })
], WhSite.prototype, "isAdjustementControlCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSEOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isConsumableInputControlCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSSOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isConsumableOutputControlCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSHOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isSimplifiedStockCountCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFLST',
        lookupAccess: true,
    })
], WhSite.prototype, "isPrintTransferListAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFLBL',
        lookupAccess: true,
    })
], WhSite.prototype, "isPrintTransferLabelAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFPKZPIK',
        lookupAccess: true,
    })
], WhSite.prototype, "isMonoZoneOriginAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFPKZDPS',
        lookupAccess: true,
    })
], WhSite.prototype, "isMonoZoneDestinationAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYOCPMGT',
        lookupAccess: true,
    })
], WhSite.prototype, "isDockAssignmentAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HTPITM',
        lookupAccess: true,
    })
], WhSite.prototype, "isItemBarCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HTPEAN',
        lookupAccess: true,
    })
], WhSite.prototype, "isEanBarCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HTPTRFITM',
        lookupAccess: true,
    })
], WhSite.prototype, "isTransferProductBarCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HTPTRFEAN',
        lookupAccess: true,
    })
], WhSite.prototype, "isTransferEanBarCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WATFLG',
        lookupAccess: true,
    })
], WhSite.prototype, "isDripAndDropAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKPFLG',
        lookupAccess: true,
    })
], WhSite.prototype, "isPreventiveStockCount", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCTER',
        lookupAccess: true,
    })
], WhSite.prototype, "timeBetweenInterval", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCMVT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], WhSite.prototype, "inventoryMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKCOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isPickingOperationCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QATFLGCTL',
        lookupAccess: true,
    })
], WhSite.prototype, "isDockControlParcels", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGDEP',
        lookupAccess: true,
    })
], WhSite.prototype, "isSingleDepositor", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGSTY',
        lookupAccess: true,
    })
], WhSite.prototype, "isSingleStorageType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOCHN',
        lookupAccess: true,
    })
], WhSite.prototype, "isStoreChaining", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ABCCHN',
        lookupAccess: true,
    })
], WhSite.prototype, "isRotationClassesChaining", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ASGCHN',
        lookupAccess: true,
    })
], WhSite.prototype, "isChainingAssignmentClasses", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VOLCHN',
        lookupAccess: true,
    })
], WhSite.prototype, "isChainingVolumeClasses", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGITMSSO',
        lookupAccess: true,
    })
], WhSite.prototype, "isPickProdWithoutPrompt", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ABCITMSSO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.RotationClass,
        lookupAccess: true,
    })
], WhSite.prototype, "rotationPickingWithoutPrompt", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VOLITMSSO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.VolumeClass,
        lookupAccess: true,
    })
], WhSite.prototype, "pickingVolumeWithoutPrompt", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ABCCRI',
        dataType: () => sageWhMasterData.enums.idealRotationClassDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "idealRotationClass", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VOLCRI',
        dataType: () => sageWhMasterData.enums.idealVolumeTypeDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "idealVolumeClass", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DAYCAP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "targetCover", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MINTER',
        lookupAccess: true,
    })
], WhSite.prototype, "minimumDelayBeforeReallocation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MINACT',
        lookupAccess: true,
    })
], WhSite.prototype, "minimumActivityBeforeAllocation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STTPER',
        lookupAccess: true,
    })
], WhSite.prototype, "calculationPeriod", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PICPIC',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], WhSite.prototype, "transferPicking", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PICRSV',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], WhSite.prototype, "transferReserve", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DRNCRE',
        lookupAccess: true,
    })
], WhSite.prototype, "isRoundCreation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRRDFT',
        lookupAccess: true,
    })
], WhSite.prototype, "isInitializeCarrierAndTransportMode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GDRSEA',
        lookupAccess: true,
    })
], WhSite.prototype, "isResearchGenericRound", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVEAR',
        lookupAccess: true,
    })
], WhSite.prototype, "deliveryInAdvance", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DRNHOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "roundHour", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EDIOPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isEdiOperationCode", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DGGQTYMAX',
        lookupAccess: true,
    })
], WhSite.prototype, "dcmdLimitQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DCMDBTEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], WhSite.prototype, "carriageNoteDstdReport", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DCMDRTEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], WhSite.prototype, "carriageReceiptDstdReport", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DCMDLAN',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Language,
        lookupAccess: true,
    })
], WhSite.prototype, "internationalLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOCDK',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], WhSite.prototype, "crossDockingStore", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INIWAVFLG',
        lookupAccess: true,
    })
], WhSite.prototype, "isWaveInitialization", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSFLG',
        lookupAccess: true,
    })
], WhSite.prototype, "isInterSiteRoundManagement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EANDVRFLG',
        dataType: () => sageWhMasterData.enums.defaultModeDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "eanDefaultMethod", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UNQEDOFLG',
        lookupAccess: true,
    })
], WhSite.prototype, "isUnicityCheck", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKROPE',
        lookupAccess: true,
    })
], WhSite.prototype, "isRepackingOperationCodeAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIKVALFLG',
        lookupAccess: true,
    })
], WhSite.prototype, "isPickingValidated", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRMMVT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], WhSite.prototype, "transferMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUMGRU',
        lookupAccess: true,
    })
], WhSite.prototype, "isOutputMouvementGrouping", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRMGRU',
        lookupAccess: true,
    })
], WhSite.prototype, "isTransfertMouvementGrouping", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QAYTYPUNI',
        dataType: () => sageWhMasterData.enums.loadUnitTypeDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "loadingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGRST',
        lookupAccess: true,
    })
], WhSite.prototype, "isReceiptDockCapacity", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGRAU',
        lookupAccess: true,
    })
], WhSite.prototype, "isAutoQuayOccupation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TIMFLGRE1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "receiptAppointmentOccupationStartTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TIMFLGRE2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "receiptAppointmentOccupationEndTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYTERRPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "receiptAppointmentProvisionalDuration", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYSTARTR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "receiptAppointmentTruckTrackingStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGRCR',
        lookupAccess: true,
    })
], WhSite.prototype, "isReceiptAppointmentAssignement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGRLI',
        lookupAccess: true,
    })
], WhSite.prototype, "isReceiptAppointementDockFreeing", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGEST',
        lookupAccess: true,
    })
], WhSite.prototype, "isShipmentDockCapacity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TIMFLGEX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "shipmentAppointmentOccupationStartTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TIMFLGEX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "shipmentAppointmentOccupationEndTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYTEREPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "shipmentAppointmentProvisionalDuration", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYSTAETR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "shipmentAppointmentTruckTrackingStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYREFETO',
        lookupAccess: true,
    })
], WhSite.prototype, "isRoundReference", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGECR',
        lookupAccess: true,
    })
], WhSite.prototype, "isShipmentAppointementAssignment", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGESU',
        lookupAccess: true,
    })
], WhSite.prototype, "isAutoShipmentAppointementAssignment", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGEMA',
        lookupAccess: true,
    })
], WhSite.prototype, "isUpdateOnLoading", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYFLGELI',
        lookupAccess: true,
    })
], WhSite.prototype, "isShipmentAppointementDockFreing", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TIMFLGAU1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "otherAppointmentOccupationStartTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TIMFLGAU2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "otherAppointmentOccupationEndTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYTERAPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "otherAppointmentProvisionalDuration", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QAYSTAATR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "otherAppointmentTruckTrackingStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOP1',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.WorkCenter,
        lookupAccess: true,
    })
], WhSite.prototype, "workCenter1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOM1',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.UnitOfMeasure,
        lookupAccess: true,
    })
], WhSite.prototype, "unitOfMeasure1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOP2',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.WorkCenter,
        lookupAccess: true,
    })
], WhSite.prototype, "workCenter2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOM2',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.UnitOfMeasure,
        lookupAccess: true,
    })
], WhSite.prototype, "unitOfMeasure2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGINVSSH',
        lookupAccess: true,
    })
], WhSite.prototype, "isSimplifiedStockCount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGDATINVSSH',
        lookupAccess: true,
    })
], WhSite.prototype, "isLastStockCountDateUpdate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCYSEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], WhSite.prototype, "siteSei", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.WhSiteAddressingPriorities,
    })
], WhSite.prototype, "addressingPriorities", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.WhSiteIsNoWorkDays,
    })
], WhSite.prototype, "isNoWorkDays", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.WhSiteSupplierBarCodes,
    })
], WhSite.prototype, "supplierBarCodes", void 0);
exports.WhSite = WhSite = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SITE',
        keyPropertyNames: ['site'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WhSite);
//# sourceMappingURL=wh-site.js.map