import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class WhSite extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly transferValidationType: Promise<sageWhMasterData.enums.ValidationType | null>;
    readonly isTransferOperationCodeAllowed: Promise<boolean>;
    readonly isPickControlCodeAllowed: Promise<boolean>;
    readonly isRepositoningControlCodeAllowed: Promise<boolean>;
    readonly isReceiptOperationCodeAllowed: Promise<boolean>;
    readonly isAdjustementOperationCodeAllowed: Promise<boolean>;
    readonly isAdjustementControlCodeAllowed: Promise<boolean>;
    readonly isConsumableInputControlCodeAllowed: Promise<boolean>;
    readonly isConsumableOutputControlCodeAllowed: Promise<boolean>;
    readonly isSimplifiedStockCountCodeAllowed: Promise<boolean>;
    readonly isPrintTransferListAllowed: Promise<boolean>;
    readonly isPrintTransferLabelAllowed: Promise<boolean>;
    readonly isMonoZoneOriginAllowed: Promise<boolean>;
    readonly isMonoZoneDestinationAllowed: Promise<boolean>;
    readonly isDockAssignmentAllowed: Promise<boolean>;
    readonly isItemBarCodeAllowed: Promise<boolean>;
    readonly isEanBarCodeAllowed: Promise<boolean>;
    readonly isTransferProductBarCodeAllowed: Promise<boolean>;
    readonly isTransferEanBarCodeAllowed: Promise<boolean>;
    readonly isDripAndDropAllowed: Promise<boolean>;
    readonly isPreventiveStockCount: Promise<boolean>;
    readonly timeBetweenInterval: Promise<integer | null>;
    readonly inventoryMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly isPickingOperationCodeAllowed: Promise<boolean>;
    readonly isDockControlParcels: Promise<boolean>;
    readonly isSingleDepositor: Promise<boolean>;
    readonly isSingleStorageType: Promise<boolean>;
    readonly isStoreChaining: Promise<boolean>;
    readonly isRotationClassesChaining: Promise<boolean>;
    readonly isChainingAssignmentClasses: Promise<boolean>;
    readonly isChainingVolumeClasses: Promise<boolean>;
    readonly isPickProdWithoutPrompt: Promise<boolean>;
    readonly rotationPickingWithoutPrompt: Reference<sageWhMasterData.nodes.RotationClass | null>;
    readonly pickingVolumeWithoutPrompt: Reference<sageWhMasterData.nodes.VolumeClass | null>;
    readonly idealRotationClass: Promise<sageWhMasterData.enums.IdealRotationClass | null>;
    readonly idealVolumeClass: Promise<sageWhMasterData.enums.IdealVolumeType | null>;
    readonly targetCover: Promise<decimal | null>;
    readonly minimumDelayBeforeReallocation: Promise<integer | null>;
    readonly minimumActivityBeforeAllocation: Promise<integer | null>;
    readonly calculationPeriod: Promise<integer | null>;
    readonly transferPicking: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly transferReserve: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly isRoundCreation: Promise<boolean>;
    readonly isInitializeCarrierAndTransportMode: Promise<boolean>;
    readonly isResearchGenericRound: Promise<boolean>;
    readonly deliveryInAdvance: Promise<integer | null>;
    readonly roundHour: Promise<string>;
    readonly isEdiOperationCode: Promise<boolean>;
    readonly dcmdLimitQuantity: Promise<integer | null>;
    readonly carriageNoteDstdReport: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly carriageReceiptDstdReport: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly internationalLanguage: Reference<sageWhSystem.nodes.Language | null>;
    readonly crossDockingStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly isWaveInitialization: Promise<boolean>;
    readonly isInterSiteRoundManagement: Promise<boolean>;
    readonly eanDefaultMethod: Promise<sageWhMasterData.enums.DefaultMode | null>;
    readonly isUnicityCheck: Promise<boolean>;
    readonly isRepackingOperationCodeAllowed: Promise<boolean>;
    readonly isPickingValidated: Promise<boolean>;
    readonly transferMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly isOutputMouvementGrouping: Promise<boolean>;
    readonly isTransfertMouvementGrouping: Promise<boolean>;
    readonly loadingUnit: Promise<sageWhMasterData.enums.LoadUnitType | null>;
    readonly isReceiptDockCapacity: Promise<boolean>;
    readonly isAutoQuayOccupation: Promise<boolean>;
    readonly receiptAppointmentOccupationStartTime: Promise<string>;
    readonly receiptAppointmentOccupationEndTime: Promise<string>;
    readonly receiptAppointmentProvisionalDuration: Promise<string>;
    readonly receiptAppointmentTruckTrackingStatus: Promise<string>;
    readonly isReceiptAppointmentAssignement: Promise<boolean>;
    readonly isReceiptAppointementDockFreeing: Promise<boolean>;
    readonly isShipmentDockCapacity: Promise<boolean>;
    readonly shipmentAppointmentOccupationStartTime: Promise<string>;
    readonly shipmentAppointmentOccupationEndTime: Promise<string>;
    readonly shipmentAppointmentProvisionalDuration: Promise<string>;
    readonly shipmentAppointmentTruckTrackingStatus: Promise<string>;
    readonly isRoundReference: Promise<boolean>;
    readonly isShipmentAppointementAssignment: Promise<boolean>;
    readonly isAutoShipmentAppointementAssignment: Promise<boolean>;
    readonly isUpdateOnLoading: Promise<boolean>;
    readonly isShipmentAppointementDockFreing: Promise<boolean>;
    readonly otherAppointmentOccupationStartTime: Promise<string>;
    readonly otherAppointmentOccupationEndTime: Promise<string>;
    readonly otherAppointmentProvisionalDuration: Promise<string>;
    readonly otherAppointmentTruckTrackingStatus: Promise<string>;
    readonly workCenter1: Reference<sageWhMasterData.nodes.WorkCenter | null>;
    readonly unitOfMeasure1: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
    readonly workCenter2: Reference<sageWhMasterData.nodes.WorkCenter | null>;
    readonly unitOfMeasure2: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
    readonly isSimplifiedStockCount: Promise<boolean>;
    readonly isLastStockCountDateUpdate: Promise<boolean>;
    readonly siteSei: Promise<string>;
    readonly addressingPriorities: Collection<sageWhMasterData.nodes.WhSiteAddressingPriorities>;
    readonly isNoWorkDays: Collection<sageWhMasterData.nodes.WhSiteIsNoWorkDays>;
    readonly supplierBarCodes: Collection<sageWhMasterData.nodes.WhSiteSupplierBarCodes>;
}
//# sourceMappingURL=wh-site.d.ts.map