"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnitOfMeasure = void 0;
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        codeCeeOnu: {
            glossaryId() {
                return 18;
            },
            code: 'codeCeeOnu',
        },
    },
};
let UnitOfMeasure = class UnitOfMeasure extends xtrem_core_1.Node {
};
exports.UnitOfMeasure = UnitOfMeasure;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], UnitOfMeasure.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], UnitOfMeasure.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], UnitOfMeasure.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMDEC',
        lookupAccess: true,
    })
], UnitOfMeasure.prototype, "numberOfDecimals", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOMSYM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], UnitOfMeasure.prototype, "symbol", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMTYP',
        dataType: () => sageWhSystem.enums.unitTypeDatatype,
        lookupAccess: true,
    })
], UnitOfMeasure.prototype, "unitType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INTSAU',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 18,
            },
            control: {
                glossaryId: 18,
            },
        },
        node: () => sageWhSystem.nodes.MiscellaneousTable,
        lookupAccess: true,
    })
], UnitOfMeasure.prototype, "codeCeeOnu", void 0);
exports.UnitOfMeasure = UnitOfMeasure = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABUNIT',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], UnitOfMeasure);
//# sourceMappingURL=unit-of-measure.js.map