import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class Store extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly isProximityPickingStore: Promise<boolean>;
    readonly isKeyInControlCode: Promise<boolean>;
    readonly priorityInOutput: Promise<string>;
    readonly isAuthorizedInOutput: Promise<boolean>;
    readonly storeType: Promise<sageWhMasterData.enums.StoreType>;
    readonly groupMergingOfFlows: Promise<string>;
    readonly isBigVolumesAllowed: Promise<boolean>;
    readonly isSmallVolumesAllowed: Promise<boolean>;
    readonly chainingMode: Reference<sageWhMasterData.nodes.StoreChaining | null>;
    readonly addressStructure: Promise<string>;
    readonly storingStructure: Promise<string>;
    readonly aisleType: Promise<sageWhMasterData.enums.AislesType | null>;
    readonly rowFacing: Promise<sageWhMasterData.enums.AislesInFront | null>;
    readonly presentAisleRank: Promise<integer | null>;
    readonly presentAisleLevel: Promise<string>;
    readonly rankOfFrontAisle: Promise<integer | null>;
    readonly levelOfInfrontAisle: Promise<string>;
    readonly isAisleChaining: Promise<boolean>;
    readonly extendProximityLevel: Promise<string>;
    readonly keyOfCalculation: Promise<integer | null>;
    readonly isTransferCompleteObject: Promise<boolean>;
    readonly reintegrationStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly isPreventiveStockCount: Promise<boolean>;
    readonly isBalanceReaddressing: Promise<boolean>;
    readonly supportingBeamMaxWeight: Promise<decimal | null>;
    readonly alertThreshold: Promise<decimal | null>;
    readonly locations: Collection<sageWhMasterData.nodes.Location>;
    readonly addressesCode: Collection<sageWhMasterData.nodes.StoreAddressesCode>;
    readonly addressesDescription: Collection<sageWhMasterData.nodes.StoreAddressesDescription>;
    readonly addressesFormat: Collection<sageWhMasterData.nodes.StoreAddressesFormat>;
    readonly addressesLength: Collection<sageWhMasterData.nodes.StoreAddressesLength>;
    readonly addressesType: Collection<sageWhMasterData.nodes.StoreAddressesType>;
    readonly putawayOrders: Collection<sageWhMasterData.nodes.StorePutawayOrders>;
    readonly startLevels: Collection<sageWhMasterData.nodes.StoreStartLevels>;
}
//# sourceMappingURL=store.d.ts.map