"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoreChainingStoresChaining = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhMasterData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'CHN'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            site: 'site',
            code: 'code',
        },
        storeChaining: {
            site: 'site',
            code: 'storeChaining',
        },
    },
};
let StoreChainingStoresChaining = class StoreChainingStoresChaining extends xtrem_core_1.Node {
};
exports.StoreChainingStoresChaining = StoreChainingStoresChaining;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        lookupAccess: true,
    })
], StoreChainingStoresChaining.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'FCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], StoreChainingStoresChaining.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CHNMOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], StoreChainingStoresChaining.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StoreChaining,
    })
], StoreChainingStoresChaining.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOCHN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], StoreChainingStoresChaining.prototype, "storeChaining", void 0);
exports.StoreChainingStoresChaining = StoreChainingStoresChaining = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STORECHN',
        keyPropertyNames: ['denormalizedIndex', 'site', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], StoreChainingStoresChaining);
//# sourceMappingURL=store-chaining-stores-chaining.js.map