"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageType = void 0;
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhMasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
    },
};
let StorageType = class StorageType extends xtrem_core_1.Node {
};
exports.StorageType = StorageType;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], StorageType.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STYDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STYSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLOTYP',
        dataType: () => sageWhMasterData.enums.locationTypeDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "locationType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DYNPIC',
        lookupAccess: true,
    })
], StorageType.prototype, "isPickingPivot", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPMGT',
        dataType: () => sageWhMasterData.enums.assignmentDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "depositorManagement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMMGT',
        dataType: () => sageWhMasterData.enums.assignmentDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "productManagement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGCTR',
        lookupAccess: true,
    })
], StorageType.prototype, "isSingleContainer", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGORI',
        lookupAccess: true,
    })
], StorageType.prototype, "isSingleSource", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGLOT',
        lookupAccess: true,
    })
], StorageType.prototype, "isSingleLot", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGRSA',
        lookupAccess: true,
    })
], StorageType.prototype, "isSingleReservation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNGDAT',
        dataType: () => sageWhMasterData.enums.monoFifoDateDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "singleDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGSKN',
        lookupAccess: true,
    })
], StorageType.prototype, "isSingleStockStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRCSP',
        lookupAccess: true,
    })
], StorageType.prototype, "isContainerCorrespendence", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RESFIFDAT',
        lookupAccess: true,
    })
], StorageType.prototype, "isInputFifoDateResetToZero", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FIFLOK',
        lookupAccess: true,
    })
], StorageType.prototype, "isStrictUnStocking", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOOMGT',
        dataType: () => sageWhMasterData.enums.unstoringTypeDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "unStocking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FIFSLOMGT',
        lookupAccess: true,
    })
], StorageType.prototype, "isFifoByLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OLDDATINP',
        lookupAccess: true,
    })
], StorageType.prototype, "isInputOfOldFifoDateAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FIFDEV',
        lookupAccess: true,
    })
], StorageType.prototype, "isFifoGapControl", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLOMES',
        dataType: () => sageWhMasterData.enums.fillingUpControlDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "fillControl", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUTALLAUZ',
        lookupAccess: true,
    })
], StorageType.prototype, "isAutomaticAddressingAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PALLBLEDT',
        lookupAccess: true,
    })
], StorageType.prototype, "isLabelPrinting", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOTYP',
        dataType: () => sageWhMasterData.enums.storeTypeDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "storeType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PSTMGT',
        lookupAccess: true,
    })
], StorageType.prototype, "isAdressPositionManagement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HMGPAL',
        dataType: () => sageWhMasterData.enums.homogeneousPalletDatatype,
        lookupAccess: true,
    })
], StorageType.prototype, "homogeneousObject", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MAXPIC',
        lookupAccess: true,
    })
], StorageType.prototype, "isExceedMaximumCapacityOfPickingLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGSKO',
        lookupAccess: true,
    })
], StorageType.prototype, "isUndifferentiatedStockObject", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMAUZ',
        lookupAccess: true,
    })
], StorageType.prototype, "isAssemblyAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SWAPLOT',
        lookupAccess: true,
    })
], StorageType.prototype, "isLotSwapping", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPLITMVT',
        lookupAccess: true,
    })
], StorageType.prototype, "isAutomaticMovementSplit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUMVTSKO',
        lookupAccess: true,
    })
], StorageType.prototype, "isStockObjectAdcGrouping", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUMVTFIF',
        lookupAccess: true,
    })
], StorageType.prototype, "isFifoDateAdcGrouping", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
        lookupAccess: true,
    })
], StorageType.prototype, "isActive", void 0);
exports.StorageType = StorageType = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STORAGETYP',
        keyPropertyNames: ['site', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StorageType);
//# sourceMappingURL=storage-type.js.map