import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class StorageType extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
    readonly isPickingPivot: Promise<boolean>;
    readonly depositorManagement: Promise<sageWhMasterData.enums.Assignment | null>;
    readonly productManagement: Promise<sageWhMasterData.enums.Assignment | null>;
    readonly isSingleContainer: Promise<boolean>;
    readonly isSingleSource: Promise<boolean>;
    readonly isSingleLot: Promise<boolean>;
    readonly isSingleReservation: Promise<boolean>;
    readonly singleDate: Promise<sageWhMasterData.enums.MonoFifoDate | null>;
    readonly isSingleStockStatus: Promise<boolean>;
    readonly isContainerCorrespendence: Promise<boolean>;
    readonly isInputFifoDateResetToZero: Promise<boolean>;
    readonly isStrictUnStocking: Promise<boolean>;
    readonly unStocking: Promise<sageWhMasterData.enums.UnstoringType | null>;
    readonly isFifoByLocation: Promise<boolean>;
    readonly isInputOfOldFifoDateAllowed: Promise<boolean>;
    readonly isFifoGapControl: Promise<boolean>;
    readonly fillControl: Promise<sageWhMasterData.enums.FillingUpControl | null>;
    readonly isAutomaticAddressingAuthorized: Promise<boolean>;
    readonly isLabelPrinting: Promise<boolean>;
    readonly storeType: Promise<sageWhMasterData.enums.StoreType | null>;
    readonly isAdressPositionManagement: Promise<boolean>;
    readonly homogeneousObject: Promise<sageWhMasterData.enums.HomogeneousPallet | null>;
    readonly isExceedMaximumCapacityOfPickingLocation: Promise<boolean>;
    readonly isUndifferentiatedStockObject: Promise<boolean>;
    readonly isAssemblyAuthorized: Promise<boolean>;
    readonly isLotSwapping: Promise<boolean>;
    readonly isAutomaticMovementSplit: Promise<boolean>;
    readonly isStockObjectAdcGrouping: Promise<boolean>;
    readonly isFifoDateAdcGrouping: Promise<boolean>;
    readonly isActive: Promise<boolean>;
}
//# sourceMappingURL=storage-type.d.ts.map