"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreparationArea = void 0;
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhMasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        preparationOrderPrint: {
            reportName: 'preparationOrderPrint',
        },
        generalPrinter: {
            code: 'generalPrinter',
        },
        labelPrinter1: {
            code: 'labelPrinter1',
        },
        labelPrinter2: {
            code: 'labelPrinter2',
        },
    },
};
let PreparationArea = class PreparationArea extends xtrem_core_1.Node {
};
exports.PreparationArea = PreparationArea;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], PreparationArea.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PKZ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], PreparationArea.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKZDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], PreparationArea.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKZSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], PreparationArea.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], PreparationArea.prototype, "preparationOrderPrint", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRN1',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Destination,
        lookupAccess: true,
    })
], PreparationArea.prototype, "generalPrinter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRN2',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Destination,
        lookupAccess: true,
    })
], PreparationArea.prototype, "labelPrinter1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRN3',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Destination,
        lookupAccess: true,
    })
], PreparationArea.prototype, "labelPrinter2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LPC',
        lookupAccess: true,
    })
], PreparationArea.prototype, "isBigParcelAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOMAXPAC',
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumNumberOfParcels", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOMAXWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumWeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOMAXVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumVolume", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOEQVSUR',
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumSurfaceEquivalent", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRMLVL1',
        lookupAccess: true,
    })
], PreparationArea.prototype, "isTransmittedToL1", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOMAXSHP',
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumShippingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOMAXWEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumWeightForPrepalletizationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOMAXVOP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumVolumeForPrepalletizationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOEQVSUP',
        lookupAccess: true,
    })
], PreparationArea.prototype, "maximumSurfaceEquivalentForPrepalletizationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.PreparationAreaParametersForPreparationOrder,
    })
], PreparationArea.prototype, "parametersForPreparationOrder", void 0);
exports.PreparationArea = PreparationArea = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PICKINGZON',
        keyPropertyNames: ['site', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PreparationArea);
//# sourceMappingURL=preparation-area.js.map