import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class ParcelType extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel>;
    readonly code: Promise<string>;
    readonly siteDepositorIdentifier: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly height: Promise<decimal | null>;
    readonly width: Promise<decimal | null>;
    readonly depth: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly usefulVolume: Promise<decimal>;
    readonly isBigParcel: Promise<boolean>;
    readonly isActive: Promise<boolean>;
    readonly surfaceEquivalent: Promise<integer | null>;
    readonly maximumWeight: Promise<decimal | null>;
    readonly minimumLimitPercentagePerBigParcel: Promise<integer | null>;
    readonly parcelTare: Promise<decimal | null>;
    readonly tareTolerancePercentage: Promise<integer | null>;
    readonly shippingUnitGroup: Promise<string>;
    readonly shippinUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
    readonly isPalettizableAsIs: Promise<boolean>;
    readonly shippingUnitTypeShippedAsIs: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
}
//# sourceMappingURL=parcel-type.d.ts.map