"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Operand = void 0;
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
    },
};
let Operand = class Operand extends xtrem_core_1.Node {
};
exports.Operand = Operand;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Operand.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'OPE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Operand.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Operand.prototype, "operatorName", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZRCP',
        lookupAccess: true,
    })
], Operand.prototype, "isReceiptAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZSKC',
        lookupAccess: true,
    })
], Operand.prototype, "isPreventiveStockCountAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZSTL',
        lookupAccess: true,
    })
], Operand.prototype, "isPutawayAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZRPN',
        lookupAccess: true,
    })
], Operand.prototype, "isReorderAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZTRF',
        lookupAccess: true,
    })
], Operand.prototype, "isTransferAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZPKO',
        lookupAccess: true,
    })
], Operand.prototype, "isPickingAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZPRC',
        lookupAccess: true,
    })
], Operand.prototype, "isPrepackingAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZDPK',
        lookupAccess: true,
    })
], Operand.prototype, "isDeclaredPackingAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZADJ',
        lookupAccess: true,
    })
], Operand.prototype, "isManualAdjustmentAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZEDI',
        lookupAccess: true,
    })
], Operand.prototype, "isCarrierEdiAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZDCL',
        lookupAccess: true,
    })
], Operand.prototype, "isAssemblyAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZLCD',
        lookupAccess: true,
    })
], Operand.prototype, "isDisassemblyAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZQLY',
        lookupAccess: true,
    })
], Operand.prototype, "isQualityControlAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZVQL',
        lookupAccess: true,
    })
], Operand.prototype, "isAnalysisRequestAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZCSE',
        lookupAccess: true,
    })
], Operand.prototype, "isConsumableInputAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZCSS',
        lookupAccess: true,
    })
], Operand.prototype, "isConsumableOuputAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZQAT',
        lookupAccess: true,
    })
], Operand.prototype, "isStockOnDockAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZEXO',
        lookupAccess: true,
    })
], Operand.prototype, "isForcedDeliveryOrderShippingAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZSHC',
        lookupAccess: true,
    })
], Operand.prototype, "isPrepalletizationAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZSHP',
        lookupAccess: true,
    })
], Operand.prototype, "isAutoPalletisationAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZSKR',
        lookupAccess: true,
    })
], Operand.prototype, "isRepackingAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZSSH',
        lookupAccess: true,
    })
], Operand.prototype, "isSimplifiedStockCountAuthorized", void 0);
exports.Operand = Operand = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'OPERATOR',
        keyPropertyNames: ['site', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Operand);
//# sourceMappingURL=operand.js.map