import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, integer, date, Collection } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class Location extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly store: Reference<sageWhMasterData.nodes.Store>;
    readonly code: Promise<string>;
    readonly storageType: Promise<string>;
    readonly storage: Reference<sageWhMasterData.nodes.StorageType>;
    readonly storeType: Promise<sageWhMasterData.enums.StoreType>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType>;
    readonly dockType: Promise<sageWhMasterData.enums.DockType | null>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
    readonly lotNumber: Promise<string>;
    readonly reservationNumber: Promise<string>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly numberOfConsumptionUnitPerContainer: Promise<decimal | null>;
    readonly rotationClass: Reference<sageWhMasterData.nodes.RotationClass | null>;
    readonly assignmentClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
    readonly prohibitedClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
    readonly height: Promise<decimal>;
    readonly width: Promise<decimal>;
    readonly depth: Promise<decimal>;
    readonly volume: Promise<decimal>;
    readonly maxVolume: Promise<decimal | null>;
    readonly maxWeightAuthorized: Promise<decimal | null>;
    readonly maxMeters: Promise<decimal | null>;
    readonly maximumLoad: Promise<decimal | null>;
    readonly dockHeight: Promise<decimal | null>;
    readonly storingTime: Promise<decimal | null>;
    readonly unStockingTime: Promise<decimal | null>;
    readonly presentContainerMaximumQuantity: Promise<decimal | null>;
    readonly referenceContainerLevel: Promise<integer | null>;
    readonly maximumQuantityInReferenceContainer: Promise<decimal | null>;
    readonly quantityInStock: Promise<decimal | null>;
    readonly lastStockCount: Promise<date | null>;
    readonly lastReceipt: Promise<date | null>;
    readonly firstArrival: Promise<date | null>;
    readonly fifoDate: Promise<date | null>;
    readonly quantityInPendingInput: Promise<decimal | null>;
    readonly quantityInPendingOutput: Promise<decimal | null>;
    readonly quantityInPendingReplenish: Promise<decimal | null>;
    readonly isBlockedInInput: Promise<boolean>;
    readonly isBlockedInOutput: Promise<boolean>;
    readonly isBlockedInInput2: Promise<boolean>;
    readonly isBlockedInOutput2: Promise<boolean>;
    readonly isAutoAddressing: Promise<boolean>;
    readonly isKeyInControlCode: Promise<boolean>;
    readonly controlCode: Promise<string>;
    readonly reorderPoint: Promise<decimal | null>;
    readonly replenishmentType: Promise<sageWhMasterData.enums.LocationType | null>;
    readonly replenishmentLevel: Promise<sageWhMasterData.enums.ContainerLevel | null>;
    readonly percentageOccupied: Promise<integer | null>;
    readonly parity: Promise<sageWhMasterData.enums.Parity | null>;
    readonly isTemporaryPicking: Promise<boolean>;
    readonly isPickingPivot: Promise<boolean>;
    readonly wavePivot: Promise<string>;
    readonly pickingPriority: Promise<integer | null>;
    readonly isUsed: Promise<boolean>;
    readonly controlDimension: Promise<sageWhMasterData.enums.ControlOfDimensions | null>;
    readonly isActive: Promise<boolean>;
    readonly isDockLeveler: Promise<boolean>;
    readonly completeObjectsAddressingThreshold: Promise<decimal | null>;
    readonly displayCode: Promise<string>;
    readonly storeLocationCode: Promise<string>;
    readonly storeLocationKey: Promise<string>;
    readonly splitAddresses: Collection<sageWhMasterData.nodes.LocationSplitAddresses>;
}
//# sourceMappingURL=location.d.ts.map