import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, Collection } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class GenericRound extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly dock: Reference<sageWhMasterData.nodes.Location | null>;
    readonly duration: Promise<string>;
    readonly maximumWeight: Promise<decimal | null>;
    readonly maximumVolume: Promise<decimal | null>;
    readonly maximumLinearMeters: Promise<decimal | null>;
    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
    readonly shipToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly pickingLeadTime: Promise<string>;
    readonly isInterSiteRoundManagement: Promise<boolean>;
    readonly destinationSite: Reference<sageWhSystem.nodes.Site | null>;
    readonly isActive: Promise<boolean>;
    readonly timeLimitPerDays: Collection<sageWhMasterData.nodes.GenericRoundTimeLimitPerDays>;
}
//# sourceMappingURL=generic-round.d.ts.map