"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Depositor = void 0;
const sageWhStructure = require("@sage/wh-structure");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhMasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        country: {
            code: 'country',
        },
        shippingUnitTypeShippingAsIs: {
            site: 'site',
            code: 'shippingUnitTypeShippingAsIs',
        },
        parcelRange: {
            site: 'site',
            code: 'parcelRange',
        },
        parcelTypeDispatchableInState: {
            site: 'site',
            parcelRange: 'parcelRangeDispatchableInState',
            code: 'parcelTypeDispatchableInState',
        },
        parcelRangeDispatchableInState: {
            site: 'site',
            code: 'parcelRangeDispatchableInState',
        },
        printDeliveryNotes: {
            reportName: 'printDeliveryNotes',
        },
        shippingUnitType: {
            site: 'site',
            code: 'shippingUnitType',
        },
        autoTransferMovementAdjustementCode: {
            site: 'site',
            code: 'autoTransferMovementAdjustementCode',
        },
        auto2PhaseTransferMovementAdjustementCode: {
            site: 'site',
            code: 'auto2PhaseTransferMovementAdjustementCode',
        },
        waveReplenishment: {
            site: 'site',
            code: 'waveReplenishment',
        },
        balanceMovementCode: {
            site: 'site',
            code: 'balanceMovementCode',
        },
        mergingOfFlowsTransfer: {
            site: 'site',
            code: 'mergingOfFlowsTransfer',
        },
        transferOfComponent: {
            site: 'site',
            code: 'transferOfComponent',
        },
        kitTransfer: {
            site: 'site',
            code: 'kitTransfer',
        },
        adjustmentAfterStockCount: {
            site: 'site',
            code: 'adjustmentAfterStockCount',
        },
        analysisKitMovementCode: {
            site: 'site',
            code: 'analysisKitMovementCode',
        },
        analysisComponentMovementCode: {
            site: 'site',
            code: 'analysisComponentMovementCode',
        },
        maximumPrepaprationAreaKit: {
            site: 'site',
            code: 'maximumPrepaprationAreaKit',
        },
        mergingOfFlowsPreparationAreaMax: {
            site: 'site',
            code: 'mergingOfFlowsPreparationAreaMax',
        },
        refuseStockNature: {
            site: 'site',
            code: 'refuseStockNature',
        },
        consumedStockNature: {
            site: 'site',
            code: 'consumedStockNature',
        },
        autoAnalysisRequestAdjustementMovementCode: {
            site: 'site',
            code: 'autoAnalysisRequestAdjustementMovementCode',
        },
        autoAnalysisRequestTransfertMovementCode: {
            site: 'site',
            code: 'autoAnalysisRequestTransfertMovementCode',
        },
        sequenceCode: {
            site: 'site',
            code: 'sequenceCode',
        },
        interSiteDeliveryNotePrinting: {
            reportName: 'interSiteDeliveryNotePrinting',
        },
    },
};
let Depositor = class Depositor extends xtrem_core_1.Node {
};
exports.Depositor = Depositor;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Depositor.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "shortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "postalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "city", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "region", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageWhStructure.nodes.Country,
        lookupAccess: true,
    })
], Depositor.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "countryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "phone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "fax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "siteTaxIdNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADDEML',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RGC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "registeredCapital", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "rcs", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPTMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isSupportNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOTMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isLotNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STLVLD',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "storingListValidation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IFLCTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isControlInputFlow", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STLLBL',
        lookupAccess: true,
    })
], Depositor.prototype, "isPutAlwayLabel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STLEDT',
        lookupAccess: true,
    })
], Depositor.prototype, "isStoringList", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGINPSTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isSingleInputStoringList", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGSTOSTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isSingleStoreStoringList", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STLSEQ',
        dataType: () => sageWhMasterData.enums.printingSequenceDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "printSequenceOfStoringList", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STLCTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isStoringListControlCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STLOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isStoringListOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UNQIRF',
        dataType: () => sageWhMasterData.enums.uniqueReferenceDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "uniqueInputReference", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTLQTY',
        dataType: () => sageWhMasterData.enums.quantityControlInputLineDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "quantityControlInInput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTPDI',
        lookupAccess: true,
    })
], Depositor.prototype, "isOutputOnPendingInput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRO',
        lookupAccess: true,
    })
], Depositor.prototype, "isSplitReplenishmentObjects", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IPAAUTTRF',
        lookupAccess: true,
    })
], Depositor.prototype, "isReplenishmentBalanceReaddressing", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OFLCTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isControlOutputFlow", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHRMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isOutputShortageManagement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSHITM',
        lookupAccess: true,
    })
], Depositor.prototype, "isPartialsByProduct", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSHDLO',
        lookupAccess: true,
    })
], Depositor.prototype, "isShortageByDeliveryOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WAVSTT',
        lookupAccess: true,
    })
], Depositor.prototype, "isPreparationLoad", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RPNVLD',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "replenishmentValidation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RPNLST',
        lookupAccess: true,
    })
], Depositor.prototype, "isReplenishList", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RPNLBL',
        lookupAccess: true,
    })
], Depositor.prototype, "isReplenishLabel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKOOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isPreparationOrderOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPKOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isDeclarativePackingOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isPrepackingOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHCOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isPickOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isSuOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RPNOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isRoOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UNQORF',
        dataType: () => sageWhMasterData.enums.uniqueReferenceDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "uniqueOutputReference", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isOrderManagement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GDRMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isGenericRoundManagement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPAITM',
        lookupAccess: true,
    })
], Depositor.prototype, "isSingleParcelItem", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SEQPKO',
        lookupAccess: true,
    })
], Depositor.prototype, "isStrictSequentiality", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHUDST',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ShippingUnitType,
        lookupAccess: true,
    })
], Depositor.prototype, "shippingUnitTypeShippingAsIs", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGCLOSHP',
        lookupAccess: true,
    })
], Depositor.prototype, "isShippingUnitClosingAuthorization", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSPMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isShipmentManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRADFT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.RangeOfParcel,
        lookupAccess: true,
    })
], Depositor.prototype, "parcelRange", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCINF',
        dataType: () => sageWhMasterData.enums.kyInInformationDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "keyInRealParcelWeight", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPINF',
        dataType: () => sageWhMasterData.enums.suInformationEntryDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "enterShippingUnitInfo", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCPLZ',
        lookupAccess: true,
    })
], Depositor.prototype, "isParcelPalletisation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LODCTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isControlLoadingParcel", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTYDST',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ParcelType,
        lookupAccess: true,
    })
], Depositor.prototype, "parcelTypeDispatchableInState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRADST',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.RangeOfParcel,
        lookupAccess: true,
    })
], Depositor.prototype, "parcelRangeDispatchableInState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLNEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], Depositor.prototype, "printDeliveryNotes", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCLST',
        lookupAccess: true,
    })
], Depositor.prototype, "isPrintMergingOfFlowsTransferReport", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCLBL',
        lookupAccess: true,
    })
], Depositor.prototype, "isPrintMergingOfFlowsTransferLabel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCLBL',
        lookupAccess: true,
    })
], Depositor.prototype, "isPrintParcelLabels", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPLBL',
        lookupAccess: true,
    })
], Depositor.prototype, "isShippingUnitLabels", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPALBL',
        lookupAccess: true,
    })
], Depositor.prototype, "isPalletizationOrderLabels", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGLBL1',
        lookupAccess: true,
    })
], Depositor.prototype, "isGroupedsLabels", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIKCTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isControlCodeOfPick", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPSCTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isControlCodeOfDeposit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTCTL',
        lookupAccess: true,
    })
], Depositor.prototype, "isControlCodeOfOutput", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCPIO',
        dataType: () => sageWhMasterData.enums.mergingOfFlowsPriorityDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "addressingPriority", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCVLD',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "transferMergingOfFlowsValidation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUCOD',
        lookupAccess: true,
    })
], Depositor.prototype, "isGroupMergingOfFlows", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VOLMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isParcelVolumeManagement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLCSTA2',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "launchingMergingOfFlowsStep2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TDN',
        lookupAccess: true,
    })
], Depositor.prototype, "isPrintTemporaryDeliveryNotes", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TDNSTA',
        dataType: () => sageWhMasterData.enums.doHeaderStatusDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "deliveryOrderStatusForDeliveryNotes", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLN',
        lookupAccess: true,
    })
], Depositor.prototype, "isPrintFinalDeliveryNotes", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DDN',
        lookupAccess: true,
    })
], Depositor.prototype, "isPrintDifferentialDeliveryNotes", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUPCTR',
        lookupAccess: true,
    })
], Depositor.prototype, "isMovementInSuperiorContainer", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPSNGDLO',
        lookupAccess: true,
    })
], Depositor.prototype, "isSingleDeliveryOrderShippingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPSNGDLV',
        lookupAccess: true,
    })
], Depositor.prototype, "isSingleConsigneeShippingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPAUT',
        lookupAccess: true,
    })
], Depositor.prototype, "isAutoPalettizeBigParcels", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHPSHU',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ShippingUnitType,
        lookupAccess: true,
    })
], Depositor.prototype, "shippingUnitType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTADJAUT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "autoTransferMovementAdjustementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTADJAU2',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "auto2PhaseTransferMovementAdjustementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTWAVRPN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "waveReplenishment", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTRPNSHR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "balanceMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTTRFFLC',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "mergingOfFlowsTransfer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTTRFCPN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "transferOfComponent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTTRFKIT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "kitTransfer", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRRDFT',
        lookupAccess: true,
    })
], Depositor.prototype, "isInitializeCarrierAndTransportMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCAJM',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "adjustmentAfterStockCount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMSTKAVL',
        lookupAccess: true,
    })
], Depositor.prototype, "isStockAvailable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMSTKPIC',
        lookupAccess: true,
    })
], Depositor.prototype, "isPickingStock", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMTRFIPA',
        lookupAccess: true,
    })
], Depositor.prototype, "isTransferOfIncomplete", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMUNQREF',
        dataType: () => sageWhMasterData.enums.uniqueReferenceDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "uniqueReference", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPNVLD',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "componentTransferValidation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'KITVLD',
        dataType: () => sageWhMasterData.enums.validationTypeDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "kitTransferValidation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMSSHITM',
        lookupAccess: true,
    })
], Depositor.prototype, "isShortagePerItem", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMSSHORD',
        lookupAccess: true,
    })
], Depositor.prototype, "isShortagePerPreparationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DCLOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isKitOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LCDOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isComponentOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTDCLKIT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "analysisKitMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTDCLCPN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "analysisComponentMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMLST',
        lookupAccess: true,
    })
], Depositor.prototype, "isComponentTransferList", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMLBL',
        lookupAccess: true,
    })
], Depositor.prototype, "isComponentTransferLabel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMPKZPIK',
        lookupAccess: true,
    })
], Depositor.prototype, "isSinglePreparationAreaKitRemoval", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMPKZDPS',
        lookupAccess: true,
    })
], Depositor.prototype, "isSinglePreparationAreaKitRelocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMWKL',
        lookupAccess: true,
    })
], Depositor.prototype, "isSplittingKit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMWKLPKZ',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.PreparationArea,
        lookupAccess: true,
    })
], Depositor.prototype, "maximumPrepaprationAreaKit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLGDLVCLT',
        dataType: () => sageWhMasterData.enums.customerEnumDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "customerControl", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INPFLG',
        lookupAccess: true,
    })
], Depositor.prototype, "isInputsConfigurationFlag", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTFLG',
        lookupAccess: true,
    })
], Depositor.prototype, "isOutputsConfigurationFlag", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STKFLG',
        lookupAccess: true,
    })
], Depositor.prototype, "isStocksConfigurationFlag", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RPNPKZPIK',
        lookupAccess: true,
    })
], Depositor.prototype, "isPickReplenishOrderMonoPreparationArea", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RPNPKZDPS',
        lookupAccess: true,
    })
], Depositor.prototype, "isDepositorReplenishOrderMonoPreparationArea", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCPKZPIK',
        lookupAccess: true,
    })
], Depositor.prototype, "isPickMergingOfFlowsMonoPreparationArea", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCPKZDPS',
        lookupAccess: true,
    })
], Depositor.prototype, "isDepositorMergingOfFlowsMonoPreparationArea", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLCWKL',
        lookupAccess: true,
    })
], Depositor.prototype, "isMergingOfflowsDivision", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLCWKLPKZ',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.PreparationArea,
        lookupAccess: true,
    })
], Depositor.prototype, "mergingOfFlowsPreparationAreaMax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DILSKN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StockNature,
        lookupAccess: true,
    })
], Depositor.prototype, "refuseStockNature", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USESKN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StockNature,
        lookupAccess: true,
    })
], Depositor.prototype, "consumedStockNature", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ALLQLYAUT',
        lookupAccess: true,
    })
], Depositor.prototype, "isAutomaticAddressing", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QLYOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isQualityOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VQLOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isValidationAnalysisRequestOperatorCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTQLYAUT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "autoAnalysisRequestAdjustementMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTTRFQLY',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], Depositor.prototype, "autoAnalysisRequestTransfertMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRNAUT',
        lookupAccess: true,
    })
], Depositor.prototype, "isAutoPrintQualityRecord", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHNMODDYN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StoreChaining,
        lookupAccess: true,
    })
], Depositor.prototype, "sequenceCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHNDYN',
        lookupAccess: true,
    })
], Depositor.prototype, "isChainingStore", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHNABCDYN',
        lookupAccess: true,
    })
], Depositor.prototype, "isChainingRotationClasse", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHNASGDYN',
        lookupAccess: true,
    })
], Depositor.prototype, "isChainingAssignmentClasses", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CDKMGT',
        lookupAccess: true,
    })
], Depositor.prototype, "isCrossDockingManagement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDKLVLCTL',
        dataType: () => sageWhMasterData.enums.crossDockingBlockingLevelDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "crossDockingLevel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STKCDK',
        lookupAccess: true,
    })
], Depositor.prototype, "isCrossDockingStoreStock", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STKCDKPDI',
        lookupAccess: true,
    })
], Depositor.prototype, "isCrossDockingStoreStockNotAvailable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STKPDI',
        lookupAccess: true,
    })
], Depositor.prototype, "isReserveStockNotAvailable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NEDINPMVT',
        lookupAccess: true,
    })
], Depositor.prototype, "isDirectInputMovementNotAddressed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NEDEINRCP',
        lookupAccess: true,
    })
], Depositor.prototype, "isExpectedInputUnderReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NEDALW',
        lookupAccess: true,
    })
], Depositor.prototype, "isAlwaysExpressRequirement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INIWAVFLG',
        lookupAccess: true,
    })
], Depositor.prototype, "isWaveInitialization", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSCEXSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "ssccExtensionCharacter", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EANUCCCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "eanUccCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSCFLG',
        lookupAccess: true,
    })
], Depositor.prototype, "isSsccParcelOnOutput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSCUMFLG',
        lookupAccess: true,
    })
], Depositor.prototype, "isSsccShippingUnitOnOutput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QATFLGPRC',
        lookupAccess: true,
    })
], Depositor.prototype, "isStockOnDockParcels", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QATFLGSHP',
        lookupAccess: true,
    })
], Depositor.prototype, "isStockOnDockShippingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QATOPE',
        lookupAccess: true,
    })
], Depositor.prototype, "isStockOnDockOperation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QATVLDAUT',
        lookupAccess: true,
    })
], Depositor.prototype, "isStockOnDockValidation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TNSDLNEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], Depositor.prototype, "interSiteDeliveryNotePrinting", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRANAM0',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "log", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DFTRMD',
        lookupAccess: true,
    })
], Depositor.prototype, "isDefaultReceiptMode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DFTPMD',
        lookupAccess: true,
    })
], Depositor.prototype, "isDefaultPickingMode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCKPDI',
        lookupAccess: true,
    })
], Depositor.prototype, "isUnavailablePendingInput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCKPDR',
        lookupAccess: true,
    })
], Depositor.prototype, "isUnavailableReorderInProcess", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEPSEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Depositor.prototype, "seiDepositor", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.DepositorAddresses,
    })
], Depositor.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.DepositorCrossDockingPriorities,
    })
], Depositor.prototype, "crossDockingPriorities", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.DepositorNames,
    })
], Depositor.prototype, "names", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.DepositorPickingPivotPriorities,
    })
], Depositor.prototype, "pickingPivotPriorities", void 0);
exports.Depositor = Depositor = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'DEPOSITOR',
        keyPropertyNames: ['site', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Depositor);
//# sourceMappingURL=depositor.js.map