import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, Collection } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class Depositor extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly shortDescription: Promise<string>;
    readonly postalCode: Promise<string>;
    readonly city: Promise<string>;
    readonly region: Promise<string>;
    readonly country: Reference<sageWhStructure.nodes.Country | null>;
    readonly countryName: Promise<string>;
    readonly phone: Promise<string>;
    readonly fax: Promise<string>;
    readonly siteTaxIdNumber: Promise<string>;
    readonly email: Promise<string>;
    readonly registeredCapital: Promise<string>;
    readonly rcs: Promise<string>;
    readonly isSupportNumber: Promise<boolean>;
    readonly isLotNumber: Promise<boolean>;
    readonly storingListValidation: Promise<sageWhMasterData.enums.ValidationType>;
    readonly isControlInputFlow: Promise<boolean>;
    readonly isPutAlwayLabel: Promise<boolean>;
    readonly isStoringList: Promise<boolean>;
    readonly isSingleInputStoringList: Promise<boolean>;
    readonly isSingleStoreStoringList: Promise<boolean>;
    readonly printSequenceOfStoringList: Promise<sageWhMasterData.enums.PrintingSequence>;
    readonly isStoringListControlCode: Promise<boolean>;
    readonly isStoringListOperatorCode: Promise<boolean>;
    readonly uniqueInputReference: Promise<sageWhMasterData.enums.UniqueReference>;
    readonly quantityControlInInput: Promise<sageWhMasterData.enums.QuantityControlInputLine>;
    readonly isOutputOnPendingInput: Promise<boolean>;
    readonly isSplitReplenishmentObjects: Promise<boolean>;
    readonly isReplenishmentBalanceReaddressing: Promise<boolean>;
    readonly isControlOutputFlow: Promise<boolean>;
    readonly isOutputShortageManagement: Promise<boolean>;
    readonly isPartialsByProduct: Promise<boolean>;
    readonly isShortageByDeliveryOrder: Promise<boolean>;
    readonly isPreparationLoad: Promise<boolean>;
    readonly replenishmentValidation: Promise<sageWhMasterData.enums.ValidationType>;
    readonly isReplenishList: Promise<boolean>;
    readonly isReplenishLabel: Promise<boolean>;
    readonly isPreparationOrderOperatorCode: Promise<boolean>;
    readonly isDeclarativePackingOperatorCode: Promise<boolean>;
    readonly isPrepackingOperatorCode: Promise<boolean>;
    readonly isPickOperatorCode: Promise<boolean>;
    readonly isSuOperatorCode: Promise<boolean>;
    readonly isRoOperatorCode: Promise<boolean>;
    readonly uniqueOutputReference: Promise<sageWhMasterData.enums.UniqueReference>;
    readonly isOrderManagement: Promise<boolean>;
    readonly isGenericRoundManagement: Promise<boolean>;
    readonly isSingleParcelItem: Promise<boolean>;
    readonly isStrictSequentiality: Promise<boolean>;
    readonly shippingUnitTypeShippingAsIs: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
    readonly isShippingUnitClosingAuthorization: Promise<boolean>;
    readonly isShipmentManagement: Promise<boolean>;
    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
    readonly keyInRealParcelWeight: Promise<sageWhMasterData.enums.KyInInformation>;
    readonly enterShippingUnitInfo: Promise<sageWhMasterData.enums.SuInformationEntry>;
    readonly isParcelPalletisation: Promise<boolean>;
    readonly isControlLoadingParcel: Promise<boolean>;
    readonly parcelTypeDispatchableInState: Reference<sageWhMasterData.nodes.ParcelType | null>;
    readonly parcelRangeDispatchableInState: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
    readonly printDeliveryNotes: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly isPrintMergingOfFlowsTransferReport: Promise<boolean>;
    readonly isPrintMergingOfFlowsTransferLabel: Promise<boolean>;
    readonly isPrintParcelLabels: Promise<boolean>;
    readonly isShippingUnitLabels: Promise<boolean>;
    readonly isPalletizationOrderLabels: Promise<boolean>;
    readonly isGroupedsLabels: Promise<boolean>;
    readonly isControlCodeOfPick: Promise<boolean>;
    readonly isControlCodeOfDeposit: Promise<boolean>;
    readonly isControlCodeOfOutput: Promise<boolean>;
    readonly addressingPriority: Promise<sageWhMasterData.enums.MergingOfFlowsPriority>;
    readonly transferMergingOfFlowsValidation: Promise<sageWhMasterData.enums.ValidationType>;
    readonly isGroupMergingOfFlows: Promise<boolean>;
    readonly isParcelVolumeManagement: Promise<boolean>;
    readonly launchingMergingOfFlowsStep2: Promise<sageWhMasterData.enums.ValidationType | null>;
    readonly isPrintTemporaryDeliveryNotes: Promise<boolean>;
    readonly deliveryOrderStatusForDeliveryNotes: Promise<sageWhMasterData.enums.DoHeaderStatus | null>;
    readonly isPrintFinalDeliveryNotes: Promise<boolean>;
    readonly isPrintDifferentialDeliveryNotes: Promise<boolean>;
    readonly isMovementInSuperiorContainer: Promise<boolean>;
    readonly isSingleDeliveryOrderShippingUnit: Promise<boolean>;
    readonly isSingleConsigneeShippingUnit: Promise<boolean>;
    readonly isAutoPalettizeBigParcels: Promise<boolean>;
    readonly shippingUnitType: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
    readonly autoTransferMovementAdjustementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly auto2PhaseTransferMovementAdjustementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly waveReplenishment: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly balanceMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly mergingOfFlowsTransfer: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly transferOfComponent: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly kitTransfer: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly isInitializeCarrierAndTransportMode: Promise<boolean>;
    readonly adjustmentAfterStockCount: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly isStockAvailable: Promise<boolean>;
    readonly isPickingStock: Promise<boolean>;
    readonly isTransferOfIncomplete: Promise<boolean>;
    readonly uniqueReference: Promise<sageWhMasterData.enums.UniqueReference | null>;
    readonly componentTransferValidation: Promise<sageWhMasterData.enums.ValidationType | null>;
    readonly kitTransferValidation: Promise<sageWhMasterData.enums.ValidationType | null>;
    readonly isShortagePerItem: Promise<boolean>;
    readonly isShortagePerPreparationOrder: Promise<boolean>;
    readonly isKitOperatorCode: Promise<boolean>;
    readonly isComponentOperatorCode: Promise<boolean>;
    readonly analysisKitMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly analysisComponentMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly isComponentTransferList: Promise<boolean>;
    readonly isComponentTransferLabel: Promise<boolean>;
    readonly isSinglePreparationAreaKitRemoval: Promise<boolean>;
    readonly isSinglePreparationAreaKitRelocation: Promise<boolean>;
    readonly isSplittingKit: Promise<boolean>;
    readonly maximumPrepaprationAreaKit: Reference<sageWhMasterData.nodes.PreparationArea | null>;
    readonly customerControl: Promise<sageWhMasterData.enums.CustomerEnum | null>;
    readonly isInputsConfigurationFlag: Promise<boolean>;
    readonly isOutputsConfigurationFlag: Promise<boolean>;
    readonly isStocksConfigurationFlag: Promise<boolean>;
    readonly isPickReplenishOrderMonoPreparationArea: Promise<boolean>;
    readonly isDepositorReplenishOrderMonoPreparationArea: Promise<boolean>;
    readonly isPickMergingOfFlowsMonoPreparationArea: Promise<boolean>;
    readonly isDepositorMergingOfFlowsMonoPreparationArea: Promise<boolean>;
    readonly isMergingOfflowsDivision: Promise<boolean>;
    readonly mergingOfFlowsPreparationAreaMax: Reference<sageWhMasterData.nodes.PreparationArea | null>;
    readonly refuseStockNature: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly consumedStockNature: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly isAutomaticAddressing: Promise<boolean>;
    readonly isQualityOperatorCode: Promise<boolean>;
    readonly isValidationAnalysisRequestOperatorCode: Promise<boolean>;
    readonly autoAnalysisRequestAdjustementMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly autoAnalysisRequestTransfertMovementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly isAutoPrintQualityRecord: Promise<boolean>;
    readonly sequenceCode: Reference<sageWhMasterData.nodes.StoreChaining | null>;
    readonly isChainingStore: Promise<boolean>;
    readonly isChainingRotationClasse: Promise<boolean>;
    readonly isChainingAssignmentClasses: Promise<boolean>;
    readonly isCrossDockingManagement: Promise<boolean>;
    readonly crossDockingLevel: Promise<sageWhMasterData.enums.CrossDockingBlockingLevel | null>;
    readonly isCrossDockingStoreStock: Promise<boolean>;
    readonly isCrossDockingStoreStockNotAvailable: Promise<boolean>;
    readonly isReserveStockNotAvailable: Promise<boolean>;
    readonly isDirectInputMovementNotAddressed: Promise<boolean>;
    readonly isExpectedInputUnderReceipt: Promise<boolean>;
    readonly isAlwaysExpressRequirement: Promise<boolean>;
    readonly isWaveInitialization: Promise<boolean>;
    readonly ssccExtensionCharacter: Promise<string>;
    readonly eanUccCode: Promise<string>;
    readonly isSsccParcelOnOutput: Promise<boolean>;
    readonly isSsccShippingUnitOnOutput: Promise<boolean>;
    readonly isStockOnDockParcels: Promise<boolean>;
    readonly isStockOnDockShippingUnit: Promise<boolean>;
    readonly isStockOnDockOperation: Promise<boolean>;
    readonly isStockOnDockValidation: Promise<boolean>;
    readonly interSiteDeliveryNotePrinting: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly log: Promise<string>;
    readonly isDefaultReceiptMode: Promise<boolean>;
    readonly isDefaultPickingMode: Promise<boolean>;
    readonly isUnavailablePendingInput: Promise<boolean>;
    readonly isUnavailableReorderInProcess: Promise<boolean>;
    readonly seiDepositor: Promise<string>;
    readonly addresses: Collection<sageWhMasterData.nodes.DepositorAddresses>;
    readonly crossDockingPriorities: Collection<sageWhMasterData.nodes.DepositorCrossDockingPriorities>;
    readonly names: Collection<sageWhMasterData.nodes.DepositorNames>;
    readonly pickingPivotPriorities: Collection<sageWhMasterData.nodes.DepositorPickingPivotPriorities>;
}
//# sourceMappingURL=depositor.d.ts.map