import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class Customer extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly shortDescription: Promise<string>;
    readonly postalCode: Promise<string>;
    readonly city: Promise<string>;
    readonly region: Promise<string>;
    readonly country: Reference<sageWhStructure.nodes.Country | null>;
    readonly countryName: Promise<string>;
    readonly telephone: Promise<string>;
    readonly fax: Promise<string>;
    readonly email: Promise<string>;
    readonly billToCustomer: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly notes: Promise<string>;
    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly roundPosition: Promise<integer | null>;
    readonly deliveryArea: Promise<string>;
    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
    readonly currency: Reference<sageWhMasterData.nodes.Currency>;
    readonly partialDeliveryManagement: Promise<sageWhMasterData.enums.PartialDeliveryAuthorized | null>;
    readonly servicePriority: Promise<sageWhMasterData.enums.ServicePriority | null>;
    readonly isCarriageAmountCalculation: Promise<boolean>;
    readonly tariffCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
    readonly printLanguage: Reference<sageWhSystem.nodes.Language>;
    readonly deliveryNotePrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly isSsccManagementOnOutput: Promise<boolean>;
    readonly isLotManagement: Promise<boolean>;
    readonly isActive: Promise<boolean>;
    readonly adresses: Collection<sageWhMasterData.nodes.CustomerAdresses>;
    readonly companyNames: Collection<sageWhMasterData.nodes.CustomerCompanyNames>;
}
//# sourceMappingURL=customer.d.ts.map