"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Carrier = void 0;
const sageWhStructure = require("@sage/wh-structure");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhMasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        country: {
            code: 'country',
        },
        carriageNotePrint: {
            reportName: 'carriageNotePrint',
        },
        carriageReceiptPrint: {
            reportName: 'carriageReceiptPrint',
        },
        carriageNoteTariffCode: {
            site: 'site',
            code: 'carriageNoteTariffCode',
        },
        carriageReceiptTariffCode: {
            site: 'site',
            code: 'carriageReceiptTariffCode',
        },
        currency: {
            code: 'currency',
        },
        interSiteCarriageNotePrint: {
            reportName: 'interSiteCarriageNotePrint',
        },
        interSiteCarriageReceiptPrint: {
            reportName: 'interSiteCarriageReceiptPrint',
        },
    },
};
let Carrier = class Carrier extends xtrem_core_1.Node {
};
exports.Carrier = Carrier;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Carrier.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "postalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "city", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "region", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageWhStructure.nodes.Country,
        lookupAccess: true,
    })
], Carrier.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "countryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "telephone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "fax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADDEML',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Carrier.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CANEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], Carrier.prototype, "carriageNotePrint", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NTREDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], Carrier.prototype, "carriageReceiptPrint", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CANRAC',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TariffCode,
        lookupAccess: true,
    })
], Carrier.prototype, "carriageNoteTariffCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NTRRAC',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TariffCode,
        lookupAccess: true,
    })
], Carrier.prototype, "carriageReceiptTariffCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CANCST',
        lookupAccess: true,
    })
], Carrier.prototype, "isCarriageNoteAmountCalculation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NTRCST',
        lookupAccess: true,
    })
], Carrier.prototype, "isCarriageReceiptAmountCalculation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Currency,
        lookupAccess: true,
    })
], Carrier.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EDH',
        lookupAccess: true,
    })
], Carrier.prototype, "isEdiManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TNSCANEDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], Carrier.prototype, "interSiteCarriageNotePrint", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TNSNTREDT',
        columnType: 'string',
        node: () => sageWhSystem.nodes.GenericPrintReport,
        lookupAccess: true,
    })
], Carrier.prototype, "interSiteCarriageReceiptPrint", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
        lookupAccess: true,
    })
], Carrier.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.CarrierAddresses,
    })
], Carrier.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.CarrierCompanyNames,
    })
], Carrier.prototype, "companyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.CarrierTarifficationTypes,
    })
], Carrier.prototype, "tarifficationTypes", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhMasterData.nodes.CarrierTransportationMethods,
    })
], Carrier.prototype, "transportationMethods", void 0);
exports.Carrier = Carrier = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CARRIER',
        keyPropertyNames: ['site', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Carrier);
//# sourceMappingURL=carrier.js.map