import * as sageWhStructure from '@sage/wh-structure';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, Collection } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class Carrier extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly postalCode: Promise<string>;
    readonly city: Promise<string>;
    readonly region: Promise<string>;
    readonly country: Reference<sageWhStructure.nodes.Country | null>;
    readonly countryName: Promise<string>;
    readonly telephone: Promise<string>;
    readonly fax: Promise<string>;
    readonly email: Promise<string>;
    readonly carriageNotePrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly carriageReceiptPrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly carriageNoteTariffCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
    readonly carriageReceiptTariffCode: Reference<sageWhMasterData.nodes.TariffCode | null>;
    readonly isCarriageNoteAmountCalculation: Promise<boolean>;
    readonly isCarriageReceiptAmountCalculation: Promise<boolean>;
    readonly currency: Reference<sageWhMasterData.nodes.Currency | null>;
    readonly isEdiManagement: Promise<boolean>;
    readonly interSiteCarriageNotePrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly interSiteCarriageReceiptPrint: Reference<sageWhSystem.nodes.GenericPrintReport | null>;
    readonly isActive: Promise<boolean>;
    readonly addresses: Collection<sageWhMasterData.nodes.CarrierAddresses>;
    readonly companyNames: Collection<sageWhMasterData.nodes.CarrierCompanyNames>;
    readonly tarifficationTypes: Collection<sageWhMasterData.nodes.CarrierTarifficationTypes>;
    readonly transportationMethods: Collection<sageWhMasterData.nodes.CarrierTransportationMethods>;
}
//# sourceMappingURL=carrier.d.ts.map