import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, decimal, TextStream } from '@sage/xtrem-core';
import * as sageWhMasterData from '..';
export declare class AppointmentManagement extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly description: Promise<string>;
    readonly appointmentType: Promise<sageWhMasterData.enums.AppointmentType | null>;
    readonly appointmentStatus: Promise<sageWhMasterData.enums.AppointmentStatus | null>;
    readonly appointmentCreationType: Promise<sageWhMasterData.enums.AppointmentCreationType | null>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
    readonly creationDate: Promise<date>;
    readonly expectedDockAssignmentStartDate: Promise<date | null>;
    readonly expectedDockAssignmentEndDate: Promise<date | null>;
    readonly actualDockAssignmentStartDate: Promise<date | null>;
    readonly actualDockAssignmentEndDate: Promise<date | null>;
    readonly effectiveStartDate: Promise<date | null>;
    readonly effectiveEndDate: Promise<date | null>;
    readonly expectedTruckArrivalDate: Promise<date | null>;
    readonly expectedTruckDepartureDate: Promise<date | null>;
    readonly actualTruckArrivalDate: Promise<date | null>;
    readonly actualTruckDepartureDate: Promise<date | null>;
    readonly creationTime: Promise<string>;
    readonly expectedDockAssignmentDuration: Promise<string>;
    readonly expectedStartTime: Promise<string>;
    readonly expectedEndTime: Promise<string>;
    readonly actualStartTime: Promise<string>;
    readonly actualEndTime: Promise<string>;
    readonly effectiveStartTime: Promise<string>;
    readonly effectiveEndTime: Promise<string>;
    readonly expectedTruckArrivalTime: Promise<string>;
    readonly expectedTruckDepartureTime: Promise<string>;
    readonly actualTruckArrivalTime: Promise<string>;
    readonly actualTruckDepartureTime: Promise<string>;
    readonly status: Promise<sageWhMasterData.enums.RoundStatus | null>;
    readonly carrier: Reference<sageWhMasterData.nodes.Carrier | null>;
    readonly carrierName: Promise<string>;
    readonly transportationMethod: Reference<sageWhMasterData.nodes.TransportMode | null>;
    readonly carriageReference: Promise<string>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly dock: Reference<sageWhMasterData.nodes.Location | null>;
    readonly genericRound: Reference<sageWhMasterData.nodes.GenericRound | null>;
    readonly volume: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly linearMeters: Promise<decimal | null>;
    readonly transportType: Reference<sageWhMasterData.nodes.TransportType | null>;
    readonly customer: Reference<sageWhMasterData.nodes.Customer | null>;
    readonly supplier: Reference<sageWhMasterData.nodes.Supplier | null>;
    readonly truckTrackingStatus: Reference<sageWhMasterData.nodes.TruckTrackingStatus | null>;
    readonly comment: Promise<TextStream>;
    readonly workCenter: Reference<sageWhMasterData.nodes.WorkCenter | null>;
    readonly unit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
    readonly estimatedLoad: Promise<decimal | null>;
    readonly loadWeight: Promise<decimal | null>;
}
//# sourceMappingURL=appointment-management.d.ts.map