"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserExtension = void 0;
const sageWhSystem = require("@sage/wh-system");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhMasterData = require("..");
const xtrem_core_1 = require("@sage/xtrem-core");
const joins = {};
let UserExtension = class UserExtension extends xtrem_core_1.NodeExtension {
};
exports.UserExtension = UserExtension;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        computeValue() {
            return sageWhMasterData.functions.getByUserCurrentDepositorCode(this);
        },
    })
], UserExtension.prototype, "currentDepositorCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        computeValue() {
            return sageWhMasterData.functions.getByUserCurrentSiteCode(this);
        },
    })
], UserExtension.prototype, "currentSiteCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        computeValue() {
            return sageWhMasterData.functions.getDefaultSiteCode(this);
        },
    })
], UserExtension.prototype, "defaultSiteCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageWhMasterData.functions.getByUserIsAllowedDepositorChange(this);
        },
    })
], UserExtension.prototype, "isAllowedDepositorChange", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageWhMasterData.functions.getByUserIsAllowedSiteChange(this);
        },
    })
], UserExtension.prototype, "isAllowedSiteChange", void 0);
exports.UserExtension = UserExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageWhSystem.nodes.User,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], UserExtension);
//# sourceMappingURL=user-extension.js.map