"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyExtension = void 0;
const sageWhStructure = require("@sage/wh-structure");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageWhMasterData = require("..");
const joins = {
    referenceJoins: {
        country: {
            code: 'country',
        },
        registredCapitalCurrency: {
            code: 'registredCapitalCurrency',
        },
        currency: {
            code: 'currency',
        },
    },
};
let CompanyExtension = class CompanyExtension extends xtrem_core_1.NodeExtension {
};
exports.CompanyExtension = CompanyExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageWhStructure.nodes.Country,
    })
], CompanyExtension.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RGCCUR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Currency,
        serviceOptions: () => [sageWhSystem.serviceOptions.EurActivityCode],
    })
], CompanyExtension.prototype, "registredCapitalCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCCUR',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Currency,
    })
], CompanyExtension.prototype, "currency", void 0);
exports.CompanyExtension = CompanyExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageWhSystem.nodes.Company,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], CompanyExtension);
//# sourceMappingURL=company-extension.js.map