import * as whSystem from '@sage/wh-system';
import { ExtensionMembers } from '@sage/xtrem-core';
import * as whMasterData from '..';
/**
 * get default site code
 * @param _this
 * @returns default site for current user
 */
export declare function getDefaultSiteCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
/**
 *  get site code for current user
 * @param _this
 * @param user
 * @returns
 */
export declare function getCurrentSiteCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
/**
 * get depositor code for current user
 * @param _this
 * @param user
 * @returns
 */
export declare function getCurrentDepositorCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
/**
 * Check if you can enter the site
 * @param _this
 * @returns
 */
export declare function getByUserIsAllowedSiteChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
/**
 * Check if you can enter the depositor
 *  @param _this
 * @returns
 */
export declare function getByUserIsAllowedDepositorChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
/**
 * get site code for given user
 * @param this
 * @param userCode
 * @returns default site for the user
 */
export declare function getByUserCurrentSiteCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
/**
 * get depositor code for given user
 *  @param this
 * @param user
 * @returns default depositor for the user
 */
export declare function getByUserCurrentDepositorCode(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<string>;
/**
 * Check if the given user can enter the site
 * @param _this
 * @param userCode
 * @returns
 */
export declare function getIsUserAllowedSiteChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
/**
 * Check if the given user can enter the depositor
 * @param _this
 * @param userCode
 * @returns
 */
export declare function getIsUserAllowedDepositorChange(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>): Promise<boolean>;
/**
 * Read site from given site
 * Only instance with property code
 * @param _this
 * @param siteCode
 * @returns site when exist
 */
export declare function readSite(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>, siteCode: string): Promise<whSystem.nodes.Site | null>;
/**
 *  Read user from given user code for print destinations and site depositor
 * @param pageInstance
 * @param userCode
 * @returns
 */
export declare function readUser(_this: ExtensionMembers<whMasterData.nodeExtensions.UserExtension & whSystem.nodes.User>, userCode?: string | null): Promise<whSystem.nodes.User | null>;
/**
 * Read record section
 */
/**
 * Read depositor from given site and depositor codes
 * Only instance with property site and code
 * @param _this
 * @param siteCode
 * @param depositorCode
 * @returns depositor when exist
 */
export declare function readDepositor(_this: whMasterData.nodes.Depositor, siteCode: string, depositorCode: string): Promise<whMasterData.nodes.Depositor | null>;
//# sourceMappingURL=user-extension.d.ts.map