"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDisplayCode = getDisplayCode;
exports.getStoreLocationCode = getStoreLocationCode;
const xtrem_core_1 = require("@sage/xtrem-core");
/**
 * Get the location key for a store location (SQL mutation).
 * @param _this The location object.
 * @returns The location key as a string.
 */
async function getDisplayCode(_this) {
    return `${await (await _this.store).code} ${await _this.code}`;
}
(0, xtrem_core_1.registerSqlFunction)('sageWhMasterData.functions.getDisplayCode', getDisplayCode);
/**
 * Get the location code for a store location (SQL mutation).
 * @param _this The location object.
 * @returns The location code as a string.
 */
async function getStoreLocationCode(_this) {
    // FIXME: TODO: Enable this function only when padEnd (minimum) and substring function will be fully implemented by platform (sql transformation)
    // return `${(await (await _this.store).code).padEnd(sageWhMasterData.sharedFunctions.MAX_STORE_CODE_LENGTH).substring(0, sageWhMasterData.sharedFunctions.MAX_STORE_CODE_LENGTH)}${await _this.code}`;
    return `${await (await _this.store).code} ${await _this.code}`;
}
(0, xtrem_core_1.registerSqlFunction)('sageWhMasterData.functions.getStoreLocationCode', getStoreLocationCode);
//# sourceMappingURL=location.js.map