"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultSite = getDefaultSite;
exports.readSite = readSite;
exports.readDepositor = readDepositor;
exports.readUser = readUser;
const user_parameters_values_1 = require("@sage/wh-system/lib/client-functions/user-parameters-values");
/**
 * get default site for the user for GEODE module
 * @param user
 * @returns default site for the user
 */
function getDefaultSite(user) {
    return (0, user_parameters_values_1.getUserProfile)(user) ? (0, user_parameters_values_1.getDefaultSiteFromModule)(user, 2) : null;
}
/**
 * Read site from given site
 * Only instance with property code
 * @param pageInstance
 * @param siteCode
 * @param depositorCode
 * @returns site when exist
 */
async function readSite(pageInstance, siteCode) {
    try {
        return (await pageInstance.$.graph
            .node('@sage/wh-system/Site')
            .read({
            code: true,
        }, `${siteCode?.toUpperCase()}`)
            .execute());
    }
    catch (_error) {
        return null;
    }
}
/**
 * Read depositor from given site and depositor codes
 * Only instance with property site and code
 * @param pageInstance
 * @param siteCode
 * @param depositorCode
 * @returns depositor when exist
 */
async function readDepositor(pageInstance, siteCode, depositorCode) {
    try {
        return (await pageInstance.$.graph
            .node('@sage/wh-master-data/Depositor')
            .read({
            site: {
                code: true,
            },
            code: true,
        }, `${siteCode?.toUpperCase()}|${depositorCode?.toUpperCase()}`)
            .execute());
    }
    catch (_error) {
        return null;
    }
}
/**
 *  Read user from given user code for print destinations and site depositor
 * @param pageInstance
 * @param userCode
 * @returns
 */
async function readUser(pageInstance, userCode) {
    try {
        return (await pageInstance.$.graph
            .node('@sage/wh-system/User')
            .read({
            code: true,
            name: true,
            functionProfile: {
                profile: true,
                userProfileDefaultSites: {
                    query: {
                        edges: {
                            node: {
                                site: {
                                    code: true,
                                },
                            },
                        },
                    },
                },
            },
            profession: {
                profession: true,
                functionProfile: {
                    profile: true,
                    userProfileDefaultSites: {
                        query: {
                            edges: {
                                node: {
                                    site: {
                                        code: true,
                                    },
                                },
                            },
                        },
                    },
                },
            },
            userDestinations: {
                query: {
                    edges: {
                        node: {
                            code: true,
                            destination: {
                                code: true,
                                description: true,
                                destination: true,
                            },
                        },
                    },
                },
            },
            currentDepositorCode: true,
            currentSiteCode: true,
            defaultSiteCode: true,
            isAllowedDepositorChange: true,
            isAllowedSiteChange: true,
        }, `${userCode?.toUpperCase() ?? pageInstance.$.userCode?.toUpperCase()}`)
            .execute());
    }
    catch (_error) {
        return null;
    }
}
//# sourceMappingURL=user-extension.js.map