/**
 * Client functions for user extension : temporary functions before server-side implementation
 */
import type { Depositor } from '@sage/wh-master-data-api';
import type { Site, User } from '@sage/wh-system-api';
/**
 * get default site for the user for GEODE module
 * @param user
 * @returns default site for the user
 */
export declare function getDefaultSite(user: User): Site | null;
/**
 * Read site from given site
 * Only instance with property code
 * @param pageInstance
 * @param siteCode
 * @param depositorCode
 * @returns site when exist
 */
export declare function readSite(pageInstance: any, siteCode: string): Promise<Site | null>;
/**
 * Read depositor from given site and depositor codes
 * Only instance with property site and code
 * @param pageInstance
 * @param siteCode
 * @param depositorCode
 * @returns depositor when exist
 */
export declare function readDepositor(pageInstance: any, siteCode: string, depositorCode: string): Promise<Depositor | null>;
/**
 *  Read user from given user code for print destinations and site depositor
 * @param pageInstance
 * @param userCode
 * @returns
 */
export declare function readUser(pageInstance: any, userCode?: string): Promise<User | null>;
//# sourceMappingURL=user-extension.d.ts.map