type Storage = any;
/**
 *  Selected site and depositor type
 */
export type SiteDepositor = {
    site: string;
    depositor?: string;
};
export type LabelDocumentDestination = {
    labelDestination?: string;
    documentDestination?: string;
};
/**
 *  Get the selected site and depositor
 * @param pageInstance
 * @returns
 */
export declare function getSelectedSiteDepositor(pageInstance: any): SiteDepositor | undefined;
/**
 *  Get the selected site and depositor by storage
 * @param storage
 * @returns
 */
export declare function getSelectedSiteDepositorByStorage(storage: Storage): SiteDepositor | undefined;
/**
 *  Get the selected site
 * @param pageInstance
 * @returns
 */
export declare function getSelectedSite(pageInstance: any): string | undefined;
/**
 *  Get the selected site by storage
 * @param storage
 * @returns
 */
export declare function getSelectedSiteByStorage(storage: Storage): string | undefined;
/**
 *  Get the selected depositor
 * @param pageInstance
 * @returns
 */
export declare function getSelectedDepositor(pageInstance: any): string | undefined;
/**
 *  Get the selected depositor by storage
 * @param storage
 * @returns
 */
export declare function getSelectedDepositorByStorage(storage: Storage): string | undefined;
/**
 * Set the selected site and depositor
 * @param pageInstance
 * @param site
 * @param depositor
 */
export declare function setSelectedSiteDepositorByCode(pageInstance: any, site?: string, depositor?: string): void;
/**
 * Set the selected site and depositor
 * @param pageInstance
 * @param siteDepositor
 */
export declare function setSelectedSiteDepositor(pageInstance: any, siteDepositor?: SiteDepositor): void;
/**
 * Remove the selected site and depositor
 * @param pageInstance
 */
export declare function removeSelectedSiteDepositor(pageInstance: any): void;
/**
 * Set the selected site
 * @param pageInstance
 * @param site
 */
export declare function setSelectedSite(pageInstance: any, site?: string): void;
/**
 * Set the selected depositor
 * @param pageInstance
 * @param depositor
 */
export declare function setSelectedDepositor(pageInstance: any, depositor: string): void;
/**
 * Save the selected site and depositor to X3
 * @param pageInstance
 * @param siteDepositor
 * @returns
 */
export declare function saveSelectedSiteDepositor(pageInstance: any, user: string | undefined | null, siteDepositor: SiteDepositor): Promise<boolean>;
/**
 * Get the label and document destinations
 * @param pageInstance
 * @returns
 */
export declare function getLabelDocumentDestination(pageInstance: any): LabelDocumentDestination | undefined;
/**
 * Set the label and document destinations
 * @param pageInstance
 * @param labelDocumentDestination
 */
export declare function setLabelDocumentDestination(pageInstance: any, labelDocumentDestination?: LabelDocumentDestination): void;
/**
 * Set the label and document destinations by codes
 * @param pageInstance
 * @returns
 */
export declare function setLabelDocumentDestinationCode(pageInstance: any, labelDestination?: string, documentDestination?: string): void;
/**
 * Remove the label and document destinations
 * @param pageInstance
 */
export declare function removeLabelDocumentDestination(pageInstance: any): void;
/**
 * Get the label destination
 * @param pageInstance
 * @returns
 */
export declare function getLabelDestination(pageInstance: any): string | undefined;
/**
 * Get the document destination
 * @param pageInstance
 * @returns
 */
export declare function getDocumentDestination(pageInstance: any): string | undefined;
/**
 * Set the label destination
 * @param pageInstance
 * @param labelDestination
 */
export declare function setLabelDestination(pageInstance: any, labelDestination?: string): void;
/**
 * Set the document destination
 * @param pageInstance
 * @param documentDestination
 */
export declare function setDocumentDestination(pageInstance: any, documentDestination?: string): void;
export {};
//# sourceMappingURL=storage-properties.d.ts.map