"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSiteConfiguration = getSiteConfiguration;
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
const storage_properties_1 = require("./storage-properties");
/**
 * Load current site configuration, assign default mode and full list
 *  @returns  SiteConfiguration
 */
async function getSiteConfiguration(pageInstance) {
    const _siteCode = (0, storage_properties_1.getSelectedSite)(pageInstance);
    try {
        if (_siteCode) {
            const _response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
                .node('@sage/wh-master-data/WhSite')
                .query(ui.queryUtils.edgesSelector({
                eanDefaultMethod: true,
                isDripAndDropAllowed: true,
                supplierBarCodes: {
                    query: {
                        edges: {
                            node: {
                                supplierBarCodeStart: true,
                                supplierBarCodeEnd: true,
                            },
                        },
                    },
                },
            }, {
                filter: {
                    site: { code: _siteCode },
                },
            }))
                .execute())[0];
            if (_response) {
                return {
                    eanDefaultMethod: _response.eanDefaultMethod ?? 'supplierBC',
                    isDripAndDropAllowed: _response.isDripAndDropAllowed,
                    supplierBarCodeRange1: [
                        Number(_response.supplierBarCodes[0].supplierBarCodeStart),
                        Number(_response.supplierBarCodes[0].supplierBarCodeEnd),
                    ],
                    supplierBarCodeRange2: [
                        Number(_response.supplierBarCodes[1].supplierBarCodeStart),
                        Number(_response.supplierBarCodes[1].supplierBarCodeEnd),
                    ],
                };
            }
        }
    }
    catch (error) {
        ui.console.error(`Error reading site configuration :\n${error}`);
    }
    return undefined;
}
//# sourceMappingURL=get-site-configuration.js.map