"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentSiteDepositor = getCurrentSiteDepositor;
exports.getCurrentSite = getCurrentSite;
exports.getCurrentDepositor = getCurrentDepositor;
const dialogs_1 = require("./dialogs");
const storage_properties_1 = require("./storage-properties");
/**
 * Return selected stock site for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default site and depositor or null
 */
async function getCurrentSiteDepositor(pageInstance, errorTitle, errorMessage) {
    const _selectedSiteDepositor = (0, storage_properties_1.getSelectedSiteDepositor)(pageInstance);
    if (!_selectedSiteDepositor?.site) {
        // Please note that there asynchronous processing is not prefixed by an await on purpose
        // so that it can be processed in parallel and not block the main process.
        // Be careful not to leave the current page before the user has closed this dialog box.
        await pageInstance.$.sound.error();
        await (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);
        return null;
    }
    return _selectedSiteDepositor;
}
/**
 * Return selected site for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default site or null
 */
async function getCurrentSite(pageInstance, errorTitle, errorMessage) {
    const _selectedSiteDepositor = await getCurrentSiteDepositor(pageInstance, errorTitle, errorMessage);
    return _selectedSiteDepositor?.site ?? null;
}
/**
 * Return current depositor for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default depositor or null
 */
async function getCurrentDepositor(pageInstance, errorTitle, errorMessage) {
    const _selectedSiteDepositor = await getCurrentSiteDepositor(pageInstance, errorTitle, errorMessage);
    return _selectedSiteDepositor?.depositor ?? null;
}
//# sourceMappingURL=get-selected-site-depositor.js.map