import * as ui from '@sage/xtrem-ui';
import { SiteDepositor } from './storage-properties';
/**
 * Return selected stock site for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default site and depositor or null
 */
export declare function getCurrentSiteDepositor(pageInstance: ui.Page, errorTitle: string, errorMessage: string): Promise<SiteDepositor | null>;
/**
 * Return selected site for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default site or null
 */
export declare function getCurrentSite(pageInstance: ui.Page, errorTitle: string, errorMessage: string): Promise<string | null>;
/**
 * Return current depositor for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default depositor or null
 */
export declare function getCurrentDepositor(pageInstance: ui.Page, errorTitle: string, errorMessage: string): Promise<string | null>;
//# sourceMappingURL=get-selected-site-depositor.d.ts.map