"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDepositorConfiguration = getDepositorConfiguration;
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
const storage_properties_1 = require("./storage-properties");
/**
 *  Load current depositor configuration
 * @param pageInstance
 *  @returns
 */
async function getDepositorConfiguration(pageInstance) {
    const _siteDepositorCode = (0, storage_properties_1.getSelectedSiteDepositor)(pageInstance);
    const _siteCode = _siteDepositorCode?.site;
    const _depositorCode = _siteDepositorCode?.depositor;
    try {
        if (_siteCode && _depositorCode) {
            const _response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
                .node('@sage/wh-master-data/Depositor')
                .query(ui.queryUtils.edgesSelector({
                code: true,
                isLotNumber: true,
                isSupportNumber: true,
            }, {
                filter: {
                    site: { code: _siteCode },
                    code: _depositorCode,
                },
            }))
                .execute())[0];
            if (_response) {
                return {
                    isLotNumber: _response.isLotNumber,
                    isSupportNumber: _response.isSupportNumber,
                };
            }
        }
    }
    catch (error) {
        ui.console.error(`Error reading depositor configuration :\n${error}`);
    }
    return undefined;
}
//# sourceMappingURL=get-depositor-configuration.js.map