import * as ui from '@sage/xtrem-ui';
/**
 * @description: This enum is used to define the authorized operation for the current site.
 * @example: AuthorizedOperation.receipt
 */
export declare enum AuthorizedOperation {
    adjustment = "adjustment",
    carrierEdi = "carrierEdi",
    consumableInput = "consumableInput",
    consumableOutput = "consumableOutput",
    picking = "picking",
    receipt = "receipt",
    repacking = "repacking",
    simplifiedStockCount = "simplifiedStockCount",
    transfer = "transfer"
}
/**
 *  @description: This function is used to get the authorized operator for current site:
 *                she returns an operator code when required, otherwise an empty string, and undefined when not applicable.
 *  @example: getAuthorizedOperator(AuthorizedOperation.receipt)
 *  @param pageInstance: ui.Page,
 *  @param operatorCode : string
 *  @param operationCode : AuthorizedOperation
 *  @returns: Promise<string | undefined | Error>
 */
export declare function getAuthorizedOperator(pageInstance: ui.Page, operationCode: AuthorizedOperation): Promise<string | undefined | Error>;
/**
 *  @description: This function is used to get the authorized operator for current site :
 *                she valid an operator code, and undefined when not applicable (no standard).
 *  @example: isOperatorRequired(this, this._siteSelectedCode, AuthorizedOperation.receipt)
 *  @param pageInstance: ui.Page,
 *  @param operationCode : AuthorizedOperation
 *  @returns: Promise<boolean | error>
 */
export declare function isOperatorRequired(pageInstance: ui.Page, operationCode: AuthorizedOperation): Promise<boolean | Error>;
/**
 *  @description: This function is used to get the authorized operator for current site :
 *                she valid an operator code, and undefined when not applicable (no standard).
 *  @example: isAuthorizedOperator(this, this._siteSelectedCode, _operatorCode, AuthorizedOperation.receipt)
 *  @param pageInstance: ui.Page,
 *  @param operatorCode : string
 *  @param operationCode : AuthorizedOperation
 *  @returns: Promise<boolean | error>
 */
export declare function isAuthorizedOperator(pageInstance: ui.Page, operatorCode: string, operationCode: AuthorizedOperation): Promise<boolean | Error>;
//# sourceMappingURL=get-authorized-operator.d.ts.map