"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dialogMessage = dialogMessage;
exports.dialogConfirmation = dialogConfirmation;
/**
 * Display a dialog typed info with given page instance, dialog level, message and optionals options and title
 * @param pageInstance
 * @param dialogLevel must be error, info, success or warn.
 * @param title current title
 * @param message message to display.
 * @param options optional options.
 * @returns
 */
async function dialogMessage(pageInstance, dialogLevel, title, message, options) {
    return (await pageInstance.$.dialog
        .message(dialogLevel, title, message, options)
        .then(() => true)
        .catch(() => false));
}
/**
 * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title
 * @param pageInstance
 * @param dialogLevel must be error, info, success or warn.
 * @param title current title
 * @param message message to display.
 * @param options optional options.
 * @returns
 */
async function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {
    return (await pageInstance.$.dialog
        .confirmation(dialogLevel, title, message, options)
        .then(() => true)
        .catch(() => false));
}
//# sourceMappingURL=dialogs.js.map