"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareAggregateGenericRequest = prepareAggregateGenericRequest;
const xtrem_client_1 = require("@sage/xtrem-client");
/**
 * Prepare the aggregate request before execution
 * @param selector
 * @param filter
 * @param numberOfRecords (optional, default 1000)
 * @returns request prepared
 */
function prepareAggregateGenericRequest(selector, filter, numberOfRecords = 1000) {
    const _aggregateRequest = (0, xtrem_client_1.aggregateEdgesSelector)(selector, filter);
    if (_aggregateRequest?.__args) {
        _aggregateRequest.__args.first = numberOfRecords;
    }
    return _aggregateRequest;
}
//# sourceMappingURL=aggregators.js.map