declare module '@sage/wh-master-data-api-partial' {
    import type { Country, Package as SageWhStructure$Package } from '@sage/wh-structure-api';
    import type {
        Access,
        Company,
        CompanyInput,
        Destination,
        GenericPrintReport,
        Image,
        Language,
        MiscellaneousTable,
        Package as SageWhSystem$Package,
        Site,
        SiteInput,
        SiteUnavailabilityDays,
        SiteUnavailabilityDaysBinding,
        SiteUnavailabilityDaysInput,
        SyracusMethod,
        User,
        UserFunctionProfile,
        UserFunctions,
        UserFunctionsBinding,
        UserFunctionsInput,
        UserProfileMenu,
        UserSupervisors,
        UserSupervisorsBinding,
        UserSupervisorsInput,
        UserUserDestinations,
        UserUserDestinationsBinding,
        UserUserDestinationsInput,
    } from '@sage/wh-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AdjustmentType$Enum {
        addToTheContainer: 1;
        creation: 2;
        qualitative: 3;
        deletion: 4;
        increaseQuantity: 5;
        decreaseQuantity: 6;
    }
    export type AdjustmentType = keyof AdjustmentType$Enum;
    export interface AislesInFront$Enum {
        negative: 1;
        positive: 2;
    }
    export type AislesInFront = keyof AislesInFront$Enum;
    export interface AislesType$Enum {
        line: 1;
        comb: 2;
    }
    export type AislesType = keyof AislesType$Enum;
    export interface AppointmentCreationType$Enum {
        appointmentEntry: 1;
        appointmentImport: 2;
        expectedInput: 3;
        receipt: 4;
        round: 5;
    }
    export type AppointmentCreationType = keyof AppointmentCreationType$Enum;
    export interface AppointmentStatus$Enum {
        planned: 1;
        inProgress: 2;
        completed: 3;
    }
    export type AppointmentStatus = keyof AppointmentStatus$Enum;
    export interface AppointmentType$Enum {
        receiptAppointment: 1;
        shippingAppointment: 2;
        otherAppointment: 3;
    }
    export type AppointmentType = keyof AppointmentType$Enum;
    export interface Assignment$Enum {
        assigned: 1;
        single: 2;
        multi: 3;
    }
    export type Assignment = keyof Assignment$Enum;
    export interface ConsumableMvtType$Enum {
        input: 1;
        output: 2;
    }
    export type ConsumableMvtType = keyof ConsumableMvtType$Enum;
    export interface ContainerLevel$Enum {
        level1: 1;
        level2: 2;
        level3: 3;
        level4: 4;
        level5: 5;
    }
    export type ContainerLevel = keyof ContainerLevel$Enum;
    export interface ContainerManagementType$Enum {
        normal: 1;
        unit: 2;
    }
    export type ContainerManagementType = keyof ContainerManagementType$Enum;
    export interface ControlOfDimensions$Enum {
        none: 1;
        height: 2;
        heightAndWidthDepth: 3;
        heightAndWidthAndDepth: 4;
        widthDepth: 5;
        widthAndDepth: 6;
    }
    export type ControlOfDimensions = keyof ControlOfDimensions$Enum;
    export interface CrossDockingBlockingLevel$Enum {
        pickingsParcelsValidation: 1;
        packing: 2;
        palettization: 3;
        shippingUnitClosing: 4;
        loading: 5;
        shipment: 6;
        none: 7;
    }
    export type CrossDockingBlockingLevel = keyof CrossDockingBlockingLevel$Enum;
    export interface CrossDockingOutputPriority$Enum {
        cdkStoreStock: 1;
        nonAvailableReserveStock: 2;
        nonAddressedDirectInputMvt: 3;
        expectedInputReceptionInProcess: 4;
    }
    export type CrossDockingOutputPriority = keyof CrossDockingOutputPriority$Enum;
    export interface CustomerEnum$Enum {
        no: 1;
        yes: 2;
        additional: 3;
    }
    export type CustomerEnum = keyof CustomerEnum$Enum;
    export interface DefaultMode$Enum {
        supplierBc: 1;
        eanCode: 2;
        support: 3;
    }
    export type DefaultMode = keyof DefaultMode$Enum;
    export interface DoHeaderStatus$Enum {
        waitFirstPick: 1;
        waitNthPick: 2;
        selectedForPreparation: 3;
        preparationInProcess: 4;
        waitToBePacked: 5;
        waitToPalletized: 6;
        waitToLoad: 7;
        waitToShip: 8;
        shippedClosed: 9;
    }
    export type DoHeaderStatus = keyof DoHeaderStatus$Enum;
    export interface DockManagement$Enum {
        rdv: 1;
        round: 2;
    }
    export type DockManagement = keyof DockManagement$Enum;
    export interface DockType$Enum {
        receivingDock: 1;
        shippingDock: 2;
        generalDock: 3;
    }
    export type DockType = keyof DockType$Enum;
    export interface FillingUpControl$Enum {
        no: 1;
        inReferenceContainer: 2;
        inNumberOfContainer: 3;
        inReferenceContainerOnTheGround: 4;
    }
    export type FillingUpControl = keyof FillingUpControl$Enum;
    export interface Format$Enum {
        alphabetic: 1;
        numeric: 2;
        alphanumeric: 3;
    }
    export type Format = keyof Format$Enum;
    export interface HomogeneousPallet$Enum {
        no: 1;
        standardHomogeneous: 2;
        homogeneous: 3;
    }
    export type HomogeneousPallet = keyof HomogeneousPallet$Enum;
    export interface IdealRotationClass$Enum {
        location: 1;
        countOfRotation: 2;
    }
    export type IdealRotationClass = keyof IdealRotationClass$Enum;
    export interface IdealVolumeType$Enum {
        location: 1;
        targetCover: 2;
    }
    export type IdealVolumeType = keyof IdealVolumeType$Enum;
    export interface KyInInformation$Enum {
        notModifiable: 1;
        byDefaultAndNotModifiable: 2;
        byDefaultAndModifiable: 3;
        modifiable: 4;
    }
    export type KyInInformation = keyof KyInInformation$Enum;
    export interface LoadUnitType$Enum {
        notManaged: 1;
        weight: 2;
        linearMeters: 3;
    }
    export type LoadUnitType = keyof LoadUnitType$Enum;
    export interface LocationType$Enum {
        picking: 1;
        reserve: 2;
    }
    export type LocationType = keyof LocationType$Enum;
    export interface MappingAddressingCriteria$Enum {
        store: 1;
        rotationClass: 2;
        assignmentClass: 3;
        volumeClass: 4;
        depositor: 5;
        storageType: 6;
    }
    export type MappingAddressingCriteria = keyof MappingAddressingCriteria$Enum;
    export interface MergingOfFlowsPriority$Enum {
        priorityService: 1;
        priorityShipComplete: 2;
    }
    export type MergingOfFlowsPriority = keyof MergingOfFlowsPriority$Enum;
    export interface MonoFifoDate$Enum {
        no: 1;
        byDay: 2;
        byMonth: 3;
        byYear: 4;
    }
    export type MonoFifoDate = keyof MonoFifoDate$Enum;
    export interface Outsize$Enum {
        no: 1;
        yes: 2;
        adjoiningOutsize: 3;
    }
    export type Outsize = keyof Outsize$Enum;
    export interface Parity$Enum {
        old: 1;
        even: 2;
        evenAndOdd: 3;
    }
    export type Parity = keyof Parity$Enum;
    export interface PartialDeliveryAuthorized$Enum {
        yes: 1;
        byLine: 2;
        no: 3;
    }
    export type PartialDeliveryAuthorized = keyof PartialDeliveryAuthorized$Enum;
    export interface PivotPickingPriority$Enum {
        depositor: 1;
        store: 2;
        rotation: 3;
        assignment: 4;
    }
    export type PivotPickingPriority = keyof PivotPickingPriority$Enum;
    export interface PrintingSequence$Enum {
        storeInput: 1;
        inputStore: 2;
    }
    export type PrintingSequence = keyof PrintingSequence$Enum;
    export interface ProcessingFamily$Enum {
        inputs: 1;
        transfers: 2;
        manualAdjustments: 3;
        automaticAdjustments: 4;
        outputs: 5;
        consumable: 6;
        assembling: 7;
        disassembling: 8;
    }
    export type ProcessingFamily = keyof ProcessingFamily$Enum;
    export interface QuantityControlInputLine$Enum {
        no: 1;
        yes: 2;
        warning: 3;
    }
    export type QuantityControlInputLine = keyof QuantityControlInputLine$Enum;
    export interface RoundStatus$Enum {
        notCompliant: 1;
        notUsed2: 2;
        awaitingTruck: 3;
        awaitingShipment: 4;
        notUsed5: 5;
        notUsed6: 6;
        notUsed7: 7;
        notUsed8: 8;
        validated: 9;
    }
    export type RoundStatus = keyof RoundStatus$Enum;
    export interface ServicePriority$Enum {
        lowest: 1;
        low: 2;
        medium: 3;
        mediumHigh: 4;
        high: 5;
        highest: 6;
    }
    export type ServicePriority = keyof ServicePriority$Enum;
    export interface StockNatureType$Enum {
        general: 1;
        assembling: 2;
        qualityControl: 3;
    }
    export type StockNatureType = keyof StockNatureType$Enum;
    export interface StoreType$Enum {
        main: 1;
        singleAddress: 2;
        splitting: 3;
        dock: 4;
        crossDocking: 5;
        buffer: 6;
        twoPhaseTransfer: 7;
    }
    export type StoreType = keyof StoreType$Enum;
    export interface SuInformationEntry$Enum {
        byDefaultAndNonModifiable: 1;
        byDefaultAndModifiable: 2;
        modifiable: 3;
    }
    export type SuInformationEntry = keyof SuInformationEntry$Enum;
    export interface TarificationType$Enum {
        weight: 1;
        volume: 2;
        linearMeter: 3;
        noOfParcel: 4;
    }
    export type TarificationType = keyof TarificationType$Enum;
    export interface UniqueReference$Enum {
        no: 1;
        yes: 2;
        yesIfNotClosed: 3;
    }
    export type UniqueReference = keyof UniqueReference$Enum;
    export interface UnstoringType$Enum {
        fifo: 1;
        lifo: 2;
    }
    export type UnstoringType = keyof UnstoringType$Enum;
    export interface ValidationType$Enum {
        manual: 1;
        automatic: 2;
    }
    export type ValidationType = keyof ValidationType$Enum;
    export interface AppointmentManagement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        description: string;
        appointmentType: AppointmentType;
        appointmentStatus: AppointmentStatus;
        appointmentCreationType: AppointmentCreationType;
        depositor: Depositor;
        creationDate: string;
        expectedDockAssignmentStartDate: string;
        expectedDockAssignmentEndDate: string;
        actualDockAssignmentStartDate: string;
        actualDockAssignmentEndDate: string;
        effectiveStartDate: string;
        effectiveEndDate: string;
        expectedTruckArrivalDate: string;
        expectedTruckDepartureDate: string;
        actualTruckArrivalDate: string;
        actualTruckDepartureDate: string;
        creationTime: string;
        expectedDockAssignmentDuration: string;
        expectedStartTime: string;
        expectedEndTime: string;
        actualStartTime: string;
        actualEndTime: string;
        effectiveStartTime: string;
        effectiveEndTime: string;
        expectedTruckArrivalTime: string;
        expectedTruckDepartureTime: string;
        actualTruckArrivalTime: string;
        actualTruckDepartureTime: string;
        status: RoundStatus;
        carrier: Carrier;
        carrierName: string;
        transportationMethod: TransportMode;
        carriageReference: string;
        store: Store;
        dock: Location;
        genericRound: GenericRound;
        volume: string;
        weight: string;
        linearMeters: string;
        transportType: TransportType;
        customer: Customer;
        supplier: Supplier;
        truckTrackingStatus: TruckTrackingStatus;
        comment: TextStream;
        workCenter: WorkCenter;
        unit: UnitOfMeasure;
        estimatedLoad: string;
        loadWeight: string;
    }
    export interface AppointmentManagementInput extends ClientNodeInput {
        site?: string;
        code?: string;
        description?: string;
        appointmentType?: AppointmentType;
        appointmentStatus?: AppointmentStatus;
        appointmentCreationType?: AppointmentCreationType;
        depositor?: string;
        creationDate?: string;
        expectedDockAssignmentStartDate?: string;
        expectedDockAssignmentEndDate?: string;
        actualDockAssignmentStartDate?: string;
        actualDockAssignmentEndDate?: string;
        effectiveStartDate?: string;
        effectiveEndDate?: string;
        expectedTruckArrivalDate?: string;
        expectedTruckDepartureDate?: string;
        actualTruckArrivalDate?: string;
        actualTruckDepartureDate?: string;
        creationTime?: string;
        expectedDockAssignmentDuration?: string;
        expectedStartTime?: string;
        expectedEndTime?: string;
        actualStartTime?: string;
        actualEndTime?: string;
        effectiveStartTime?: string;
        effectiveEndTime?: string;
        expectedTruckArrivalTime?: string;
        expectedTruckDepartureTime?: string;
        actualTruckArrivalTime?: string;
        actualTruckDepartureTime?: string;
        status?: RoundStatus;
        carrier?: string;
        carrierName?: string;
        transportationMethod?: string;
        carriageReference?: string;
        store?: string;
        dock?: string;
        genericRound?: string;
        volume?: decimal | string;
        weight?: decimal | string;
        linearMeters?: decimal | string;
        transportType?: string;
        customer?: string;
        supplier?: string;
        truckTrackingStatus?: string;
        comment?: TextStream;
        workCenter?: string;
        unit?: string;
        estimatedLoad?: decimal | string;
        loadWeight?: decimal | string;
    }
    export interface AppointmentManagementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        description: string;
        appointmentType: AppointmentType;
        appointmentStatus: AppointmentStatus;
        appointmentCreationType: AppointmentCreationType;
        depositor: Depositor;
        creationDate: string;
        expectedDockAssignmentStartDate: string;
        expectedDockAssignmentEndDate: string;
        actualDockAssignmentStartDate: string;
        actualDockAssignmentEndDate: string;
        effectiveStartDate: string;
        effectiveEndDate: string;
        expectedTruckArrivalDate: string;
        expectedTruckDepartureDate: string;
        actualTruckArrivalDate: string;
        actualTruckDepartureDate: string;
        creationTime: string;
        expectedDockAssignmentDuration: string;
        expectedStartTime: string;
        expectedEndTime: string;
        actualStartTime: string;
        actualEndTime: string;
        effectiveStartTime: string;
        effectiveEndTime: string;
        expectedTruckArrivalTime: string;
        expectedTruckDepartureTime: string;
        actualTruckArrivalTime: string;
        actualTruckDepartureTime: string;
        status: RoundStatus;
        carrier: Carrier;
        carrierName: string;
        transportationMethod: TransportMode;
        carriageReference: string;
        store: Store;
        dock: Location;
        genericRound: GenericRound;
        volume: string;
        weight: string;
        linearMeters: string;
        transportType: TransportType;
        customer: Customer;
        supplier: Supplier;
        truckTrackingStatus: TruckTrackingStatus;
        comment: TextStream;
        workCenter: WorkCenter;
        unit: UnitOfMeasure;
        estimatedLoad: string;
        loadWeight: string;
    }
    export interface AppointmentManagement$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        store: QueryOperation<Store>;
        dock: QueryOperation<Location>;
        genericRound: QueryOperation<GenericRound>;
        transportType: QueryOperation<TransportType>;
        customer: QueryOperation<Customer>;
        supplier: QueryOperation<Supplier>;
        truckTrackingStatus: QueryOperation<TruckTrackingStatus>;
        workCenter: QueryOperation<WorkCenter>;
        unit: QueryOperation<UnitOfMeasure>;
    }
    export interface AppointmentManagement$Operations {
        query: QueryOperation<AppointmentManagement>;
        read: ReadOperation<AppointmentManagement>;
        aggregate: {
            read: AggregateReadOperation<AppointmentManagement>;
            query: AggregateQueryOperation<AppointmentManagement>;
        };
        lookups(dataOrId: string | { data: AppointmentManagementInput }): AppointmentManagement$Lookups;
        getDefaults: GetDefaultsOperation<AppointmentManagement>;
    }
    export interface AssignmentClassChainingAssignments extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        chainingAssignmentClass: AssignmentClass;
    }
    export interface AssignmentClassChainingAssignmentsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        chainingAssignmentClass?: string;
    }
    export interface AssignmentClassChainingAssignmentsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        chainingAssignmentClass: AssignmentClass;
    }
    export interface AssignmentClassChainingAssignments$Lookups {
        chainingAssignmentClass: QueryOperation<AssignmentClass>;
    }
    export interface AssignmentClassChainingAssignments$Operations {
        query: QueryOperation<AssignmentClassChainingAssignments>;
        read: ReadOperation<AssignmentClassChainingAssignments>;
        aggregate: {
            read: AggregateReadOperation<AssignmentClassChainingAssignments>;
            query: AggregateQueryOperation<AssignmentClassChainingAssignments>;
        };
        lookups(
            dataOrId: string | { data: AssignmentClassChainingAssignmentsInput },
        ): AssignmentClassChainingAssignments$Lookups;
        getDefaults: GetDefaultsOperation<AssignmentClassChainingAssignments>;
    }
    export interface AssignmentClass extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfChainings: integer;
        outsizeManagement: Outsize;
        isActive: boolean;
        chainingAssignments: ClientCollection<AssignmentClassChainingAssignments>;
    }
    export interface AssignmentClassInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        numberOfChainings?: integer | string;
        outsizeManagement?: Outsize;
        isActive?: boolean | string;
        chainingAssignments?: Partial<AssignmentClassChainingAssignmentsInput>[];
    }
    export interface AssignmentClassBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfChainings: integer;
        outsizeManagement: Outsize;
        isActive: boolean;
        chainingAssignments: ClientCollection<AssignmentClassChainingAssignmentsBinding>;
    }
    export interface AssignmentClass$Lookups {
        site: QueryOperation<Site>;
    }
    export interface AssignmentClass$Operations {
        query: QueryOperation<AssignmentClass>;
        read: ReadOperation<AssignmentClass>;
        aggregate: {
            read: AggregateReadOperation<AssignmentClass>;
            query: AggregateQueryOperation<AssignmentClass>;
        };
        lookups(dataOrId: string | { data: AssignmentClassInput }): AssignmentClass$Lookups;
        getDefaults: GetDefaultsOperation<AssignmentClass>;
    }
    export interface CarrierAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        address: string;
    }
    export interface CarrierAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        address?: string;
    }
    export interface CarrierAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        address: string;
    }
    export interface CarrierAddresses$Operations {
        query: QueryOperation<CarrierAddresses>;
        read: ReadOperation<CarrierAddresses>;
        aggregate: {
            read: AggregateReadOperation<CarrierAddresses>;
            query: AggregateQueryOperation<CarrierAddresses>;
        };
        getDefaults: GetDefaultsOperation<CarrierAddresses>;
    }
    export interface CarrierCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        companyName: string;
    }
    export interface CarrierCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        companyName?: string;
    }
    export interface CarrierCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        companyName: string;
    }
    export interface CarrierCompanyNames$Operations {
        query: QueryOperation<CarrierCompanyNames>;
        read: ReadOperation<CarrierCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<CarrierCompanyNames>;
            query: AggregateQueryOperation<CarrierCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<CarrierCompanyNames>;
    }
    export interface CarrierTarifficationTypes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        tarifficationType: TarificationType;
    }
    export interface CarrierTarifficationTypesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        tarifficationType?: TarificationType;
    }
    export interface CarrierTarifficationTypesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        tarifficationType: TarificationType;
    }
    export interface CarrierTarifficationTypes$Operations {
        query: QueryOperation<CarrierTarifficationTypes>;
        read: ReadOperation<CarrierTarifficationTypes>;
        aggregate: {
            read: AggregateReadOperation<CarrierTarifficationTypes>;
            query: AggregateQueryOperation<CarrierTarifficationTypes>;
        };
        getDefaults: GetDefaultsOperation<CarrierTarifficationTypes>;
    }
    export interface CarrierTransportationMethods extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        transportationMethod: TransportMode;
    }
    export interface CarrierTransportationMethodsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        transportationMethod?: string;
    }
    export interface CarrierTransportationMethodsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        transportationMethod: TransportMode;
    }
    export interface CarrierTransportationMethods$Lookups {
        transportationMethod: QueryOperation<TransportMode>;
    }
    export interface CarrierTransportationMethods$Operations {
        query: QueryOperation<CarrierTransportationMethods>;
        read: ReadOperation<CarrierTransportationMethods>;
        aggregate: {
            read: AggregateReadOperation<CarrierTransportationMethods>;
            query: AggregateQueryOperation<CarrierTransportationMethods>;
        };
        lookups(dataOrId: string | { data: CarrierTransportationMethodsInput }): CarrierTransportationMethods$Lookups;
        getDefaults: GetDefaultsOperation<CarrierTransportationMethods>;
    }
    export interface Carrier extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedShortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        telephone: string;
        fax: string;
        email: string;
        carriageNotePrint: GenericPrintReport;
        carriageReceiptPrint: GenericPrintReport;
        carriageNoteTariffCode: TariffCode;
        carriageReceiptTariffCode: TariffCode;
        isCarriageNoteAmountCalculation: boolean;
        isCarriageReceiptAmountCalculation: boolean;
        currency: Currency;
        isEdiManagement: boolean;
        interSiteCarriageNotePrint: GenericPrintReport;
        interSiteCarriageReceiptPrint: GenericPrintReport;
        isActive: boolean;
        addresses: ClientCollection<CarrierAddresses>;
        companyNames: ClientCollection<CarrierCompanyNames>;
        tarifficationTypes: ClientCollection<CarrierTarifficationTypes>;
        transportationMethods: ClientCollection<CarrierTransportationMethods>;
    }
    export interface CarrierInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedShortDescription?: string;
        postalCode?: string;
        city?: string;
        region?: string;
        country?: string;
        countryName?: string;
        telephone?: string;
        fax?: string;
        email?: string;
        carriageNotePrint?: string;
        carriageReceiptPrint?: string;
        carriageNoteTariffCode?: string;
        carriageReceiptTariffCode?: string;
        isCarriageNoteAmountCalculation?: boolean | string;
        isCarriageReceiptAmountCalculation?: boolean | string;
        currency?: string;
        isEdiManagement?: boolean | string;
        interSiteCarriageNotePrint?: string;
        interSiteCarriageReceiptPrint?: string;
        isActive?: boolean | string;
        addresses?: Partial<CarrierAddressesInput>[];
        companyNames?: Partial<CarrierCompanyNamesInput>[];
        tarifficationTypes?: Partial<CarrierTarifficationTypesInput>[];
        transportationMethods?: Partial<CarrierTransportationMethodsInput>[];
    }
    export interface CarrierBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedShortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        telephone: string;
        fax: string;
        email: string;
        carriageNotePrint: GenericPrintReport;
        carriageReceiptPrint: GenericPrintReport;
        carriageNoteTariffCode: TariffCode;
        carriageReceiptTariffCode: TariffCode;
        isCarriageNoteAmountCalculation: boolean;
        isCarriageReceiptAmountCalculation: boolean;
        currency: Currency;
        isEdiManagement: boolean;
        interSiteCarriageNotePrint: GenericPrintReport;
        interSiteCarriageReceiptPrint: GenericPrintReport;
        isActive: boolean;
        addresses: ClientCollection<CarrierAddressesBinding>;
        companyNames: ClientCollection<CarrierCompanyNamesBinding>;
        tarifficationTypes: ClientCollection<CarrierTarifficationTypesBinding>;
        transportationMethods: ClientCollection<CarrierTransportationMethodsBinding>;
    }
    export interface Carrier$Lookups {
        site: QueryOperation<Site>;
        country: QueryOperation<Country>;
        carriageNotePrint: QueryOperation<GenericPrintReport>;
        carriageReceiptPrint: QueryOperation<GenericPrintReport>;
        carriageNoteTariffCode: QueryOperation<TariffCode>;
        carriageReceiptTariffCode: QueryOperation<TariffCode>;
        currency: QueryOperation<Currency>;
        interSiteCarriageNotePrint: QueryOperation<GenericPrintReport>;
        interSiteCarriageReceiptPrint: QueryOperation<GenericPrintReport>;
    }
    export interface Carrier$Operations {
        query: QueryOperation<Carrier>;
        read: ReadOperation<Carrier>;
        aggregate: {
            read: AggregateReadOperation<Carrier>;
            query: AggregateQueryOperation<Carrier>;
        };
        lookups(dataOrId: string | { data: CarrierInput }): Carrier$Lookups;
        getDefaults: GetDefaultsOperation<Carrier>;
    }
    export interface CommonImage extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        site: Site;
        depositor: Depositor;
        identifier1: string;
        identifier2: string;
        identifier3: string;
        filename: string;
        image: BinaryStream;
    }
    export interface CommonImageInput extends ClientNodeInput {
        code?: string;
        site?: string;
        depositor?: string;
        identifier1?: string;
        identifier2?: string;
        identifier3?: string;
        filename?: string;
        image?: BinaryStream;
    }
    export interface CommonImageBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        site: Site;
        depositor: Depositor;
        identifier1: string;
        identifier2: string;
        identifier3: string;
        filename: string;
        image: BinaryStream;
    }
    export interface CommonImage$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
    }
    export interface CommonImage$Operations {
        query: QueryOperation<CommonImage>;
        read: ReadOperation<CommonImage>;
        aggregate: {
            read: AggregateReadOperation<CommonImage>;
            query: AggregateQueryOperation<CommonImage>;
        };
        lookups(dataOrId: string | { data: CommonImageInput }): CommonImage$Lookups;
        getDefaults: GetDefaultsOperation<CommonImage>;
    }
    export interface CurrencyRate extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        rateType: ExchangeRateType;
        sourceCurrency: Currency;
        destinationCurrency: Currency;
        rateDate: string;
        inverseRate: string;
        rate: string;
        divisor: string;
    }
    export interface CurrencyRateInput extends ClientNodeInput {
        rateType?: ExchangeRateType;
        sourceCurrency?: string;
        destinationCurrency?: string;
        rateDate?: string;
        inverseRate?: decimal | string;
        rate?: decimal | string;
        divisor?: decimal | string;
    }
    export interface CurrencyRateBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        rateType: ExchangeRateType;
        sourceCurrency: Currency;
        destinationCurrency: Currency;
        rateDate: string;
        inverseRate: string;
        rate: string;
        divisor: string;
    }
    export interface CurrencyRate$Lookups {
        sourceCurrency: QueryOperation<Currency>;
        destinationCurrency: QueryOperation<Currency>;
    }
    export interface CurrencyRate$Operations {
        query: QueryOperation<CurrencyRate>;
        read: ReadOperation<CurrencyRate>;
        aggregate: {
            read: AggregateReadOperation<CurrencyRate>;
            query: AggregateQueryOperation<CurrencyRate>;
        };
        lookups(dataOrId: string | { data: CurrencyRateInput }): CurrencyRate$Lookups;
        getDefaults: GetDefaultsOperation<CurrencyRate>;
    }
    export interface Currency extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        rounding: string;
        format1: string;
        format2: string;
        format3: string;
        isEuro: boolean;
        euroRate: string;
        euroConversionDate: string;
        currencyEndDate: string;
        symbol: string;
        numberOfDecimals: integer;
        isoCode: string;
        isoNumericCode: string;
        currencyRates: ClientCollection<CurrencyRate>;
    }
    export interface CurrencyInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        rounding?: decimal | string;
        format1?: string;
        format2?: string;
        format3?: string;
        isEuro?: boolean | string;
        euroRate?: decimal | string;
        euroConversionDate?: string;
        currencyEndDate?: string;
        symbol?: string;
        numberOfDecimals?: integer | string;
        isoCode?: string;
        isoNumericCode?: string;
    }
    export interface CurrencyBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        rounding: string;
        format1: string;
        format2: string;
        format3: string;
        isEuro: boolean;
        euroRate: string;
        euroConversionDate: string;
        currencyEndDate: string;
        symbol: string;
        numberOfDecimals: integer;
        isoCode: string;
        isoNumericCode: string;
        currencyRates: ClientCollection<CurrencyRate>;
    }
    export interface Currency$Operations {
        query: QueryOperation<Currency>;
        read: ReadOperation<Currency>;
        aggregate: {
            read: AggregateReadOperation<Currency>;
            query: AggregateQueryOperation<Currency>;
        };
        getDefaults: GetDefaultsOperation<Currency>;
    }
    export interface CustomerAdresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        adress: string;
    }
    export interface CustomerAdressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        adress?: string;
    }
    export interface CustomerAdressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        adress: string;
    }
    export interface CustomerAdresses$Operations {
        query: QueryOperation<CustomerAdresses>;
        read: ReadOperation<CustomerAdresses>;
        aggregate: {
            read: AggregateReadOperation<CustomerAdresses>;
            query: AggregateQueryOperation<CustomerAdresses>;
        };
        getDefaults: GetDefaultsOperation<CustomerAdresses>;
    }
    export interface CustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        companyName: string;
    }
    export interface CustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        companyName?: string;
    }
    export interface CustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        companyName: string;
    }
    export interface CustomerCompanyNames$Operations {
        query: QueryOperation<CustomerCompanyNames>;
        read: ReadOperation<CustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<CustomerCompanyNames>;
            query: AggregateQueryOperation<CustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<CustomerCompanyNames>;
    }
    export interface Customer extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        shortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        telephone: string;
        fax: string;
        email: string;
        billToCustomer: Customer;
        notes: string;
        genericRound: GenericRound;
        carrier: Carrier;
        transportationMethod: TransportMode;
        roundPosition: integer;
        deliveryArea: string;
        transportType: TransportType;
        currency: Currency;
        partialDeliveryManagement: PartialDeliveryAuthorized;
        servicePriority: ServicePriority;
        isCarriageAmountCalculation: boolean;
        tariffCode: TariffCode;
        printLanguage: Language;
        deliveryNotePrint: GenericPrintReport;
        isSsccManagementOnOutput: boolean;
        isLotManagement: boolean;
        isActive: boolean;
        adresses: ClientCollection<CustomerAdresses>;
        companyNames: ClientCollection<CustomerCompanyNames>;
    }
    export interface CustomerInput extends ClientNodeInput {
        site?: string;
        code?: string;
        shortDescription?: string;
        postalCode?: string;
        city?: string;
        region?: string;
        country?: string;
        countryName?: string;
        telephone?: string;
        fax?: string;
        email?: string;
        billToCustomer?: string;
        notes?: string;
        genericRound?: string;
        carrier?: string;
        transportationMethod?: string;
        roundPosition?: integer | string;
        deliveryArea?: string;
        transportType?: string;
        currency?: string;
        partialDeliveryManagement?: PartialDeliveryAuthorized;
        servicePriority?: ServicePriority;
        isCarriageAmountCalculation?: boolean | string;
        tariffCode?: string;
        printLanguage?: string;
        deliveryNotePrint?: string;
        isSsccManagementOnOutput?: boolean | string;
        isLotManagement?: boolean | string;
        isActive?: boolean | string;
        adresses?: Partial<CustomerAdressesInput>[];
        companyNames?: Partial<CustomerCompanyNamesInput>[];
    }
    export interface CustomerBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        shortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        telephone: string;
        fax: string;
        email: string;
        billToCustomer: Customer;
        notes: string;
        genericRound: GenericRound;
        carrier: Carrier;
        transportationMethod: TransportMode;
        roundPosition: integer;
        deliveryArea: string;
        transportType: TransportType;
        currency: Currency;
        partialDeliveryManagement: PartialDeliveryAuthorized;
        servicePriority: ServicePriority;
        isCarriageAmountCalculation: boolean;
        tariffCode: TariffCode;
        printLanguage: Language;
        deliveryNotePrint: GenericPrintReport;
        isSsccManagementOnOutput: boolean;
        isLotManagement: boolean;
        isActive: boolean;
        adresses: ClientCollection<CustomerAdressesBinding>;
        companyNames: ClientCollection<CustomerCompanyNamesBinding>;
    }
    export interface Customer$Lookups {
        site: QueryOperation<Site>;
        country: QueryOperation<Country>;
        billToCustomer: QueryOperation<Customer>;
        genericRound: QueryOperation<GenericRound>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        transportType: QueryOperation<TransportType>;
        currency: QueryOperation<Currency>;
        tariffCode: QueryOperation<TariffCode>;
        printLanguage: QueryOperation<Language>;
        deliveryNotePrint: QueryOperation<GenericPrintReport>;
    }
    export interface Customer$Operations {
        query: QueryOperation<Customer>;
        read: ReadOperation<Customer>;
        aggregate: {
            read: AggregateReadOperation<Customer>;
            query: AggregateQueryOperation<Customer>;
        };
        lookups(dataOrId: string | { data: CustomerInput }): Customer$Lookups;
        getDefaults: GetDefaultsOperation<Customer>;
    }
    export interface DepositorAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        address: string;
    }
    export interface DepositorAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        address?: string;
    }
    export interface DepositorAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        address: string;
    }
    export interface DepositorAddresses$Operations {
        query: QueryOperation<DepositorAddresses>;
        read: ReadOperation<DepositorAddresses>;
        aggregate: {
            read: AggregateReadOperation<DepositorAddresses>;
            query: AggregateQueryOperation<DepositorAddresses>;
        };
        getDefaults: GetDefaultsOperation<DepositorAddresses>;
    }
    export interface DepositorCrossDockingPriorities extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        crossDockingPriority: CrossDockingOutputPriority;
    }
    export interface DepositorCrossDockingPrioritiesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        crossDockingPriority?: CrossDockingOutputPriority;
    }
    export interface DepositorCrossDockingPrioritiesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        crossDockingPriority: CrossDockingOutputPriority;
    }
    export interface DepositorCrossDockingPriorities$Operations {
        query: QueryOperation<DepositorCrossDockingPriorities>;
        read: ReadOperation<DepositorCrossDockingPriorities>;
        aggregate: {
            read: AggregateReadOperation<DepositorCrossDockingPriorities>;
            query: AggregateQueryOperation<DepositorCrossDockingPriorities>;
        };
        getDefaults: GetDefaultsOperation<DepositorCrossDockingPriorities>;
    }
    export interface DepositorNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        name: string;
    }
    export interface DepositorNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        name?: string;
    }
    export interface DepositorNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        name: string;
    }
    export interface DepositorNames$Operations {
        query: QueryOperation<DepositorNames>;
        read: ReadOperation<DepositorNames>;
        aggregate: {
            read: AggregateReadOperation<DepositorNames>;
            query: AggregateQueryOperation<DepositorNames>;
        };
        getDefaults: GetDefaultsOperation<DepositorNames>;
    }
    export interface DepositorPickingPivotPriorities extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        pickingPivotPriority: PivotPickingPriority;
    }
    export interface DepositorPickingPivotPrioritiesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        pickingPivotPriority?: PivotPickingPriority;
    }
    export interface DepositorPickingPivotPrioritiesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        pickingPivotPriority: PivotPickingPriority;
    }
    export interface DepositorPickingPivotPriorities$Operations {
        query: QueryOperation<DepositorPickingPivotPriorities>;
        read: ReadOperation<DepositorPickingPivotPriorities>;
        aggregate: {
            read: AggregateReadOperation<DepositorPickingPivotPriorities>;
            query: AggregateQueryOperation<DepositorPickingPivotPriorities>;
        };
        getDefaults: GetDefaultsOperation<DepositorPickingPivotPriorities>;
    }
    export interface Depositor extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        shortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        phone: string;
        fax: string;
        siteTaxIdNumber: string;
        email: string;
        registeredCapital: string;
        rcs: string;
        isSupportNumber: boolean;
        isLotNumber: boolean;
        storingListValidation: ValidationType;
        isControlInputFlow: boolean;
        isPutAlwayLabel: boolean;
        isStoringList: boolean;
        isSingleInputStoringList: boolean;
        isSingleStoreStoringList: boolean;
        printSequenceOfStoringList: PrintingSequence;
        isStoringListControlCode: boolean;
        isStoringListOperatorCode: boolean;
        uniqueInputReference: UniqueReference;
        quantityControlInInput: QuantityControlInputLine;
        isOutputOnPendingInput: boolean;
        isSplitReplenishmentObjects: boolean;
        isReplenishmentBalanceReaddressing: boolean;
        isControlOutputFlow: boolean;
        isOutputShortageManagement: boolean;
        isPartialsByProduct: boolean;
        isShortageByDeliveryOrder: boolean;
        isPreparationLoad: boolean;
        replenishmentValidation: ValidationType;
        isReplenishList: boolean;
        isReplenishLabel: boolean;
        isPreparationOrderOperatorCode: boolean;
        isDeclarativePackingOperatorCode: boolean;
        isPrepackingOperatorCode: boolean;
        isPickOperatorCode: boolean;
        isSuOperatorCode: boolean;
        isRoOperatorCode: boolean;
        uniqueOutputReference: UniqueReference;
        isOrderManagement: boolean;
        isGenericRoundManagement: boolean;
        isSingleParcelItem: boolean;
        isStrictSequentiality: boolean;
        shippingUnitTypeShippingAsIs: ShippingUnitType;
        isShippingUnitClosingAuthorization: boolean;
        isShipmentManagement: boolean;
        parcelRange: RangeOfParcel;
        keyInRealParcelWeight: KyInInformation;
        enterShippingUnitInfo: SuInformationEntry;
        isParcelPalletisation: boolean;
        isControlLoadingParcel: boolean;
        parcelTypeDispatchableInState: ParcelType;
        parcelRangeDispatchableInState: RangeOfParcel;
        printDeliveryNotes: GenericPrintReport;
        isPrintMergingOfFlowsTransferReport: boolean;
        isPrintMergingOfFlowsTransferLabel: boolean;
        isPrintParcelLabels: boolean;
        isShippingUnitLabels: boolean;
        isPalletizationOrderLabels: boolean;
        isGroupedsLabels: boolean;
        isControlCodeOfPick: boolean;
        isControlCodeOfDeposit: boolean;
        isControlCodeOfOutput: boolean;
        addressingPriority: MergingOfFlowsPriority;
        transferMergingOfFlowsValidation: ValidationType;
        isGroupMergingOfFlows: boolean;
        isParcelVolumeManagement: boolean;
        launchingMergingOfFlowsStep2: ValidationType;
        isPrintTemporaryDeliveryNotes: boolean;
        deliveryOrderStatusForDeliveryNotes: DoHeaderStatus;
        isPrintFinalDeliveryNotes: boolean;
        isPrintDifferentialDeliveryNotes: boolean;
        isMovementInSuperiorContainer: boolean;
        isSingleDeliveryOrderShippingUnit: boolean;
        isSingleConsigneeShippingUnit: boolean;
        isAutoPalettizeBigParcels: boolean;
        shippingUnitType: ShippingUnitType;
        autoTransferMovementAdjustementCode: MovementCode;
        auto2PhaseTransferMovementAdjustementCode: MovementCode;
        waveReplenishment: MovementCode;
        balanceMovementCode: MovementCode;
        mergingOfFlowsTransfer: MovementCode;
        transferOfComponent: MovementCode;
        kitTransfer: MovementCode;
        isInitializeCarrierAndTransportMode: boolean;
        adjustmentAfterStockCount: MovementCode;
        isStockAvailable: boolean;
        isPickingStock: boolean;
        isTransferOfIncomplete: boolean;
        uniqueReference: UniqueReference;
        componentTransferValidation: ValidationType;
        kitTransferValidation: ValidationType;
        isShortagePerItem: boolean;
        isShortagePerPreparationOrder: boolean;
        isKitOperatorCode: boolean;
        isComponentOperatorCode: boolean;
        analysisKitMovementCode: MovementCode;
        analysisComponentMovementCode: MovementCode;
        isComponentTransferList: boolean;
        isComponentTransferLabel: boolean;
        isSinglePreparationAreaKitRemoval: boolean;
        isSinglePreparationAreaKitRelocation: boolean;
        isSplittingKit: boolean;
        maximumPrepaprationAreaKit: PreparationArea;
        customerControl: CustomerEnum;
        isInputsConfigurationFlag: boolean;
        isOutputsConfigurationFlag: boolean;
        isStocksConfigurationFlag: boolean;
        isPickReplenishOrderMonoPreparationArea: boolean;
        isDepositorReplenishOrderMonoPreparationArea: boolean;
        isPickMergingOfFlowsMonoPreparationArea: boolean;
        isDepositorMergingOfFlowsMonoPreparationArea: boolean;
        isMergingOfflowsDivision: boolean;
        mergingOfFlowsPreparationAreaMax: PreparationArea;
        refuseStockNature: StockNature;
        consumedStockNature: StockNature;
        isAutomaticAddressing: boolean;
        isQualityOperatorCode: boolean;
        isValidationAnalysisRequestOperatorCode: boolean;
        autoAnalysisRequestAdjustementMovementCode: MovementCode;
        autoAnalysisRequestTransfertMovementCode: MovementCode;
        isAutoPrintQualityRecord: boolean;
        sequenceCode: StoreChaining;
        isChainingStore: boolean;
        isChainingRotationClasse: boolean;
        isChainingAssignmentClasses: boolean;
        isCrossDockingManagement: boolean;
        crossDockingLevel: CrossDockingBlockingLevel;
        isCrossDockingStoreStock: boolean;
        isCrossDockingStoreStockNotAvailable: boolean;
        isReserveStockNotAvailable: boolean;
        isDirectInputMovementNotAddressed: boolean;
        isExpectedInputUnderReceipt: boolean;
        isAlwaysExpressRequirement: boolean;
        isWaveInitialization: boolean;
        ssccExtensionCharacter: string;
        eanUccCode: string;
        isSsccParcelOnOutput: boolean;
        isSsccShippingUnitOnOutput: boolean;
        isStockOnDockParcels: boolean;
        isStockOnDockShippingUnit: boolean;
        isStockOnDockOperation: boolean;
        isStockOnDockValidation: boolean;
        interSiteDeliveryNotePrinting: GenericPrintReport;
        log: string;
        isDefaultReceiptMode: boolean;
        isDefaultPickingMode: boolean;
        isUnavailablePendingInput: boolean;
        isUnavailableReorderInProcess: boolean;
        seiDepositor: string;
        addresses: ClientCollection<DepositorAddresses>;
        crossDockingPriorities: ClientCollection<DepositorCrossDockingPriorities>;
        names: ClientCollection<DepositorNames>;
        pickingPivotPriorities: ClientCollection<DepositorPickingPivotPriorities>;
    }
    export interface DepositorInput extends ClientNodeInput {
        site?: string;
        code?: string;
        shortDescription?: string;
        postalCode?: string;
        city?: string;
        region?: string;
        country?: string;
        countryName?: string;
        phone?: string;
        fax?: string;
        siteTaxIdNumber?: string;
        email?: string;
        registeredCapital?: string;
        rcs?: string;
        isSupportNumber?: boolean | string;
        isLotNumber?: boolean | string;
        storingListValidation?: ValidationType;
        isControlInputFlow?: boolean | string;
        isPutAlwayLabel?: boolean | string;
        isStoringList?: boolean | string;
        isSingleInputStoringList?: boolean | string;
        isSingleStoreStoringList?: boolean | string;
        printSequenceOfStoringList?: PrintingSequence;
        isStoringListControlCode?: boolean | string;
        isStoringListOperatorCode?: boolean | string;
        uniqueInputReference?: UniqueReference;
        quantityControlInInput?: QuantityControlInputLine;
        isOutputOnPendingInput?: boolean | string;
        isSplitReplenishmentObjects?: boolean | string;
        isReplenishmentBalanceReaddressing?: boolean | string;
        isControlOutputFlow?: boolean | string;
        isOutputShortageManagement?: boolean | string;
        isPartialsByProduct?: boolean | string;
        isShortageByDeliveryOrder?: boolean | string;
        isPreparationLoad?: boolean | string;
        replenishmentValidation?: ValidationType;
        isReplenishList?: boolean | string;
        isReplenishLabel?: boolean | string;
        isPreparationOrderOperatorCode?: boolean | string;
        isDeclarativePackingOperatorCode?: boolean | string;
        isPrepackingOperatorCode?: boolean | string;
        isPickOperatorCode?: boolean | string;
        isSuOperatorCode?: boolean | string;
        isRoOperatorCode?: boolean | string;
        uniqueOutputReference?: UniqueReference;
        isOrderManagement?: boolean | string;
        isGenericRoundManagement?: boolean | string;
        isSingleParcelItem?: boolean | string;
        isStrictSequentiality?: boolean | string;
        shippingUnitTypeShippingAsIs?: string;
        isShippingUnitClosingAuthorization?: boolean | string;
        isShipmentManagement?: boolean | string;
        parcelRange?: string;
        keyInRealParcelWeight?: KyInInformation;
        enterShippingUnitInfo?: SuInformationEntry;
        isParcelPalletisation?: boolean | string;
        isControlLoadingParcel?: boolean | string;
        parcelTypeDispatchableInState?: string;
        parcelRangeDispatchableInState?: string;
        printDeliveryNotes?: string;
        isPrintMergingOfFlowsTransferReport?: boolean | string;
        isPrintMergingOfFlowsTransferLabel?: boolean | string;
        isPrintParcelLabels?: boolean | string;
        isShippingUnitLabels?: boolean | string;
        isPalletizationOrderLabels?: boolean | string;
        isGroupedsLabels?: boolean | string;
        isControlCodeOfPick?: boolean | string;
        isControlCodeOfDeposit?: boolean | string;
        isControlCodeOfOutput?: boolean | string;
        addressingPriority?: MergingOfFlowsPriority;
        transferMergingOfFlowsValidation?: ValidationType;
        isGroupMergingOfFlows?: boolean | string;
        isParcelVolumeManagement?: boolean | string;
        launchingMergingOfFlowsStep2?: ValidationType;
        isPrintTemporaryDeliveryNotes?: boolean | string;
        deliveryOrderStatusForDeliveryNotes?: DoHeaderStatus;
        isPrintFinalDeliveryNotes?: boolean | string;
        isPrintDifferentialDeliveryNotes?: boolean | string;
        isMovementInSuperiorContainer?: boolean | string;
        isSingleDeliveryOrderShippingUnit?: boolean | string;
        isSingleConsigneeShippingUnit?: boolean | string;
        isAutoPalettizeBigParcels?: boolean | string;
        shippingUnitType?: string;
        autoTransferMovementAdjustementCode?: string;
        auto2PhaseTransferMovementAdjustementCode?: string;
        waveReplenishment?: string;
        balanceMovementCode?: string;
        mergingOfFlowsTransfer?: string;
        transferOfComponent?: string;
        kitTransfer?: string;
        isInitializeCarrierAndTransportMode?: boolean | string;
        adjustmentAfterStockCount?: string;
        isStockAvailable?: boolean | string;
        isPickingStock?: boolean | string;
        isTransferOfIncomplete?: boolean | string;
        uniqueReference?: UniqueReference;
        componentTransferValidation?: ValidationType;
        kitTransferValidation?: ValidationType;
        isShortagePerItem?: boolean | string;
        isShortagePerPreparationOrder?: boolean | string;
        isKitOperatorCode?: boolean | string;
        isComponentOperatorCode?: boolean | string;
        analysisKitMovementCode?: string;
        analysisComponentMovementCode?: string;
        isComponentTransferList?: boolean | string;
        isComponentTransferLabel?: boolean | string;
        isSinglePreparationAreaKitRemoval?: boolean | string;
        isSinglePreparationAreaKitRelocation?: boolean | string;
        isSplittingKit?: boolean | string;
        maximumPrepaprationAreaKit?: string;
        customerControl?: CustomerEnum;
        isInputsConfigurationFlag?: boolean | string;
        isOutputsConfigurationFlag?: boolean | string;
        isStocksConfigurationFlag?: boolean | string;
        isPickReplenishOrderMonoPreparationArea?: boolean | string;
        isDepositorReplenishOrderMonoPreparationArea?: boolean | string;
        isPickMergingOfFlowsMonoPreparationArea?: boolean | string;
        isDepositorMergingOfFlowsMonoPreparationArea?: boolean | string;
        isMergingOfflowsDivision?: boolean | string;
        mergingOfFlowsPreparationAreaMax?: string;
        refuseStockNature?: string;
        consumedStockNature?: string;
        isAutomaticAddressing?: boolean | string;
        isQualityOperatorCode?: boolean | string;
        isValidationAnalysisRequestOperatorCode?: boolean | string;
        autoAnalysisRequestAdjustementMovementCode?: string;
        autoAnalysisRequestTransfertMovementCode?: string;
        isAutoPrintQualityRecord?: boolean | string;
        sequenceCode?: string;
        isChainingStore?: boolean | string;
        isChainingRotationClasse?: boolean | string;
        isChainingAssignmentClasses?: boolean | string;
        isCrossDockingManagement?: boolean | string;
        crossDockingLevel?: CrossDockingBlockingLevel;
        isCrossDockingStoreStock?: boolean | string;
        isCrossDockingStoreStockNotAvailable?: boolean | string;
        isReserveStockNotAvailable?: boolean | string;
        isDirectInputMovementNotAddressed?: boolean | string;
        isExpectedInputUnderReceipt?: boolean | string;
        isAlwaysExpressRequirement?: boolean | string;
        isWaveInitialization?: boolean | string;
        ssccExtensionCharacter?: string;
        eanUccCode?: string;
        isSsccParcelOnOutput?: boolean | string;
        isSsccShippingUnitOnOutput?: boolean | string;
        isStockOnDockParcels?: boolean | string;
        isStockOnDockShippingUnit?: boolean | string;
        isStockOnDockOperation?: boolean | string;
        isStockOnDockValidation?: boolean | string;
        interSiteDeliveryNotePrinting?: string;
        log?: string;
        isDefaultReceiptMode?: boolean | string;
        isDefaultPickingMode?: boolean | string;
        isUnavailablePendingInput?: boolean | string;
        isUnavailableReorderInProcess?: boolean | string;
        seiDepositor?: string;
        addresses?: Partial<DepositorAddressesInput>[];
        crossDockingPriorities?: Partial<DepositorCrossDockingPrioritiesInput>[];
        names?: Partial<DepositorNamesInput>[];
        pickingPivotPriorities?: Partial<DepositorPickingPivotPrioritiesInput>[];
    }
    export interface DepositorBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        shortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        phone: string;
        fax: string;
        siteTaxIdNumber: string;
        email: string;
        registeredCapital: string;
        rcs: string;
        isSupportNumber: boolean;
        isLotNumber: boolean;
        storingListValidation: ValidationType;
        isControlInputFlow: boolean;
        isPutAlwayLabel: boolean;
        isStoringList: boolean;
        isSingleInputStoringList: boolean;
        isSingleStoreStoringList: boolean;
        printSequenceOfStoringList: PrintingSequence;
        isStoringListControlCode: boolean;
        isStoringListOperatorCode: boolean;
        uniqueInputReference: UniqueReference;
        quantityControlInInput: QuantityControlInputLine;
        isOutputOnPendingInput: boolean;
        isSplitReplenishmentObjects: boolean;
        isReplenishmentBalanceReaddressing: boolean;
        isControlOutputFlow: boolean;
        isOutputShortageManagement: boolean;
        isPartialsByProduct: boolean;
        isShortageByDeliveryOrder: boolean;
        isPreparationLoad: boolean;
        replenishmentValidation: ValidationType;
        isReplenishList: boolean;
        isReplenishLabel: boolean;
        isPreparationOrderOperatorCode: boolean;
        isDeclarativePackingOperatorCode: boolean;
        isPrepackingOperatorCode: boolean;
        isPickOperatorCode: boolean;
        isSuOperatorCode: boolean;
        isRoOperatorCode: boolean;
        uniqueOutputReference: UniqueReference;
        isOrderManagement: boolean;
        isGenericRoundManagement: boolean;
        isSingleParcelItem: boolean;
        isStrictSequentiality: boolean;
        shippingUnitTypeShippingAsIs: ShippingUnitType;
        isShippingUnitClosingAuthorization: boolean;
        isShipmentManagement: boolean;
        parcelRange: RangeOfParcel;
        keyInRealParcelWeight: KyInInformation;
        enterShippingUnitInfo: SuInformationEntry;
        isParcelPalletisation: boolean;
        isControlLoadingParcel: boolean;
        parcelTypeDispatchableInState: ParcelType;
        parcelRangeDispatchableInState: RangeOfParcel;
        printDeliveryNotes: GenericPrintReport;
        isPrintMergingOfFlowsTransferReport: boolean;
        isPrintMergingOfFlowsTransferLabel: boolean;
        isPrintParcelLabels: boolean;
        isShippingUnitLabels: boolean;
        isPalletizationOrderLabels: boolean;
        isGroupedsLabels: boolean;
        isControlCodeOfPick: boolean;
        isControlCodeOfDeposit: boolean;
        isControlCodeOfOutput: boolean;
        addressingPriority: MergingOfFlowsPriority;
        transferMergingOfFlowsValidation: ValidationType;
        isGroupMergingOfFlows: boolean;
        isParcelVolumeManagement: boolean;
        launchingMergingOfFlowsStep2: ValidationType;
        isPrintTemporaryDeliveryNotes: boolean;
        deliveryOrderStatusForDeliveryNotes: DoHeaderStatus;
        isPrintFinalDeliveryNotes: boolean;
        isPrintDifferentialDeliveryNotes: boolean;
        isMovementInSuperiorContainer: boolean;
        isSingleDeliveryOrderShippingUnit: boolean;
        isSingleConsigneeShippingUnit: boolean;
        isAutoPalettizeBigParcels: boolean;
        shippingUnitType: ShippingUnitType;
        autoTransferMovementAdjustementCode: MovementCode;
        auto2PhaseTransferMovementAdjustementCode: MovementCode;
        waveReplenishment: MovementCode;
        balanceMovementCode: MovementCode;
        mergingOfFlowsTransfer: MovementCode;
        transferOfComponent: MovementCode;
        kitTransfer: MovementCode;
        isInitializeCarrierAndTransportMode: boolean;
        adjustmentAfterStockCount: MovementCode;
        isStockAvailable: boolean;
        isPickingStock: boolean;
        isTransferOfIncomplete: boolean;
        uniqueReference: UniqueReference;
        componentTransferValidation: ValidationType;
        kitTransferValidation: ValidationType;
        isShortagePerItem: boolean;
        isShortagePerPreparationOrder: boolean;
        isKitOperatorCode: boolean;
        isComponentOperatorCode: boolean;
        analysisKitMovementCode: MovementCode;
        analysisComponentMovementCode: MovementCode;
        isComponentTransferList: boolean;
        isComponentTransferLabel: boolean;
        isSinglePreparationAreaKitRemoval: boolean;
        isSinglePreparationAreaKitRelocation: boolean;
        isSplittingKit: boolean;
        maximumPrepaprationAreaKit: PreparationArea;
        customerControl: CustomerEnum;
        isInputsConfigurationFlag: boolean;
        isOutputsConfigurationFlag: boolean;
        isStocksConfigurationFlag: boolean;
        isPickReplenishOrderMonoPreparationArea: boolean;
        isDepositorReplenishOrderMonoPreparationArea: boolean;
        isPickMergingOfFlowsMonoPreparationArea: boolean;
        isDepositorMergingOfFlowsMonoPreparationArea: boolean;
        isMergingOfflowsDivision: boolean;
        mergingOfFlowsPreparationAreaMax: PreparationArea;
        refuseStockNature: StockNature;
        consumedStockNature: StockNature;
        isAutomaticAddressing: boolean;
        isQualityOperatorCode: boolean;
        isValidationAnalysisRequestOperatorCode: boolean;
        autoAnalysisRequestAdjustementMovementCode: MovementCode;
        autoAnalysisRequestTransfertMovementCode: MovementCode;
        isAutoPrintQualityRecord: boolean;
        sequenceCode: StoreChaining;
        isChainingStore: boolean;
        isChainingRotationClasse: boolean;
        isChainingAssignmentClasses: boolean;
        isCrossDockingManagement: boolean;
        crossDockingLevel: CrossDockingBlockingLevel;
        isCrossDockingStoreStock: boolean;
        isCrossDockingStoreStockNotAvailable: boolean;
        isReserveStockNotAvailable: boolean;
        isDirectInputMovementNotAddressed: boolean;
        isExpectedInputUnderReceipt: boolean;
        isAlwaysExpressRequirement: boolean;
        isWaveInitialization: boolean;
        ssccExtensionCharacter: string;
        eanUccCode: string;
        isSsccParcelOnOutput: boolean;
        isSsccShippingUnitOnOutput: boolean;
        isStockOnDockParcels: boolean;
        isStockOnDockShippingUnit: boolean;
        isStockOnDockOperation: boolean;
        isStockOnDockValidation: boolean;
        interSiteDeliveryNotePrinting: GenericPrintReport;
        log: string;
        isDefaultReceiptMode: boolean;
        isDefaultPickingMode: boolean;
        isUnavailablePendingInput: boolean;
        isUnavailableReorderInProcess: boolean;
        seiDepositor: string;
        addresses: ClientCollection<DepositorAddressesBinding>;
        crossDockingPriorities: ClientCollection<DepositorCrossDockingPrioritiesBinding>;
        names: ClientCollection<DepositorNamesBinding>;
        pickingPivotPriorities: ClientCollection<DepositorPickingPivotPrioritiesBinding>;
    }
    export interface Depositor$Lookups {
        site: QueryOperation<Site>;
        country: QueryOperation<Country>;
        shippingUnitTypeShippingAsIs: QueryOperation<ShippingUnitType>;
        parcelRange: QueryOperation<RangeOfParcel>;
        parcelTypeDispatchableInState: QueryOperation<ParcelType>;
        parcelRangeDispatchableInState: QueryOperation<RangeOfParcel>;
        printDeliveryNotes: QueryOperation<GenericPrintReport>;
        shippingUnitType: QueryOperation<ShippingUnitType>;
        autoTransferMovementAdjustementCode: QueryOperation<MovementCode>;
        auto2PhaseTransferMovementAdjustementCode: QueryOperation<MovementCode>;
        waveReplenishment: QueryOperation<MovementCode>;
        balanceMovementCode: QueryOperation<MovementCode>;
        mergingOfFlowsTransfer: QueryOperation<MovementCode>;
        transferOfComponent: QueryOperation<MovementCode>;
        kitTransfer: QueryOperation<MovementCode>;
        adjustmentAfterStockCount: QueryOperation<MovementCode>;
        analysisKitMovementCode: QueryOperation<MovementCode>;
        analysisComponentMovementCode: QueryOperation<MovementCode>;
        maximumPrepaprationAreaKit: QueryOperation<PreparationArea>;
        mergingOfFlowsPreparationAreaMax: QueryOperation<PreparationArea>;
        refuseStockNature: QueryOperation<StockNature>;
        consumedStockNature: QueryOperation<StockNature>;
        autoAnalysisRequestAdjustementMovementCode: QueryOperation<MovementCode>;
        autoAnalysisRequestTransfertMovementCode: QueryOperation<MovementCode>;
        sequenceCode: QueryOperation<StoreChaining>;
        interSiteDeliveryNotePrinting: QueryOperation<GenericPrintReport>;
    }
    export interface Depositor$Operations {
        query: QueryOperation<Depositor>;
        read: ReadOperation<Depositor>;
        aggregate: {
            read: AggregateReadOperation<Depositor>;
            query: AggregateQueryOperation<Depositor>;
        };
        lookups(dataOrId: string | { data: DepositorInput }): Depositor$Lookups;
        getDefaults: GetDefaultsOperation<Depositor>;
    }
    export interface GenericRoundTimeLimitPerDays extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        timeLimitPerDay: string;
    }
    export interface GenericRoundTimeLimitPerDaysInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        timeLimitPerDay?: string;
    }
    export interface GenericRoundTimeLimitPerDaysBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        timeLimitPerDay: string;
    }
    export interface GenericRoundTimeLimitPerDays$Operations {
        query: QueryOperation<GenericRoundTimeLimitPerDays>;
        read: ReadOperation<GenericRoundTimeLimitPerDays>;
        aggregate: {
            read: AggregateReadOperation<GenericRoundTimeLimitPerDays>;
            query: AggregateQueryOperation<GenericRoundTimeLimitPerDays>;
        };
        getDefaults: GetDefaultsOperation<GenericRoundTimeLimitPerDays>;
    }
    export interface GenericRound extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        carrier: Carrier;
        transportationMethod: TransportMode;
        store: Store;
        dock: Location;
        duration: string;
        maximumWeight: string;
        maximumVolume: string;
        maximumLinearMeters: string;
        transportType: TransportType;
        shipToCustomer: Customer;
        pickingLeadTime: string;
        isInterSiteRoundManagement: boolean;
        destinationSite: Site;
        isActive: boolean;
        timeLimitPerDays: ClientCollection<GenericRoundTimeLimitPerDays>;
    }
    export interface GenericRoundInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        carrier?: string;
        transportationMethod?: string;
        store?: string;
        dock?: string;
        duration?: string;
        maximumWeight?: decimal | string;
        maximumVolume?: decimal | string;
        maximumLinearMeters?: decimal | string;
        transportType?: string;
        shipToCustomer?: string;
        pickingLeadTime?: string;
        isInterSiteRoundManagement?: boolean | string;
        destinationSite?: string;
        isActive?: boolean | string;
        timeLimitPerDays?: Partial<GenericRoundTimeLimitPerDaysInput>[];
    }
    export interface GenericRoundBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        carrier: Carrier;
        transportationMethod: TransportMode;
        store: Store;
        dock: Location;
        duration: string;
        maximumWeight: string;
        maximumVolume: string;
        maximumLinearMeters: string;
        transportType: TransportType;
        shipToCustomer: Customer;
        pickingLeadTime: string;
        isInterSiteRoundManagement: boolean;
        destinationSite: Site;
        isActive: boolean;
        timeLimitPerDays: ClientCollection<GenericRoundTimeLimitPerDaysBinding>;
    }
    export interface GenericRound$Lookups {
        site: QueryOperation<Site>;
        carrier: QueryOperation<Carrier>;
        transportationMethod: QueryOperation<TransportMode>;
        store: QueryOperation<Store>;
        dock: QueryOperation<Location>;
        transportType: QueryOperation<TransportType>;
        shipToCustomer: QueryOperation<Customer>;
        destinationSite: QueryOperation<Site>;
    }
    export interface GenericRound$Operations {
        query: QueryOperation<GenericRound>;
        read: ReadOperation<GenericRound>;
        aggregate: {
            read: AggregateReadOperation<GenericRound>;
            query: AggregateQueryOperation<GenericRound>;
        };
        lookups(dataOrId: string | { data: GenericRoundInput }): GenericRound$Lookups;
        getDefaults: GetDefaultsOperation<GenericRound>;
    }
    export interface GenericWave extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        priority: integer;
        criteria: string;
        workCenter: WorkCenter;
        unitOfMeasure: UnitOfMeasure;
        maximumLoadLimit: string;
        isAdditionAuthorized: boolean;
        isSingleDeliveryOrderWave: boolean;
        isMergingOfFlows: boolean;
        isAutomaticRelease: boolean;
        isMissionToBlock: boolean;
        missionPriority: integer;
        siteDepositorIdentifier: string;
    }
    export interface GenericWaveInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isActive?: boolean | string;
        priority?: integer | string;
        criteria?: string;
        workCenter?: string;
        unitOfMeasure?: string;
        maximumLoadLimit?: decimal | string;
        isAdditionAuthorized?: boolean | string;
        isSingleDeliveryOrderWave?: boolean | string;
        isMergingOfFlows?: boolean | string;
        isAutomaticRelease?: boolean | string;
        isMissionToBlock?: boolean | string;
        missionPriority?: integer | string;
        siteDepositorIdentifier?: string;
    }
    export interface GenericWaveBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        priority: integer;
        criteria: string;
        workCenter: WorkCenter;
        unitOfMeasure: UnitOfMeasure;
        maximumLoadLimit: string;
        isAdditionAuthorized: boolean;
        isSingleDeliveryOrderWave: boolean;
        isMergingOfFlows: boolean;
        isAutomaticRelease: boolean;
        isMissionToBlock: boolean;
        missionPriority: integer;
        siteDepositorIdentifier: string;
    }
    export interface GenericWave$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        workCenter: QueryOperation<WorkCenter>;
        unitOfMeasure: QueryOperation<UnitOfMeasure>;
    }
    export interface GenericWave$Operations {
        query: QueryOperation<GenericWave>;
        read: ReadOperation<GenericWave>;
        aggregate: {
            read: AggregateReadOperation<GenericWave>;
            query: AggregateQueryOperation<GenericWave>;
        };
        lookups(dataOrId: string | { data: GenericWaveInput }): GenericWave$Lookups;
        getDefaults: GetDefaultsOperation<GenericWave>;
    }
    export interface LocationSplitAddresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        store: string;
        code: string;
        splitAddress: string;
    }
    export interface LocationSplitAddressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        store?: string;
        code?: string;
        splitAddress?: string;
    }
    export interface LocationSplitAddressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        store: string;
        code: string;
        splitAddress: string;
    }
    export interface LocationSplitAddresses$Operations {
        query: QueryOperation<LocationSplitAddresses>;
        read: ReadOperation<LocationSplitAddresses>;
        aggregate: {
            read: AggregateReadOperation<LocationSplitAddresses>;
            query: AggregateQueryOperation<LocationSplitAddresses>;
        };
        getDefaults: GetDefaultsOperation<LocationSplitAddresses>;
    }
    export interface Location extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddresses>;
    }
    export interface LocationInput extends ClientNodeInput {
        site?: string;
        store?: string;
        code?: string;
        storageType?: string;
        storage?: string;
        storeType?: StoreType;
        locationType?: LocationType;
        dockType?: DockType;
        depositor?: string;
        lotNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        numberOfConsumptionUnitPerContainer?: decimal | string;
        rotationClass?: string;
        assignmentClass?: string;
        prohibitedClass?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        maxVolume?: decimal | string;
        maxWeightAuthorized?: decimal | string;
        maxMeters?: decimal | string;
        maximumLoad?: decimal | string;
        dockHeight?: decimal | string;
        storingTime?: decimal | string;
        unStockingTime?: decimal | string;
        presentContainerMaximumQuantity?: decimal | string;
        referenceContainerLevel?: integer | string;
        maximumQuantityInReferenceContainer?: decimal | string;
        quantityInStock?: decimal | string;
        lastStockCount?: string;
        lastReceipt?: string;
        firstArrival?: string;
        fifoDate?: string;
        quantityInPendingInput?: decimal | string;
        quantityInPendingOutput?: decimal | string;
        quantityInPendingReplenish?: decimal | string;
        isBlockedInInput?: boolean | string;
        isBlockedInOutput?: boolean | string;
        isBlockedInInput2?: boolean | string;
        isBlockedInOutput2?: boolean | string;
        isAutoAddressing?: boolean | string;
        isKeyInControlCode?: boolean | string;
        controlCode?: string;
        reorderPoint?: decimal | string;
        replenishmentType?: LocationType;
        replenishmentLevel?: ContainerLevel;
        percentageOccupied?: integer | string;
        parity?: Parity;
        isTemporaryPicking?: boolean | string;
        isPickingPivot?: boolean | string;
        wavePivot?: string;
        pickingPriority?: integer | string;
        isUsed?: boolean | string;
        controlDimension?: ControlOfDimensions;
        isActive?: boolean | string;
        isDockLeveler?: boolean | string;
        completeObjectsAddressingThreshold?: decimal | string;
        splitAddresses?: Partial<LocationSplitAddressesInput>[];
    }
    export interface LocationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddressesBinding>;
    }
    export interface Location$Lookups {
        site: QueryOperation<Site>;
        store: QueryOperation<Store>;
        storage: QueryOperation<StorageType>;
        depositor: QueryOperation<Depositor>;
        stockStatus: QueryOperation<StockNature>;
        rotationClass: QueryOperation<RotationClass>;
        assignmentClass: QueryOperation<AssignmentClass>;
        prohibitedClass: QueryOperation<AssignmentClass>;
    }
    export interface Location$Operations {
        query: QueryOperation<Location>;
        read: ReadOperation<Location>;
        aggregate: {
            read: AggregateReadOperation<Location>;
            query: AggregateQueryOperation<Location>;
        };
        lookups(dataOrId: string | { data: LocationInput }): Location$Lookups;
        getDefaults: GetDefaultsOperation<Location>;
    }
    export interface MovementCode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        adjustmentMovementType: AdjustmentType;
        processingFamily: ProcessingFamily;
        consumableMovementType: ConsumableMvtType;
        isTransmittedFromL3: boolean;
        isActive: boolean;
    }
    export interface MovementCodeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        adjustmentMovementType?: AdjustmentType;
        processingFamily?: ProcessingFamily;
        consumableMovementType?: ConsumableMvtType;
        isTransmittedFromL3?: boolean | string;
        isActive?: boolean | string;
    }
    export interface MovementCodeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        adjustmentMovementType: AdjustmentType;
        processingFamily: ProcessingFamily;
        consumableMovementType: ConsumableMvtType;
        isTransmittedFromL3: boolean;
        isActive: boolean;
    }
    export interface MovementCode$Lookups {
        site: QueryOperation<Site>;
    }
    export interface MovementCode$Operations {
        query: QueryOperation<MovementCode>;
        read: ReadOperation<MovementCode>;
        aggregate: {
            read: AggregateReadOperation<MovementCode>;
            query: AggregateQueryOperation<MovementCode>;
        };
        lookups(dataOrId: string | { data: MovementCodeInput }): MovementCode$Lookups;
        getDefaults: GetDefaultsOperation<MovementCode>;
    }
    export interface Operand extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        operatorName: string;
        isReceiptAuthorized: boolean;
        isPreventiveStockCountAuthorized: boolean;
        isPutawayAuthorized: boolean;
        isReorderAuthorized: boolean;
        isTransferAuthorized: boolean;
        isPickingAuthorized: boolean;
        isPrepackingAuthorized: boolean;
        isDeclaredPackingAuthorized: boolean;
        isManualAdjustmentAuthorized: boolean;
        isCarrierEdiAuthorized: boolean;
        isAssemblyAuthorized: boolean;
        isDisassemblyAuthorized: boolean;
        isQualityControlAuthorized: boolean;
        isAnalysisRequestAuthorized: boolean;
        isConsumableInputAuthorized: boolean;
        isConsumableOuputAuthorized: boolean;
        isStockOnDockAuthorized: boolean;
        isForcedDeliveryOrderShippingAuthorized: boolean;
        isPrepalletizationAuthorized: boolean;
        isAutoPalletisationAuthorized: boolean;
        isRepackingAuthorized: boolean;
        isSimplifiedStockCountAuthorized: boolean;
    }
    export interface OperandInput extends ClientNodeInput {
        site?: string;
        code?: string;
        operatorName?: string;
        isReceiptAuthorized?: boolean | string;
        isPreventiveStockCountAuthorized?: boolean | string;
        isPutawayAuthorized?: boolean | string;
        isReorderAuthorized?: boolean | string;
        isTransferAuthorized?: boolean | string;
        isPickingAuthorized?: boolean | string;
        isPrepackingAuthorized?: boolean | string;
        isDeclaredPackingAuthorized?: boolean | string;
        isManualAdjustmentAuthorized?: boolean | string;
        isCarrierEdiAuthorized?: boolean | string;
        isAssemblyAuthorized?: boolean | string;
        isDisassemblyAuthorized?: boolean | string;
        isQualityControlAuthorized?: boolean | string;
        isAnalysisRequestAuthorized?: boolean | string;
        isConsumableInputAuthorized?: boolean | string;
        isConsumableOuputAuthorized?: boolean | string;
        isStockOnDockAuthorized?: boolean | string;
        isForcedDeliveryOrderShippingAuthorized?: boolean | string;
        isPrepalletizationAuthorized?: boolean | string;
        isAutoPalletisationAuthorized?: boolean | string;
        isRepackingAuthorized?: boolean | string;
        isSimplifiedStockCountAuthorized?: boolean | string;
    }
    export interface OperandBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        operatorName: string;
        isReceiptAuthorized: boolean;
        isPreventiveStockCountAuthorized: boolean;
        isPutawayAuthorized: boolean;
        isReorderAuthorized: boolean;
        isTransferAuthorized: boolean;
        isPickingAuthorized: boolean;
        isPrepackingAuthorized: boolean;
        isDeclaredPackingAuthorized: boolean;
        isManualAdjustmentAuthorized: boolean;
        isCarrierEdiAuthorized: boolean;
        isAssemblyAuthorized: boolean;
        isDisassemblyAuthorized: boolean;
        isQualityControlAuthorized: boolean;
        isAnalysisRequestAuthorized: boolean;
        isConsumableInputAuthorized: boolean;
        isConsumableOuputAuthorized: boolean;
        isStockOnDockAuthorized: boolean;
        isForcedDeliveryOrderShippingAuthorized: boolean;
        isPrepalletizationAuthorized: boolean;
        isAutoPalletisationAuthorized: boolean;
        isRepackingAuthorized: boolean;
        isSimplifiedStockCountAuthorized: boolean;
    }
    export interface Operand$Lookups {
        site: QueryOperation<Site>;
    }
    export interface Operand$Operations {
        query: QueryOperation<Operand>;
        read: ReadOperation<Operand>;
        aggregate: {
            read: AggregateReadOperation<Operand>;
            query: AggregateQueryOperation<Operand>;
        };
        lookups(dataOrId: string | { data: OperandInput }): Operand$Lookups;
        getDefaults: GetDefaultsOperation<Operand>;
    }
    export interface ParcelType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        parcelRange: RangeOfParcel;
        code: string;
        siteDepositorIdentifier: string;
        localizedDescription: string;
        localizedShortDescription: string;
        height: string;
        width: string;
        depth: string;
        volume: string;
        usefulVolume: string;
        isBigParcel: boolean;
        isActive: boolean;
        surfaceEquivalent: integer;
        maximumWeight: string;
        minimumLimitPercentagePerBigParcel: integer;
        parcelTare: string;
        tareTolerancePercentage: integer;
        shippingUnitGroup: string;
        shippinUnitType: ShippingUnitType;
        isPalettizableAsIs: boolean;
        shippingUnitTypeShippedAsIs: ShippingUnitType;
    }
    export interface ParcelTypeInput extends ClientNodeInput {
        site?: string;
        parcelRange?: string;
        code?: string;
        siteDepositorIdentifier?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        usefulVolume?: decimal | string;
        isBigParcel?: boolean | string;
        isActive?: boolean | string;
        surfaceEquivalent?: integer | string;
        maximumWeight?: decimal | string;
        minimumLimitPercentagePerBigParcel?: integer | string;
        parcelTare?: decimal | string;
        tareTolerancePercentage?: integer | string;
        shippingUnitGroup?: string;
        shippinUnitType?: string;
        isPalettizableAsIs?: boolean | string;
        shippingUnitTypeShippedAsIs?: string;
    }
    export interface ParcelTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        parcelRange: RangeOfParcel;
        code: string;
        siteDepositorIdentifier: string;
        localizedDescription: string;
        localizedShortDescription: string;
        height: string;
        width: string;
        depth: string;
        volume: string;
        usefulVolume: string;
        isBigParcel: boolean;
        isActive: boolean;
        surfaceEquivalent: integer;
        maximumWeight: string;
        minimumLimitPercentagePerBigParcel: integer;
        parcelTare: string;
        tareTolerancePercentage: integer;
        shippingUnitGroup: string;
        shippinUnitType: ShippingUnitType;
        isPalettizableAsIs: boolean;
        shippingUnitTypeShippedAsIs: ShippingUnitType;
    }
    export interface ParcelType$Lookups {
        site: QueryOperation<Site>;
        parcelRange: QueryOperation<RangeOfParcel>;
        shippinUnitType: QueryOperation<ShippingUnitType>;
        shippingUnitTypeShippedAsIs: QueryOperation<ShippingUnitType>;
    }
    export interface ParcelType$Operations {
        query: QueryOperation<ParcelType>;
        read: ReadOperation<ParcelType>;
        aggregate: {
            read: AggregateReadOperation<ParcelType>;
            query: AggregateQueryOperation<ParcelType>;
        };
        lookups(dataOrId: string | { data: ParcelTypeInput }): ParcelType$Lookups;
        getDefaults: GetDefaultsOperation<ParcelType>;
    }
    export interface PreparationAreaParametersForPreparationOrder extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        parameterForPickingPreparationOrder: string;
        parameterForReservePreparationOrder: string;
        parameterForMixedPreparationOrder: string;
    }
    export interface PreparationAreaParametersForPreparationOrderInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        parameterForPickingPreparationOrder?: decimal | string;
        parameterForReservePreparationOrder?: decimal | string;
        parameterForMixedPreparationOrder?: decimal | string;
    }
    export interface PreparationAreaParametersForPreparationOrderBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        parameterForPickingPreparationOrder: string;
        parameterForReservePreparationOrder: string;
        parameterForMixedPreparationOrder: string;
    }
    export interface PreparationAreaParametersForPreparationOrder$Operations {
        query: QueryOperation<PreparationAreaParametersForPreparationOrder>;
        read: ReadOperation<PreparationAreaParametersForPreparationOrder>;
        aggregate: {
            read: AggregateReadOperation<PreparationAreaParametersForPreparationOrder>;
            query: AggregateQueryOperation<PreparationAreaParametersForPreparationOrder>;
        };
        getDefaults: GetDefaultsOperation<PreparationAreaParametersForPreparationOrder>;
    }
    export interface PreparationArea extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        preparationOrderPrint: GenericPrintReport;
        generalPrinter: Destination;
        labelPrinter1: Destination;
        labelPrinter2: Destination;
        isBigParcelAuthorized: boolean;
        maximumNumberOfParcels: integer;
        maximumWeight: string;
        maximumVolume: string;
        maximumSurfaceEquivalent: integer;
        isTransmittedToL1: boolean;
        maximumShippingUnit: integer;
        maximumWeightForPrepalletizationOrder: string;
        maximumVolumeForPrepalletizationOrder: string;
        maximumSurfaceEquivalentForPrepalletizationOrder: integer;
        parametersForPreparationOrder: ClientCollection<PreparationAreaParametersForPreparationOrder>;
    }
    export interface PreparationAreaInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        preparationOrderPrint?: string;
        generalPrinter?: string;
        labelPrinter1?: string;
        labelPrinter2?: string;
        isBigParcelAuthorized?: boolean | string;
        maximumNumberOfParcels?: integer | string;
        maximumWeight?: decimal | string;
        maximumVolume?: decimal | string;
        maximumSurfaceEquivalent?: integer | string;
        isTransmittedToL1?: boolean | string;
        maximumShippingUnit?: integer | string;
        maximumWeightForPrepalletizationOrder?: decimal | string;
        maximumVolumeForPrepalletizationOrder?: decimal | string;
        maximumSurfaceEquivalentForPrepalletizationOrder?: integer | string;
        parametersForPreparationOrder?: Partial<PreparationAreaParametersForPreparationOrderInput>[];
    }
    export interface PreparationAreaBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        preparationOrderPrint: GenericPrintReport;
        generalPrinter: Destination;
        labelPrinter1: Destination;
        labelPrinter2: Destination;
        isBigParcelAuthorized: boolean;
        maximumNumberOfParcels: integer;
        maximumWeight: string;
        maximumVolume: string;
        maximumSurfaceEquivalent: integer;
        isTransmittedToL1: boolean;
        maximumShippingUnit: integer;
        maximumWeightForPrepalletizationOrder: string;
        maximumVolumeForPrepalletizationOrder: string;
        maximumSurfaceEquivalentForPrepalletizationOrder: integer;
        parametersForPreparationOrder: ClientCollection<PreparationAreaParametersForPreparationOrderBinding>;
    }
    export interface PreparationArea$Lookups {
        site: QueryOperation<Site>;
        preparationOrderPrint: QueryOperation<GenericPrintReport>;
        generalPrinter: QueryOperation<Destination>;
        labelPrinter1: QueryOperation<Destination>;
        labelPrinter2: QueryOperation<Destination>;
    }
    export interface PreparationArea$Operations {
        query: QueryOperation<PreparationArea>;
        read: ReadOperation<PreparationArea>;
        aggregate: {
            read: AggregateReadOperation<PreparationArea>;
            query: AggregateQueryOperation<PreparationArea>;
        };
        lookups(dataOrId: string | { data: PreparationAreaInput }): PreparationArea$Lookups;
        getDefaults: GetDefaultsOperation<PreparationArea>;
    }
    export interface RangeOfParcel extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface RangeOfParcelInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface RangeOfParcelBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface RangeOfParcel$Lookups {
        site: QueryOperation<Site>;
    }
    export interface RangeOfParcel$Operations {
        query: QueryOperation<RangeOfParcel>;
        read: ReadOperation<RangeOfParcel>;
        aggregate: {
            read: AggregateReadOperation<RangeOfParcel>;
            query: AggregateQueryOperation<RangeOfParcel>;
        };
        lookups(dataOrId: string | { data: RangeOfParcelInput }): RangeOfParcel$Lookups;
        getDefaults: GetDefaultsOperation<RangeOfParcel>;
    }
    export interface RotationClassRotationClassesChaining extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        rotationClassChaining: RotationClass;
    }
    export interface RotationClassRotationClassesChainingInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        rotationClassChaining?: string;
    }
    export interface RotationClassRotationClassesChainingBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        rotationClassChaining: RotationClass;
    }
    export interface RotationClassRotationClassesChaining$Lookups {
        rotationClassChaining: QueryOperation<RotationClass>;
    }
    export interface RotationClassRotationClassesChaining$Operations {
        query: QueryOperation<RotationClassRotationClassesChaining>;
        read: ReadOperation<RotationClassRotationClassesChaining>;
        aggregate: {
            read: AggregateReadOperation<RotationClassRotationClassesChaining>;
            query: AggregateQueryOperation<RotationClassRotationClassesChaining>;
        };
        lookups(
            dataOrId: string | { data: RotationClassRotationClassesChainingInput },
        ): RotationClassRotationClassesChaining$Lookups;
        getDefaults: GetDefaultsOperation<RotationClassRotationClassesChaining>;
    }
    export interface RotationClass extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        maximumRequestPerDay: integer;
        promptRate: integer;
        numberOfChaining: integer;
        isActive: boolean;
        rotationClassesChaining: ClientCollection<RotationClassRotationClassesChaining>;
    }
    export interface RotationClassInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        maximumRequestPerDay?: integer | string;
        promptRate?: integer | string;
        numberOfChaining?: integer | string;
        isActive?: boolean | string;
        rotationClassesChaining?: Partial<RotationClassRotationClassesChainingInput>[];
    }
    export interface RotationClassBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        maximumRequestPerDay: integer;
        promptRate: integer;
        numberOfChaining: integer;
        isActive: boolean;
        rotationClassesChaining: ClientCollection<RotationClassRotationClassesChainingBinding>;
    }
    export interface RotationClass$Lookups {
        site: QueryOperation<Site>;
    }
    export interface RotationClass$Operations {
        query: QueryOperation<RotationClass>;
        read: ReadOperation<RotationClass>;
        aggregate: {
            read: AggregateReadOperation<RotationClass>;
            query: AggregateQueryOperation<RotationClass>;
        };
        lookups(dataOrId: string | { data: RotationClassInput }): RotationClass$Lookups;
        getDefaults: GetDefaultsOperation<RotationClass>;
    }
    export interface SerialGroup extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        parentGroup: SerialGroup;
    }
    export interface SerialGroupInput extends ClientNodeInput {
        site?: string;
        code?: string;
        parentGroup?: string;
    }
    export interface SerialGroupBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        parentGroup: SerialGroup;
    }
    export interface SerialGroup$Lookups {
        site: QueryOperation<Site>;
        parentGroup: QueryOperation<SerialGroup>;
    }
    export interface SerialGroup$Operations {
        query: QueryOperation<SerialGroup>;
        read: ReadOperation<SerialGroup>;
        aggregate: {
            read: AggregateReadOperation<SerialGroup>;
            query: AggregateQueryOperation<SerialGroup>;
        };
        lookups(dataOrId: string | { data: SerialGroupInput }): SerialGroup$Lookups;
        getDefaults: GetDefaultsOperation<SerialGroup>;
    }
    export interface ShippingUnitType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        height: string;
        width: string;
        depth: string;
        volume: string;
        usefulVolume: string;
        surfaceEquivalent: integer;
        isLengthChangeable: boolean;
        isWidthChangeable: boolean;
        isDepthChangeable: boolean;
        weight: string;
        maximumWeight: string;
        isWeightChangeable: boolean;
    }
    export interface ShippingUnitTypeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isActive?: boolean | string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        usefulVolume?: decimal | string;
        surfaceEquivalent?: integer | string;
        isLengthChangeable?: boolean | string;
        isWidthChangeable?: boolean | string;
        isDepthChangeable?: boolean | string;
        weight?: decimal | string;
        maximumWeight?: decimal | string;
        isWeightChangeable?: boolean | string;
    }
    export interface ShippingUnitTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
        height: string;
        width: string;
        depth: string;
        volume: string;
        usefulVolume: string;
        surfaceEquivalent: integer;
        isLengthChangeable: boolean;
        isWidthChangeable: boolean;
        isDepthChangeable: boolean;
        weight: string;
        maximumWeight: string;
        isWeightChangeable: boolean;
    }
    export interface ShippingUnitType$Lookups {
        site: QueryOperation<Site>;
    }
    export interface ShippingUnitType$Operations {
        query: QueryOperation<ShippingUnitType>;
        read: ReadOperation<ShippingUnitType>;
        aggregate: {
            read: AggregateReadOperation<ShippingUnitType>;
            query: AggregateQueryOperation<ShippingUnitType>;
        };
        lookups(dataOrId: string | { data: ShippingUnitTypeInput }): ShippingUnitType$Lookups;
        getDefaults: GetDefaultsOperation<ShippingUnitType>;
    }
    export interface StockCountClass extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfStockCounts: integer;
        minimumDaysBetweenStockCounts: integer;
    }
    export interface StockCountClassInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        numberOfStockCounts?: integer | string;
        minimumDaysBetweenStockCounts?: integer | string;
    }
    export interface StockCountClassBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfStockCounts: integer;
        minimumDaysBetweenStockCounts: integer;
    }
    export interface StockCountClass$Lookups {
        site: QueryOperation<Site>;
    }
    export interface StockCountClass$Operations {
        query: QueryOperation<StockCountClass>;
        read: ReadOperation<StockCountClass>;
        aggregate: {
            read: AggregateReadOperation<StockCountClass>;
            query: AggregateQueryOperation<StockCountClass>;
        };
        lookups(dataOrId: string | { data: StockCountClassInput }): StockCountClass$Lookups;
        getDefaults: GetDefaultsOperation<StockCountClass>;
    }
    export interface StockNature extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        store: Store;
        type: StockNatureType;
        isExclusiveStore: boolean;
    }
    export interface StockNatureInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        store?: string;
        type?: StockNatureType;
        isExclusiveStore?: boolean | string;
    }
    export interface StockNatureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        store: Store;
        type: StockNatureType;
        isExclusiveStore: boolean;
    }
    export interface StockNature$Lookups {
        site: QueryOperation<Site>;
        store: QueryOperation<Store>;
    }
    export interface StockNature$Operations {
        query: QueryOperation<StockNature>;
        read: ReadOperation<StockNature>;
        aggregate: {
            read: AggregateReadOperation<StockNature>;
            query: AggregateQueryOperation<StockNature>;
        };
        lookups(dataOrId: string | { data: StockNatureInput }): StockNature$Lookups;
        getDefaults: GetDefaultsOperation<StockNature>;
    }
    export interface StorageType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        locationType: LocationType;
        isPickingPivot: boolean;
        depositorManagement: Assignment;
        productManagement: Assignment;
        isSingleContainer: boolean;
        isSingleSource: boolean;
        isSingleLot: boolean;
        isSingleReservation: boolean;
        singleDate: MonoFifoDate;
        isSingleStockStatus: boolean;
        isContainerCorrespendence: boolean;
        isInputFifoDateResetToZero: boolean;
        isStrictUnStocking: boolean;
        unStocking: UnstoringType;
        isFifoByLocation: boolean;
        isInputOfOldFifoDateAllowed: boolean;
        isFifoGapControl: boolean;
        fillControl: FillingUpControl;
        isAutomaticAddressingAuthorized: boolean;
        isLabelPrinting: boolean;
        storeType: StoreType;
        isAdressPositionManagement: boolean;
        homogeneousObject: HomogeneousPallet;
        isExceedMaximumCapacityOfPickingLocation: boolean;
        isUndifferentiatedStockObject: boolean;
        isAssemblyAuthorized: boolean;
        isLotSwapping: boolean;
        isAutomaticMovementSplit: boolean;
        isStockObjectAdcGrouping: boolean;
        isFifoDateAdcGrouping: boolean;
        isActive: boolean;
    }
    export interface StorageTypeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        locationType?: LocationType;
        isPickingPivot?: boolean | string;
        depositorManagement?: Assignment;
        productManagement?: Assignment;
        isSingleContainer?: boolean | string;
        isSingleSource?: boolean | string;
        isSingleLot?: boolean | string;
        isSingleReservation?: boolean | string;
        singleDate?: MonoFifoDate;
        isSingleStockStatus?: boolean | string;
        isContainerCorrespendence?: boolean | string;
        isInputFifoDateResetToZero?: boolean | string;
        isStrictUnStocking?: boolean | string;
        unStocking?: UnstoringType;
        isFifoByLocation?: boolean | string;
        isInputOfOldFifoDateAllowed?: boolean | string;
        isFifoGapControl?: boolean | string;
        fillControl?: FillingUpControl;
        isAutomaticAddressingAuthorized?: boolean | string;
        isLabelPrinting?: boolean | string;
        storeType?: StoreType;
        isAdressPositionManagement?: boolean | string;
        homogeneousObject?: HomogeneousPallet;
        isExceedMaximumCapacityOfPickingLocation?: boolean | string;
        isUndifferentiatedStockObject?: boolean | string;
        isAssemblyAuthorized?: boolean | string;
        isLotSwapping?: boolean | string;
        isAutomaticMovementSplit?: boolean | string;
        isStockObjectAdcGrouping?: boolean | string;
        isFifoDateAdcGrouping?: boolean | string;
        isActive?: boolean | string;
    }
    export interface StorageTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        locationType: LocationType;
        isPickingPivot: boolean;
        depositorManagement: Assignment;
        productManagement: Assignment;
        isSingleContainer: boolean;
        isSingleSource: boolean;
        isSingleLot: boolean;
        isSingleReservation: boolean;
        singleDate: MonoFifoDate;
        isSingleStockStatus: boolean;
        isContainerCorrespendence: boolean;
        isInputFifoDateResetToZero: boolean;
        isStrictUnStocking: boolean;
        unStocking: UnstoringType;
        isFifoByLocation: boolean;
        isInputOfOldFifoDateAllowed: boolean;
        isFifoGapControl: boolean;
        fillControl: FillingUpControl;
        isAutomaticAddressingAuthorized: boolean;
        isLabelPrinting: boolean;
        storeType: StoreType;
        isAdressPositionManagement: boolean;
        homogeneousObject: HomogeneousPallet;
        isExceedMaximumCapacityOfPickingLocation: boolean;
        isUndifferentiatedStockObject: boolean;
        isAssemblyAuthorized: boolean;
        isLotSwapping: boolean;
        isAutomaticMovementSplit: boolean;
        isStockObjectAdcGrouping: boolean;
        isFifoDateAdcGrouping: boolean;
        isActive: boolean;
    }
    export interface StorageType$Lookups {
        site: QueryOperation<Site>;
    }
    export interface StorageType$Operations {
        query: QueryOperation<StorageType>;
        read: ReadOperation<StorageType>;
        aggregate: {
            read: AggregateReadOperation<StorageType>;
            query: AggregateQueryOperation<StorageType>;
        };
        lookups(dataOrId: string | { data: StorageTypeInput }): StorageType$Lookups;
        getDefaults: GetDefaultsOperation<StorageType>;
    }
    export interface StoreAddressesCode extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressCode: string;
    }
    export interface StoreAddressesCodeInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        addressCode?: string;
    }
    export interface StoreAddressesCodeBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressCode: string;
    }
    export interface StoreAddressesCode$Operations {
        query: QueryOperation<StoreAddressesCode>;
        read: ReadOperation<StoreAddressesCode>;
        aggregate: {
            read: AggregateReadOperation<StoreAddressesCode>;
            query: AggregateQueryOperation<StoreAddressesCode>;
        };
        getDefaults: GetDefaultsOperation<StoreAddressesCode>;
    }
    export interface StoreAddressesDescription extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressDescription: string;
    }
    export interface StoreAddressesDescriptionInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        addressDescription?: string;
    }
    export interface StoreAddressesDescriptionBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressDescription: string;
    }
    export interface StoreAddressesDescription$Operations {
        query: QueryOperation<StoreAddressesDescription>;
        read: ReadOperation<StoreAddressesDescription>;
        aggregate: {
            read: AggregateReadOperation<StoreAddressesDescription>;
            query: AggregateQueryOperation<StoreAddressesDescription>;
        };
        getDefaults: GetDefaultsOperation<StoreAddressesDescription>;
    }
    export interface StoreAddressesFormat extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressFormat: string;
    }
    export interface StoreAddressesFormatInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        addressFormat?: string;
    }
    export interface StoreAddressesFormatBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressFormat: string;
    }
    export interface StoreAddressesFormat$Operations {
        query: QueryOperation<StoreAddressesFormat>;
        read: ReadOperation<StoreAddressesFormat>;
        aggregate: {
            read: AggregateReadOperation<StoreAddressesFormat>;
            query: AggregateQueryOperation<StoreAddressesFormat>;
        };
        getDefaults: GetDefaultsOperation<StoreAddressesFormat>;
    }
    export interface StoreAddressesLength extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressLength: integer;
    }
    export interface StoreAddressesLengthInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        addressLength?: integer | string;
    }
    export interface StoreAddressesLengthBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressLength: integer;
    }
    export interface StoreAddressesLength$Operations {
        query: QueryOperation<StoreAddressesLength>;
        read: ReadOperation<StoreAddressesLength>;
        aggregate: {
            read: AggregateReadOperation<StoreAddressesLength>;
            query: AggregateQueryOperation<StoreAddressesLength>;
        };
        getDefaults: GetDefaultsOperation<StoreAddressesLength>;
    }
    export interface StoreAddressesType extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressType: Format;
    }
    export interface StoreAddressesTypeInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        addressType?: Format;
    }
    export interface StoreAddressesTypeBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        addressType: Format;
    }
    export interface StoreAddressesType$Operations {
        query: QueryOperation<StoreAddressesType>;
        read: ReadOperation<StoreAddressesType>;
        aggregate: {
            read: AggregateReadOperation<StoreAddressesType>;
            query: AggregateQueryOperation<StoreAddressesType>;
        };
        getDefaults: GetDefaultsOperation<StoreAddressesType>;
    }
    export interface StoreChainingStoresChaining extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        storeChaining: Store;
    }
    export interface StoreChainingStoresChainingInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        storeChaining?: string;
    }
    export interface StoreChainingStoresChainingBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        storeChaining: Store;
    }
    export interface StoreChainingStoresChaining$Lookups {
        storeChaining: QueryOperation<Store>;
    }
    export interface StoreChainingStoresChaining$Operations {
        query: QueryOperation<StoreChainingStoresChaining>;
        read: ReadOperation<StoreChainingStoresChaining>;
        aggregate: {
            read: AggregateReadOperation<StoreChainingStoresChaining>;
            query: AggregateQueryOperation<StoreChainingStoresChaining>;
        };
        lookups(dataOrId: string | { data: StoreChainingStoresChainingInput }): StoreChainingStoresChaining$Lookups;
        getDefaults: GetDefaultsOperation<StoreChainingStoresChaining>;
    }
    export interface StoreChaining extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        priorityStore: Store;
        numberOfChaining: integer;
        isChainingForSplittingStores: boolean;
        storesChaining: ClientCollection<StoreChainingStoresChaining>;
    }
    export interface StoreChainingInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        priorityStore?: string;
        numberOfChaining?: integer | string;
        isChainingForSplittingStores?: boolean | string;
        storesChaining?: Partial<StoreChainingStoresChainingInput>[];
    }
    export interface StoreChainingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        priorityStore: Store;
        numberOfChaining: integer;
        isChainingForSplittingStores: boolean;
        storesChaining: ClientCollection<StoreChainingStoresChainingBinding>;
    }
    export interface StoreChaining$Lookups {
        site: QueryOperation<Site>;
        priorityStore: QueryOperation<Store>;
    }
    export interface StoreChaining$Operations {
        query: QueryOperation<StoreChaining>;
        read: ReadOperation<StoreChaining>;
        aggregate: {
            read: AggregateReadOperation<StoreChaining>;
            query: AggregateQueryOperation<StoreChaining>;
        };
        lookups(dataOrId: string | { data: StoreChainingInput }): StoreChaining$Lookups;
        getDefaults: GetDefaultsOperation<StoreChaining>;
    }
    export interface StorePutawayOrders extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        putawayOrder: integer;
    }
    export interface StorePutawayOrdersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        putawayOrder?: integer | string;
    }
    export interface StorePutawayOrdersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        putawayOrder: integer;
    }
    export interface StorePutawayOrders$Operations {
        query: QueryOperation<StorePutawayOrders>;
        read: ReadOperation<StorePutawayOrders>;
        aggregate: {
            read: AggregateReadOperation<StorePutawayOrders>;
            query: AggregateQueryOperation<StorePutawayOrders>;
        };
        getDefaults: GetDefaultsOperation<StorePutawayOrders>;
    }
    export interface StoreStartLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        startLevel: integer;
    }
    export interface StoreStartLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        startLevel?: integer | string;
    }
    export interface StoreStartLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        startLevel: integer;
    }
    export interface StoreStartLevels$Operations {
        query: QueryOperation<StoreStartLevels>;
        read: ReadOperation<StoreStartLevels>;
        aggregate: {
            read: AggregateReadOperation<StoreStartLevels>;
            query: AggregateQueryOperation<StoreStartLevels>;
        };
        getDefaults: GetDefaultsOperation<StoreStartLevels>;
    }
    export interface Store extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isProximityPickingStore: boolean;
        isKeyInControlCode: boolean;
        priorityInOutput: string;
        isAuthorizedInOutput: boolean;
        storeType: StoreType;
        groupMergingOfFlows: string;
        isBigVolumesAllowed: boolean;
        isSmallVolumesAllowed: boolean;
        chainingMode: StoreChaining;
        addressStructure: string;
        storingStructure: string;
        aisleType: AislesType;
        rowFacing: AislesInFront;
        presentAisleRank: integer;
        presentAisleLevel: string;
        rankOfFrontAisle: integer;
        levelOfInfrontAisle: string;
        isAisleChaining: boolean;
        extendProximityLevel: string;
        keyOfCalculation: integer;
        isTransferCompleteObject: boolean;
        reintegrationStore: Store;
        isPreventiveStockCount: boolean;
        isBalanceReaddressing: boolean;
        supportingBeamMaxWeight: string;
        alertThreshold: string;
        locations: ClientCollection<Location>;
        addressesCode: ClientCollection<StoreAddressesCode>;
        addressesDescription: ClientCollection<StoreAddressesDescription>;
        addressesFormat: ClientCollection<StoreAddressesFormat>;
        addressesLength: ClientCollection<StoreAddressesLength>;
        addressesType: ClientCollection<StoreAddressesType>;
        putawayOrders: ClientCollection<StorePutawayOrders>;
        startLevels: ClientCollection<StoreStartLevels>;
    }
    export interface StoreInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isProximityPickingStore?: boolean | string;
        isKeyInControlCode?: boolean | string;
        priorityInOutput?: string;
        isAuthorizedInOutput?: boolean | string;
        storeType?: StoreType;
        groupMergingOfFlows?: string;
        isBigVolumesAllowed?: boolean | string;
        isSmallVolumesAllowed?: boolean | string;
        chainingMode?: string;
        addressStructure?: string;
        storingStructure?: string;
        aisleType?: AislesType;
        rowFacing?: AislesInFront;
        presentAisleRank?: integer | string;
        presentAisleLevel?: string;
        rankOfFrontAisle?: integer | string;
        levelOfInfrontAisle?: string;
        isAisleChaining?: boolean | string;
        extendProximityLevel?: string;
        keyOfCalculation?: integer | string;
        isTransferCompleteObject?: boolean | string;
        reintegrationStore?: string;
        isPreventiveStockCount?: boolean | string;
        isBalanceReaddressing?: boolean | string;
        supportingBeamMaxWeight?: decimal | string;
        alertThreshold?: decimal | string;
        locations?: Partial<LocationInput>[];
        addressesCode?: Partial<StoreAddressesCodeInput>[];
        addressesDescription?: Partial<StoreAddressesDescriptionInput>[];
        addressesFormat?: Partial<StoreAddressesFormatInput>[];
        addressesLength?: Partial<StoreAddressesLengthInput>[];
        addressesType?: Partial<StoreAddressesTypeInput>[];
        putawayOrders?: Partial<StorePutawayOrdersInput>[];
        startLevels?: Partial<StoreStartLevelsInput>[];
    }
    export interface StoreBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isProximityPickingStore: boolean;
        isKeyInControlCode: boolean;
        priorityInOutput: string;
        isAuthorizedInOutput: boolean;
        storeType: StoreType;
        groupMergingOfFlows: string;
        isBigVolumesAllowed: boolean;
        isSmallVolumesAllowed: boolean;
        chainingMode: StoreChaining;
        addressStructure: string;
        storingStructure: string;
        aisleType: AislesType;
        rowFacing: AislesInFront;
        presentAisleRank: integer;
        presentAisleLevel: string;
        rankOfFrontAisle: integer;
        levelOfInfrontAisle: string;
        isAisleChaining: boolean;
        extendProximityLevel: string;
        keyOfCalculation: integer;
        isTransferCompleteObject: boolean;
        reintegrationStore: Store;
        isPreventiveStockCount: boolean;
        isBalanceReaddressing: boolean;
        supportingBeamMaxWeight: string;
        alertThreshold: string;
        locations: ClientCollection<Location>;
        addressesCode: ClientCollection<StoreAddressesCodeBinding>;
        addressesDescription: ClientCollection<StoreAddressesDescriptionBinding>;
        addressesFormat: ClientCollection<StoreAddressesFormatBinding>;
        addressesLength: ClientCollection<StoreAddressesLengthBinding>;
        addressesType: ClientCollection<StoreAddressesTypeBinding>;
        putawayOrders: ClientCollection<StorePutawayOrdersBinding>;
        startLevels: ClientCollection<StoreStartLevelsBinding>;
    }
    export interface Store$Lookups {
        site: QueryOperation<Site>;
        chainingMode: QueryOperation<StoreChaining>;
        reintegrationStore: QueryOperation<Store>;
    }
    export interface Store$Operations {
        query: QueryOperation<Store>;
        read: ReadOperation<Store>;
        aggregate: {
            read: AggregateReadOperation<Store>;
            query: AggregateQueryOperation<Store>;
        };
        lookups(dataOrId: string | { data: StoreInput }): Store$Lookups;
        getDefaults: GetDefaultsOperation<Store>;
    }
    export interface SupplierAdresses extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        adress: string;
    }
    export interface SupplierAdressesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        adress?: string;
    }
    export interface SupplierAdressesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        adress: string;
    }
    export interface SupplierAdresses$Operations {
        query: QueryOperation<SupplierAdresses>;
        read: ReadOperation<SupplierAdresses>;
        aggregate: {
            read: AggregateReadOperation<SupplierAdresses>;
            query: AggregateQueryOperation<SupplierAdresses>;
        };
        getDefaults: GetDefaultsOperation<SupplierAdresses>;
    }
    export interface SupplierCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        companyName: string;
    }
    export interface SupplierCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        companyName?: string;
    }
    export interface SupplierCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        companyName: string;
    }
    export interface SupplierCompanyNames$Operations {
        query: QueryOperation<SupplierCompanyNames>;
        read: ReadOperation<SupplierCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SupplierCompanyNames>;
            query: AggregateQueryOperation<SupplierCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SupplierCompanyNames>;
    }
    export interface Supplier extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        shortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        telephone: string;
        fax: string;
        email: string;
        isQualityControlManagement: boolean;
        isActive: boolean;
        adresses: ClientCollection<SupplierAdresses>;
        companyNames: ClientCollection<SupplierCompanyNames>;
    }
    export interface SupplierInput extends ClientNodeInput {
        site?: string;
        code?: string;
        shortDescription?: string;
        postalCode?: string;
        city?: string;
        region?: string;
        country?: string;
        countryName?: string;
        telephone?: string;
        fax?: string;
        email?: string;
        isQualityControlManagement?: boolean | string;
        isActive?: boolean | string;
        adresses?: Partial<SupplierAdressesInput>[];
        companyNames?: Partial<SupplierCompanyNamesInput>[];
    }
    export interface SupplierBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        shortDescription: string;
        postalCode: string;
        city: string;
        region: string;
        country: Country;
        countryName: string;
        telephone: string;
        fax: string;
        email: string;
        isQualityControlManagement: boolean;
        isActive: boolean;
        adresses: ClientCollection<SupplierAdressesBinding>;
        companyNames: ClientCollection<SupplierCompanyNamesBinding>;
    }
    export interface Supplier$Lookups {
        site: QueryOperation<Site>;
        country: QueryOperation<Country>;
    }
    export interface Supplier$Operations {
        query: QueryOperation<Supplier>;
        read: ReadOperation<Supplier>;
        aggregate: {
            read: AggregateReadOperation<Supplier>;
            query: AggregateQueryOperation<Supplier>;
        };
        lookups(dataOrId: string | { data: SupplierInput }): Supplier$Lookups;
        getDefaults: GetDefaultsOperation<Supplier>;
    }
    export interface TariffCode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
    }
    export interface TariffCodeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isActive?: boolean | string;
    }
    export interface TariffCodeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
    }
    export interface TariffCode$Lookups {
        site: QueryOperation<Site>;
    }
    export interface TariffCode$Operations {
        query: QueryOperation<TariffCode>;
        read: ReadOperation<TariffCode>;
        aggregate: {
            read: AggregateReadOperation<TariffCode>;
            query: AggregateQueryOperation<TariffCode>;
        };
        lookups(dataOrId: string | { data: TariffCodeInput }): TariffCode$Lookups;
        getDefaults: GetDefaultsOperation<TariffCode>;
    }
    export interface TransportMode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
    }
    export interface TransportModeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isActive?: boolean | string;
    }
    export interface TransportModeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
    }
    export interface TransportMode$Lookups {
        site: QueryOperation<Site>;
    }
    export interface TransportMode$Operations {
        query: QueryOperation<TransportMode>;
        read: ReadOperation<TransportMode>;
        aggregate: {
            read: AggregateReadOperation<TransportMode>;
            query: AggregateQueryOperation<TransportMode>;
        };
        lookups(dataOrId: string | { data: TransportModeInput }): TransportMode$Lookups;
        getDefaults: GetDefaultsOperation<TransportMode>;
    }
    export interface TransportType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isFreeFreight: boolean;
        isActive: boolean;
    }
    export interface TransportTypeInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isFreeFreight?: boolean | string;
        isActive?: boolean | string;
    }
    export interface TransportTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isFreeFreight: boolean;
        isActive: boolean;
    }
    export interface TransportType$Lookups {
        site: QueryOperation<Site>;
    }
    export interface TransportType$Operations {
        query: QueryOperation<TransportType>;
        read: ReadOperation<TransportType>;
        aggregate: {
            read: AggregateReadOperation<TransportType>;
            query: AggregateQueryOperation<TransportType>;
        };
        lookups(dataOrId: string | { data: TransportTypeInput }): TransportType$Lookups;
        getDefaults: GetDefaultsOperation<TransportType>;
    }
    export interface TruckTrackingStatus extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface TruckTrackingStatusInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface TruckTrackingStatusBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface TruckTrackingStatus$Lookups {
        site: QueryOperation<Site>;
    }
    export interface TruckTrackingStatus$Operations {
        query: QueryOperation<TruckTrackingStatus>;
        read: ReadOperation<TruckTrackingStatus>;
        aggregate: {
            read: AggregateReadOperation<TruckTrackingStatus>;
            query: AggregateQueryOperation<TruckTrackingStatus>;
        };
        lookups(dataOrId: string | { data: TruckTrackingStatusInput }): TruckTrackingStatus$Lookups;
        getDefaults: GetDefaultsOperation<TruckTrackingStatus>;
    }
    export interface UnitOfMeasure extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfDecimals: integer;
        symbol: string;
        unitType: UnitType;
        codeCeeOnu: MiscellaneousTable;
    }
    export interface UnitOfMeasureInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        numberOfDecimals?: integer | string;
        symbol?: string;
        unitType?: UnitType;
        codeCeeOnu?: string;
    }
    export interface UnitOfMeasureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfDecimals: integer;
        symbol: string;
        unitType: UnitType;
        codeCeeOnu: MiscellaneousTable;
    }
    export interface UnitOfMeasure$Lookups {
        codeCeeOnu: QueryOperation<MiscellaneousTable>;
    }
    export interface UnitOfMeasure$Operations {
        query: QueryOperation<UnitOfMeasure>;
        read: ReadOperation<UnitOfMeasure>;
        aggregate: {
            read: AggregateReadOperation<UnitOfMeasure>;
            query: AggregateQueryOperation<UnitOfMeasure>;
        };
        lookups(dataOrId: string | { data: UnitOfMeasureInput }): UnitOfMeasure$Lookups;
        getDefaults: GetDefaultsOperation<UnitOfMeasure>;
    }
    export interface VolumeClassVolumeClassesChaining extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        volumeClassChaining: VolumeClass;
    }
    export interface VolumeClassVolumeClassesChainingInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        code?: string;
        volumeClassChaining?: string;
    }
    export interface VolumeClassVolumeClassesChainingBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        code: string;
        volumeClassChaining: VolumeClass;
    }
    export interface VolumeClassVolumeClassesChaining$Lookups {
        volumeClassChaining: QueryOperation<VolumeClass>;
    }
    export interface VolumeClassVolumeClassesChaining$Operations {
        query: QueryOperation<VolumeClassVolumeClassesChaining>;
        read: ReadOperation<VolumeClassVolumeClassesChaining>;
        aggregate: {
            read: AggregateReadOperation<VolumeClassVolumeClassesChaining>;
            query: AggregateQueryOperation<VolumeClassVolumeClassesChaining>;
        };
        lookups(
            dataOrId: string | { data: VolumeClassVolumeClassesChainingInput },
        ): VolumeClassVolumeClassesChaining$Lookups;
        getDefaults: GetDefaultsOperation<VolumeClassVolumeClassesChaining>;
    }
    export interface VolumeClass extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortdescription: string;
        maximumVolume: string;
        numberOfChaining: integer;
        volumeClassesChaining: ClientCollection<VolumeClassVolumeClassesChaining>;
    }
    export interface VolumeClassInput extends ClientNodeInput {
        site?: string;
        code?: string;
        localizedDescription?: string;
        localizedShortdescription?: string;
        maximumVolume?: decimal | string;
        numberOfChaining?: integer | string;
        volumeClassesChaining?: Partial<VolumeClassVolumeClassesChainingInput>[];
    }
    export interface VolumeClassBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        localizedDescription: string;
        localizedShortdescription: string;
        maximumVolume: string;
        numberOfChaining: integer;
        volumeClassesChaining: ClientCollection<VolumeClassVolumeClassesChainingBinding>;
    }
    export interface VolumeClass$Lookups {
        site: QueryOperation<Site>;
    }
    export interface VolumeClass$Operations {
        query: QueryOperation<VolumeClass>;
        read: ReadOperation<VolumeClass>;
        aggregate: {
            read: AggregateReadOperation<VolumeClass>;
            query: AggregateQueryOperation<VolumeClass>;
        };
        lookups(dataOrId: string | { data: VolumeClassInput }): VolumeClass$Lookups;
        getDefaults: GetDefaultsOperation<VolumeClass>;
    }
    export interface WhSiteAddressingPriorities extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        addressingPriority: MappingAddressingCriteria;
    }
    export interface WhSiteAddressingPrioritiesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        addressingPriority?: MappingAddressingCriteria;
    }
    export interface WhSiteAddressingPrioritiesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        addressingPriority: MappingAddressingCriteria;
    }
    export interface WhSiteAddressingPriorities$Operations {
        query: QueryOperation<WhSiteAddressingPriorities>;
        read: ReadOperation<WhSiteAddressingPriorities>;
        aggregate: {
            read: AggregateReadOperation<WhSiteAddressingPriorities>;
            query: AggregateQueryOperation<WhSiteAddressingPriorities>;
        };
        getDefaults: GetDefaultsOperation<WhSiteAddressingPriorities>;
    }
    export interface WhSiteIsNoWorkDays extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        isNoWorkDay: boolean;
    }
    export interface WhSiteIsNoWorkDaysInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        isNoWorkDay?: boolean | string;
    }
    export interface WhSiteIsNoWorkDaysBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        isNoWorkDay: boolean;
    }
    export interface WhSiteIsNoWorkDays$Operations {
        query: QueryOperation<WhSiteIsNoWorkDays>;
        read: ReadOperation<WhSiteIsNoWorkDays>;
        aggregate: {
            read: AggregateReadOperation<WhSiteIsNoWorkDays>;
            query: AggregateQueryOperation<WhSiteIsNoWorkDays>;
        };
        getDefaults: GetDefaultsOperation<WhSiteIsNoWorkDays>;
    }
    export interface WhSiteSupplierBarCodes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        supplierBarCodeStart: integer;
        supplierBarCodeEnd: integer;
    }
    export interface WhSiteSupplierBarCodesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        supplierBarCodeStart?: integer | string;
        supplierBarCodeEnd?: integer | string;
    }
    export interface WhSiteSupplierBarCodesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        supplierBarCodeStart: integer;
        supplierBarCodeEnd: integer;
    }
    export interface WhSiteSupplierBarCodes$Operations {
        query: QueryOperation<WhSiteSupplierBarCodes>;
        read: ReadOperation<WhSiteSupplierBarCodes>;
        aggregate: {
            read: AggregateReadOperation<WhSiteSupplierBarCodes>;
            query: AggregateQueryOperation<WhSiteSupplierBarCodes>;
        };
        getDefaults: GetDefaultsOperation<WhSiteSupplierBarCodes>;
    }
    export interface WhSite extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        transferValidationType: ValidationType;
        isTransferOperationCodeAllowed: boolean;
        isPickControlCodeAllowed: boolean;
        isRepositoningControlCodeAllowed: boolean;
        isReceiptOperationCodeAllowed: boolean;
        isAdjustementOperationCodeAllowed: boolean;
        isAdjustementControlCodeAllowed: boolean;
        isConsumableInputControlCodeAllowed: boolean;
        isConsumableOutputControlCodeAllowed: boolean;
        isSimplifiedStockCountCodeAllowed: boolean;
        isPrintTransferListAllowed: boolean;
        isPrintTransferLabelAllowed: boolean;
        isMonoZoneOriginAllowed: boolean;
        isMonoZoneDestinationAllowed: boolean;
        isDockAssignmentAllowed: boolean;
        isItemBarCodeAllowed: boolean;
        isEanBarCodeAllowed: boolean;
        isTransferProductBarCodeAllowed: boolean;
        isTransferEanBarCodeAllowed: boolean;
        isDripAndDropAllowed: boolean;
        isPreventiveStockCount: boolean;
        timeBetweenInterval: integer;
        inventoryMovementCode: MovementCode;
        isPickingOperationCodeAllowed: boolean;
        isDockControlParcels: boolean;
        isSingleDepositor: boolean;
        isSingleStorageType: boolean;
        isStoreChaining: boolean;
        isRotationClassesChaining: boolean;
        isChainingAssignmentClasses: boolean;
        isChainingVolumeClasses: boolean;
        isPickProdWithoutPrompt: boolean;
        rotationPickingWithoutPrompt: RotationClass;
        pickingVolumeWithoutPrompt: VolumeClass;
        idealRotationClass: IdealRotationClass;
        idealVolumeClass: IdealVolumeType;
        targetCover: string;
        minimumDelayBeforeReallocation: integer;
        minimumActivityBeforeAllocation: integer;
        calculationPeriod: integer;
        transferPicking: MovementCode;
        transferReserve: MovementCode;
        isRoundCreation: boolean;
        isInitializeCarrierAndTransportMode: boolean;
        isResearchGenericRound: boolean;
        deliveryInAdvance: integer;
        roundHour: string;
        isEdiOperationCode: boolean;
        dcmdLimitQuantity: integer;
        carriageNoteDstdReport: GenericPrintReport;
        carriageReceiptDstdReport: GenericPrintReport;
        internationalLanguage: Language;
        crossDockingStore: Store;
        isWaveInitialization: boolean;
        isInterSiteRoundManagement: boolean;
        eanDefaultMethod: DefaultMode;
        isUnicityCheck: boolean;
        isRepackingOperationCodeAllowed: boolean;
        isPickingValidated: boolean;
        transferMovementCode: MovementCode;
        isOutputMouvementGrouping: boolean;
        isTransfertMouvementGrouping: boolean;
        loadingUnit: LoadUnitType;
        isReceiptDockCapacity: boolean;
        isAutoQuayOccupation: boolean;
        receiptAppointmentOccupationStartTime: string;
        receiptAppointmentOccupationEndTime: string;
        receiptAppointmentProvisionalDuration: string;
        receiptAppointmentTruckTrackingStatus: string;
        isReceiptAppointmentAssignement: boolean;
        isReceiptAppointementDockFreeing: boolean;
        isShipmentDockCapacity: boolean;
        shipmentAppointmentOccupationStartTime: string;
        shipmentAppointmentOccupationEndTime: string;
        shipmentAppointmentProvisionalDuration: string;
        shipmentAppointmentTruckTrackingStatus: string;
        isRoundReference: boolean;
        isShipmentAppointementAssignment: boolean;
        isAutoShipmentAppointementAssignment: boolean;
        isUpdateOnLoading: boolean;
        isShipmentAppointementDockFreing: boolean;
        otherAppointmentOccupationStartTime: string;
        otherAppointmentOccupationEndTime: string;
        otherAppointmentProvisionalDuration: string;
        otherAppointmentTruckTrackingStatus: string;
        workCenter1: WorkCenter;
        unitOfMeasure1: UnitOfMeasure;
        workCenter2: WorkCenter;
        unitOfMeasure2: UnitOfMeasure;
        isSimplifiedStockCount: boolean;
        isLastStockCountDateUpdate: boolean;
        siteSei: string;
        addressingPriorities: ClientCollection<WhSiteAddressingPriorities>;
        isNoWorkDays: ClientCollection<WhSiteIsNoWorkDays>;
        supplierBarCodes: ClientCollection<WhSiteSupplierBarCodes>;
    }
    export interface WhSiteInput extends ClientNodeInput {
        site?: string;
        transferValidationType?: ValidationType;
        isTransferOperationCodeAllowed?: boolean | string;
        isPickControlCodeAllowed?: boolean | string;
        isRepositoningControlCodeAllowed?: boolean | string;
        isReceiptOperationCodeAllowed?: boolean | string;
        isAdjustementOperationCodeAllowed?: boolean | string;
        isAdjustementControlCodeAllowed?: boolean | string;
        isConsumableInputControlCodeAllowed?: boolean | string;
        isConsumableOutputControlCodeAllowed?: boolean | string;
        isSimplifiedStockCountCodeAllowed?: boolean | string;
        isPrintTransferListAllowed?: boolean | string;
        isPrintTransferLabelAllowed?: boolean | string;
        isMonoZoneOriginAllowed?: boolean | string;
        isMonoZoneDestinationAllowed?: boolean | string;
        isDockAssignmentAllowed?: boolean | string;
        isItemBarCodeAllowed?: boolean | string;
        isEanBarCodeAllowed?: boolean | string;
        isTransferProductBarCodeAllowed?: boolean | string;
        isTransferEanBarCodeAllowed?: boolean | string;
        isDripAndDropAllowed?: boolean | string;
        isPreventiveStockCount?: boolean | string;
        timeBetweenInterval?: integer | string;
        inventoryMovementCode?: string;
        isPickingOperationCodeAllowed?: boolean | string;
        isDockControlParcels?: boolean | string;
        isSingleDepositor?: boolean | string;
        isSingleStorageType?: boolean | string;
        isStoreChaining?: boolean | string;
        isRotationClassesChaining?: boolean | string;
        isChainingAssignmentClasses?: boolean | string;
        isChainingVolumeClasses?: boolean | string;
        isPickProdWithoutPrompt?: boolean | string;
        rotationPickingWithoutPrompt?: string;
        pickingVolumeWithoutPrompt?: string;
        idealRotationClass?: IdealRotationClass;
        idealVolumeClass?: IdealVolumeType;
        targetCover?: decimal | string;
        minimumDelayBeforeReallocation?: integer | string;
        minimumActivityBeforeAllocation?: integer | string;
        calculationPeriod?: integer | string;
        transferPicking?: string;
        transferReserve?: string;
        isRoundCreation?: boolean | string;
        isInitializeCarrierAndTransportMode?: boolean | string;
        isResearchGenericRound?: boolean | string;
        deliveryInAdvance?: integer | string;
        roundHour?: string;
        isEdiOperationCode?: boolean | string;
        dcmdLimitQuantity?: integer | string;
        carriageNoteDstdReport?: string;
        carriageReceiptDstdReport?: string;
        internationalLanguage?: string;
        crossDockingStore?: string;
        isWaveInitialization?: boolean | string;
        isInterSiteRoundManagement?: boolean | string;
        eanDefaultMethod?: DefaultMode;
        isUnicityCheck?: boolean | string;
        isRepackingOperationCodeAllowed?: boolean | string;
        isPickingValidated?: boolean | string;
        transferMovementCode?: string;
        isOutputMouvementGrouping?: boolean | string;
        isTransfertMouvementGrouping?: boolean | string;
        loadingUnit?: LoadUnitType;
        isReceiptDockCapacity?: boolean | string;
        isAutoQuayOccupation?: boolean | string;
        receiptAppointmentOccupationStartTime?: string;
        receiptAppointmentOccupationEndTime?: string;
        receiptAppointmentProvisionalDuration?: string;
        receiptAppointmentTruckTrackingStatus?: string;
        isReceiptAppointmentAssignement?: boolean | string;
        isReceiptAppointementDockFreeing?: boolean | string;
        isShipmentDockCapacity?: boolean | string;
        shipmentAppointmentOccupationStartTime?: string;
        shipmentAppointmentOccupationEndTime?: string;
        shipmentAppointmentProvisionalDuration?: string;
        shipmentAppointmentTruckTrackingStatus?: string;
        isRoundReference?: boolean | string;
        isShipmentAppointementAssignment?: boolean | string;
        isAutoShipmentAppointementAssignment?: boolean | string;
        isUpdateOnLoading?: boolean | string;
        isShipmentAppointementDockFreing?: boolean | string;
        otherAppointmentOccupationStartTime?: string;
        otherAppointmentOccupationEndTime?: string;
        otherAppointmentProvisionalDuration?: string;
        otherAppointmentTruckTrackingStatus?: string;
        workCenter1?: string;
        unitOfMeasure1?: string;
        workCenter2?: string;
        unitOfMeasure2?: string;
        isSimplifiedStockCount?: boolean | string;
        isLastStockCountDateUpdate?: boolean | string;
        siteSei?: string;
        addressingPriorities?: Partial<WhSiteAddressingPrioritiesInput>[];
        isNoWorkDays?: Partial<WhSiteIsNoWorkDaysInput>[];
        supplierBarCodes?: Partial<WhSiteSupplierBarCodesInput>[];
    }
    export interface WhSiteBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        transferValidationType: ValidationType;
        isTransferOperationCodeAllowed: boolean;
        isPickControlCodeAllowed: boolean;
        isRepositoningControlCodeAllowed: boolean;
        isReceiptOperationCodeAllowed: boolean;
        isAdjustementOperationCodeAllowed: boolean;
        isAdjustementControlCodeAllowed: boolean;
        isConsumableInputControlCodeAllowed: boolean;
        isConsumableOutputControlCodeAllowed: boolean;
        isSimplifiedStockCountCodeAllowed: boolean;
        isPrintTransferListAllowed: boolean;
        isPrintTransferLabelAllowed: boolean;
        isMonoZoneOriginAllowed: boolean;
        isMonoZoneDestinationAllowed: boolean;
        isDockAssignmentAllowed: boolean;
        isItemBarCodeAllowed: boolean;
        isEanBarCodeAllowed: boolean;
        isTransferProductBarCodeAllowed: boolean;
        isTransferEanBarCodeAllowed: boolean;
        isDripAndDropAllowed: boolean;
        isPreventiveStockCount: boolean;
        timeBetweenInterval: integer;
        inventoryMovementCode: MovementCode;
        isPickingOperationCodeAllowed: boolean;
        isDockControlParcels: boolean;
        isSingleDepositor: boolean;
        isSingleStorageType: boolean;
        isStoreChaining: boolean;
        isRotationClassesChaining: boolean;
        isChainingAssignmentClasses: boolean;
        isChainingVolumeClasses: boolean;
        isPickProdWithoutPrompt: boolean;
        rotationPickingWithoutPrompt: RotationClass;
        pickingVolumeWithoutPrompt: VolumeClass;
        idealRotationClass: IdealRotationClass;
        idealVolumeClass: IdealVolumeType;
        targetCover: string;
        minimumDelayBeforeReallocation: integer;
        minimumActivityBeforeAllocation: integer;
        calculationPeriod: integer;
        transferPicking: MovementCode;
        transferReserve: MovementCode;
        isRoundCreation: boolean;
        isInitializeCarrierAndTransportMode: boolean;
        isResearchGenericRound: boolean;
        deliveryInAdvance: integer;
        roundHour: string;
        isEdiOperationCode: boolean;
        dcmdLimitQuantity: integer;
        carriageNoteDstdReport: GenericPrintReport;
        carriageReceiptDstdReport: GenericPrintReport;
        internationalLanguage: Language;
        crossDockingStore: Store;
        isWaveInitialization: boolean;
        isInterSiteRoundManagement: boolean;
        eanDefaultMethod: DefaultMode;
        isUnicityCheck: boolean;
        isRepackingOperationCodeAllowed: boolean;
        isPickingValidated: boolean;
        transferMovementCode: MovementCode;
        isOutputMouvementGrouping: boolean;
        isTransfertMouvementGrouping: boolean;
        loadingUnit: LoadUnitType;
        isReceiptDockCapacity: boolean;
        isAutoQuayOccupation: boolean;
        receiptAppointmentOccupationStartTime: string;
        receiptAppointmentOccupationEndTime: string;
        receiptAppointmentProvisionalDuration: string;
        receiptAppointmentTruckTrackingStatus: string;
        isReceiptAppointmentAssignement: boolean;
        isReceiptAppointementDockFreeing: boolean;
        isShipmentDockCapacity: boolean;
        shipmentAppointmentOccupationStartTime: string;
        shipmentAppointmentOccupationEndTime: string;
        shipmentAppointmentProvisionalDuration: string;
        shipmentAppointmentTruckTrackingStatus: string;
        isRoundReference: boolean;
        isShipmentAppointementAssignment: boolean;
        isAutoShipmentAppointementAssignment: boolean;
        isUpdateOnLoading: boolean;
        isShipmentAppointementDockFreing: boolean;
        otherAppointmentOccupationStartTime: string;
        otherAppointmentOccupationEndTime: string;
        otherAppointmentProvisionalDuration: string;
        otherAppointmentTruckTrackingStatus: string;
        workCenter1: WorkCenter;
        unitOfMeasure1: UnitOfMeasure;
        workCenter2: WorkCenter;
        unitOfMeasure2: UnitOfMeasure;
        isSimplifiedStockCount: boolean;
        isLastStockCountDateUpdate: boolean;
        siteSei: string;
        addressingPriorities: ClientCollection<WhSiteAddressingPrioritiesBinding>;
        isNoWorkDays: ClientCollection<WhSiteIsNoWorkDaysBinding>;
        supplierBarCodes: ClientCollection<WhSiteSupplierBarCodesBinding>;
    }
    export interface WhSite$Lookups {
        site: QueryOperation<Site>;
        inventoryMovementCode: QueryOperation<MovementCode>;
        rotationPickingWithoutPrompt: QueryOperation<RotationClass>;
        pickingVolumeWithoutPrompt: QueryOperation<VolumeClass>;
        transferPicking: QueryOperation<MovementCode>;
        transferReserve: QueryOperation<MovementCode>;
        carriageNoteDstdReport: QueryOperation<GenericPrintReport>;
        carriageReceiptDstdReport: QueryOperation<GenericPrintReport>;
        internationalLanguage: QueryOperation<Language>;
        crossDockingStore: QueryOperation<Store>;
        transferMovementCode: QueryOperation<MovementCode>;
        workCenter1: QueryOperation<WorkCenter>;
        unitOfMeasure1: QueryOperation<UnitOfMeasure>;
        workCenter2: QueryOperation<WorkCenter>;
        unitOfMeasure2: QueryOperation<UnitOfMeasure>;
    }
    export interface WhSite$Operations {
        query: QueryOperation<WhSite>;
        read: ReadOperation<WhSite>;
        aggregate: {
            read: AggregateReadOperation<WhSite>;
            query: AggregateQueryOperation<WhSite>;
        };
        lookups(dataOrId: string | { data: WhSiteInput }): WhSite$Lookups;
        getDefaults: GetDefaultsOperation<WhSite>;
    }
    export interface WorkCenter extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        sequence: integer;
        lastSlave: integer;
        level: integer;
        localizedDescription: string;
        localizedShortDescription: string;
        masterStation: WorkCenter;
        unit1: UnitOfMeasure;
        unit2: UnitOfMeasure;
        unit3: UnitOfMeasure;
    }
    export interface WorkCenterInput extends ClientNodeInput {
        site?: string;
        code?: string;
        sequence?: integer | string;
        lastSlave?: integer | string;
        level?: integer | string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        masterStation?: string;
        unit1?: string;
        unit2?: string;
        unit3?: string;
    }
    export interface WorkCenterBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        sequence: integer;
        lastSlave: integer;
        level: integer;
        localizedDescription: string;
        localizedShortDescription: string;
        masterStation: WorkCenter;
        unit1: UnitOfMeasure;
        unit2: UnitOfMeasure;
        unit3: UnitOfMeasure;
    }
    export interface WorkCenter$Lookups {
        site: QueryOperation<Site>;
        masterStation: QueryOperation<WorkCenter>;
        unit1: QueryOperation<UnitOfMeasure>;
        unit2: QueryOperation<UnitOfMeasure>;
        unit3: QueryOperation<UnitOfMeasure>;
    }
    export interface WorkCenter$Operations {
        query: QueryOperation<WorkCenter>;
        read: ReadOperation<WorkCenter>;
        aggregate: {
            read: AggregateReadOperation<WorkCenter>;
            query: AggregateQueryOperation<WorkCenter>;
        };
        lookups(dataOrId: string | { data: WorkCenterInput }): WorkCenter$Lookups;
        getDefaults: GetDefaultsOperation<WorkCenter>;
    }
    export interface CompanyExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        isLegalCompany: boolean;
        legislation: MiscellaneousTable;
        mainSite: Site;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        uniqueIdentificationNumber: string;
        legalForm: string;
        analyticalDimension: string;
        registredCapital: string;
        consolidation: string;
        divisionCode: string;
        europeanUnionVatNumber: string;
        firstFiscalYear: string;
        sector1: MiscellaneousTable;
        sector2: MiscellaneousTable;
        additionalNumber: integer;
        federalState: MiscellaneousTable;
        isRetention: boolean;
        isCollectionAgent: boolean;
        rexNumber: MiscellaneousTable;
        eoriNumber: string;
        subjectToTax: boolean;
        logo: Image;
        country: Country;
        registredCapitalCurrency: Currency;
        currency: Currency;
    }
    export interface CompanyInputExtension {
        code?: string;
        name?: string;
        shortName?: string;
        isLegalCompany?: boolean | string;
        legislation?: string;
        mainSite?: string;
        identificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        uniqueIdentificationNumber?: string;
        legalForm?: string;
        analyticalDimension?: string;
        registredCapital?: decimal | string;
        consolidation?: string;
        divisionCode?: string;
        europeanUnionVatNumber?: string;
        firstFiscalYear?: string;
        sector1?: string;
        sector2?: string;
        additionalNumber?: integer | string;
        federalState?: string;
        isRetention?: boolean | string;
        isCollectionAgent?: boolean | string;
        rexNumber?: string;
        eoriNumber?: string;
        subjectToTax?: boolean | string;
        logo?: string;
        country?: string;
        registredCapitalCurrency?: string;
        currency?: string;
    }
    export interface CompanyBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        isLegalCompany: boolean;
        legislation: MiscellaneousTable;
        mainSite: Site;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        uniqueIdentificationNumber: string;
        legalForm: string;
        analyticalDimension: string;
        registredCapital: string;
        consolidation: string;
        divisionCode: string;
        europeanUnionVatNumber: string;
        firstFiscalYear: string;
        sector1: MiscellaneousTable;
        sector2: MiscellaneousTable;
        additionalNumber: integer;
        federalState: MiscellaneousTable;
        isRetention: boolean;
        isCollectionAgent: boolean;
        rexNumber: MiscellaneousTable;
        eoriNumber: string;
        subjectToTax: boolean;
        logo: Image;
        country: Country;
        registredCapitalCurrency: Currency;
        currency: Currency;
    }
    export interface CompanyExtension$Lookups {
        country: QueryOperation<Country>;
        registredCapitalCurrency: QueryOperation<Currency>;
        currency: QueryOperation<Currency>;
    }
    export interface CompanyExtension$Operations {
        lookups(dataOrId: string | { data: CompanyInput }): CompanyExtension$Lookups;
    }
    export interface SiteExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        isManufacturing: boolean;
        isSales: boolean;
        isPurchasing: boolean;
        isStockSite: boolean;
        isAccounting: boolean;
        financialSite: Site;
        legalCompany: Company;
        legislation: MiscellaneousTable;
        analyticalDimension: string;
        isCityInterior: string;
        eoriNumber: string;
        unavailabilityCode: string;
        unavailabilityDays: ClientCollection<SiteUnavailabilityDays>;
        country: Country;
    }
    export interface SiteInputExtension {
        code?: string;
        name?: string;
        shortName?: string;
        identificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        isManufacturing?: boolean | string;
        isSales?: boolean | string;
        isPurchasing?: boolean | string;
        isStockSite?: boolean | string;
        isAccounting?: boolean | string;
        financialSite?: string;
        legalCompany?: string;
        legislation?: string;
        analyticalDimension?: string;
        isCityInterior?: string;
        eoriNumber?: string;
        unavailabilityCode?: string;
        unavailabilityDays?: Partial<SiteUnavailabilityDaysInput>[];
        country?: string;
    }
    export interface SiteBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortName: string;
        identificationNumber: string;
        standardIndustrialClassificationCode: string;
        isManufacturing: boolean;
        isSales: boolean;
        isPurchasing: boolean;
        isStockSite: boolean;
        isAccounting: boolean;
        financialSite: Site;
        legalCompany: Company;
        legislation: MiscellaneousTable;
        analyticalDimension: string;
        isCityInterior: string;
        eoriNumber: string;
        unavailabilityCode: string;
        unavailabilityDays: ClientCollection<SiteUnavailabilityDaysBinding>;
        country: Country;
    }
    export interface SiteExtension$Lookups {
        country: QueryOperation<Country>;
    }
    export interface SiteExtension$Operations {
        lookups(dataOrId: string | { data: SiteInput }): SiteExtension$Lookups;
    }
    export interface UserExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        activeInSelec: boolean;
        name: string;
        nameDescription: string;
        profession: SyracusMethod;
        menuProfile: UserProfileMenu;
        functionProfile: UserFunctionProfile;
        email: string;
        login: string;
        allAccessCodes: boolean;
        externalUser: boolean;
        x3Connection: boolean;
        webServicesConnection: boolean;
        defaultBankId: string;
        access: Access;
        bankIdNumber: string;
        userModel: User;
        profile: string;
        image: Image;
        picture: BinaryStream;
        functions: ClientCollection<UserFunctions>;
        supervisors: ClientCollection<UserSupervisors>;
        userDestinations: ClientCollection<UserUserDestinations>;
        currentDepositorCode: string;
        currentSiteCode: string;
        defaultSiteCode: string;
        isAllowedDepositorChange: boolean;
        isAllowedSiteChange: boolean;
    }
    export interface UserInputExtension {
        code?: string;
        activeInSelec?: boolean | string;
        name?: string;
        nameDescription?: string;
        profession?: string;
        menuProfile?: integer | string;
        functionProfile?: string;
        email?: string;
        login?: string;
        allAccessCodes?: boolean | string;
        externalUser?: boolean | string;
        x3Connection?: boolean | string;
        webServicesConnection?: boolean | string;
        defaultBankId?: string;
        access?: string;
        bankIdNumber?: string;
        userModel?: string;
        profile?: string;
        image?: string;
        picture?: BinaryStream;
        functions?: Partial<UserFunctionsInput>[];
        supervisors?: Partial<UserSupervisorsInput>[];
        userDestinations?: Partial<UserUserDestinationsInput>[];
    }
    export interface UserBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        activeInSelec: boolean;
        name: string;
        nameDescription: string;
        profession: SyracusMethod;
        menuProfile: UserProfileMenu;
        functionProfile: UserFunctionProfile;
        email: string;
        login: string;
        allAccessCodes: boolean;
        externalUser: boolean;
        x3Connection: boolean;
        webServicesConnection: boolean;
        defaultBankId: string;
        access: Access;
        bankIdNumber: string;
        userModel: User;
        profile: string;
        image: Image;
        picture: BinaryStream;
        functions: ClientCollection<UserFunctionsBinding>;
        supervisors: ClientCollection<UserSupervisorsBinding>;
        userDestinations: ClientCollection<UserUserDestinationsBinding>;
        currentDepositorCode: string;
        currentSiteCode: string;
        defaultSiteCode: string;
        isAllowedDepositorChange: boolean;
        isAllowedSiteChange: boolean;
    }
    export interface Package {
        '@sage/wh-master-data/AppointmentManagement': AppointmentManagement$Operations;
        '@sage/wh-master-data/AssignmentClassChainingAssignments': AssignmentClassChainingAssignments$Operations;
        '@sage/wh-master-data/AssignmentClass': AssignmentClass$Operations;
        '@sage/wh-master-data/CarrierAddresses': CarrierAddresses$Operations;
        '@sage/wh-master-data/CarrierCompanyNames': CarrierCompanyNames$Operations;
        '@sage/wh-master-data/CarrierTarifficationTypes': CarrierTarifficationTypes$Operations;
        '@sage/wh-master-data/CarrierTransportationMethods': CarrierTransportationMethods$Operations;
        '@sage/wh-master-data/Carrier': Carrier$Operations;
        '@sage/wh-master-data/CommonImage': CommonImage$Operations;
        '@sage/wh-master-data/CurrencyRate': CurrencyRate$Operations;
        '@sage/wh-master-data/Currency': Currency$Operations;
        '@sage/wh-master-data/CustomerAdresses': CustomerAdresses$Operations;
        '@sage/wh-master-data/CustomerCompanyNames': CustomerCompanyNames$Operations;
        '@sage/wh-master-data/Customer': Customer$Operations;
        '@sage/wh-master-data/DepositorAddresses': DepositorAddresses$Operations;
        '@sage/wh-master-data/DepositorCrossDockingPriorities': DepositorCrossDockingPriorities$Operations;
        '@sage/wh-master-data/DepositorNames': DepositorNames$Operations;
        '@sage/wh-master-data/DepositorPickingPivotPriorities': DepositorPickingPivotPriorities$Operations;
        '@sage/wh-master-data/Depositor': Depositor$Operations;
        '@sage/wh-master-data/GenericRoundTimeLimitPerDays': GenericRoundTimeLimitPerDays$Operations;
        '@sage/wh-master-data/GenericRound': GenericRound$Operations;
        '@sage/wh-master-data/GenericWave': GenericWave$Operations;
        '@sage/wh-master-data/LocationSplitAddresses': LocationSplitAddresses$Operations;
        '@sage/wh-master-data/Location': Location$Operations;
        '@sage/wh-master-data/MovementCode': MovementCode$Operations;
        '@sage/wh-master-data/Operand': Operand$Operations;
        '@sage/wh-master-data/ParcelType': ParcelType$Operations;
        '@sage/wh-master-data/PreparationAreaParametersForPreparationOrder': PreparationAreaParametersForPreparationOrder$Operations;
        '@sage/wh-master-data/PreparationArea': PreparationArea$Operations;
        '@sage/wh-master-data/RangeOfParcel': RangeOfParcel$Operations;
        '@sage/wh-master-data/RotationClassRotationClassesChaining': RotationClassRotationClassesChaining$Operations;
        '@sage/wh-master-data/RotationClass': RotationClass$Operations;
        '@sage/wh-master-data/SerialGroup': SerialGroup$Operations;
        '@sage/wh-master-data/ShippingUnitType': ShippingUnitType$Operations;
        '@sage/wh-master-data/StockCountClass': StockCountClass$Operations;
        '@sage/wh-master-data/StockNature': StockNature$Operations;
        '@sage/wh-master-data/StorageType': StorageType$Operations;
        '@sage/wh-master-data/StoreAddressesCode': StoreAddressesCode$Operations;
        '@sage/wh-master-data/StoreAddressesDescription': StoreAddressesDescription$Operations;
        '@sage/wh-master-data/StoreAddressesFormat': StoreAddressesFormat$Operations;
        '@sage/wh-master-data/StoreAddressesLength': StoreAddressesLength$Operations;
        '@sage/wh-master-data/StoreAddressesType': StoreAddressesType$Operations;
        '@sage/wh-master-data/StoreChainingStoresChaining': StoreChainingStoresChaining$Operations;
        '@sage/wh-master-data/StoreChaining': StoreChaining$Operations;
        '@sage/wh-master-data/StorePutawayOrders': StorePutawayOrders$Operations;
        '@sage/wh-master-data/StoreStartLevels': StoreStartLevels$Operations;
        '@sage/wh-master-data/Store': Store$Operations;
        '@sage/wh-master-data/SupplierAdresses': SupplierAdresses$Operations;
        '@sage/wh-master-data/SupplierCompanyNames': SupplierCompanyNames$Operations;
        '@sage/wh-master-data/Supplier': Supplier$Operations;
        '@sage/wh-master-data/TariffCode': TariffCode$Operations;
        '@sage/wh-master-data/TransportMode': TransportMode$Operations;
        '@sage/wh-master-data/TransportType': TransportType$Operations;
        '@sage/wh-master-data/TruckTrackingStatus': TruckTrackingStatus$Operations;
        '@sage/wh-master-data/UnitOfMeasure': UnitOfMeasure$Operations;
        '@sage/wh-master-data/VolumeClassVolumeClassesChaining': VolumeClassVolumeClassesChaining$Operations;
        '@sage/wh-master-data/VolumeClass': VolumeClass$Operations;
        '@sage/wh-master-data/WhSiteAddressingPriorities': WhSiteAddressingPriorities$Operations;
        '@sage/wh-master-data/WhSiteIsNoWorkDays': WhSiteIsNoWorkDays$Operations;
        '@sage/wh-master-data/WhSiteSupplierBarCodes': WhSiteSupplierBarCodes$Operations;
        '@sage/wh-master-data/WhSite': WhSite$Operations;
        '@sage/wh-master-data/WorkCenter': WorkCenter$Operations;
    }
    export interface GraphApi
        extends Package,
            SageWhStructure$Package,
            SageWhSystem$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-master-data-api' {
    export type * from '@sage/wh-master-data-api-partial';
}
declare module '@sage/wh-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type {
        CompanyBindingExtension,
        CompanyExtension,
        CompanyExtension$Lookups,
        CompanyExtension$Operations,
        CompanyInputExtension,
        SiteBindingExtension,
        SiteExtension,
        SiteExtension$Lookups,
        SiteExtension$Operations,
        SiteInputExtension,
        UserBindingExtension,
        UserExtension,
        UserInputExtension,
    } from '@sage/wh-master-data-api';
    export interface Company extends CompanyExtension {}
    export interface CompanyBinding extends CompanyBindingExtension {}
    export interface CompanyInput extends CompanyInputExtension {}
    export interface Company$Lookups extends CompanyExtension$Lookups {}
    export interface Company$Operations extends CompanyExtension$Operations {}
    export interface Site extends SiteExtension {}
    export interface SiteBinding extends SiteBindingExtension {}
    export interface SiteInput extends SiteInputExtension {}
    export interface Site$Lookups extends SiteExtension$Lookups {}
    export interface Site$Operations extends SiteExtension$Operations {}
    export interface User extends UserExtension {}
    export interface UserBinding extends UserBindingExtension {}
    export interface UserInput extends UserInputExtension {}
}
