import { CacheableMemory } from "cacheable";
import { TenantAppDatasource } from "./TenantAppDatasource";
export declare class CachedTenantAppDataStore implements TenantAppDatasource {
    tenantCache: CacheableMemory;
    tenantAppsCache: CacheableMemory;
    customerCache: CacheableMemory;
    actualTenantAppDatasource: TenantAppDatasource;
    cacheTTLInMS: number;
    constructor(actualTenantAppDatasource: TenantAppDatasource, cacheTTLInMS?: number);
    getAppsOfTenant(tenantId: string): Promise<Record<string, string[]>>;
    getEmailDomainOfTenant(tenantId: string): Promise<string | undefined>;
    getCustomer(customerId: string): Promise<Record<string, string>>;
    getTenant(tenantId: string): Promise<Record<string, string>>;
}
