"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsYmlTenantAppDatasource = void 0;
const fs_1 = require("fs");
const yaml = require("js-yaml");
/***
 * Provide list of apps by reading apps.yml, used for local developer implementation
 */
class AppsYmlTenantAppDatasource {
    appsFileLocation;
    apps;
    hardcodedClusterName;
    emailDomain;
    constructor(appsFileLocation, hardcodedClusterName, emailDomain) {
        this.appsFileLocation = appsFileLocation;
        this.hardcodedClusterName = hardcodedClusterName;
        this.emailDomain = emailDomain;
    }
    async loadAppsFromFile() {
        try {
            const fileContents = await fs_1.promises.readFile(this.appsFileLocation, 'utf8');
            const parsedYaml = yaml.load(fileContents);
            this.apps = {};
            this.apps[this.hardcodedClusterName] = Object.keys(parsedYaml.apps);
        }
        catch (error) {
            console.error(`Error reading or parsing apps.yml file  ${this.appsFileLocation} .`, error);
            this.apps = {};
        }
    }
    async getAppsOfTenant(_tenantId) {
        if (!this.apps) {
            await this.loadAppsFromFile();
        }
        return this.apps || {};
    }
    async getEmailDomainOfTenant(_tenantId) {
        return this.emailDomain;
    }
    async getCustomer(customerId) {
        if (this.emailDomain) {
            return {
                id: customerId,
                emailDomain: this.emailDomain
            };
        }
        return {
            id: customerId
        };
    }
    async getTenant(tenantId) {
        return {
            id: tenantId,
            customerId: tenantId
        };
    }
}
exports.AppsYmlTenantAppDatasource = AppsYmlTenantAppDatasource;
//# sourceMappingURL=data:application/json;base64,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