import { TenantAppDatasource } from "./TenantAppDatasource";
/***
 * Provide list of apps by reading apps.yml, used for local developer implementation
 */
export declare class AppsYmlTenantAppDatasource implements TenantAppDatasource {
    private readonly appsFileLocation;
    private apps;
    private readonly hardcodedClusterName;
    private readonly emailDomain;
    constructor(appsFileLocation: string, hardcodedClusterName: string, emailDomain: string | undefined);
    private loadAppsFromFile;
    getAppsOfTenant(_tenantId: string): Promise<Record<string, string[]>>;
    getEmailDomainOfTenant(_tenantId: string): Promise<string | undefined>;
    getCustomer(customerId: string): Promise<Record<string, string>>;
    getTenant(tenantId: string): Promise<Record<string, string>>;
}
