import { AwsConfigOverride } from "../utils";
export interface SearchOption {
    noCache?: boolean;
}
export interface GetAppOfTenantRequest {
    tenantId: string;
    cluster?: string;
    option?: SearchOption;
}
export interface GetAppOfTenantCrossClusterRequest {
    tenantId: string;
    option?: SearchOption;
}
export interface GetEmailDomainOfTenant {
    tenantId: string;
    option?: SearchOption;
}
export declare class TenantAppHelper {
    private readonly tenantDatasource;
    private readonly cachedTenantDatasource;
    private readonly currentCluster;
    private constructor();
    /***
     * Return apps of tenant for a given xtrem cluster
     * @param request if request's cluster is not set we will filter apps on the current cluster
     */
    getAppsOfTenant(request: GetAppOfTenantRequest): Promise<string[]>;
    /***
     * Return a record object of apps code per cluster id for hte given tenant
     * @param request
     */
    getAppsOfTenantPerCluster(request: GetAppOfTenantCrossClusterRequest): Promise<Record<string, string[]>>;
    /***
     * Return an array of application code that represent all the apps the tenants own across all the cluster
     * @param request
     */
    getAppsCrossCluster(request: GetAppOfTenantCrossClusterRequest): Promise<string[]>;
    /***
     * Return email domain of tenant
     * @param request tenant id and options to search
     */
    getEmailDomainOfTenant(request: GetEmailDomainOfTenant): Promise<string | undefined>;
    /***
     * Return TenanAppHelper instance singleton based on param passed
     * @param awsConfig override of aws config, specify region property
     * @param tableName dynamoDB table name, should be read from xtrem config file
     * @param currentCluster cluster id used when searching only apps of the current cluster
     * @param cacheTTLInMilliSecond optional, how long(milliseconds) we keep record in memory cache, default 5 minute
     */
    static getCloudImplementation(awsConfig: AwsConfigOverride, tableName: string, currentCluster: string, cacheTTLInMilliSecond?: number): TenantAppHelper;
    /***
     * Return a local developer singleton implementation, using apps.yml to get list of apps of the tenant, assuming the tenant have them all
     * @param appsYamlPath full path to  the apps.yml file
     * @param localClusterName optional what is your cluster name, local by default
     * @param emailDomain optional what is the emailDomain of your tenant, empty by default
     *
     */
    static getLocalDeveloperImplementation(appsYamlPath: string, localClusterName?: string, emailDomain?: string): TenantAppHelper;
}
