/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),x3SystemUtils=require("../../../lib/index");describe("get user parameters values",()=>{it("Parameter = PTHDIR,  User = ROFLI defined at user level",()=>xtrem_core_1.Test.withContext(async e=>{const t=await x3SystemUtils.functions.getGeneralParameterUserValue(e,"PTHDIR","I-AD1");chai_1.assert.equal(t,"2")},{user:{email:"ROFLI@sage.com",userName:"ROFLI"}})),it("Parameter = PTHDIR,  User = DA, Site = P-A12 defined at site level",()=>xtrem_core_1.Test.withContext(async e=>{const t=await x3SystemUtils.functions.getGeneralParameterUserValue(e,"PTHDIR","P-A12");chai_1.assert.equal(t,"1")},{user:{email:"DA@sage.com",userName:"DA"}})),it("Parameter = PTHDIR,  User = DABZD defined at folder level",()=>xtrem_core_1.Test.withContext(async e=>{const t=await x3SystemUtils.functions.getGeneralParameterUserValue(e,"PTHDIR","I-AD1");chai_1.assert.equal(t,"2")},{user:{email:"DABZD@sage.com",userName:"DABZD"}})),it("Invalid Parameter = PTHDI",()=>xtrem_core_1.Test.withContext(async e=>{await chai_1.assert.isRejected(x3SystemUtils.functions.getGeneralParameterUserValue(e,"PTHDI","I-AD1"),"PTHDI General parameter does not exist")}))});
//# sourceMappingURL=user-parameters-values-test.js.map