/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),path=require("path"),index_1=require("../../../lib/nodes/index"),x3_service_option_manager_1=require("../../../lib/services/x3-service-option-manager"),adc_1=require("../../fixtures/service-options/adc"),local_taxing_1=require("../../fixtures/service-options/local-taxing"),paperless_document_exchange_1=require("../../fixtures/service-options/paperless-document-exchange"),product_version_management_1=require("../../fixtures/service-options/product-version-management"),project_management_1=require("../../fixtures/service-options/project-management"),unit_state_of_america_localization_1=require("../../fixtures/service-options/unit-state-of-america-localization");describe("Service options as activity codes tests",()=>{it("get active service options",()=>xtrem_core_1.Test.withContext(async e=>{const i=new x3_service_option_manager_1.XtremX3ServiceOptionManager(e.application);chai_1.assert.deepEqual(await i.getEnabledServiceOptions(e),[new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/adc.js"),code:"ADC",description:"ADC",isHidden:false,name:"adc",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/no-of-analytical-dimensions.js"),code:"ANA",description:"No of analytical dimensions",isHidden:false,name:"noOfAnalyticalDimensions",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/safe-x3-was.js"),code:"AYT",description:"Safe X3 WAS",isHidden:false,name:"safeX3Was",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/belgian-2815-form-1.js"),code:"BE281",description:"Belgian 2815 form 1",isHidden:false,name:"belgian2815Form1",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/concessions.js"),code:"CCN",description:"Concessions",isHidden:false,name:"concessions",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/configurator.js"),code:"CFG",description:"Configurator",isHidden:false,name:"configurator",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/cash-forecast-management.js"),code:"CFOM",description:"Cash forecast management",isHidden:false,name:"cashForecastManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/das-2.js"),code:"DAS",description:"Das 2",isHidden:false,name:"das2",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/eu-exchange-declaration.js"),code:"DEB",description:"Eu exchange declaration",isHidden:false,name:"euExchangeDeclaration",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/electronic-signature.js"),code:"DKS",description:"Electronic signature",isHidden:false,name:"electronicSignature",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/product-version-management.js"),code:"ECC",description:"Product version management",isHidden:false,name:"productVersionManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/paperless-document-exchange.js"),code:"EDIX3",description:"Paperless document exchange (EDI)",isHidden:false,name:"paperlessDocumentExchange",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/efat-electronic-invoice.js"),code:"EFAT",description:"EFAT electronic invoice",isHidden:false,name:"efatElectronicInvoice",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/location-management.js"),code:"EMP",description:"Location management",isHidden:false,name:"locationManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/economic-operator-registration-and-identification.js"),code:"EORI",description:"Economic operator registration and identification",isHidden:false,name:"economicOperatorRegistrationAndIdentification",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/factoring-management.js"),code:"FCT",description:"Factoring management",isHidden:false,name:"factoringManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/fee-declaration.js"),code:"FEE2",description:"Fee declaration",isHidden:false,name:"feeDeclaration",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/reminder-and-late-payment-mana.js"),code:"FUP",description:"Reminder and late payment management",isHidden:false,name:"reminderAndLatePaymentMana",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/generic-finite-scheduler-advanced.js"),code:"GFSA",description:"Generic finite scheduler advanced",isHidden:false,name:"genericFiniteSchedulerAdvanced",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/cancellation-invoice.js"),code:"INVCA",description:"Cancellation invoice",isHidden:false,name:"cancellationInvoice",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/belgian-localization.js"),code:"KBE",description:"Belgian localization",isHidden:false,name:"belgianLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/german-localization.js"),code:"KDE",description:"German localization",isHidden:false,name:"germanLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/french-localization.js"),code:"KFR",description:"French localization",isHidden:false,name:"frenchLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/italian-localization.js"),code:"KIT",description:"Italian localization",isHidden:false,name:"italianLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/polish-localization.js"),code:"KPL",description:"Polish localization",isHidden:false,name:"polishLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/portuguese-localization.js"),code:"KPO",description:"Portuguese localization",isHidden:false,name:"portugueseLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/spanish-localization.js"),code:"KSP",description:"Spanish localization",isHidden:false,name:"spanishLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/swiss-localization.js"),code:"KSW",description:"Swiss localization",isHidden:false,name:"swissLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/unit-state-of-america-localization.js"),code:"KUS",description:"Unit-State-Of-America localization",isHidden:false,name:"unitStateOfAmericaLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/south-african-localization.js"),code:"KZA",description:"South-African localization",isHidden:false,name:"southAfricanLocalization",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/loan-management.js"),code:"LND",description:"Loan management",isHidden:false,name:"loanManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/lot-management.js"),code:"LOT",description:"Lot management",isHidden:false,name:"lotManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/local-taxing.js"),code:"LTA",description:"Local taxing",isHidden:false,name:"localTaxing",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/maximum-periods.js"),code:"MAXPD",description:"Maximum periods",isHidden:false,name:"maximumPeriods",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/murano-payroll.js"),code:"MURAN",description:"Murano payroll",isHidden:false,name:"muranoPayroll",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/container-management.js"),code:"MWC",description:"Container management",isHidden:false,name:"containerManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/weighing-stations.js"),code:"MWM",description:"Weighing stations",isHidden:false,name:"weighingStations",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/product-design.js"),code:"NPI",description:"Product design",isHidden:false,name:"productDesign",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/payment-balance-declaration.js"),code:"PBDPO",description:"Payment balance declaration",isHidden:false,name:"paymentBalanceDeclaration",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/project-management.js"),code:"PJM",description:"Project Management",isHidden:false,name:"projectManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/purchase-discount-or-charge-1.js"),code:"PP1",description:"Purchase discount or charge1",isHidden:false,name:"purchaseDiscountOrCharge1",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/purchase-discount-or-charge-2.js"),code:"PP2",description:"Purchase discount or charge2",isHidden:false,name:"purchaseDiscountOrCharge2",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/purchase-discount-or-charge-3.js"),code:"PP3",description:"Purchase discount or charge3",isHidden:false,name:"purchaseDiscountOrCharge3",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/max-purchasing-charge-discount.js"),code:"PPR",description:"Max purchasing charge discount",isHidden:false,name:"maxPurchasingChargeDiscount",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/prospect-management.js"),code:"PPT",description:"Prospect management",isHidden:false,name:"prospectManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/pre-consolidation.js"),code:"PRCSL",description:"Pre consolidation",isHidden:false,name:"preConsolidation",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/prepayment-invoice-management.js"),code:"PREPM",description:"Prepayment invoice management",isHidden:false,name:"prepaymentInvoiceManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/regional-taxes.js"),code:"PTX",description:"Regional taxes",isHidden:false,name:"regionalTaxes",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/sales-rep-1.js"),code:"RE1",description:"Sales rep 1",isHidden:false,name:"salesRep1",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/sales-rep-2.js"),code:"RE2",description:"Sales rep 2",isHidden:false,name:"salesRep2",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/customer-sales-reps.js"),code:"REC",description:"Customer sales reps",isHidden:false,name:"customerSalesReps",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/sales-rep.js"),code:"REP",description:"Sales rep",isHidden:false,name:"salesRep",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/rex-custom-systems.js"),code:"REX",description:"REX Customs System",isHidden:false,name:"rexCustomSystems",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/s-1099.js"),code:"S1099",description:"S 1099",isHidden:false,name:"s1099",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/sdd-management.js"),code:"SDD",description:"SDD management",isHidden:false,name:"sddManagement",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/max-no-entered-inv-elts-1.js"),code:"SFI",description:"Max no entered inv elts1",isHidden:false,name:"maxNoEnteredInvElts1",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/no-of-distributed-line-invoicing-elements.js"),code:"SFL",description:"No of distributed line invoicing elements",isHidden:false,name:"noOfDistributedLineInvoicingElements",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/sales-discount-or-charge-1.js"),code:"SP1",description:"Sales discount or charge1",isHidden:false,name:"salesDiscountOrCharge1",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/sales-discount-or-charge-2.js"),code:"SP2",description:"Sales discount or charge2",isHidden:false,name:"salesDiscountOrCharge2",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/sales-discount-or-charge-3.js"),code:"SP3",description:"Sales discount or charge3",isHidden:false,name:"salesDiscountOrCharge3",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/max-sales-charge-discount.js"),code:"SPR",description:"Max sales charge discount",isHidden:false,name:"maxSalesChargeDiscount",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/customer-statistical-groups.js"),code:"STC",description:"Customer statistical groups",isHidden:false,name:"customerStatisticalGroups",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/product-statistical-groups.js"),code:"STI",description:"Product statistical groups",isHidden:false,name:"productStatisticalGroups",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/cost-and-revenue-accruals.js"),code:"SVC",description:"Cost and revenue accruals",isHidden:false,name:"costAndRevenueAccruals",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/international-transfers.js"),code:"VII",description:"International transfers",isHidden:false,name:"internationalTransfers",status:"released"}),new xtrem_core_1.ServiceOption({__filename:path.join(__dirname,"../../fixtures/service-options/withholding-tax-management.js"),code:"WTHMG",description:"Withholding tax management",isHidden:false,name:"withholdingTaxManagement",status:"released"})])})),it("can check if service options is active, even if not part of application.",()=>xtrem_core_1.Test.withContext(async e=>{const i=new x3_service_option_manager_1.XtremX3ServiceOptionManager(e.application);chai_1.assert.isTrue(await i.isServiceOptionEnabled(e,adc_1.adc)),chai_1.assert.isTrue(await i.isServiceOptionEnabled(e,product_version_management_1.ecc)),chai_1.assert.isTrue(await i.isServiceOptionEnabled(e,project_management_1.ProjectManagementActivityCode)),chai_1.assert.isTrue(await i.isServiceOptionEnabled(e,unit_state_of_america_localization_1.UnitStateOfAmericaLocalization)),chai_1.assert.isTrue(await i.isServiceOptionEnabled(e,local_taxing_1.LocalTaxing)),chai_1.assert.isTrue(await i.isServiceOptionEnabled(e,paperless_document_exchange_1.paperlessDocumentExchange)),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"PP4",name:"purchaseDiscountOrCharge4",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"PP5",name:"purchaseDiscountOrCharge5",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"PP6",name:"purchaseDiscountOrCharge6",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"PP7",name:"purchaseDiscountOrCharge7",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"PP8",name:"purchaseDiscountOrCharge8",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"PP9",name:"purchaseDiscountOrCharge9",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"SP4",name:"salesDiscountOrCharge4",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"SP5",name:"salesDiscountOrCharge5",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"SP6",name:"salesDiscountOrCharge6",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"SP7",name:"salesDiscountOrCharge7",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"SP8",name:"salesDiscountOrCharge8",isHidden:false}))),chai_1.assert.isFalse(await i.isServiceOptionEnabled(e,new xtrem_core_1.ServiceOption({__filename,status:"released",code:"SP9",name:"salesDiscountOrCharge9",isHidden:false})))})),it("can get inactive properties from external storage manager.",()=>xtrem_core_1.Test.withContext(e=>{const i=e.application.getFactoryByConstructor(index_1.SysSyracusMethod),a=(i?.externalStorageManager).getInactiveProperties(e).map(e=>e.name);chai_1.assert.deepEqual(a,["biUserProfile"])})),it("cannot get value of inactive property.",()=>xtrem_core_1.Test.withContext(async e=>{const i=await e.query(index_1.SysSyracusMethod).toArray();await(0,xtrem_core_1.asyncArray)(i).forEach(async e=>{chai_1.assert.strictEqual("",await e.biUserProfile,"SysSyracusMethod.biUserProfile string value must be empty for inactive property")})}))});
//# sourceMappingURL=service-options-test.js.map