/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),x3SystemUtils=require("../../../lib/index");describe("get general parameters values",()=>{it("Parameter = ACCWIPEOA,  Site = P-A12 defined at site level",()=>xtrem_core_1.Test.withContext(async e=>{const t=await x3SystemUtils.functions.getGeneralParameterValue(e,"P-A12","ACCWIPEOA");chai_1.assert.equal(t,"WIP")})),it("Parameter = ACCWIPEOA,  Company = F-RR1 defined at company level",()=>xtrem_core_1.Test.withContext(async e=>{const t=await x3SystemUtils.nodes.SysGeneralParameter.readParameterValueBoolean(e,{parameterCode:"ACCPERCTL",level:"company",code:"F-RR1"});chai_1.assert.equal(t,false)})),it("Parameter = AUSCRMH,  Folder = X3RBTRUN defined at company level",()=>xtrem_core_1.Test.withContext(async e=>{const t=await x3SystemUtils.functions.getGeneralParameterValue(e,null,"AUSCRMH","folder");chai_1.assert.equal(t,"J-1")})),it("Invalid Parameter = AUSCRM",()=>xtrem_core_1.Test.withContext(async e=>{await chai_1.assert.isRejected(x3SystemUtils.nodes.SysGeneralParameter.readParameterValueString(e,{parameterCode:"AUSCRM"}),"AUSCRM General parameter does not exist")}))});
//# sourceMappingURL=general-parameters-values-test.js.map