/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai");describe("Allowed sites tests",()=>{it("returns null if all sites are allowed",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.isNull((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","")).sites)},{user:{email:"ADMIN@sage.com",userName:"ADMIN"}})),it("returns empty if no sites are allowed",()=>xtrem_core_1.Test.withContext(async e=>{const s=await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","");chai_1.assert.deepEqual(s.sites,[])},{user:{email:"CONS@sage.com",userName:"CONS"}})),it.skip("returns all profile sites if option is empty",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode4","")).sites,["ZA001","ZCOF1"])},{user:{email:"ADC@sage.com",userName:"ADC"}})),it.skip("returns only profile sites matching option",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode3","D")).sites,["ZA001","ZCOF1"]),chai_1.assert.deepEqual((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode3","C")).sites,["ZA001"]),chai_1.assert.deepEqual((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode3","A")).sites,[])},{user:{email:"ZUSR1@sage.com",userName:"ZUSR1"}}))});
//# sourceMappingURL=allowed-sites-test.js.map