/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai");describe("allowed access codes tests",()=>{it("returns null if all access codes are allowed",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.isNull(await xtrem_core_1.Context.accessRightsManager.getUserAccessCodes(e))},{user:{email:"ADMIN@sage.com",userName:"ADMIN"}})),it.skip("returns empty if no access codes are allowed",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual(await xtrem_core_1.Context.accessRightsManager.getUserAccessCodes(e),[])},{user:{email:"AR@sage.com",userName:"AR"}})),it("returns only authorized profile access codes",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual((await xtrem_core_1.Context.accessRightsManager.getUserAccessCodes(e))?.map(e=>e.accessCode),["ADCOADERHC","ADCOADETRE","ADCOADETRH","RESSADDO","RESSMAGA","STOCK"])},{user:{email:"WH@sage.com",userName:"WH "}}))});
//# sourceMappingURL=allowed-access-codes-test.js.map