/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),restrictedUser={email:"AR@sage.com",userName:"AR"};describe("access rights tests",()=>{it("Admin user has all access",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","create")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","testQuery")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","testMutation")).status,"authorized")},{user:{email:"ADMIN@sage.com",userName:"ADMIN"}})),it("Empty options",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode2","")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode2","create")).status,"unauthorized")},{user:restrictedUser})),it("SysAccess denied (any crud op)",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode3","")).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode3","create")).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","testQuery")).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","testMutation")).status,"unauthorized")},{user:restrictedUser})),it("SysAccess denied (any custom op)",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","testQuery")).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","testMutation")).status,"unauthorized")},{user:restrictedUser})),it("AllAuthorizedFunctions = true",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","")).status,"authorized")},{user:{email:"ADMIN@sage.com",userName:"ADMIN"}})),it("gives full access if the node does not have an authorizationCode",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNodeNoAuthCode","read")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNodeNoAuthCode","update")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNodeNoAuthCode","create")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNodeNoAuthCode","delete")).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNodeNoAuthCode","lookup")).status,"authorized")},{user:restrictedUser})),it("Returns all permission options",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual(await xtrem_core_1.Context.accessRightsManager.getPermissions(e,"GESATB"),["create","read","update","delete","lookup"])})),it("Returns empty permission array",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual(await xtrem_core_1.Context.accessRightsManager.getPermissions(e,"GESATB"),[])},{user:restrictedUser})),it('Returns only ["read", "lookup"] if function is allowed, but no options are set',()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual(await xtrem_core_1.Context.accessRightsManager.getPermissions(e,"GESFUP"),["read","lookup"])},{user:restrictedUser})),it("Returns allowed permission array",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.deepEqual(await xtrem_core_1.Context.accessRightsManager.getPermissions(e,"GESBPC"),["read","lookup","create","update","delete"])},{user:restrictedUser})),it("determines Admin user has all access to ADC functions",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSCS"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSIS"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSALR"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSLPNA"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSLPNG"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSMO"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSMR"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSSL"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSPRH"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"INQSTOLOC"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"INQSTOLPN"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"INQSTOPRO"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSCSL"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSACC"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSST"})).status,"authorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSLPNU"})).status,"authorized")},{user:{email:"ADMIN@sage.com",userName:"ADMIN"}})),it("determines a user (DA) has no access to ADC functions",()=>xtrem_core_1.Test.withContext(async e=>{chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSCS"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSIS"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSALR"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSLPNA"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSLPNG"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSMO"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSMR"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSSL"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSPRH"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"INQSTOLOC"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"INQSTOLPN"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"INQSTOPRO"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSCSL"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSACC"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSSST"})).status,"unauthorized"),chai_1.assert.equal((await xtrem_core_1.Context.accessRightsManager.getUserAccessFor(e,"TestAccessNode1","",{authorizationCode:"CWSLPNU"})).status,"unauthorized")},{user:restrictedUser}))});
//# sourceMappingURL=access-rights-test.js.map