// From file: @sage/xtrem-x3-system-utils/build/index.d.ts
declare module '@sage/xtrem-x3-system-utils/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/index' {
	import '@sage/xtrem-x3-syracuse';
	import * as datatypes from '@sage/xtrem-x3-system-utils/lib/data-types/index';
	import * as enums from '@sage/xtrem-x3-system-utils/lib/enums/index';
	import * as functions from '@sage/xtrem-x3-system-utils/lib/functions/index';
	import * as nodes from '@sage/xtrem-x3-system-utils/lib/nodes/index';
	import * as serviceOptions from '@sage/xtrem-x3-system-utils/lib/service-options/index';
	import { allowedAccessCodes, getSizingFromActivityCode, UserAccessCode } from '@sage/xtrem-x3-system-utils/lib/services/index';
	export { allowedAccessCodes, datatypes, enums, functions, getSizingFromActivityCode, nodes, serviceOptions, UserAccessCode, };
	export function updateContext(): void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/services/x3-service-option-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-service-option-manager' {
	import { Context, ServiceOption, ServiceOptionManager } from '@sage/xtrem-core';
	export class XtremX3ServiceOptionManager extends ServiceOptionManager {
	    isServiceOptionEnabled(context: Context, serviceOption: ServiceOption): Promise<boolean>;
	    setServiceOptionActiveState(): Promise<void>;
	    private getLanguageFromLocale;
	    /**
	     * Get the activity code etag from the database (max UPDDATTIM_0)
	     * @param context
	     * @returns
	     */
	    private static getActivityCodeEtag;
	    private static activityCodeEtag;
	    /**
	     * Verify the activity code etag from the database
	     * @param context
	     * @returns
	     */
	    private static verifyActivityCodeEtag;
	    private static lastCacheCheck;
	    /**
	     * Verify the activity code cache is still valid
	     * @param context
	     * @returns
	     */
	    private static verifyActivityCodeCache;
	    private loadCurrentLanguageCode;
	    private loadSizingActivityCodes;
	    getEnabledServiceOptions(context: Context): Promise<ServiceOption[]>;
	}
	/**
	 * Get maxRepeat of denormalized node based on sizing activity code
	 * @param context
	 * @param activityCode
	 * @returns
	 */
	export function getSizingFromActivityCode(context: Context, activityCode: string): number;
	//# sourceMappingURL=x3-service-option-manager.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/services/x3-package-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-package-manager' {
	import { Application, Context, CreateSchemaOptions, Package, PackageManager } from '@sage/xtrem-core';
	export class X3PackageManager extends PackageManager {
	    readonly application: Application;
	    constructor(application: Application);
	    /**
	     * Get the package etag from the database (max UPDDATTIM_0)
	     * @param context
	     * @returns
	     */
	    private static getPackageEtag;
	    private static packageEtag;
	    /**
	     * Verify the package etag from the database
	     * @param context
	     * @returns
	     */
	    private static verifyPackageEtag;
	    private static lastCacheCheck;
	    /**
	     * Verify the package cache is still valid
	     * @param context
	     * @returns
	     */
	    private static verifyPackageCache;
	    getActivePackageNames(context: Context): Promise<string[]>;
	    getCurrentVersion(pack: Package, _context?: Context): Promise<string | undefined>;
	    validatePackageVersions(): Promise<void>;
	    createSqlSchemaAndTables(_options?: CreateSchemaOptions): Promise<boolean>;
	    ensureSchemaExists(_options?: CreateSchemaOptions): Promise<void>;
	    createOrUpgradePackageAllocations(_context: Context, _activePackageNames?: string[]): Promise<void>;
	}
	//# sourceMappingURL=x3-package-manager.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/services/x3-localization-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-localization-manager' {
	import { Context } from '@sage/xtrem-core';
	import { X3LocalizationManager } from '@sage/xtrem-x3-gateway';
	export class XtremX3LocalizationManager implements X3LocalizationManager {
	    private localeLangMap;
	    private folderDefaultLangMap;
	    initializeManager(): void;
	    getDefaultTenantLocale(): string;
	    isMasterLocale(): boolean;
	    createTenantLocale(): void;
	    getLanguageFromLocale(context: Context, locale: string, folderName: string): Promise<string>;
	    getFolderDefaultLanguage(context: Context): Promise<string>;
	}
	//# sourceMappingURL=x3-localization-manager.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/services/x3-client-settings-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-client-settings-manager' {
	import { ClientSettingsManager } from '@sage/xtrem-core';
	export const clientSettingsManager: ClientSettingsManager;
	//# sourceMappingURL=x3-client-settings-manager.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/services/x3-access-rights-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-access-rights-manager' {
	import { AccessRightsManager, ActivityInfo, AnyFilterObject, Context, Dict, NodeFactory, UserAccess, UserInfo } from '@sage/xtrem-core';
	import { AsyncResponse } from '@sage/xtrem-shared';
	import { UserAccessCode } from '@sage/xtrem-x3-gateway';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	export { UserAccessCode };
	interface AccessRightDescriptor {
	    userCode: string;
	    profile: string;
	    accessCodes: UserAccessCode[] | null;
	    allFunctionsAllowed: boolean;
	    optionsByFunctionCode: Dict<string>;
	    sitesByFunctionCode: Dict<string[] | null>;
	    inherited?: {
	        lookup?: Dict<string[]>;
	    };
	}
	interface GetUserAccessOptions {
	    authorizationCode?: string;
	    parentNodeName?: string;
	    visitedNodes?: Set<string>;
	}
	export class XtremX3AccessRightsManager implements AccessRightsManager {
	    private static _getUserAccessCodes;
	    private static allFunctionVariables;
	    private static getAllVariables;
	    private static _getFunctionalAuthorization;
	    static getUsername(context: Context): Promise<string>;
	    private static _loadRightsFromDb;
	    /**
	     * Get the rights etag from the database (RIGHTSETAG parameter value)
	     * @param context
	     * @returns
	     */
	    private static getRightsEtag;
	    private static rightsEtag;
	    /**
	     * Verify the rights etag from the database
	     * @param context
	     * @returns
	     */
	    private static verifyRightsEtag;
	    private static lastCacheCheck;
	    /**
	     * Verify the user cache is still valid
	     * @param context
	     * @returns
	     */
	    private static verifyUserCache;
	    private static loadRightsFromDbPromises;
	    private static _getAccessRights;
	    static getProfilesSitesByFunctionCode(context: Context, profile: string, functionCode: string): Promise<{
	        site: {
	            code: string;
	        } | null;
	        options: string;
	        profile: {
	            profile: string;
	        };
	        function: {
	            internal: string;
	        };
	    }[]>;
	    private static getSiteCodes;
	    private static readonly mutableParentsCache;
	    private static getMutableParents;
	    /**
	     * Gets parent nodes excluding self-references and system properties
	     */
	    private static getParentNodes;
	    /**
	     * Checks if factory provides site information
	     */
	    private static factoryProvidesSite;
	    /**
	     * Gets inferred access without site restrictions (simpler case)
	     */
	    private getInferredAccessWithoutSites;
	    /**
	     * Gets inferred access with site aggregation (complex case)
	     */
	    private getInferredAccessWithSiteAggregation;
	    /**
	     * Determines lookup access for a factory based on referring properties and site aggregation.
	     */
	    private getReferringPropertiesLookupAccess;
	    /**
	     * Gets inferred lookup access through parent nodes
	     */
	    private getInferredLookupAccess;
	    static getInheritedAccess(context: Context, factory: NodeFactory, inheritedFromFunctions: string[], ard: AccessRightDescriptor): Promise<UserAccess>;
	    static getInheritedLookupAccess(context: Context, factory: NodeFactory, ard: AccessRightDescriptor): AsyncResponse<UserAccess>;
	    /**
	     * Determines lookup access for a factory
	     * Lookup access can be granted through:
	     * 1. Parent node access (when called from a lookup context)
	     * 2. Direct read access on the target node
	     * 3. Inferred access through parent nodes
	     */
	    getUserAccessForLookup(context: Context, factory: NodeFactory, ard: AccessRightDescriptor, options?: GetUserAccessOptions): Promise<UserAccess>;
	    static verifyKeyFunction(context: Context, functionCode?: string): boolean;
	    /**
	     * Creates a UserAccess object with default values
	     */
	    private static createUserAccess;
	    /**
	     * Finds custom operation (query or mutation) by name
	     */
	    private static findCustomOperation;
	    /**
	     * Determines the access context (property, operation, or standard CRUD)
	     */
	    private static determineAccessContext;
	    /**
	     * Extracts access codes from access rights descriptor
	     */
	    private static extractAccessCodes;
	    /**
	     * Checks if property allows lookup access
	     */
	    private static isPropertyLookupAllowed;
	    /**
	     * Handles access checks for property access
	     */
	    private handlePropertyAccess;
	    /**
	     * Gets option code for custom operations
	     */
	    private static getCustomOperationOptionCode;
	    /**
	     * Determines the operation option code (C, M, S, or '')
	     */
	    private static determineOperationOptionCode;
	    /**
	     * Checks if operation is allowed based on function options
	     */
	    private static isOperationAllowed;
	    /**
	     * Gets access from vital parent if applicable
	     * @param context
	     * @param factory
	     * @param operationName
	     * @returns
	     */
	    private getVitalParentAccess;
	    /**
	     * Handles access checks for function/operation access
	     */
	    private handleFunctionAccess;
	    getUserAccess(context: Context, nodeName: string, propertyOrOperation?: string, options?: GetUserAccessOptions): Promise<UserAccess>;
	    /**
	     * Returns whether a user (from his/her user code) can access a function (from its code)
	     */
	    getUserAccessFor(context: Context, nodeName: string, propertyOrOperation?: string, options?: GetUserAccessOptions): Promise<UserAccess>;
	    /**
	     * Gets the list of access codes that the user is allowed to access
	     *
	     * @param context
	     * @returns the list of access codes if controlled, null if the user can see all access codes.
	     */
	    getUserAccessCodes(context: Context): Promise<UserAccessCode[] | null>;
	    /**
	     * Returns whether a user (from his/her user code) can access a property (from its accessCode)
	     *
	     * @param {Context} context
	     * @param {string} accessCode
	     * @returns {boolean}
	     * @memberof X3AccessRightsManager
	     */
	    isAccessCodeAvailable(context: Context, accessCode: string): Promise<boolean>;
	    getOperationSecurityFilter(context: Context, factory: NodeFactory, operation: string): Promise<AnyFilterObject | undefined>;
	    /**
	     * Returns the user code for a given login
	     *
	     * @param {Context} context
	     * @param {string} code
	     */
	    getUser(context: Context, code: string): Promise<UserInfo>;
	    createAdminUser(): Promise<void>;
	    createRequiredUsers(): void;
	    ensureAdminPersonaCreated(): UserInfo;
	    getCurrentUser(context: Context): Promise<UserInfo>;
	    getUserNode(): typeof x3SystemUtils.nodes.SysUser;
	    getPermissions(context: Context, activity: string): Promise<string[]>;
	    createActivities(): Promise<void>;
	    updateActivities(): Promise<void>;
	    deleteActivities(): Promise<void>;
	    getActivityNode(): typeof x3SystemUtils.nodes.SysActivityCode;
	    getActivitiesInfo(): ActivityInfo[];
	    supportsPersona(): boolean;
	    getPersonaUser(): UserInfo | null;
	    getDemoPersonas(): UserInfo[];
	    invalidateAuthorizationCache(context: Context): Promise<void>;
	    /**
	     * Returns whether the 'Authorization access control' service option is enabled
	     */
	    isAuthorizationServiceOptionEnabled(_context: Context): AsyncResponse<boolean>;
	    hasLookupAccess(nodeName: string): boolean;
	}
	export const accessRightsManager: XtremX3AccessRightsManager;
	export function allowedAccessCodes(context: Context): Promise<string[] | null>;
	//# sourceMappingURL=x3-access-rights-manager.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/services/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-access-rights-manager';
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-client-settings-manager';
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-localization-manager';
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-package-manager';
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-service-option-manager';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/service-options/sys-business-intelligence.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/service-options/sys-business-intelligence' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const sysBusinessIntelligenceActivityCode: ServiceOption;
	//# sourceMappingURL=sys-business-intelligence.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/service-options/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/service-options/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/service-options/sys-business-intelligence';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-utility.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-utility' {
	import { Context, Node } from '@sage/xtrem-core';
	export interface NodeKeyInfo {
	    nodeName: string;
	    key: string;
	}
	export class SysUtility extends Node {
	    private static parsePropertyValue;
	    private static getMainNodeNameFromTableName;
	    /**
	     * Returns the node key using the table name and X3 key.
	     * @param context
	     * @param tableName
	     * @param x3Names
	     * @param source
	     * @returns
	     */
	    private static getNodeKeyFromTableName;
	    private static functionCache;
	    private static functionEtag;
	    private static functionLastCheck;
	    private static validateFunctionCache;
	    /**
	     * Retrieves the table name from the function code.
	     * The function code is used to find the object code, which is then used to find the table name.
	     * The result is cached to improve performance.
	     * @param context
	     * @param folderName
	     * @param functionCode
	     * @returns
	     */
	    private static getTableNameFromFunctionCode;
	    /**
	     * Retrieves the node key using the function code and X3 key.
	     * The function code is used to find the table name, which is then used to find the node key.
	     * @param context
	     * @param functionCode
	     * @param x3Names
	     * @returns
	     */
	    private static getClassicFunctionKey;
	    private static representationCache;
	    private static representationEtag;
	    private static representationLastCheck;
	    private static validateRepresentationCache;
	    /**
	     * Retrieves the table name from the representation code.
	     * The representation code is used to find the class code, which is then used to find the table name.
	     * @param context
	     * @param folderName
	     * @param representationCode
	     * @returns
	     */
	    private static getTableNameFromRepresentationCode;
	    /**
	     * Retrieves the node key using the representation code and X3 key.
	     * The representation and class code is used to find the table name, which is then used to find the node key.
	     * @param context
	     * @param representationCode
	     * @param x3Names
	     * @returns
	     */
	    private static getRepresentationKey;
	    /**
	     * Returns the node key using the function code or representation code and X3 key.
	     * @param context
	     * @param input
	     * @returns
	     */
	    static parseKey(context: Context, input: string): Promise<NodeKeyInfo>;
	}
	//# sourceMappingURL=sys-utility.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-user.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user' {
	import { BinaryStream, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL columnName: AUTILIS */
	export class SysUser extends Node {
	    /** 4GL columnName: ENAFLG */
	    readonly activeInSelec: Promise<boolean | null>;
	    /** 4GL columnName: NOMUSR */
	    readonly name: Promise<string>;
	    /** 4GL columnName: INTUSR */
	    readonly nameDescription: Promise<string>;
	    /** 4GL columnName: USR */
	    readonly code: Promise<string>;
	    /** 4GL columnName: ALLACS */
	    readonly allAccessCodes: Promise<boolean | null>;
	    /** 4GL columnName: USREXT */
	    readonly externalUser: Promise<boolean | null>;
	    /** 4GL columnName: FNCCOD */
	    readonly functions: Promise<string>;
	    /** 4GL columnName: CODMET */
	    readonly profession: Reference<x3SystemUtils.nodes.SysSyracusMethod | null>;
	    /** 4GL columnName: PRFFCT */
	    readonly functionProfile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile | null>;
	    /** 4GL columnName: ADDEML */
	    readonly email: Promise<string>;
	    readonly displayName: Promise<string>;
	    /** 4GL columnName: LOGIN */
	    readonly login: Promise<string>;
	    readonly access: Reference<x3SystemUtils.nodes.SysAccess | null>;
	    /** 4GL columnName: ARCPRF */
	    readonly profile: Promise<string>;
	    /** 4GL columnName: AUSPIC */
	    readonly _image: Reference<x3SystemUtils.nodes.SysImage | null>;
	    readonly photo: Promise<BinaryStream | null>;
	}
	//# sourceMappingURL=sys-user.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-user-parameter-value.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-parameter-value' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ADOVALAUS */
	export class SysUserParameterValue extends Node {
	    /** 4GL code: CODUSR */
	    readonly user: Reference<x3SystemUtils.nodes.SysUser | null>;
	    /** 4GL code: PARAM */
	    readonly description: Promise<string>;
	    /** 4GL code: VALEUR */
	    readonly value: Promise<string>;
	    /** 4GL code: JEU */
	    readonly defaultSetOfValues: Reference<x3SystemUtils.nodes.SysMiscellaneousTable | null>;
	}
	//# sourceMappingURL=sys-user-parameter-value.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-user-function-profile.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-function-profile' {
	import { Collection, Node } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: AFCTFCT */
	export class SysUserFunctionProfile extends Node {
	    /** 4GL code: PRFCOD */
	    readonly profile: Promise<string>;
	    /** 4GL code: INTPRF */
	    readonly description: Promise<string>;
	    /** 4GL code: ALLACS */
	    readonly allAccessAllowed: Promise<boolean | null>;
	    /** 4GL code: DIFIMP */
	    readonly deferredPrint: Promise<boolean | null>;
	    /** 4GL code: FILTRE */
	    readonly reportFilters: Promise<string>;
	    /** 4GL code: ALLFCT */
	    readonly allAuthorizedFunctions: Promise<boolean | null>;
	    /** 4GL code: FLGPOR */
	    readonly fixedDashboard: Promise<boolean | null>;
	    readonly defaultSites: Collection<x3SystemUtils.nodes.SysUserFunctionProfileUserProfileDefaultSites>;
	}
	//# sourceMappingURL=sys-user-function-profile.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-user-function-profile-user-profile-default-sites.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-function-profile-user-profile-default-sites' {
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageXtremX3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	export class SysUserFunctionProfileUserProfileDefaultSites extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly profile: Promise<string>;
	    readonly _denormalizedParent: Reference<sageXtremX3SystemUtils.nodes.SysUserFunctionProfile>;
	    readonly site: Reference<sageXtremX3SystemUtils.nodes.SysSite | null>;
	}
	//# sourceMappingURL=sys-user-function-profile-user-profile-default-sites.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-user-access.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-access' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ACCES */
	export class SysUserAccess extends Node {
	    /** 4GL code: CODACC */
	    readonly access: Reference<x3SystemUtils.nodes.SysAccess>;
	    /** 4GL columnName: USR */
	    readonly user: Reference<x3SystemUtils.nodes.SysUser>;
	    /** 4GL columnName: CONSUL */
	    readonly inquiry: Promise<boolean | null>;
	    /** 4GL columnName: EXEC */
	    readonly execution: Promise<boolean | null>;
	    /** 4GL columnName: MODIF */
	    readonly modification: Promise<boolean | null>;
	    /** 4GL columnName: PRFCOD */
	    readonly profile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile | null>;
	}
	//# sourceMappingURL=sys-user-access.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-syracus-method.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-syracus-method' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ASYRMET */
	export class SysSyracusMethod extends Node {
	    /** 4GL code: CODMET */
	    readonly profession: Promise<string>;
	    /** 4GL code: INTMET */
	    readonly description: Promise<string>;
	    /** 4GL code: PRFFCT */
	    readonly functionProfile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile>;
	    /** 4GL code: USRBI */
	    readonly biUserProfile: Promise<string>;
	}
	//# sourceMappingURL=sys-syracus-method.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-site.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-site' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: FACILITY */
	export class SysSite extends Node {
	    /** 4GL code: FCY */
	    readonly code: Promise<string>;
	    /** 4GL code: FCYNAM */
	    readonly name: Promise<string>;
	    /** 4GL code: WRHFLG */
	    readonly isStockSite: Promise<boolean>;
	    /** 4GL code: LEGCPY */
	    readonly legalCompany: Reference<x3SystemUtils.nodes.SysCompany>;
	}
	//# sourceMappingURL=sys-site.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-package.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-package' {
	import { Node } from '@sage/xtrem-core';
	/** 4GL code: FACILITY */
	export class SysPackage extends Node {
	    readonly name: Promise<string>;
	    readonly description: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=sys-package.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-miscellaneous-tables.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables' {
	import { Collection, integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL columnName: ATABTAB */
	export class SysMiscellaneousTables extends Node {
	    /** 4GL columnName: NUMTAB */
	    readonly glossaryId: Promise<integer>;
	    /** 4GL columnName: NUMCAR */
	    readonly tableNumber: Promise<string>;
	    /** 4GL columnName: LNGDES */
	    readonly description: Promise<string>;
	    /** 4GL columnName: SHODES */
	    readonly shortDescription: Promise<string>;
	    /** 4GL columnName: CODACT */
	    readonly activityCode: Reference<x3SystemUtils.nodes.SysActivityCode | null>;
	    /** 4GL columnName: ACS */
	    readonly access: Reference<x3SystemUtils.nodes.SysAccess | null>;
	    /** 4GL columnName: MODULE */
	    readonly module: Promise<x3SystemUtils.enums.SysModuleTable | null>;
	    /** 4GL columnName: DEPNUM */
	    readonly dependency: Reference<SysMiscellaneousTables | null>;
	    /** 4GL columnName: LNGFLG */
	    readonly modifiableLength: Promise<boolean | null>;
	    /** 4GL columnName: LNG */
	    readonly length: Promise<integer>;
	    /** 4GL columnName: FLGSOC */
	    readonly companyFilter: Promise<boolean | null>;
	    /** 4GL columnName: FLGLEG */
	    readonly filterLegislation: Promise<boolean | null>;
	    /** 4GL columnName: FLGENA */
	    readonly activeFlag: Promise<boolean | null>;
	    /** 4GL columnName: ALPDES1 */
	    readonly alpha1: Promise<string>;
	    /** 4GL columnName: CODTYP1 */
	    readonly type1: Promise<string>;
	    /** 4GL columnName: SUP1 */
	    readonly option1: Promise<string>;
	    /** 4GL columnName: ALPDES2 */
	    readonly alpha2: Promise<string>;
	    /** 4GL columnName: CODTYP2 */
	    readonly type2: Promise<string>;
	    /** 4GL columnName: SUP2 */
	    readonly option2: Promise<string>;
	    /** 4GL columnName: NUMDES1 */
	    readonly numeric1: Promise<string>;
	    /** 4GL columnName: CODTYP3 */
	    readonly type3: Promise<string>;
	    /** 4GL columnName: SUP3 */
	    readonly option3: Promise<string>;
	    /** 4GL columnName: NUMDES2 */
	    readonly numeric2: Promise<string>;
	    /** 4GL columnName: CODTYP4 */
	    readonly type4: Promise<string>;
	    /** 4GL columnName: SUP4 */
	    readonly option4: Promise<string>;
	    /** 4GL code: NBCOL */
	    readonly number: Promise<integer>;
	    readonly columns: Collection<x3SystemUtils.nodes.SysMiscellaneousTablesColumns>;
	    /** 4GL columnName: OBLLEG */
	    readonly legislationMandatory: Promise<boolean>;
	}
	//# sourceMappingURL=sys-miscellaneous-tables.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-miscellaneous-tables-columns.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables-columns' {
	import { integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	import { SysMiscellaneousTables } from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables';
	/** 4GL columnName: ATABTAB */
	export class SysMiscellaneousTablesColumns extends Node {
	    /** 4GL columnName: NUMTAB */
	    readonly glossaryId: Promise<integer>;
	    readonly _denormalizedParent: Reference<SysMiscellaneousTables | null>;
	    readonly denormalizedIndex: Promise<integer>;
	    /** 4GL code: COLTYPTYP */
	    readonly columnType: Promise<x3SystemUtils.enums.SysSequenceNumberType>;
	    /** 4GL code: COLDES */
	    readonly description1: Promise<string>;
	    /** 4GL code: COLTYP */
	    readonly dataType: Promise<string>;
	    /** 4GL columnName: COLSUP */
	    readonly option: Promise<string>;
	}
	//# sourceMappingURL=sys-miscellaneous-tables-columns.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-miscellaneous-table.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-table' {
	import { decimal, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ATABDIV */
	export class SysMiscellaneousTable extends Node {
	    /** 4GL code: NUMTAB */
	    readonly glossaryId: Reference<x3SystemUtils.nodes.SysMiscellaneousTables>;
	    /** 4GL code: CODE */
	    readonly code: Promise<string>;
	    /** 4GL code: LNGDES */
	    readonly description: Promise<string>;
	    /** 4GL code: SHODES */
	    readonly shortDescription: Promise<string>;
	    /** 4GL code: DEFVAL */
	    readonly defaultValue: Promise<boolean | null>;
	    /** 4GL code: DEPCOD */
	    readonly dependency: Reference<SysMiscellaneousTable | null>;
	    /** 4GL code: SOC */
	    readonly groupOfCompany: Promise<string>;
	    /** 4GL code: LEG */
	    readonly legislation: Reference<x3SystemUtils.nodes.SysMiscellaneousTable | null>;
	    /** 4GL code: ENAFLG */
	    readonly activeFlag: Promise<boolean | null>;
	    /** 4GL code: A1 */
	    readonly alpha1: Promise<string>;
	    /** 4GL code: A2 */
	    readonly alpha2: Promise<string>;
	    /** 4GL code: A3 */
	    readonly alpha3: Promise<string>;
	    /** 4GL code: A4 */
	    readonly alpha4: Promise<string>;
	    /** 4GL code: A5 */
	    readonly alpha5: Promise<string>;
	    /** 4GL code: A6 */
	    readonly alpha6: Promise<string>;
	    /** 4GL code: A7 */
	    readonly alpha7: Promise<string>;
	    /** 4GL code: A8 */
	    readonly alpha8: Promise<string>;
	    /** 4GL code: A9 */
	    readonly alpha9: Promise<string>;
	    /** 4GL code: A10 */
	    readonly alpha10: Promise<string>;
	    /** 4GL code: A11 */
	    readonly alpha11: Promise<string>;
	    /** 4GL code: A12 */
	    readonly alpha12: Promise<string>;
	    /** 4GL code: A13 */
	    readonly alpha13: Promise<string>;
	    /** 4GL code: A14 */
	    readonly alpha14: Promise<string>;
	    /** 4GL code: A15 */
	    readonly alpha15: Promise<string>;
	    /** 4GL code: N1 */
	    readonly numeric1: Promise<decimal>;
	    /** 4GL code: N2 */
	    readonly numeric2: Promise<decimal>;
	    /** 4GL code: N3 */
	    readonly numeric3: Promise<decimal>;
	    /** 4GL code: N4 */
	    readonly numeric4: Promise<decimal>;
	    /** 4GL code: N5 */
	    readonly numeric5: Promise<decimal>;
	    /** 4GL code: N6 */
	    readonly numeric6: Promise<decimal>;
	    /** 4GL code: N7 */
	    readonly numeric7: Promise<decimal>;
	    /** 4GL code: N8 */
	    readonly numeric8: Promise<decimal>;
	    /** 4GL code: N9 */
	    readonly numeric9: Promise<decimal>;
	    /** 4GL code: N10 */
	    readonly numeric10: Promise<decimal>;
	    /** 4GL code: N11 */
	    readonly numeric11: Promise<decimal>;
	    /** 4GL code: N12 */
	    readonly numeric12: Promise<decimal>;
	    /** 4GL code: N13 */
	    readonly numeric13: Promise<decimal>;
	    /** 4GL code: N14 */
	    readonly numeric14: Promise<decimal>;
	    /** 4GL code: N15 */
	    readonly numeric15: Promise<decimal>;
	}
	//# sourceMappingURL=sys-miscellaneous-table.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-language.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-language' {
	import { Node, Reference } from '@sage/xtrem-core';
	/** 4GL code: TABLAN */
	export class SysLanguage extends Node {
	    /** 4GL code: LAN */
	    readonly code: Promise<string>;
	    /** 4GL code: LANSTD */
	    readonly standardLanguage: Promise<boolean | null>;
	    /** 4GL code: LANISO */
	    readonly iso: Promise<string>;
	    /** 4GL code: LANUNI */
	    readonly unicodeLanguage: Promise<boolean | null>;
	    /** 4GL code: LANCON */
	    readonly connectionLanguage: Promise<boolean | null>;
	    /** 4GL code: LANRPL */
	    readonly backupLanguage: Reference<SysLanguage | null>;
	    /** 4GL code: INTSHO */
	    readonly shortDescription: Promise<string>;
	    /** 4GL code: INTDES */
	    readonly description: Promise<string>;
	    /** 4GL code: LANMAIN */
	    readonly primaryLanguage: Promise<string>;
	}
	//# sourceMappingURL=sys-language.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-image.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-image' {
	import { BinaryStream, Node } from '@sage/xtrem-core';
	export class SysImage extends Node {
	    readonly code: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly identifier3: Promise<string>;
	    readonly fileName: Promise<string>;
	    readonly data: Promise<BinaryStream>;
	    readonly specialFileType: Promise<number>;
	}
	//# sourceMappingURL=sys-image.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-general-parameters-data.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-general-parameters-data' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ADOVAL */
	export class SysGeneralParametersData extends Node {
	    /** 4GL code: CMP */
	    readonly company: Reference<x3SystemUtils.nodes.SysCompany | null>;
	    /** 4GL code: FCY */
	    readonly siteOrLegislationCode: Promise<string>;
	    readonly legislation: Reference<x3SystemUtils.nodes.SysMiscellaneousTable | null>;
	    readonly site: Reference<x3SystemUtils.nodes.SysSite | null>;
	    /** 4GL code: PARAM */
	    readonly code: Promise<string>;
	    /** 4GL code: VALEUR */
	    readonly value: Promise<string>;
	    /** 4GL code: JEU */
	    readonly defaultSetOfValues: Reference<x3SystemUtils.nodes.SysMiscellaneousTable | null>;
	}
	//# sourceMappingURL=sys-general-parameters-data.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-general-parameter.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-general-parameter' {
	import { Context, Decimal, Node, Reference, date, integer } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ADOPAR */
	export class SysGeneralParameter extends Node {
	    /** 4GL code: CHAPITRE */
	    readonly chapter: Reference<x3SystemUtils.nodes.SysMiscellaneousTable>;
	    readonly valueType: Promise<x3SystemUtils.enums.SysFieldType1>;
	    /** 4GL code: PARAM */
	    readonly code: Promise<string>;
	    /** 4GL code: GRPPAR */
	    readonly group: Reference<x3SystemUtils.nodes.SysMiscellaneousTable>;
	    /** 4GL code: NAM */
	    readonly description: Promise<integer>;
	    /** 4GL code: CODACT */
	    readonly activityCode: Reference<x3SystemUtils.nodes.SysActivityCode | null>;
	    /** 4GL code: MODIF */
	    readonly isEditable: Promise<boolean | null>;
	    /** 4GL code: NOLIB */
	    readonly localMenu: Promise<integer>;
	    /** 4GL code: NIVDEF */
	    readonly definitionLevel: Promise<x3SystemUtils.enums.SysDefinitionLevel3 | null>;
	    /** 4GL code: VALUES */
	    readonly selectableValues: Promise<string[]>;
	    /** 4GL code: VALFLG */
	    readonly isOffValue: Promise<boolean | null>;
	    /** 4GL code: TRAIT */
	    readonly processing: Promise<string>;
	    /** 4GL code: SELOPT */
	    readonly selectionOptions: Promise<string>;
	    /** 4GL code: AUSMODIF */
	    readonly canUserUpdate: Promise<boolean | null>;
	    /** 4GL code: RANG */
	    readonly sequence: Promise<integer>;
	    /** 4GL code: ACS */
	    readonly access: Reference<x3SystemUtils.nodes.SysAccess | null>;
	    /** 4GL code: VALDEF */
	    readonly folderValue: Promise<boolean | null>;
	    /** 4GL code: CNDMOD */
	    readonly modifyingCondition: Promise<string>;
	    static readByUserParameterValueString(context: Context, parameters: {
	        code: string;
	        userCode?: string;
	        site?: string;
	        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
	    }): Promise<string>;
	    static readByUserParameterValueDate(context: Context, parameters: {
	        code: string;
	        userCode?: string;
	        site?: string;
	        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
	    }): Promise<date | null>;
	    static readByUserParameterValueDecimal(context: Context, parameters: {
	        code: string;
	        userCode?: string;
	        site?: string;
	        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
	    }): Promise<Decimal>;
	    static readByUserParameterValueInteger(context: Context, parameters: {
	        code: string;
	        userCode?: string;
	        site?: string;
	        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
	    }): Promise<number>;
	    static readByUserParameterValueBoolean(context: Context, parameters: {
	        code: string;
	        userCode?: string;
	        site?: string;
	        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
	    }): Promise<boolean>;
	    static readParameterValueString(context: Context, parameters: {
	        parameterCode: string;
	        level?: x3SystemUtils.enums.SysDefinitionLevel3;
	        code?: string;
	    }): Promise<string>;
	    static readParameterValueDate(context: Context, parameters: {
	        parameterCode: string;
	        level?: x3SystemUtils.enums.SysDefinitionLevel3;
	        code?: string;
	    }): Promise<date | null>;
	    static readParameterValueDecimal(context: Context, parameters: {
	        parameterCode: string;
	        level?: x3SystemUtils.enums.SysDefinitionLevel3;
	        code?: string;
	    }): Promise<Decimal>;
	    static readParameterValueInteger(context: Context, parameters: {
	        parameterCode: string;
	        level?: x3SystemUtils.enums.SysDefinitionLevel3;
	        code?: string;
	    }): Promise<number>;
	    static readParameterValueBoolean(context: Context, parameters: {
	        parameterCode: string;
	        level?: x3SystemUtils.enums.SysDefinitionLevel3;
	        code?: string;
	    }): Promise<boolean>;
	}
	//# sourceMappingURL=sys-general-parameter.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-functional-profile.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: AFCTPRF */
	export class SysFunctionalProfile extends Node {
	    /** 4GL code: PRFCOD */
	    readonly profile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile>;
	    /** 4GL code: FNC */
	    readonly function: Reference<x3SystemUtils.nodes.SysFunction>;
	    /** 4GL code: OPT */
	    readonly options: Promise<string>;
	    /** 4GL code: ACS */
	    readonly access: Promise<boolean>;
	    /** 4GL code: FCYGRUCOD */
	    readonly menu: Promise<boolean>;
	    /** 4GL code: FCYGRU */
	    readonly siteGrouping: Promise<string>;
	    readonly profileForAllSites: Reference<x3SystemUtils.nodes.SysFunctionalProfilePerSite | null>;
	}
	//# sourceMappingURL=sys-functional-profile.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-functional-profile-per-site.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile-per-site' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: AFCTFCY */
	export class SysFunctionalProfilePerSite extends Node {
	    /** 4GL code: FCY */
	    readonly site: Reference<x3SystemUtils.nodes.SysSite | null>;
	    /** 4GL code: PRFCOD */
	    readonly profile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile>;
	    /** 4GL code: FNC */
	    readonly function: Reference<x3SystemUtils.nodes.SysFunction>;
	    /** 4GL code: OPT */
	    readonly options: Promise<string>;
	}
	//# sourceMappingURL=sys-functional-profile-per-site.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-function.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-function' {
	import { Collection, integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: EDIFNC */
	export class SysFunction extends Node {
	    /** 4GL code: MODULE */
	    readonly module: Promise<x3SystemUtils.enums.SysModuleTable | null>;
	    /** 4GL code: CODINT */
	    readonly internal: Promise<string>;
	    /** 4GL code: CODACT */
	    readonly activityCode: Reference<x3SystemUtils.nodes.SysActivityCode | null>;
	    /** 4GL code: CODEXT */
	    readonly external: Promise<string>;
	    /** 4GL code: NUMFNC */
	    readonly number: Promise<integer>;
	    /** 4GL code: LIBMENU */
	    readonly menuTitle: Promise<integer>;
	    /** 4GL code: MENU */
	    readonly parentMenu: Promise<string>;
	    /** 4GL code: NBOPT */
	    readonly noOfOptions: Promise<integer>;
	    /** 4GL code: FLAG */
	    readonly options: Promise<string[]>;
	    /** 4GL code: ACTOPT */
	    readonly activityCode1: Promise<string>;
	    /** 4GL code: OPTION */
	    readonly optionTitle: Promise<integer>;
	    /** 4GL code: FNCOPT */
	    readonly function: Promise<string>;
	    /** 4GL code: RANG */
	    readonly rowInMenu: Promise<integer>;
	    /** 4GL code: TRAIT */
	    readonly menuProcess: Promise<string>;
	    /** 4GL code: TYP */
	    readonly accessTypeObject: Promise<boolean>;
	    /** 4GL code: VALPAR */
	    readonly parameterValue: Promise<string[]>;
	    /** 4GL code: TRTENT */
	    readonly entryPoints: Promise<string>;
	    /** 4GL code: FCYAUZ */
	    readonly authorizationSite: Promise<boolean>;
	    /** 4GL code: MONO */
	    readonly single: Promise<boolean>;
	    readonly variables: Collection<x3SystemUtils.nodes.SysFunctionVariables>;
	}
	//# sourceMappingURL=sys-function.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-function-variables.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-function-variables' {
	import { integer, Node, Reference } from '@sage/xtrem-core';
	import * as sageXtremX3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	export class SysFunctionVariables extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly internal: Promise<string>;
	    readonly _denormalizedParent: Reference<sageXtremX3SystemUtils.nodes.SysFunction>;
	    readonly activityCode: Reference<sageXtremX3SystemUtils.nodes.SysActivityCode | null>;
	    readonly value: Promise<string>;
	    readonly variable: Promise<string>;
	}
	//# sourceMappingURL=sys-function-variables.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-company.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-company' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: COMPANY */
	export class SysCompany extends Node {
	    /** 4GL code: CPY */
	    readonly code: Promise<string>;
	    /** 4GL code: CPYLEGFLG */
	    readonly isLegalCompany: Promise<boolean | null>;
	    /** 4GL code: LEG */
	    readonly legislation: Reference<x3SystemUtils.nodes.SysMiscellaneousTable>;
	    /** 4GL code: CPYNAM */
	    readonly name: Promise<string>;
	    /** 4GL code: CPYSHO */
	    readonly shortDescription: Promise<string>;
	}
	//# sourceMappingURL=sys-company.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-activity-code.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-activity-code' {
	import { integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL columnName: ACTIV */
	export class SysActivityCode extends Node {
	    /** 4GL columnName: CODACT */
	    readonly code: Promise<string>;
	    /** 4GL columnName: LIBACT */
	    readonly description: Promise<integer>;
	    /** 4GL columnName: DIME */
	    readonly screenSize: Promise<integer>;
	    /** 4GL columnName: DIMFIL */
	    readonly databaseMinimumSize: Promise<integer>;
	    /** 4GL columnName: MODULE */
	    readonly module: Promise<x3SystemUtils.enums.SysModuleTable>;
	    /** 4GL columnName: DIMMAX */
	    readonly maximumSize: Promise<integer>;
	    /** 4GL columnName: RANG */
	    readonly sequence: Promise<integer>;
	    /** 4GL columnName: ORDRE */
	    readonly order: Promise<integer>;
	    /** 4GL code: TYP */
	    readonly type: Promise<x3SystemUtils.enums.SysTypesOfActivityCode | null>;
	    /** 4GL code: DEP */
	    readonly dependency: Promise<x3SystemUtils.enums.SysTypeOfDependency | null>;
	    /** 4GL columnName: FLACT */
	    readonly activeFlag: Promise<boolean | null>;
	    /** 4GL columnName: INTIT */
	    readonly description1: Promise<string>;
	    /** 4GL columnName: ACTDEP */
	    readonly activityCode: Reference<SysActivityCode | null>;
	    /** 4GL columnName: ACTFOR */
	    readonly formula: Promise<string>;
	}
	//# sourceMappingURL=sys-activity-code.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/sys-access.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-access' {
	import { Node } from '@sage/xtrem-core';
	/** 4GL code: ACCCOD */
	export class SysAccess extends Node {
	    /** 4GL code: CODACC */
	    readonly access: Promise<string>;
	    /** 4GL code: INTACC */
	    readonly description: Promise<string>;
	    /** 4GL code: DESACC */
	    readonly description1: Promise<string>;
	}
	//# sourceMappingURL=sys-access.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/nodes/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-access';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-activity-code';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-company';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-function';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-function-variables';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile-per-site';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-general-parameter';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-general-parameters-data';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-image';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-language';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-table';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables-columns';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-package';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-site';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-syracus-method';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-access';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-function-profile';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-function-profile-user-profile-default-sites';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-parameter-value';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-utility';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/functions/user-parameter-values.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/functions/user-parameter-values' {
	import { Context } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	export function getUserProfile(context: Context, options?: {
	    user?: x3SystemUtils.nodes.SysUser;
	}): Promise<x3SystemUtils.nodes.SysUserFunctionProfile | null>;
	export function getSiteFromModule(moduleName: x3SystemUtils.enums.SysModuleTable | null, profile: x3SystemUtils.nodes.SysUserFunctionProfile): Promise<x3SystemUtils.nodes.SysSite | null>;
	/**
	 * Getting parameter value defined for a given user
	 * @param context
	 * @param parameter
	 * @param currentSite
	 * @param userCode
	 */
	export function getGeneralParameterUserValue(context: Context, parameter: string, currentSite?: string, userCode?: string, definitionLevel?: x3SystemUtils.enums.SysDefinitionLevel3): Promise<string>;
	//# sourceMappingURL=user-parameter-values.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/functions/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/functions/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/functions/general-parameter-values';
	export * from '@sage/xtrem-x3-system-utils/lib/functions/get-x3-url';
	export * from '@sage/xtrem-x3-system-utils/lib/functions/user-parameter-values';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/functions/get-x3-url.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/functions/get-x3-url' {
	import { Context } from '@sage/xtrem-core';
	export function getX3Url(context: Context): string;
	//# sourceMappingURL=get-x3-url.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/functions/general-parameter-values.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/functions/general-parameter-values' {
	import { Context } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	export function getGeneralParameter(context: Context, parameter: string): Promise<x3SystemUtils.nodes.SysGeneralParameter>;
	/**
	 * General Parameter value :
	 *
	 * @param context
	 * @param _code can be a string of UserCode, Site code Company code or legislation code , or a node
	 * @param _parameter code of the general parameter to access
	 */
	export function getGeneralParameterValue(context: Context, code: string | x3SystemUtils.nodes.SysUser | x3SystemUtils.nodes.SysSite | x3SystemUtils.nodes.SysCompany | x3SystemUtils.nodes.SysMiscellaneousTable | null, parameter: string, definitionLevel?: x3SystemUtils.enums.SysDefinitionLevel3): Promise<string>;
	//# sourceMappingURL=general-parameter-values.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/enums/sys-types-of-activity-code.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-types-of-activity-code' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysTypesOfActivityCodeEnum {
	    functional = 1,
	    sizing = 2,
	    localization = 3
	}
	export type SysTypesOfActivityCode = keyof typeof SysTypesOfActivityCodeEnum;
	export const sysTypesOfActivityCodeDataType: EnumDataType<"sizing" | "functional" | "localization", unknown>;
	//# sourceMappingURL=sys-types-of-activity-code.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/enums/sys-type-of-dependency.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-type-of-dependency' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysTypeOfDependencyEnum {
	    none = 1,
	    reverse = 2,
	    sizing = 3,
	    formula = 4
	}
	export type SysTypeOfDependency = keyof typeof SysTypeOfDependencyEnum;
	export const sysTypeOfDependencyDataType: EnumDataType<"none" | "reverse" | "sizing" | "formula", unknown>;
	//# sourceMappingURL=sys-type-of-dependency.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/enums/sys-sequence-number-type.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-sequence-number-type' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysSequenceNumberTypeEnum {
	    alphanumeric = 1,
	    numeric = 2
	}
	export type SysSequenceNumberType = keyof typeof SysSequenceNumberTypeEnum;
	export const sysSequenceNumberTypeDataType: EnumDataType<"alphanumeric" | "numeric", unknown>;
	//# sourceMappingURL=sys-sequence-number-type.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/enums/sys-module-table.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-module-table' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysModuleTableEnum {
	    supervisor = 1,
	    financials = 2,
	    aparAccounting = 3,
	    external = 4,
	    sales = 5,
	    purchasing = 6,
	    stock = 7,
	    manufacturing = 8,
	    commonData = 9,
	    development = 10,
	    sageX3Internals = 11,
	    helpDesk = 12,
	    crmActivities = 13,
	    fixedAssets = 14,
	    humanResourcesAdministration = 15,
	    moduleSpe1 = 16,
	    moduleSpe2 = 17,
	    moduleSpe3 = 18,
	    moduleSpe4 = 19,
	    humanCapitalManagement = 20
	}
	export type SysModuleTable = keyof typeof SysModuleTableEnum;
	export const sysModuleTableDataType: EnumDataType<"supervisor" | "financials" | "aparAccounting" | "external" | "sales" | "purchasing" | "stock" | "manufacturing" | "commonData" | "development" | "sageX3Internals" | "helpDesk" | "crmActivities" | "fixedAssets" | "humanResourcesAdministration" | "moduleSpe1" | "moduleSpe2" | "moduleSpe3" | "moduleSpe4" | "humanCapitalManagement", unknown>;
	//# sourceMappingURL=sys-module-table.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/enums/sys-field-type-1.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-field-type-1' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysFieldType1Enum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3,
	    localMenu = 4
	}
	export type SysFieldType1 = keyof typeof SysFieldType1Enum;
	export const sysFieldType1DataType: EnumDataType<"alphanumeric" | "numeric" | "date" | "localMenu", unknown>;
	//# sourceMappingURL=sys-field-type-1.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/enums/sys-definition-level-3.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-definition-level-3' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysDefinitionLevel3Enum {
	    folder = 1,
	    company = 2,
	    site = 3,
	    user = 4,
	    legislation = 5
	}
	export type SysDefinitionLevel3 = keyof typeof SysDefinitionLevel3Enum;
	export const sysDefinitionLevel3DataType: EnumDataType<"folder" | "company" | "site" | "user" | "legislation", unknown>;
	//# sourceMappingURL=sys-definition-level-3.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/enums/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-definition-level-3';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-field-type-1';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-module-table';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-sequence-number-type';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-type-of-dependency';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-types-of-activity-code';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/data-types/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/data-types/index' {
	import * as genericDataTypes from '@sage/xtrem-x3-system-utils/lib/data-types/data-types';
	export { genericDataTypes };
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-system-utils/build/lib/data-types/data-types.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/data-types/data-types' {
	import { DecimalDataType, StringDataType } from '@sage/xtrem-core';
	export const textDatatype: StringDataType<unknown, string>;
	export const translatableTextDatatype: StringDataType<unknown, string>;
	export const decimalDatatype: DecimalDataType<unknown, number>;
	//# sourceMappingURL=data-types.d.ts.map
}
declare module '@sage/xtrem-x3-system-utils' {
	export * from '@sage/xtrem-x3-system-utils/index';
}
